### New features

* [#5848](https://github.com/rubocop-hq/rubocop/pull/5848): Add new `Performance/InefficientHashSearch` cop. ([@JacobEvelyn][])
* [#5801](https://github.com/rubocop-hq/rubocop/pull/5801): Add new `Rails/RefuteMethods` cop. ([@koic][])
* [#5805](https://github.com/rubocop-hq/rubocop/pull/5805): Add new `Rails/AssertNot` cop. ([@composerinteralia][])
* [#4136](https://github.com/rubocop-hq/rubocop/issues/4136): Allow more robust `Layout/ClosingParenthesisIndentation` detection including method chaining. ([@jfelchner][])
* [#5699](https://github.com/rubocop-hq/rubocop/pull/5699): Add `consistent_relative_to_receiver` style option to `Layout/FirstParameterIndentation`. ([@jfelchner][])
* [#5821](https://github.com/rubocop-hq/rubocop/pull/5821): Support `AR::Migration#up_only` for `Rails/ReversibleMigration` cop. ([@koic][])
* [#5800](https://github.com/rubocop-hq/rubocop/issues/5800): Don't show a stracktrace for invalid command-line params. ([@shanecav84][])
* [#5845](https://github.com/rubocop-hq/rubocop/pull/5845): Add new `Lint/ErbNewArguments` cop. ([@koic][])
* [#5871](https://github.com/rubocop-hq/rubocop/pull/5871): Add new `Lint/SplatKeywordArguments` cop. ([@koic][])
* [#4247](https://github.com/rubocop-hq/rubocop/issues/4247): Remove hard-coded file patterns and use only `Include`, `Exclude` and the new `RubyInterpreters` parameters for file selection. ([@jonas054][])

### Bug fixes

* Fix bug in `Style/EmptyMethod` which concatenated the method name and first argument if no method def parentheses are used. ([@thomasbrus][])
* [#5819](https://github.com/rubocop-hq/rubocop/issues/5819): Fix `Rails/SaveBang` when using negated if. ([@Edouard-chin][])
* [#5286](https://github.com/rubocop-hq/rubocop/issues/5286): Fix `Lint/SafeNavigationChain` not detecting chained operators after block. ([@Darhazer][])
* Fix bug where `Lint/SafeNavigationConsistency` registers multiple offenses for the same method call. ([@rrosenblum][])
* [#5713](https://github.com/rubocop-hq/rubocop/issues/5713): Fix `Style/CommentAnnotation` reporting only the first of multiple consecutive offending lines. ([@svendittmer][])
* [#5791](https://github.com/rubocop-hq/rubocop/issues/5791): Fix exception in `Lint/SafeNavigationConsistency` when there is code around the condition. ([@rrosenblum][])
* [#5784](https://github.com/rubocop-hq/rubocop/issues/5784): Fix a false positive for `Rails/HasManyOrHasOneDependent` when using nested `with_options`. ([@koic][])
* [#4666](https://github.com/rubocop-hq/rubocop/issues/4666): `--stdin` always treats input as Ruby source irregardless of filename. ([@PointlessOne][])
* Fix auto-correction for `Style/MethodCallWithArgsParentheses` adding extra parentheses if the method argument was already parenthesized. ([@dvandersluis][])
* [#5668](https://github.com/rubocop-hq/rubocop/issues/5668): Fix an issue where files with unknown extensions, listed in `AllCops/Include` were not inspected when passing the file name as an option. ([@drenmi][])
* [#5809](https://github.com/rubocop-hq/rubocop/issues/5809): Fix exception `Lint/PercentStringArray` and `Lint/PercentSymbolArray` when the inspected file is binary encoded. ([@akhramov][])
* [#5840](https://github.com/rubocop-hq/rubocop/issues/5840): Do not register an offense for methods that `nil` responds to in `Lint/SafeNavigationConsistency`. ([@rrosenblum][])
* [#5862](https://github.com/rubocop-hq/rubocop/issues/5862): Fix an incorrect auto-correct for `Lint/LiteralInInterpolation` if contains numbers. ([@koic][])
* [#5868](https://github.com/rubocop-hq/rubocop/pull/5868): Fix `Rails/CreateTableWithTimestamps` when using hash options. ([@wata727][])
* [#5708](https://github.com/rubocop-hq/rubocop/issues/5708): Fix exception in `Lint/UnneededCopEnableDirective` for instruction '# rubocop:enable **all**'. ([@balbesina][])
* Fix auto-correction of `Rails/HttpPositionalArgumnets` to use `session` instead of `header`. ([@rrosenblum][])

### Changes

* Split `Style/MethodMissing` into two cops, `Style/MethodMissingSuper` and `Style/MissingRespondToMissing`. ([@rrosenblum][])
* [#5757](https://github.com/rubocop-hq/rubocop/issues/5757): Add `AllowInMultilineConditions` option to `Style/ParenthesesAroundCondition` cop. ([@Darhazer][])
* [#5806](https://github.com/rubocop-hq/rubocop/issues/5806): Fix `Layout/SpaceInsideReferenceBrackets` when assigning a reference bracket to a reference bracket. ([@joshuapinter][])
* [#5082](https://github.com/rubocop-hq/rubocop/issues/5082): Allow caching together with `--auto-correct`. ([@jonas054][])
* Add `try!` to the list of whitelisted methods for `Lint/SafeNavigationChain` and `Style/SafeNavigation`. ([@rrosenblum][])
* [#5886](https://github.com/rubocop-hq/rubocop/pull/5886): Move `Style/EmptyLineAfterGuardClause` cop to `Layout` department. ([@koic][])

[@JacobEvelyn]: https://github.com/JacobEvelyn
[@koic]: https://github.com/koic
[@composerinteralia]: https://github.com/composerinteralia
[@jfelchner]: https://github.com/jfelchner
[@shanecav84]: https://github.com/shanecav84
[@jonas054]: https://github.com/jonas054
[@thomasbrus]: https://github.com/thomasbrus
[@Edouard-chin]: https://github.com/Edouard-chin
[@Darhazer]: https://github.com/Darhazer
[@rrosenblum]: https://github.com/rrosenblum
[@svendittmer]: https://github.com/svendittmer
[@PointlessOne]: https://github.com/PointlessOne
[@dvandersluis]: https://github.com/dvandersluis
[@drenmi]: https://github.com/drenmi
[@akhramov]: https://github.com/akhramov
[@wata727]: https://github.com/wata727
[@balbesina]: https://github.com/balbesina
[@joshuapinter]: https://github.com/joshuapinter
