# Contributing

This repository accepts contributions. Ideas, questions, feature requests and bug reports can be filed through Github issues.

Pull Requests are welcome on Github. By committing pull requests, you accept that your code might be modified and reformatted to fit the project coding style or to improve the implementation. Contributed code is considered licensed under the same license as the rest of the project unless explicitly agreed otherwise. See the `LICENCE` file.

Please discuss what you want to see modified before filing a pull request if you don't want to be doing work that might be rejected.


## Code formatting

I understand my code formatting style is quite uncommon, but it is deliberate and helps readability for me. Unfortunately, it cannot be achieved with automated tools like `rustfmt`. **Feel free to contribute code formatted however you are comfortable writing it**. I am happy to reformat during the review process. If you are uncomfortable reading my code, I suggest running `rustfmt` on the entire source tree or set your line-height to 1.2 instead of the common 1.5, which will make it look a lot less over the top.


# git workflow

Please file PR's against the `dev` branch, don't forget to update the documentation.
