# The Rust Bookshelf

![Minimum Rust version: various](https://img.shields.io/badge/Minimum%20Rust%20Version-various-brightgreen.svg), each book is different.

As Rust's documentation has grown, we've gained far more than just "The book"
and the reference. We now have a collection of various long-form docs,
nicknamed "the Rust Bookshelf." Different resources are added at various
times, and we're adding new ones as more get written.

## The Cargo book

![Minimum Rust version: 1.21](https://img.shields.io/badge/Minimum%20Rust%20Version-1.21-brightgreen.svg)

Historically, Cargo’s docs were hosted on <http://doc.crates.io>, which
doesn’t follow the release train model, even though Cargo itself does. This
led to situations where a feature would land in Cargo nightly, the docs would
be updated, and then for up to twelve weeks, users would think that it should
work, but it wouldn’t yet. <https://doc.rust-lang.org/cargo> is the new home
of Cargo’s docs, and <http://doc.crates.io> now redirects there.

## The `rustdoc` book

![Minimum Rust version: 1.21](https://img.shields.io/badge/Minimum%20Rust%20Version-1.21-brightgreen.svg)

Rustdoc, our documentation tool, now has a guide at <https://doc.rust-lang.org/rustdoc>.

## Rust By Example

![Minimum Rust version: 1.25](https://img.shields.io/badge/Minimum%20Rust%20Version-1.25-brightgreen.svg)

Rust by Example used to live at <https://rustbyexample.com>, but now is part of the Bookshelf!
It can be found at <https://doc.rust-lang.org/rust-by-example/>. RBE lets you learn Rust through
short code examples and exercises, as opposed to the lengthy prose of The Book.