/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CWirelessMsgHandler.h
    \author Romain BONDUE
    \date 17/02/06 */
#ifndef __CWIRELESSMSGHANDLER_H__
#define __CWIRELESSMSGHANDLER_H__

#include <string>
#include <stdexcept> // std::bad_alloc
#include <memory>

#include "IMsgHandler.h"
#include "IDriver.h"
#include "Exceptions.h"



namespace nsRoot
{
    class CWirelessMsgHandler : public IMsgHandler
    {
      public :
        CWirelessMsgHandler () throw();
        ~CWirelessMsgHandler () throw();
        CMsg operator () (const CMsg&) throw (nsErrors::CException,
                                              std::bad_alloc);

      protected :
        nsWireless::IDriver* GetDriver () throw();
        const nsWireless::IDriver* GetDriver () const throw();
        virtual void SetDriver (const std::string&)
                                throw (std::bad_alloc, nsErrors::CException);
            /* It hold the driver, meaning it will delete it. This function is
             * designed to help implemented the former. */
        void SetDriver (nsWireless::IDriver*) throw();


      private :
        std::auto_ptr<nsWireless::IDriver> m_pDriver;

    }; // CWirelessMsgHandler

} // namespace nsRoot

#include "private/CWirelessMsgHandler.hxx"

#endif // __CWIRELESSMSGHANDLER_H__
