from __future__ import print_function
from _mock import _Mock




compilers = _Mock()

get_exception = _Mock()

os = _Mock()

sys = _Mock()



class CompaqFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'compaq'
  description = 'Compaq Fortran Compiler'
  exe_extension = ''
  fc_exe = 'fort'
  library_switch = '-o '
  module_dir_switch = '-module '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'
  version_pattern = 'Compaq Fortran (?P<version>[^\\s]*).*'

class CompaqVisualFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  ar_exe = 'lib.exe'
  compile_switch = '/compile_only'
  compiler_type = 'compaqv'
  description = 'DIGITAL or Compaq Visual Fortran Compiler'
  exe_extension = ''
  fc_exe = 'DF'
  library_switch = '/OUT:'
  module_dir_switch = '/module:'
  module_include_switch = '/I'
  obj_extension = '.o'
  object_switch = '/object:'
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.lib'
  static_lib_format = '%s%s'
  version_pattern = '(DIGITAL|Compaq) Visual Fortran Optimizing Compiler Version (?P<version>[^\\s]*).*'

class DistutilsPlatformError(_Mock):
  pass


class FCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  exe_extension = ''
  library_switch = '-o '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

