8.3 Gammes

# Gammes

Sonic Pi supporte un large éventail de gammes. Comment faire pour jouer 
une gamme majeure de Do3 (C3) ?

```
play_pattern_timed scale(:c3, :major), 0.125, release: 0.1
```

Nous pouvons même demander plusieurs octaves :

```
play_pattern_timed scale(:c3, :major, num_octaves: 3), 0.125, release: 0.1
```

Comment obtenir toutes les notes d'une gamme pentatonique ?

```
play_pattern_timed scale(:c3, :major_pentatonic, num_octaves: 3), 0.125, release: 0.1
```

## Notes aléatoires

Les accords et les gammes sont un grand moyen de contraindre un choix 
aléatoire à quelque chose de significatif. Jouez un instant avec cet 
exemple qui prend des notes aléatoirement dans l'accord mineur de Mi3 :

```
use_synth :tb303
loop do
  play choose(chord(:E3, :minor)), release: 0.3, cutoff: rrand(60, 120)
  sleep 0.25
end
```

Essayez de modifier cet exemple avec quelques noms d'accord différents 
et des plages de cutoff différentes.

## Découverte des accords et des gammes

Pour trouver quelles gammes et quels accords sont supportés par Sonic  
Pi, cliquez sur le bouton "Lang" du menu horizontal à gauche et au bas 
de la fenêtre, et choisissez soit "chord" (accord) ou "scale" (gamme) 
dans la liste du dessus. Dans le panneau d'information, faites défiler 
l'affichage vers le bas jusqu'à voir une longue liste d'accords ou de 
gammes (selon ce que vous êtes en train de chercher).

Faites-vous plaisir et rappelez-vous : il n'y a pas de fautes, que des 
opportunités.
