/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ColumnReference;
import adql.query.TextPosition;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class ADQLOrder
implements ADQLObject {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "ORDER_BY_ITEM", false, "Column reference or expression on which the query result must be ordered.");
    private TextPosition position = null;
    protected ColumnReference colRef = null;
    protected ADQLOperand expression = null;
    private boolean descSorting = false;

    public ADQLOrder(int colIndex) throws ArrayIndexOutOfBoundsException {
        this(colIndex, false);
    }

    public ADQLOrder(int colIndex, boolean desc) throws ArrayIndexOutOfBoundsException {
        this.setOrder(colIndex, desc);
    }

    public ADQLOrder(String colName) throws NullPointerException {
        this(colName, false);
    }

    @Deprecated
    public ADQLOrder(String colName, boolean desc) throws NullPointerException {
        this(new ADQLColumn(null, colName), desc);
    }

    public ADQLOrder(ADQLOperand expr) throws NullPointerException {
        this(expr, false);
    }

    public ADQLOrder(ADQLOperand expr, boolean desc) throws NullPointerException {
        this.setOrder(expr, desc);
    }

    public ADQLOrder(ADQLOrder toCopy) throws Exception {
        if (toCopy.colRef != null) {
            this.colRef = (ColumnReference)toCopy.colRef.getCopy();
        }
        if (toCopy.expression != null) {
            this.expression = (ADQLOperand)toCopy.expression.getCopy();
        }
        this.descSorting = toCopy.descSorting;
    }

    public boolean isDescSorting() {
        return this.descSorting;
    }

    public final ColumnReference getColumnReference() {
        return this.colRef;
    }

    public final ADQLOperand getExpression() {
        return this.expression;
    }

    public void setOrder(int colIndex, boolean desc) throws ArrayIndexOutOfBoundsException {
        if (colIndex <= 0) {
            throw new ArrayIndexOutOfBoundsException("Impossible to make a reference to the " + colIndex + "th column: a column index must be greater or equal 1!");
        }
        this.colRef = new ColumnReference(colIndex);
        this.expression = null;
        this.descSorting = desc;
    }

    @Deprecated
    public void setOrder(String colName, boolean desc) throws NullPointerException {
        if (colName == null) {
            throw new NullPointerException("Impossible to make a reference: the given name is null or is an empty string!");
        }
        this.colRef = null;
        this.expression = new ADQLColumn(null, colName);
        this.descSorting = desc;
        this.position = null;
    }

    public void setOrder(ADQLOperand expr, boolean desc) throws NullPointerException {
        if (expr == null) {
            throw new NullPointerException("Impossible to make a reference: the given expression is null!");
        }
        this.colRef = null;
        this.expression = expr;
        this.descSorting = desc;
        this.position = null;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLOrder(this);
    }

    @Override
    public String getName() {
        return (this.colRef != null ? this.colRef.getName() : this.expression.getName()) + (this.descSorting ? "_DESC" : "_ASC");
    }

    @Override
    public String toADQL() {
        return (this.colRef != null ? this.colRef.toADQL() : this.expression.toADQL()) + (this.descSorting ? " DESC" : " ASC");
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public void setPosition(TextPosition pos) {
        this.position = pos;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean itemDone = false;

            @Override
            public ADQLObject next() {
                if (this.itemDone) {
                    throw new NoSuchElementException();
                }
                this.itemDone = true;
                return ADQLOrder.this.colRef != null ? ADQLOrder.this.colRef : ADQLOrder.this.expression;
            }

            @Override
            public boolean hasNext() {
                return !this.itemDone;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.itemDone) {
                    throw new IllegalStateException("No iteration done yet!");
                }
                if (replacer == null) {
                    throw new UnsupportedOperationException("Impossible to delete a column reference or an expression from an ORDER BY item! You must delete the complete ORDER BY item.");
                }
                if (replacer instanceof ColumnReference) {
                    ADQLOrder.this.colRef = (ColumnReference)replacer;
                    ADQLOrder.this.expression = null;
                } else if (replacer instanceof ADQLOperand) {
                    ADQLOrder.this.colRef = null;
                    ADQLOrder.this.expression = (ADQLOperand)replacer;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace a column reference or a value expression by a " + replacer.getClass().getName() + "!");
                }
                ADQLOrder.this.position = null;
            }
        };
    }
}

