use core:lang;
use lang:bs:macro;

/**
 * Type management helper functions used by the grammar.
 */

// Find a type.
Value findType(SrcPos pos, Scope scope, SimplePart first, SimplePart[] rest) {
	SimpleName name(first);
	for (n in rest)
		name.add(n);
	scope.value(name, pos);
}

Value longType() {
	Value(named{Long});
}

Value uLongType() {
	Value(named{Word});
}

Value intType() {
	Value(named{Int});
}

Value uIntType() {
	Value(named{Nat});
}

Value charType() {
	Value(named{Byte});
}

Value boolType() {
	Value(named{Bool});
}
