/* ====================================================================
 * Copyright (c) 2006-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "TabWidget.h"

// qt
#include <QtGui/QPainter>
#include <QtGui/QLayout>
#include <QtGui/QStackedWidget>



Tabbar::Tabbar( QWidget* parent ) : super(parent)
{
  setElideMode(Qt::ElideMiddle);
}

Tabbar::~Tabbar()
{
}

QSize Tabbar::sizeHint() const
{
#ifdef Q_OS_MACX
  return super::sizeHint();
#else
  QSize size = super::sizeHint();
  size.setWidth( ((QWidget*)parent())->width() );
  return size;
#endif // Q_OS_MACX
}

QSize Tabbar::tabSizeHint( int idx ) const
{
  QSize ssize = super::tabSizeHint(idx);

  QString text = tabText(idx);
  QFontMetrics fm(font());
  ssize.setWidth( fm.width(text) );

  return ssize;
}

void Tabbar::paintEvent( QPaintEvent* e )
{
#ifdef Q_OS_MACX
  super::paintEvent(e);
#else  
  QPainter p(this);

  // draw top line
  p.setPen( colorGroup().shadow() );
  p.drawLine( 0, 0, width(), 0 );
  p.fillRect( 1, 1, width(), 2, colorGroup().light() );
  p.setPen( colorGroup().dark() );
  p.drawLine( 0, 3, width(), 3 );

  // draw unselected tabs
  for( int c = 0; c < count(); c++ )
  {
    if( c == currentIndex() )
      continue;

    // frame
    QRect rect = tabRect(c);
    rect.setX( rect.x() );
    rect.setY( rect.y()+3 );
    rect.setWidth( rect.width() );
    rect.setHeight( rect.height()-3 );
    p.setPen( colorGroup().dark() );
    p.drawRect( rect );
    
    // fill
    rect = tabRect(c);
    rect.setX( rect.x() );
    rect.setY( rect.y()+4 );
    rect.setWidth( rect.width()+1 );
    rect.setHeight( rect.height() );
    p.fillRect( rect, colorGroup().background() );

    p.setPen( tabTextColor(c) );
    rect = tabRect(c);
    rect.adjust( 4, 0, -4, 0 );
    p.drawText( rect, Qt::TextShowMnemonic | Qt::AlignCenter, tabText(c) );
  }

  // draw the selected tab
  for( int c = 0; c < count(); c++ )
  {
    if( c != currentIndex() )
      continue;

    // frame
    QRect rect = tabRect(c);
    rect.setY( rect.y()+3 );
    rect.setHeight( rect.height()-1 );
    p.setPen( colorGroup().dark() );
    p.drawRect( rect );

    // fill, overwrite "top" frame
    rect = tabRect(c);
    rect.setX( rect.x()+1 );
    rect.setY( rect.y()+3 );
    rect.setWidth( rect.width() );
    rect.setHeight( rect.height()-1 );
    p.fillRect( rect, colorGroup().light() );

    p.setPen( tabTextColor(c) );
    rect = tabRect(c);
    rect.adjust( 4, 0, -4, 0 );
    p.drawText( rect, Qt::TextShowMnemonic | Qt::AlignCenter, tabText(c) );
  }
#endif // Q_OS_MACX
}

/////////////////////////////////////////////////////////////////////

TabWidget::TabWidget( QWidget* parent ) : super(parent)
{
  QVBoxLayout* l = new QVBoxLayout(this);
  l->setMargin(0);
  l->setSpacing(0);

  _bar = new Tabbar(this);
  //_bar->setShape(QTabBar::RoundedSouth);
  _bar->setDrawBase(true);   // Windows??
  _bar->setDrawBase(false);  // MacOSX

  _stack = new QStackedWidget(this);
  _stack->setContentsMargins(0,0,0,0);

  l->addWidget(_stack);
  l->addWidget(_bar);

  connect( _bar, SIGNAL(selected(int)), _stack, SLOT(setCurrentIndex(int)) );
}

int TabWidget::addTab( QWidget* child, const QString& label )
{
  int idx = _bar->addTab(label);
  _stack->insertWidget(idx, child);
  _bar->setTabToolTip(idx, label);
  return idx;
}

void TabWidget::setTabTitle( QWidget* child, const QString& title )
{
  int idx = _stack->indexOf(child);
  _bar->setTabText( idx, title );
}

void TabWidget::setTabTooltip( QWidget* child, const QString& title )
{
  int idx = _stack->indexOf(child);
  _bar->setTabToolTip( idx, title );
}
