/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ColorStorage.h"

// sys
#include <map>


typedef std::map<long,Color> ColorStore;

ColorStore _colorStore;
QColor     _nullColor;

void ColorStorage::setColors( const Colors& colors )
{
  _colorStore.clear();

  for( Colors::const_iterator it = colors.begin(); it != colors.end(); it++ )
  {
    const Color& c = *it;

    _colorStore.insert( ColorStore::value_type( c._id,c) );
  }
}

const QColor& ColorStorage::getColor( long cid )
{
  ColorStore::iterator it = _colorStore.find(cid);
  if( it == _colorStore.end() )
  {
    return _nullColor;
  }

  return (*it).second._color;
}
