C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECG2E
C                       *****************
C
C     -----------------------------------------
     * (NFIC,NDIM,NDIELE,NPOINS,NELEMS,NBSCAL)
C     -----------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C       FICHIER SUITE FORMAT GRAFN3S  : LECTURE DE L'ENTETE            *  
C       VERIFICATION DE LA COHERENCE AVEC LA GEOMETRIE                 *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NFIC   !   E  ! D  ! NUMERO LOGIQUE DU FICHIER                   !
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME                       !
C   ! NDIELE !   E  ! D  ! DIMENSION DES ELEMENTS                      !
C   ! NELEMS !   E  ! D  ! NOMBRE D'ELTS VOL SOLIDE                    !
C   ! NPOINS !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE                !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : LECSOL
C
C***********************************************************************
C
      IMPLICIT NONE
C      
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "nlofes.h"
#include "divct.h"
C
C**********************************************************************
C
C.. Variables externes
      INTEGER   NFIC,NDIM,NDIELE,NPOINS,NELEMS
C
C.. Variables internes
      INTEGER   NNDIM,NNDIEL,NNELE,NPOIN1,NPOIN2,NBSCAL
      CHARACTER CH*72,C4*4
      LOGICAL   COHER
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      REWIND (NFIC)
C
C     1- LECTURE DE L'ENTETE
C     ======================
C
C     NNDIM  : Dimension du probleme
C     NNDIEL : Dimension des elements
C     NNELE  : Nombre d'elements
C     NPOIN1 : Nombre de noeuds P1
C     NPOIN2 : Nombre total de noeuds P2
C     NTSYR  : Numero du pas de temps
C     TEMPSS : Temps reel
C
      READ(NFIC,1200,ERR=99)
     &       CH,CH,CH,CH,C4,NNDIM,NNDIEL,NNELE,NPOIN2,NBSCAL
      READ(NFIC,1210,ERR=99) CH,C4,NTSYR,TEMPSS,CH,CH,CH
C
C
C     2- VERIFICATION SUCCINCTE DE LA COHERENCE AVEC LA GEOMETRIE
C     ===========================================================
C
      COHER = .TRUE.
C
      IF (NNDIM.NE.NDIM) COHER = .FALSE.
      IF (NNDIEL.NE.NDIELE) COHER = .FALSE.
C
      IF (NPOIN2 .NE. NPOINS) COHER = .FALSE.
C
      IF (NNELE .NE. NELEMS) COHER = .FALSE.
C
      IF (.NOT. COHER) THEN
        WRITE(NFECRA,2000)
        STOP
      ENDIF
C
      RETURN
C     
   99 CONTINUE
      WRITE (NFECRA,999)
      STOP
      
C--------
C FORMATS
C--------
C
 1200 FORMAT(A72,/,A72,/,A72,/,A72,/,A4,5I10)
 1210 FORMAT(A72,/,A4,I10,E20.13,/,A72,/,A72,/,A72)
C
 2000 FORMAT(/,' %% ERREUR LECG2E : LE FICHIER SUITE EST INCOHERENT',
     &         ' AVEC LA GEOMETRIE !')
C
  999 FORMAT(/,' %% ERREUR LECG2E : ',
     &             'ERREUR DE LECTURE DU FICHIER SUITE')
C
C
      END
