C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MADIF1,SSI=0
C
                     SUBROUTINE MADIF1
C                    ******************
C
C     ------------------------------------------------------
     *( XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *  NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *  NPOUE,NPPEL,NBPHYS,
     *  WCT )
C     ------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DES MATRICES ELEMENTAIRES DE DIFFUSION     *
C                    PROBLEMES BIDIMENSIONNELS ET TRIDIMENSIONNEL      *
C                    POUR LES CAS ISOTROPES                            *
C                                                                      *
C                                                                      *
C                                                                      *
C      Ce sous programme constitue une extension de travaux effectuees *
C      par F. JAUBERTEAU et J.P. GREGOIRE, portant sur l'integration   *
C      analytique des matrices elementaires par les formules de        *
C      Zienkiewicz                                                     *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   XMAT    !  TR  ! R  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   COEFMA  !  TR  ! D  ! COEFFICIENTS DES MATRICES                !
C   !           !      !    !  coefma(n) = rho Cp / dt pour masse      !
C   !   PHYSOL  !  TR  ! D  ! Tableau contenant les propri physiques   !
C   !           !  TR  ! D  !   On utilise uniquement PHYSOL(n,>=3)    !
C   !           !      !    !   contient les valeurs des kii sui isotro!
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                ! 
C   !   W1...W10!  TR  ! M  ! TABLEAUX DE TRAVAIL (TAILLE: NELMXS )    !
C   !           !      !    ! (diagonale non assemblee)                !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ASSEMB,OV
C                                      
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : MATELE
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C    
C***********************************************************************
C
C..Variables externes
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NCOEMA
      INTEGER NPOUE,NPPEL,NBPHYS
C
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)   
      DOUBLE PRECISION COEFMA(NPOINS),XMAT(NELEMS,NCOEMA)      
      DOUBLE PRECISION WCT(NELEMS,NDMATS),VOLUME(NELEMS)
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)     
C
C..Variables internes
      DOUBLE PRECISION ZERO     
      INTEGER I,NCA
      INTEGER N1,N2,N3,N4,N5,N6,N7,N8,N9,N10      
      DOUBLE PRECISION S3,S4,SV1,S29,SV29,S24,SV24
      DOUBLE PRECISION X5,X6,X7,X8,X9,X10
      DOUBLE PRECISION Y5,Y6,Y7,Y8,Y9,Y10
      DOUBLE PRECISION Z5,Z6,Z7,Z8,Z9,Z10
      DOUBLE PRECISION R1,R2,R3
      DOUBLE PRECISION X45,Y45,X46,Y46,X65,Y65
      DOUBLE PRECISION XGRAD1,YGRAD1,ZGRAD1
      DOUBLE PRECISION XGRAD2,YGRAD2,ZGRAD2
      DOUBLE PRECISION XGRAD3,YGRAD3,ZGRAD3
      DOUBLE PRECISION XGRAD4,YGRAD4,ZGRAD4
      DOUBLE PRECISION XK1,XK2,XK3,XK4,XK5,XK6,XK7,XK8,XK9,XK10
      DOUBLE PRECISION XKM1,XKM2,XKM3,XKM4,XKM5,XKM6,XKM7,XKM8
      DOUBLE PRECISION ALFA1,ALFA2,ALFA3,ALFA4,ALFA5,ALFA6
      DOUBLE PRECISION ALFA11,ALFA22,ALFA33,ALFA44
      DOUBLE PRECISION XKE
C
C    
      LOGICAL LVERIF
C***********************************************************************
C
C     INITIALISATIONS
C     ================
C
      LVERIF = .FALSE.
      ZERO   = 0.D0
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
C     Constantes necessaires      
      S3 = 1.D0 / 3.D0
      S4 = 1.D0 / 4.D0 
      S24 = 1.D0 / 24.D0
      S29 = - 2.D0 / 9.D0 
C     
C     1- CAS BIDIMENSIONNEL
C     ======================
C
C        
      IF ( NDIM . EQ . 2 ) THEN
C
C        1.1 CAS BIDIMENSIONNEL CARTESIEN 
C        --------------------------------
C
         IF (IAXISY.EQ.0) THEN
C
C
          DO 110 I=1,NELEMS
C
            N1 = NODES(I,1)
            N2 = NODES(I,2)
            N3 = NODES(I,3)
            N4 = NODES(I,4)
            N5 = NODES(I,5)
            N6 = NODES(I,6)
C
C
            IF (NDPROP .EQ. 1) THEN
              XK1 = PHYSOL(N1,1,3)
              XK2 = PHYSOL(N2,1,3)
              XK3 = PHYSOL(N3,1,3)
              XK4 = PHYSOL(N4,1,3)
              XK5 = PHYSOL(N5,1,3)
              XK6 = PHYSOL(N6,1,3)
            ELSEIF( NDPROP.EQ. 2 ) THEN
              XKE = PHYSOL(I,1,3)
              XK1 = XKE
              XK2 = XKE
              XK3 = XKE
              XK4 = XKE
              XK5 = XKE
              XK6 = XKE
            ELSE
              XK1 = PHYSOL(I,1,3)
              XK2 = PHYSOL(I,2,3)
              XK3 = PHYSOL(I,3,3)
              XK4 = PHYSOL(I,4,3)
              XK5 = PHYSOL(I,5,3)
              XK6 = PHYSOL(I,6,3)
            ENDIF
C
C           Calcul des termes diagonaux
C           ---------------------------
C               
            SV1 = 1.D0 / VOLUME(I) 
C                                                                       
C                                                                       
            X45 = COORDS(N5,1) - COORDS(N4,1)
            Y45 = COORDS(N5,2) - COORDS(N4,2)
            X46 = COORDS(N6,1) - COORDS(N4,1)
            Y46 = COORDS(N6,2) - COORDS(N4,2)
            X65 = COORDS(N5,1) - COORDS(N6,1)
            Y65 = COORDS(N5,2) - COORDS(N6,2)
C
            ALFA1 =  SV1 * (X45*X65 + Y45*Y65)
            ALFA2 = -SV1 * (X46*X65 + Y46*Y65)
            ALFA3 =  SV1 * (X46*X45 + Y46*Y45) 
C                                                                       
C                                                                       
            XKM1 = S3 * (XK1+XK4+XK6)                             
            XKM2 = S3 * (XK4+XK2+XK5)                             
            XKM3 = S3 * (XK5+XK3+XK6)                            
            XKM4 = S3 * (XK4+XK5+XK6)                             
C
C
            WCT(I,1) =  (ALFA2+ALFA3)*XKM1
            WCT(I,2) =  (ALFA1+ALFA3)*XKM2
            WCT(I,3) =  (ALFA1+ALFA2)*XKM3
            WCT(I,4) =  ALFA1*(XKM1+XKM4) +
     &                  ALFA2*(XKM2+XKM4) +
     &                  ALFA3*(XKM1+XKM2)
            WCT(I,5) =  ALFA1*(XKM2+XKM3) +
     &                  ALFA2*(XKM4+XKM2) +
     &                  ALFA3*(XKM4+XKM3)
            WCT(I,6) =  ALFA1*(XKM1+XKM4) +
     &                  ALFA2*(XKM1+XKM3) +
     &                  ALFA3*(XKM4+XKM3) 
C
C
            XMAT(I,1) =  -ALFA3*XKM1
            XMAT(I,2) =  -ALFA2*XKM1
C
            XMAT(I,3) =  -ALFA3*XKM2
            XMAT(I,4) =  -ALFA1*XKM2
C
            XMAT(I,5) =  -ALFA1*XKM3
            XMAT(I,6) =  -ALFA2*XKM3
C
            XMAT(I,7) =  -ALFA2*(XKM2+XKM4)
            XMAT(I,8) =  -ALFA1*(XKM1+XKM4)
C
            XMAT(I,9) =  -ALFA3*(XKM3+XKM4)
C
  110     CONTINUE
C
C         
C       1.2- CAS AXISYMETRIQUE (DONC 2D) 
C       --------------------------------
        ELSE    
C
          DO 120 I=1,NELEMS
C
            N1 = NODES(I,1)
            N2 = NODES(I,2)
            N3 = NODES(I,3)
            N4 = NODES(I,4)
            N5 = NODES(I,5)
            N6 = NODES(I,6)   
C
            IF (NDPROP.EQ.1) THEN        
              XK1 = PHYSOL(N1,1,3)
              XK2 = PHYSOL(N2,1,3)
              XK3 = PHYSOL(N3,1,3)
              XK4 = PHYSOL(N4,1,3)
              XK5 = PHYSOL(N5,1,3)
              XK6 = PHYSOL(N6,1,3)  
            ELSEIF(NDPROP.EQ.2) THEN
              XKE = PHYSOL(I,1,3)      
              XK1 = XKE
              XK2 = XKE
              XK3 = XKE
              XK4 = XKE
              XK5 = XKE
              XK6 = XKE
            ELSE
              XK1 = PHYSOL(I,1,3)
              XK2 = PHYSOL(I,2,3)
              XK3 = PHYSOL(I,3,3)
              XK4 = PHYSOL(I,4,3)
              XK5 = PHYSOL(I,5,3)
              XK6 = PHYSOL(I,6,3)
            ENDIF
C
            SV24 = S24 / VOLUME(I) 
C
            R1 = ABS(COORDS(N1,NCA)) * SV24
            R2 = ABS(COORDS(N2,NCA)) * SV24
            R3 = ABS(COORDS(N3,NCA)) * SV24
C                                                                       
C                                                                       
            X45 = COORDS(N5,1) - COORDS(N4,1)
            Y45 = COORDS(N5,2) - COORDS(N4,2)
            X46 = COORDS(N6,1) - COORDS(N4,1)
            Y46 = COORDS(N6,2) - COORDS(N4,2)
            X65 = COORDS(N5,1) - COORDS(N6,1)
            Y65 = COORDS(N5,2) - COORDS(N6,2)
C
            ALFA1 =   X45*X65 + Y45*Y65
            ALFA2 = -(X46*X65 + Y46*Y65)
            ALFA3 =   X46*X45 + Y46*Y45
C       
C
            WCT(I,1) = (ALFA2+ALFA3)*( XK1*( 6*R1 + R2 + R3 )
     &                                +XK4*( 5*R1 + 2*R2 + R3 )
     &                                +XK6*( 5*R1 + R2 + 2*R3 ) )
            WCT(I,2) = (ALFA1+ALFA3)*( XK2*( R1 + 6*R2 + R3 )
     &                                +XK4*( 2*R1 + 5*R2 + R3 )
     &                                +XK5*( R1 + 5*R2 + 2*R3 ) )
            WCT(I,3) = (ALFA1+ALFA2)*( XK3*( R1 + R2 + 6*R3 )
     &                                +XK5*( R1 + 2*R2 + 5*R3 )
     &                                +XK6*( 2*R1 + R2 + 5*R3 ) )
            WCT(I,4) = XK1 * (ALFA1+ALFA3) * ( 6*R1 + R2 + R3 ) +
     &                 XK2 * (ALFA2+ALFA3) * ( R1 + 6*R2 + R3 ) +
     &                 XK4 * ( ALFA1*( 8*R1 + 5*R2 + 3*R3 ) +
     &                         ALFA2*( 5*R1 + 8*R2  + 3*R3 ) +
     &                         ALFA3*( 7*(R1+R2) + 2*R3 ) ) +
     &                 XK5 * ( ALFA1*( 2*R1 + 3*(R2+R3) ) +
     &                         ALFA2*( 3*R1 + 8*R2  + 5*R3 ) +
     &                         ALFA3*( R1 + 5*R2 + 2*R3 ) ) +
     &                 XK6 * ( ALFA1*( 8*R1 + 3*R2 + 5*R3 ) +
     &                         ALFA2*( 3*(R1+R3) + 2*R2 ) +
     &                         ALFA3*( 5*R1 + R2 + 2*R3 ) )
            WCT(I,5) = XK2 * ( ALFA1+ALFA2 ) * ( R1 + 6*R2 + R3 ) +
     &                 XK3 * ( ALFA1+ALFA3 ) * ( R1 + R2 + 6*R3 ) +
     &                 XK4 * ( ALFA1*( 2*R1 + 5*R2 + R3 ) +
     &                         ALFA2*( 5*R1 + 8*R2  + 3*R3 ) +
     &                         ALFA3*( 3*(R1+R2) + 2*R3 ) ) +
     &                 XK5 * ( ALFA1*( 2*R1 + 7*(R2+R3) ) +
     &                         ALFA2*( 3*R1 + 8*R2  + 5*R3 ) +
     &                         ALFA3*( 3*R1 + 5*R2 + 8*R3 ) ) +
     &                 XK6 * ( ALFA1*( 2*R1 + R2 + 5*R3 ) +
     &                         ALFA2*( 3*(R1+R3) + 2*R2 ) +
     &                         ALFA3*( 5*R1 + 3*R2 + 8*R3 ) )
            WCT(I,6) = XK1 * ( ALFA1+ALFA2) * ( 6*R1 + R2 + R3 ) +
     &                 XK3 * ( ALFA2+ALFA3) * ( R1 + R2 + 6*R3 ) +
     &                 XK4 * ( ALFA1*( 8*R1 + 5*R2 + 3*R3 ) +
     &                         ALFA2*( 5*R1 + 2*R2  + R3 ) +
     &                         ALFA3*( 3*(R1+R2) + 2*R3 ) ) +
     &                 XK5 * ( ALFA1*( 2*R1 + 3*(R2+R3) ) +
     &                         ALFA2*( R1 + 2*R2  + 5*R3 ) +
     &                         ALFA3*( 3*R1 + 5*R2 + 8*R3 ) ) +
     &                 XK6 * ( ALFA1*( 8*R1 + 3*R2 + 5*R3 ) +
     &                         ALFA2*( 7*(R1+R3) + 2*R2 ) +
     &                         ALFA3*( 5*R1 + 3*R2 + 8*R3 ) ) 
C
C
C           Premiere extra ligne de la matrice elementaire
            XMAT(I,1) = ALFA3*( XK1*( -6*R1 - (R2+R3) ) -
     &                         XK4*( 5*R1 + 2*R2 + R3 ) -
     &                         XK6*( 5*R1 + R2 + 2*R3 ) )
            XMAT(I,2) = ALFA2*( XK1*( -6*R1 -  (R2+R3) ) -
     &                         XK4*( 5*R1 + 2*R2 + R3 ) -
     &                         XK6*( 5*R1 + R2 + 2*R3 ) )
C           Deuxieme extra ligne de la matrice elementaire
            XMAT(I,3) = ALFA3*( XK2*( -R1 - 6*R2 - R3 ) -
     &                         XK4*( 2*R1 + 5*R2 + R3 ) -
     &                         XK5*( R1 + 5*R2 + 2*R3 ) )
            XMAT(I,4) = ALFA1*( XK2*( -R1 - 6*R2 - R3 ) -
     &                         XK4*( 2*R1 + 5*R2 + R3 ) -
     &                         XK5*( R1 + 5*R2 + 2*R3 ) )
C           Troisieme extra ligne de la matrice elementaire
            XMAT(I,5) = ALFA1*( XK3*( -R1 - R2 - 6*R3 ) -
     &                         XK5*( R1 + 2*R2 + 5*R3 ) -
     &                         XK6*( 2*R1 + R2 + 5*R3 ) )
            XMAT(I,6) = ALFA2*( XK3*( -R1 - R2 - 6*R3 ) -
     &                         XK5*( R1 + 2*R2 + 5*R3 ) -
     &                         XK6*( 2*R1 + R2 + 5*R3 ) )
C           Quatrieme extra ligne de la matrice elementaire
            XMAT(I,7) = ALFA2*( XK2*( -R1 - 6*R2 - R3 ) -
     &                         XK4*( 5*R1 + 8*R2 + 3*R3 ) -
     &                         XK5*( 3*R1 + 8*R2 + 5*R3 ) -
     &                         XK6*( 3*(R1+R3) + 2*R2 ) )
            XMAT(I,8) = ALFA1*( XK1*( -6*R1 - (R2+R3) ) -
     &                         XK4*( 8*R1 + 5*R2 + 3*R3 ) -
     &                         XK5*( 2*R1 + 3*(R2+R3) ) -
     &                         XK6*( 8*R1 + 3*R2 + 5*R3 ) )
C           Cinquieme extra ligne de la matrice elementaire
            XMAT(I,9) = ALFA3*( XK3*( -R1 - R2 - 6*R3 ) -
     &                         XK4*( 3*(R1+R2) + 2*R3 ) -
     &                         XK5*( 3*R1 + 5*R2 + 8*R3 ) -
     &                         XK6*( 5*R1 + 3*R2 + 8*R3 ) )
  120     CONTINUE
C
         ENDIF
C
C
C     2- CAS TRIDIMENSIONNEL
C     ======================
      ELSE
C     
         DO 200 I=1,NELEMS
C
           SV29 = S29 / VOLUME(I)             
C
C
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
           N7 = NODES(I,7)
           N8 = NODES(I,8)
           N9 = NODES(I,9)
           N10 = NODES(I,10)
C
C
           X5 = COORDS(N5,1)
           X6 = COORDS(N6,1) 
           X7 = COORDS(N7,1) 
           X8 = COORDS(N8,1) 
           X9 = COORDS(N9,1) 
           X10 = COORDS(N10,1)
C      
           Y5 = COORDS(N5,2)         
           Y6 = COORDS(N6,2) 
           Y7 = COORDS(N7,2) 
           Y8 = COORDS(N8,2)
           Y9 = COORDS(N9,2) 
           Y10 = COORDS(N10,2)       
C      
           Z5 = COORDS(N5,3)         
           Z6 = COORDS(N6,3) 
           Z7 = COORDS(N7,3) 
           Z8 = COORDS(N8,3)
           Z9 = COORDS(N9,3) 
           Z10 = COORDS(N10,3)                   
C
           IF (NDPROP.EQ.1) THEN
             XK1 = PHYSOL(N1,1,3)
             XK2 = PHYSOL(N2,1,3)
             XK3 = PHYSOL(N3,1,3)
             XK4 = PHYSOL(N4,1,3)
             XK5 = PHYSOL(N5,1,3)
             XK6 = PHYSOL(N6,1,3)
             XK7 = PHYSOL(N7,1,3)
             XK8 = PHYSOL(N8,1,3)
             XK9 = PHYSOL(N9,1,3)
             XK10 = PHYSOL(N10,1,3)
           ELSEIF(NDPROP.EQ.2) THEN
             XKE = PHYSOL(I,1,3)
             XK1 = XKE
             XK2 = XKE
             XK3 = XKE
             XK4 = XKE
             XK5 = XKE
             XK6 = XKE
             XK7 = XKE
             XK8 = XKE
             XK9 = XKE
             XK10 = XKE
           ELSE
              XK1 = PHYSOL(I,1,3)
              XK2 = PHYSOL(I,2,3)
              XK3 = PHYSOL(I,3,3)
              XK4 = PHYSOL(I,4,3)
              XK5 = PHYSOL(I,5,3)
              XK6 = PHYSOL(I,6,3)
              XK7 = PHYSOL(I,7,3)
              XK8 = PHYSOL(I,8,3)
              XK9 = PHYSOL(I,9,3)
              XK10 = PHYSOL(I,10,3)
            ENDIF

           XKM1 = S4 * (XK1+XK5+XK7+XK8)                      
           XKM2 = S4 * (XK2+XK5+XK6+XK9)                      
           XKM3 = S4 * (XK3+XK6+XK7+XK10)                     
           XKM4 = S4 * (XK4+XK8+XK9+XK10)                     
           XKM5 = S4 * (XK5+XK6+XK8+XK9)                       
           XKM6 = S4 * (XK5+XK6+XK7+XK8)                      
           XKM7 = S4 * (XK10+XK6+XK8+XK7)                     
           XKM8 = S4 * (XK10+XK6+XK8+XK9)                  
C
C
           XGRAD1 = Y7 * (Z5-Z8) - Y8 * (Z5-Z7) - Y5 * (Z7-Z8)
           YGRAD1 = X5 * (Z7-Z8) - X8 * (Z7-Z5) - X7 * (Z5-Z8)
           ZGRAD1 = X7 * (Y5-Y8) - X8 * (Y5-Y7) - X5 * (Y7-Y8)
           XGRAD2 = Y6 * (Z9-Z5) - Y5 * (Z9-Z6) - Y9 * (Z6-Z5)
           YGRAD2 = X9 * (Z6-Z5) - X5 * (Z6-Z9) - X6 * (Z9-Z5)
           ZGRAD2 = X6 * (Y9-Y5) - X5 * (Y9-Y6) - X9 * (Y6-Y5)
           XGRAD3 = Y7 * (Z10-Z6) - Y6 * (Z10-Z7) - Y10 * (Z7-Z6)
           YGRAD3 = X10 * (Z7-Z6) - X6 * (Z7-Z10) - X7 * (Z10-Z6)
           ZGRAD3 = X7 * (Y10-Y6) - X6 * (Y10-Y7) - X10 * (Y7-Y6)
           XGRAD4 = Y9 * (Z10-Z8) - Y8 * (Z10-Z9) - Y10 * (Z9-Z8)
           YGRAD4 = X10 * (Z9-Z8) - X8 * (Z9-Z10) - X9 * (Z10-Z8)
           ZGRAD4 = X9 * (Y10-Y8) - X8 * (Y10-Y9) - X10 * (Y9-Y8)
C
           ALFA1 = SV29 * (XGRAD3*XGRAD4+YGRAD3*YGRAD4+ZGRAD3*ZGRAD4)
           ALFA2 = SV29 * (XGRAD2*XGRAD4+YGRAD2*YGRAD4+ZGRAD2*ZGRAD4) 
           ALFA3 = SV29 * (XGRAD1*XGRAD4+YGRAD1*YGRAD4+ZGRAD1*ZGRAD4) 
           ALFA4 = SV29 * (XGRAD2*XGRAD3+YGRAD2*YGRAD3+ZGRAD2*ZGRAD3) 
           ALFA5 = SV29 * (XGRAD1*XGRAD3+YGRAD1*YGRAD3+ZGRAD1*ZGRAD3) 
           ALFA6 = SV29 * (XGRAD1*XGRAD2+YGRAD1*YGRAD2+ZGRAD1*ZGRAD2)
C
           ALFA11 = ALFA3 + ALFA5 + ALFA6
           ALFA22 = ALFA2 + ALFA4 + ALFA6 
           ALFA33 = ALFA1 + ALFA4 + ALFA5
           ALFA44 = ALFA1 + ALFA2 + ALFA3
C
C
           WCT(I,1) = XKM1*ALFA11                                        
           WCT(I,2) = XKM2*ALFA22                                        
           WCT(I,3) = XKM3*ALFA33                                         
           WCT(I,4) = XKM4*ALFA44                                         
           WCT(I,5) = XKM1*ALFA22 + XKM2*ALFA11 +                       
     &                (XKM5+XKM6)*(ALFA11+ALFA22-2*ALFA6)           
           WCT(I,6) = (XKM2+XKM5)*ALFA33 + (XKM3+XKM7)*ALFA22      
     &                +XKM6*ALFA11 + XKM8*ALFA44                   
           WCT(I,7) = XKM1*ALFA33 + XKM3*ALFA11 +                       
     &                (XKM6+XKM7)*(ALFA22+ALFA44-2*ALFA2)        
           WCT(I,8) = (XKM1+XKM6)*ALFA44 + (XKM4+XKM8)*ALFA11      
     &                +XKM5*ALFA22 + XKM7*ALFA33                  
           WCT(I,9) = XKM2*ALFA44 + XKM4*ALFA22 +                       
     &                (XKM5+XKM8)*(ALFA11+ALFA33-2*ALFA5)         
           WCT(I,10) = XKM3*ALFA44 + XKM4*ALFA33 +                     
     &                (XKM7+XKM8)*(ALFA33+ALFA44-2*ALFA1)
C
C  
           XMAT(I,1) = -XKM1*ALFA6                                       
           XMAT(I,2) = -XKM1*ALFA5                                       
           XMAT(I,3) = -XKM1*ALFA3                                       
C
           XMAT(I,4) = -XKM2*ALFA6                                       
           XMAT(I,5) = -XKM2*ALFA4                                       
           XMAT(I,6) = -XKM2*ALFA2                                       
C
           XMAT(I,7) = -XKM3*ALFA4                                       
           XMAT(I,8) = -XKM3*ALFA5                                      
           XMAT(I,9) = -XKM3*ALFA1                                       
C
           XMAT(I,10) = -XKM4*ALFA3                                      
           XMAT(I,11) = -XKM4*ALFA2                                      
           XMAT(I,12) = -XKM4*ALFA1                                     
C
           XMAT(I,13) = -(XKM2+XKM5+XKM6)*ALFA5 - XKM5*ALFA4 -     
     &                   XKM6*ALFA3                                    
           XMAT(I,14) = -ALFA4*XKM1 + (ALFA3-ALFA4)*XKM6               
           XMAT(I,15) = -(XKM1+XKM5+XKM6)*ALFA2 - XKM5*ALFA4 -     
     &                  XKM6*ALFA3                                    
           XMAT(I,16) = -ALFA3*XKM2 + (ALFA4-ALFA3)*XKM5
C
           XMAT(I,17) = -(XKM3+XKM6+XKM7)*ALFA6 - XKM6*ALFA3 -     
     &                  XKM7*ALFA4                                   
           XMAT(I,18) =  (XKM5+XKM7)*ALFA4 + (XKM6+XKM8)*ALFA3      
           XMAT(I,19) = -(XKM2+XKM5+XKM8)*ALFA1 - XKM5*ALFA4 -    
     &                  XKM8*ALFA3                                    
           XMAT(I,20) = -(XKM3+XKM7+XKM8)*ALFA2 - XKM7*ALFA4 -     
     &                  XKM8*ALFA3                                    
C
           XMAT(I,21) = -(XKM1+XKM6+XKM7)*ALFA1 - XKM6*ALFA3 -     
     &                  XKM7*ALFA4                                   
           XMAT(I,22) = -XKM3*ALFA3 + XKM7*(ALFA4-ALFA3)               
C
           XMAT(I,23) = -(XKM4+XKM5+XKM8)*ALFA6 - XKM5*ALFA4 -     
     &                  XKM8*ALFA3                                   
           XMAT(I,24) = -(XKM4+XKM7+XKM8)*ALFA5 - XKM7*ALFA4 -     
     &                  XKM8*ALFA3                                   
C
           XMAT(I,25) = -XKM4*ALFA4 + XKM8*(ALFA3-ALFA4)               
C                                                                         
  200    CONTINUE
C
C
C
      ENDIF                 
C
C------- 
C FORMAT
C-------
C
C
      END

