/* $Id: build_tide_db.h 1151 2006-11-21 01:37:00Z flaterco $ */

/*****************************************************************************\

                            DISTRIBUTION STATEMENT

    This source file is unclassified, distribution unlimited, public
    domain.  It is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

\*****************************************************************************/



/*
    All of this is for the case where you don't have one of Dave and Bob's
    harmonics files with the speeds, node factors, etc up front (like a NAVO
    ihbtide file).  Yeah it wastes memory but at $15 for 128MB I think we can
    afford this 100KB.  If you've just got to add something tack it on the end.
    Don't remove anything!

    These names and numbers came out of Bob Kenney's harmonics.txt file,
    harmonics.txt,v 1.51 2001/09/20 15:59:20 rmk

*/


#define DEFAULT_CONSTITUENTS                        173
#define DEFAULT_START_YEAR                          1970
#define DEFAULT_NUM_YEARS                           68



NV_CHAR *default_constituent[DEFAULT_CONSTITUENTS] = {
"J1", "K1", "K2", "L2", "M1", "M2", "M3", "M4", "M6", "M8", "N2", "2N2", "O1",
"OO1", "P1", "Q1", "2Q1", "R2", "S1", "S2", "S4", "S6", "T2", "LDA2", "MU2", 
"NU2", "RHO1", "MK3", "2MK3", "MN4", "MS4", "2SM2", "MF", "MSF", "MM", "SA", 
"SSA", "SA-IOS", "MF-IOS", "S1-IOS", "OO1-IOS", "R2-IOS", "A7", "2MK5", "2MK6",
"2MN2", "2MN6", "2MS6", "2NM6", "2SK5", "2SM6", "3MK7", "3MN8", "3MS2", "3MS4",
"3MS8", "ALP1", "BET1", "CHI1", "H1", "H2", "KJ2", "ETA2", "KQ1", "UPS1", 
"M10", "M12", "MK4", "MKS2", "MNS2", "EPS2", "MO3", "MP1", "TAU1", "MPS2", 
"MSK6", "MSM", "MSN2", "MSN6", "NLK2", "NO1", "OP2", "OQ2", "PHI1", "KP1", 
"PI1", "TK1", "PSI1", "RP1", "S3", "SIG1", "SK3", "SK4", "SN4", "SNK6", "SO1",
"SO3", "THE1", "2PO1", "2NS2", "MLN2S2", "2ML2S2", "SKM2", "2MS2K2", "MKL2S2",
"M2(KS)2", "2SN(MK)2", "2KM(SN)2", "NO3", "2MLS4", "ML4", "N4", "SL4", "MNO5",
"2MO5", "MSK5", "3KM5", "2MP5", "3MP5", "MNK5", "2NMLS6", "MSL6", "2ML6", 
"2MNLS6", "3MLS6", "2MNO7", "2NMK7", "2MSO7", "MSKO7", "2MSN8", "2(MS)8", 
"2(MN)8", "2MSL8", "4MLS8", "3ML8", "3MK8", "2MSK8", "2M2NK9", "3MNK9", "4MK9",
"3MSK9", "4MN10", "3MNS10", "4MS10", "3MSL10", "3M2S10", "4MSK11", "4MNS12", 
"5MS12", "4MSL12", "4M2S12", "M1C", "3MKS2", "OQ2-HORN", "MSK2", "MSP2", 
"2MP3", "4MS4", "2MNS4", "2MSK4", "3MN4", "2MSN4", "3MK5", "3MO5", "3MNS6", 
"4MS6", "2MNU6", "3MSK6", "MKNU6", "3MSN6", "M7", "2MNK8", "2(MS)N10"};



NV_FLOAT64 default_speed[DEFAULT_CONSTITUENTS] = {
015.5854433, 015.0410686, 030.0821373, 029.5284789, 014.4966939, 028.9841042, 
043.4761563, 057.9682084, 086.9523126, 115.9364169, 028.4397295, 027.8953548, 
013.9430356, 016.1391017, 014.9589314, 013.3986609, 012.8542862, 030.0410667, 
015.0000000, 030.0000000, 060.0000000, 090.0000000, 029.9589333, 029.4556253, 
027.9682084, 028.5125831, 013.4715145, 044.0251729, 042.9271398, 057.4238337, 
058.9841042, 031.0158958, 001.0980331, 001.0158958, 000.5443747, 000.0410686, 
000.0821373, 000.0410667, 001.0980331, 015.0000020, 016.1391017, 030.0410667, 
001.6424078, 073.0092771, 088.0503457, 029.5284789, 086.4079379, 087.9682084, 
085.8635632, 075.0410686, 088.9841042, 101.9933813, 115.3920422, 026.9523126, 
056.9523126, 116.9523126, 012.3827651, 014.4145567, 014.5695476, 028.9430375, 
029.0251709, 030.6265120, 030.6265120, 016.6834764, 016.6834764, 144.9205211, 
173.9046253, 059.0662415, 029.0662415, 027.4238337, 027.4238337, 042.9271398, 
014.0251729, 014.0251729, 028.9430356, 089.0662415, 000.4715211, 030.5443747, 
087.4238337, 027.8860711, 014.4966939, 028.9019669, 027.3509801, 015.1232059, 
015.1232059, 014.9178647, 014.9178647, 015.0821353, 015.0821353, 045.0000000, 
012.9271398, 045.0410686, 060.0821373, 058.4397295, 088.5218668, 016.0569644, 
043.9430356, 015.5125897, 015.9748271, 026.8794590, 026.9523126, 027.4966873, 
031.0980331, 027.8039339, 028.5947204, 029.1483788, 029.3734880, 030.7086493, 
042.3827651, 057.4966873, 058.5125831, 056.8794590, 059.5284789, 071.3668693, 
071.9112440, 074.0251729, 074.1073101, 072.9271398, 071.9933813, 072.4649024, 
085.3920422, 088.5125831, 087.4966873, 085.9364169, 086.4807916, 100.3509735, 
100.9046319, 101.9112440, 103.0092771, 116.4079379, 117.9682084, 114.8476675, 
117.4966873, 115.4648958, 116.4807916, 117.0344499, 118.0503457, 129.8887361, 
130.4331108, 130.9774855, 131.9933813, 144.3761464, 145.3920422, 145.9364169, 
146.4807916, 146.9523126, 160.9774855, 174.3761464, 174.9205211, 175.4648958, 
175.9364169, 014.4920521, 026.8701754, 027.3416965, 028.9019669, 029.0251729, 
043.0092771, 055.9364169, 056.4079379, 057.8860711, 058.5125831, 059.5284789, 
071.9112440, 073.0092771, 085.3920422, 085.9364169, 086.4807916, 086.8701754, 
087.5788246, 088.5125831, 101.4490066, 116.4900752, 146.4079379};



NV_FLOAT32 default_equilibrium[DEFAULT_CONSTITUENTS][DEFAULT_NUM_YEARS] = {
{
270.05, 001.78, 092.97, 197.37, 286.57, 014.27, 100.25, 198.59, 281.78, 004.92,
089.08, 188.94, 276.50, 005.57, 095.83, 201.00, 292.69, 024.71, 116.80, 222.80,
314.35, 045.25, 135.20, 237.90, 324.96, 050.25, 134.02, 231.09, 314.52, 039.28,
125.78, 228.00, 317.57, 048.20, 139.58, 245.48, 337.55, 069.61, 161.44, 266.83,
357.39, 086.88, 174.94, 275.37, 000.02, 083.38, 166.42, 264.32, 349.74, 076.91,
165.67, 269.74, 000.69, 092.28, 184.25, 290.40, 022.39, 114.06, 205.13, 309.37,
038.34, 125.78, 211.47, 309.58, 032.69, 115.92, 200.32, 300.47
},
{
013.44, 015.49, 017.10, 019.05, 019.16, 018.22, 016.17, 014.11, 010.46, 006.78,
003.66, 002.49, 001.46, 001.47, 002.36, 004.91, 006.93, 009.21, 011.55, 014.76,
016.66, 018.05, 018.71, 019.41, 018.04, 015.58, 012.24, 009.48, 005.96, 003.18,
001.46, 001.83, 002.21, 003.38, 005.15, 008.28, 010.60, 012.92, 015.04, 017.76,
018.89, 019.20, 018.51, 017.70, 014.86, 011.30, 007.56, 005.26, 002.87, 001.58,
001.37, 003.07, 004.49, 006.43, 008.66, 012.00, 014.26, 016.25, 017.78, 019.60,
019.55, 018.43, 016.21, 014.02, 010.32, 006.69, 003.71, 002.72
},
{
207.25, 211.54, 214.77, 218.44, 218.22, 215.87, 211.50, 207.58, 200.89, 194.16,
188.16, 185.60, 183.05, 182.63, 184.17, 189.26, 193.46, 198.30, 203.30, 209.98,
213.91, 216.60, 217.60, 218.53, 215.36, 210.34, 204.04, 199.21, 192.68, 187.17,
183.36, 183.61, 183.99, 186.18, 189.78, 196.26, 201.21, 206.15, 210.62, 216.10,
218.18, 218.42, 216.55, 214.58, 208.98, 202.40, 195.61, 191.35, 186.43, 183.41,
182.51, 185.62, 188.41, 192.41, 197.15, 204.13, 208.93, 213.08, 216.10, 219.49,
218.93, 216.23, 211.57, 207.47, 200.72, 194.06, 188.25, 185.98
},
{
263.01, 059.88, 245.03, 081.90, 282.66, 098.96, 276.37, 099.71, 297.89, 131.01,
310.20, 116.37, 313.40, 159.24, 350.38, 135.56, 334.44, 188.11, 026.26, 165.34,
002.18, 212.44, 049.08, 205.69, 030.36, 229.37, 066.73, 242.79, 059.19, 244.12,
083.71, 275.07, 095.26, 260.71, 105.01, 306.25, 133.04, 286.91, 131.88, 331.50,
160.87, 324.65, 157.82, 348.14, 182.73, 003.65, 182.09, 001.96, 202.17, 039.83,
211.34, 017.26, 224.34, 074.18, 246.06, 041.02, 250.95, 101.09, 279.45, 075.08,
275.50, 118.08, 307.73, 112.34, 296.36, 131.77, 330.90, 150.45
},
{
155.31, 048.57, 307.44, 235.19, 158.91, 051.78, 302.47, 198.58, 135.99, 041.87,
291.54, 170.58, 087.77, 030.23, 291.57, 171.70, 081.59, 031.81, 299.20, 179.73,
085.44, 033.71, 304.99, 184.05, 079.09, 004.84, 293.81, 176.94, 064.81, 319.81,
251.40, 167.57, 062.96, 316.20, 237.35, 169.82, 070.23, 323.54, 239.49, 174.78,
077.30, 328.53, 231.31, 159.58, 072.78, 322.99, 211.44, 102.41, 042.75, 314.62,
206.58, 090.25, 024.65, 317.03, 213.12, 096.21, 025.29, 323.68, 220.94, 101.49,
016.36, 318.70, 220.30, 096.57, 348.29, 265.70, 200.61, 088.19
},
{
165.43, 266.78, 007.96, 084.54, 185.26, 285.75, 026.03, 101.78, 201.83, 301.88,
042.01, 117.89, 218.36, 319.06, 060.00, 136.77, 238.11, 339.56, 081.04, 158.08,
259.37, 000.47, 101.33, 177.58, 277.98, 018.20, 118.30, 193.96, 294.03, 034.20,
134.53, 210.71, 311.50, 052.53, 153.76, 230.77, 332.24, 073.70, 175.08, 251.92,
352.94, 093.71, 194.25, 270.19, 010.35, 110.42, 210.46, 286.18, 026.41, 126.83,
227.47, 303.98, 045.09, 146.39, 247.82, 324.92, 066.36, 167.68, 268.83, 345.37,
086.05, 186.50, 286.76, 002.49, 102.54, 202.60, 302.74, 018.65
},
{
068.15, 040.17, 011.94, 306.81, 277.89, 248.62, 219.04, 152.67, 122.75, 092.83,
063.01, 356.84, 327.54, 298.58, 269.99, 205.16, 177.17, 149.34, 121.55, 057.12,
029.05, 000.70, 332.00, 266.37, 236.97, 207.30, 177.44, 110.93, 081.04, 051.30,
021.80, 316.06, 287.25, 258.79, 230.64, 166.15, 138.36, 110.55, 082.63, 017.89,
349.41, 320.57, 291.37, 225.29, 195.53, 165.63, 135.69, 069.27, 039.62, 010.24,
341.21, 275.96, 247.63, 219.59, 191.73, 127.38, 099.54, 071.53, 043.25, 338.06,
309.08, 279.76, 250.14, 183.74, 153.81, 123.90, 094.11, 027.98
}, 
{
330.86, 173.56, 015.92, 169.08, 010.52, 211.49, 052.06, 203.56, 043.67, 243.77,
084.01, 235.78, 076.72, 278.11, 119.99, 273.55, 116.22, 319.12, 162.07, 316.15,
158.73, 000.93, 202.67, 355.16, 195.97, 036.40, 236.59, 027.91, 228.05, 068.39,
269.07, 061.41, 263.00, 105.05, 307.52, 101.54, 304.48, 147.41, 350.17, 143.85,
345.87, 187.43, 028.50, 180.39, 020.71, 220.84, 060.93, 212.36, 052.82, 253.66,
094.94, 247.95, 090.18, 292.78, 135.64, 289.83, 132.72, 335.37, 177.66, 330.75,
172.11, 013.01, 213.52, 004.99, 205.08, 045.20, 245.48, 037.31
}, 
{
136.29, 080.34, 023.88, 253.62, 195.78, 137.24, 078.09, 305.34, 245.50, 185.65,
126.02, 353.68, 295.07, 237.17, 179.99, 050.32, 354.33, 298.67, 243.11, 114.23,
058.10, 001.40, 304.00, 172.74, 113.95, 054.61, 354.89, 221.87, 162.08, 102.59,
043.60, 272.12, 214.49, 157.58, 101.29, 332.31, 276.71, 221.11, 165.25, 035.77,
338.81, 281.14, 222.75, 090.58, 031.06, 331.26, 271.39, 138.54, 079.23, 020.48,
322.42, 191.93, 135.27, 079.17, 023.46, 254.75, 199.08, 143.05, 086.50, 316.12,
258.16, 199.51, 140.28, 007.48, 307.62, 247.79, 188.22, 055.96
}, 
{
301.72, 347.12, 031.84, 338.16, 021.04, 062.98, 104.12, 047.12, 087.34, 127.54,
168.03, 111.57, 153.43, 196.22, 239.98, 187.10, 232.45, 278.23, 324.14, 272.31,
317.47, 001.86, 045.34, 350.32, 031.93, 072.81, 113.18, 055.82, 096.10, 136.79,
178.14, 122.82, 165.99, 210.11, 255.05, 203.08, 248.95, 294.81, 340.33, 287.70,
331.75, 014.85, 057.00, 000.77, 041.42, 081.68, 121.85, 064.73, 105.64, 147.31,
189.89, 135.90, 180.36, 225.57, 271.28, 219.67, 265.43, 310.74, 355.33, 301.49,
344.22, 026.02, 067.04, 009.97, 050.16, 090.39, 130.96, 074.61
}, 
{
270.11, 282.73, 295.19, 269.98, 281.98, 293.74, 305.31, 279.27, 290.60, 301.93,
313.33, 287.43, 299.17, 311.15, 323.36, 298.35, 310.97, 323.69, 336.45, 311.70,
324.27, 336.65, 348.79, 323.25, 334.93, 346.43, 357.80, 331.67, 343.02, 354.47,
006.08, 340.47, 352.54, 004.84, 017.36, 352.58, 005.32, 018.07, 030.72, 005.78,
018.07, 030.12, 041.94, 016.09, 027.53, 038.87, 050.20, 024.13, 035.63, 047.33,
059.25, 033.97, 046.36, 058.94, 071.64, 046.95, 059.67, 072.28, 084.70, 059.45,
071.41, 083.14, 094.67, 068.62, 079.95, 091.28, 102.70, 076.83
}, 
{
014.78, 298.69, 222.42, 095.43, 018.70, 301.74, 224.58, 096.76, 019.37, 301.97,
224.65, 096.96, 019.98, 303.24, 226.73, 099.94, 023.83, 307.83, 231.86, 105.33,
029.17, 312.83, 236.25, 108.92, 031.88, 314.66, 237.30, 109.39, 032.01, 314.74,
237.63, 110.23, 033.58, 317.16, 240.95, 114.39, 038.41, 322.43, 246.37, 119.63,
043.20, 326.53, 249.62, 121.99, 044.71, 327.33, 249.93, 122.07, 044.86, 327.83,
251.03, 123.96, 047.63, 331.48, 255.47, 128.99, 052.99, 336.87, 260.57, 133.54,
056.77, 339.78, 262.59, 134.75, 057.35, 339.96, 262.66, 135.00
}, 
{
150.70, 249.04, 347.76, 061.72, 161.97, 263.47, 006.50, 085.70, 191.28, 296.92,
041.60, 119.41, 221.05, 321.40, 060.80, 134.19, 232.56, 330.72, 068.82, 141.65,
240.11, 339.03, 078.68, 154.01, 256.08, 359.72, 104.77, 185.15, 290.51, 034.64,
137.21, 212.94, 312.88, 052.01, 150.59, 223.48, 321.60, 059.73, 158.00, 231.24,
330.41, 070.43, 171.62, 248.92, 353.16, 098.58, 204.31, 283.91, 027.45, 129.41,
230.02, 304.24, 043.13, 141.57, 239.75, 312.48, 050.65, 149.04, 247.83, 321.92,
062.35, 164.09, 267.37, 346.78, 092.45, 197.99, 302.46, 020.01
}, 
{
058.75, 326.43, 232.65, 163.92, 064.60, 321.07, 212.54, 126.46, 009.82, 253.01,
139.20, 057.54, 313.57, 213.91, 117.58, 050.97, 318.55, 226.97, 135.62, 071.21,
338.41, 243.83, 146.63, 073.14, 327.73, 217.24, 102.27, 012.47, 256.52, 144.46,
037.45, 322.60, 224.34, 129.03, 035.76, 331.10, 239.67, 148.23, 056.16, 350.12,
254.63, 156.14, 053.64, 333.61, 221.23, 105.09, 348.00, 260.62, 150.48, 045.42,
304.87, 235.22, 140.79, 048.09, 316.39, 252.38, 160.76, 068.26, 334.17, 264.98,
165.05, 060.75, 311.40, 224.63, 107.73, 351.22, 238.11, 157.28
}, 
{
349.76, 350.00, 350.24, 349.50, 349.73, 349.97, 350.21, 349.46, 349.70, 349.94,
350.18, 349.43, 349.67, 349.91, 350.15, 349.40, 349.64, 349.88, 350.12, 349.37,
349.61, 349.85, 350.09, 349.34, 349.58, 349.82, 350.06, 349.31, 349.55, 349.79,
350.03, 349.28, 349.52, 349.76, 350.00, 349.25, 349.49, 349.73, 349.97, 349.22,
349.46, 349.70, 349.93, 349.19, 349.43, 349.67, 349.90, 349.16, 349.40, 349.63,
349.87, 349.13, 349.36, 349.60, 349.84, 349.10, 349.33, 349.57, 349.81, 349.06,
349.30, 349.54, 349.78, 349.03, 349.27, 349.51, 349.75, 349.00
}, 
{
255.38, 265.00, 274.99, 247.16, 258.69, 271.47, 285.78, 263.19, 280.05, 296.96,
312.93, 288.95, 301.86, 313.49, 324.17, 295.77, 305.42, 314.85, 324.23, 295.27,
305.01, 315.21, 326.14, 299.68, 313.03, 327.95, 344.28, 322.86, 339.51, 354.92,
008.76, 342.70, 353.92, 004.32, 014.18, 345.29, 354.69, 004.09, 013.64, 345.10,
355.55, 006.84, 019.31, 354.82, 010.34, 027.04, 044.04, 021.86, 036.67, 049.91,
061.80, 034.24, 044.40, 054.11, 063.57, 034.52, 043.96, 053.63, 063.70, 036.00,
047.71, 060.72, 075.29, 052.91, 069.86, 086.67, 102.42, 078.18
}, 
{
000.06, 280.95, 202.22, 072.61, 355.41, 279.47, 205.06, 080.68, 008.82, 297.01,
224.25, 098.48, 022.67, 305.58, 227.54, 097.35, 018.28, 298.99, 219.64, 088.90,
009.92, 291.40, 213.60, 085.35, 009.98, 296.18, 223.78, 100.58, 028.50, 315.19,
240.31, 112.46, 034.96, 316.64, 237.78, 107.10, 027.77, 308.45, 229.28, 098.95,
020.68, 303.25, 226.99, 100.72, 027.51, 315.49, 243.78, 119.80, 045.89, 330.41,
253.58, 124.23, 045.67, 326.66, 247.40, 116.56, 037.28, 318.22, 239.57, 110.09,
033.07, 317.36, 243.20, 119.04, 047.26, 335.36, 262.38, 136.36
}, 
{
177.81, 177.55, 177.30, 178.03, 177.77, 177.52, 177.26, 177.99, 177.73, 177.48,
177.22, 177.95, 177.70, 177.44, 177.19, 177.91, 177.66, 177.40, 177.15, 177.88,
177.62, 177.36, 177.11, 177.84, 177.58, 177.33, 177.07, 177.80, 177.54, 177.29,
177.03, 177.76, 177.51, 177.25, 177.00, 177.72, 177.47, 177.21, 176.96, 177.69,
177.43, 177.17, 176.92, 177.65, 177.39, 177.14, 176.88, 177.61, 177.35, 177.10,
176.84, 177.57, 177.32, 177.06, 176.81, 177.53, 177.28, 177.02, 176.77, 177.50,
177.24, 176.98, 176.73, 177.46, 177.20, 176.95, 176.69, 177.42
}, 
{
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00
}, 
{
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00
}, 
{
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00
}, 
{
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00,
000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00, 000.00
}, 
{
002.19, 002.45, 002.70, 001.97, 002.23, 002.48, 002.74, 002.01, 002.27, 002.52,
002.78, 002.05, 002.30, 002.56, 002.81, 002.09, 002.34, 002.60, 002.85, 002.12,
002.38, 002.64, 002.89, 002.16, 002.42, 002.67, 002.93, 002.20, 002.46, 002.71,
002.97, 002.24, 002.49, 002.75, 003.00, 002.28, 002.53, 002.79, 003.04, 002.31,
002.57, 002.83, 003.08, 002.35, 002.61, 002.86, 003.12, 002.39, 002.65, 002.90,
003.16, 002.43, 002.68, 002.94, 003.19, 002.47, 002.72, 002.98, 003.23, 002.50,
002.76, 003.02, 003.27, 002.54, 002.80, 003.05, 003.31, 002.58
}, 
{
285.57, 197.44, 109.14, 007.56, 278.81, 189.82, 100.63, 358.22, 268.80, 179.37,
090.02, 347.75, 258.74, 169.96, 081.43, 340.05, 251.91, 163.88, 075.88, 334.76,
246.58, 158.20, 069.60, 327.68, 238.61, 149.35, 059.97, 317.47, 228.07, 138.76,
049.63, 307.64, 218.96, 130.51, 042.27, 301.12, 213.11, 125.10, 037.01, 295.69,
207.23, 118.53, 029.59, 287.37, 198.06, 108.65, 019.22, 276.78, 187.53, 098.47,
009.64, 267.99, 179.62, 091.45, 003.41, 262.34, 174.31, 086.16, 357.83, 256.21,
167.42, 078.40, 349.18, 246.75, 157.32, 067.90, 338.57, 236.33
}, 
{
329.97, 172.07, 014.01, 166.96, 008.43, 209.67, 050.71, 202.83, 043.64, 244.44,
085.31, 237.57, 078.79, 280.24, 121.93, 275.08, 117.17, 319.37, 161.60, 315.02,
157.06, 358.91, 200.53, 353.15, 194.31, 035.28, 236.12, 028.15, 228.98, 069.90,
270.99, 063.54, 265.08, 106.86, 308.85, 102.23, 304.45, 146.67, 348.80, 142.01,
343.78, 185.31, 026.60, 178.91, 019.83, 220.65, 061.44, 213.53, 054.51, 255.68,
097.08, 249.96, 091.82, 293.88, 136.06, 289.53, 131.72, 333.80, 175.70, 328.61,
170.05, 011.25, 212.26, 004.36, 205.16, 045.97, 246.87, 039.15
}, 
{
225.30, 156.12, 086.78, 341.51, 271.71, 201.67, 131.43, 025.34, 314.87, 244.39,
173.99, 068.04, 357.98, 288.15, 218.56, 113.50, 044.32, 335.24, 266.19, 161.39,
092.16, 022.73, 313.07, 207.48, 137.36, 067.05, 356.62, 250.44, 179.98, 109.63,
039.44, 293.77, 224.04, 154.54, 085.25, 340.42, 271.36, 202.30, 133.16, 028.16,
318.65, 248.90, 178.91, 073.01, 002.65, 292.19, 221.71, 115.59, 045.29, 335.18,
265.30, 159.97, 090.55, 021.33, 312.24, 207.49, 138.41, 069.21, 359.83, 254.53,
184.69, 114.61, 044.34, 298.24, 227.76, 157.29, 086.91, 340.98
}, 
{
210.57, 138.38, 066.57, 318.70, 248.42, 179.40, 111.91, 009.26, 304.32, 239.43,
173.59, 069.56, 000.67, 290.49, 219.37, 110.92, 038.76, 326.40, 253.97, 144.96,
072.90, 001.30, 290.42, 183.91, 115.45, 048.57, 343.10, 241.63, 176.47, 110.08,
042.12, 296.01, 225.43, 154.02, 082.08, 333.13, 260.73, 188.33, 116.08, 007.48,
296.13, 225.61, 156.28, 051.75, 345.46, 280.36, 215.56, 113.32, 046.33, 337.77,
267.86, 160.23, 088.59, 016.51, 304.17, 195.06, 122.70, 050.56, 338.83, 231.08,
160.99, 092.20, 024.96, 282.53, 217.67, 152.68, 086.63, 342.34
}, 
{
178.87, 282.27, 025.06, 103.59, 204.42, 303.97, 042.20, 115.89, 212.29, 308.66,
045.66, 120.38, 219.81, 320.53, 062.36, 141.69, 245.04, 348.76, 092.59, 172.84,
276.03, 018.52, 120.04, 196.99, 296.03, 033.78, 130.54, 203.44, 299.98, 037.38,
135.99, 212.54, 313.71, 055.91, 158.91, 239.05, 342.84, 086.62, 190.13, 269.68,
011.83, 112.91, 212.76, 287.89, 025.21, 121.72, 218.02, 291.44, 029.28, 128.41,
228.84, 307.04, 049.58, 152.82, 256.49, 336.91, 080.62, 183.94, 286.61, 004.98,
105.60, 204.94, 302.97, 016.51, 112.86, 209.29, 306.45, 021.37
}, 
{
317.42, 158.07, 358.82, 150.03, 351.36, 193.27, 035.89, 189.45, 033.21, 236.99,
080.36, 233.29, 075.26, 276.64, 117.63, 268.64, 109.29, 309.91, 150.52, 301.39,
142.07, 342.88, 183.96, 335.75, 177.92, 020.82, 224.35, 018.43, 222.09, 065.21,
267.61, 059.58, 260.79, 101.67, 302.38, 093.26, 293.87, 134.49, 335.12, 126.09,
326.99, 168.22, 009.99, 162.69, 005.85, 209.54, 053.36, 207.11, 049.95, 252.08,
093.58, 244.89, 085.68, 286.36, 126.98, 277.84, 118.46, 319.12, 159.89, 311.14,
152.56, 354.58, 197.31, 350.97, 194.76, 038.50, 241.77, 034.59
}, 
{
075.54, 189.51, 303.15, 354.52, 107.24, 219.49, 331.33, 021.05, 132.44, 243.81,
355.34, 045.32, 157.53, 270.20, 023.36, 075.13, 189.08, 303.25, 057.48, 109.78,
223.64, 337.11, 090.13, 140.83, 252.92, 004.63, 116.09, 165.63, 277.04, 028.67,
140.62, 191.17, 304.04, 057.37, 171.12, 223.35, 337.56, 091.77, 205.81, 257.70,
011.01, 123.83, 236.19, 286.28, 037.89, 149.30, 260.66, 310.31, 062.04, 174.16,
286.72, 337.94, 091.45, 205.33, 319.46, 011.87, 126.03, 239.96, 353.53, 044.83,
157.47, 269.65, 021.43, 071.11, 182.49, 293.88, 045.44, 095.48
}, 
{
165.43, 266.78, 007.96, 084.54, 185.26, 285.75, 026.03, 101.78, 201.83, 301.88,
042.01, 117.89, 218.36, 319.06, 060.00, 136.77, 238.11, 339.56, 081.04, 158.08,
259.37, 000.47, 101.33, 177.58, 277.98, 018.20, 118.30, 193.96, 294.03, 034.20,
134.53, 210.71, 311.50, 052.53, 153.76, 230.77, 332.24, 073.70, 175.08, 251.92,
352.94, 093.71, 194.25, 270.19, 010.35, 110.42, 210.46, 286.18, 026.41, 126.83,
227.47, 303.98, 045.09, 146.39, 247.82, 324.92, 066.36, 167.68, 268.83, 345.37,
086.05, 186.50, 286.76, 002.49, 102.54, 202.60, 302.74, 018.65
}, 
{
194.57, 093.22, 352.04, 275.46, 174.74, 074.25, 333.97, 258.22, 158.17, 058.12,
317.99, 242.11, 141.64, 040.94, 300.00, 223.23, 121.89, 020.44, 278.96, 201.92,
100.63, 359.53, 258.67, 182.42, 082.02, 341.80, 241.70, 166.04, 065.97, 325.80,
225.47, 149.29, 048.50, 307.47, 206.24, 129.23, 027.76, 286.30, 184.92, 108.08,
007.06, 266.29, 165.75, 089.81, 349.65, 249.58, 149.54, 073.82, 333.59, 233.17,
132.53, 056.02, 314.91, 213.61, 112.18, 035.08, 293.64, 192.32, 091.17, 014.63,
273.95, 173.50, 073.24, 357.51, 257.46, 157.40, 057.26, 341.35
}, 
{
044.02, 308.69, 212.45, 141.10, 041.32, 298.80, 193.02, 110.38, 359.27, 248.05,
138.80, 059.06, 316.26, 216.26, 118.39, 048.39, 312.99, 218.12, 123.40, 054.78,
319.15, 222.40, 123.97, 049.56, 305.83, 198.76, 088.75, 003.66, 253.00, 144.91,
040.12, 324.83, 225.73, 128.51, 032.59, 323.81, 229.04, 134.25, 039.08, 329.44,
232.11, 132.86, 031.01, 312.34, 204.03, 093.25, 341.84, 258.36, 151.52, 048.00,
307.42, 235.49, 138.83, 043.26, 308.32, 239.95, 145.06, 049.61, 313.17, 241.53,
141.35, 038.33, 292.01, 208.93, 097.64, 346.62, 237.83, 158.63
}, 
{
194.57, 093.22, 352.04, 275.46, 174.74, 074.25, 333.97, 258.22, 158.17, 058.12,
317.99, 242.11, 141.64, 040.94, 300.00, 223.23, 121.89, 020.44, 278.96, 201.92,
100.63, 359.53, 258.67, 182.42, 082.02, 341.80, 241.70, 166.04, 065.97, 325.80,
225.47, 149.29, 048.50, 307.47, 206.24, 129.23, 027.76, 286.30, 184.92, 108.08,
007.06, 266.29, 165.75, 089.81, 349.65, 249.58, 149.54, 073.82, 333.59, 233.17,
132.53, 056.02, 314.91, 213.61, 112.18, 035.08, 293.64, 192.32, 091.17, 014.63,
273.95, 173.50, 073.24, 357.51, 257.46, 157.40, 057.26, 341.35
}, 
{
255.32, 344.05, 072.77, 174.56, 263.28, 352.00, 080.72, 182.51, 271.23, 359.96,
088.68, 190.47, 279.19, 007.91, 096.63, 198.42, 287.14, 015.86, 104.59, 206.37,
295.10, 023.82, 112.54, 214.33, 303.05, 031.77, 120.50, 222.28, 311.01, 039.73,
128.45, 230.24, 318.96, 047.68, 136.40, 238.19, 326.91, 055.64, 144.36, 246.15,
334.87, 063.59, 152.31, 254.10, 342.82, 071.55, 160.27, 262.05, 350.78, 079.50,
168.22, 270.01, 358.73, 087.45, 176.18, 277.96, 006.69, 095.41, 184.13, 285.92,
014.64, 103.36, 192.09, 293.87, 022.59, 111.32, 200.04, 301.83
}, 
{
280.24, 280.00, 279.76, 280.50, 280.27, 280.03, 279.79, 280.54, 280.30, 280.06,
279.82, 280.57, 280.33, 280.09, 279.85, 280.60, 280.36, 280.12, 279.88, 280.63,
280.39, 280.15, 279.91, 280.66, 280.42, 280.18, 279.94, 280.69, 280.45, 280.21,
279.97, 280.72, 280.48, 280.24, 280.00, 280.75, 280.51, 280.27, 280.03, 280.78,
280.54, 280.30, 280.07, 280.81, 280.57, 280.33, 280.10, 280.84, 280.60, 280.37,
280.13, 280.87, 280.64, 280.40, 280.16, 280.90, 280.67, 280.43, 280.19, 280.94,
280.70, 280.46, 280.22, 280.97, 280.73, 280.49, 280.25, 281.00
}, 
{
200.47, 199.99, 199.52, 201.01, 200.53, 200.05, 199.58, 201.07, 200.59, 200.12,
199.64, 201.13, 200.65, 200.18, 199.70, 201.19, 200.72, 200.24, 199.76, 201.26,
200.78, 200.30, 199.82, 201.32, 200.84, 200.36, 199.88, 201.38, 200.90, 200.42,
199.95, 201.44, 200.96, 200.48, 200.01, 201.50, 201.02, 200.55, 200.07, 201.56,
201.09, 200.61, 200.13, 201.62, 201.15, 200.67, 200.19, 201.69, 201.21, 200.73,
200.25, 201.75, 201.27, 200.79, 200.32, 201.81, 201.33, 200.85, 200.38, 201.87,
201.39, 200.92, 200.44, 201.93, 201.45, 200.98, 200.50, 201.99
}, 
{
357.81, 357.55, 357.30, 358.03, 357.77, 357.52, 357.26, 357.99, 357.73, 357.48,
357.22, 357.95, 357.70, 357.44, 357.19, 357.91, 357.66, 357.40, 357.15, 357.88,
357.62, 357.36, 357.11, 357.84, 357.58, 357.33, 357.07, 357.80, 357.54, 357.29,
357.03, 357.76, 357.51, 357.25, 357.00, 357.72, 357.47, 357.21, 356.96, 357.69,
357.43, 357.17, 356.92, 357.65, 357.39, 357.14, 356.88, 357.61, 357.35, 357.10,
356.84, 357.57, 357.32, 357.06, 356.81, 357.53, 357.28, 357.02, 356.77, 357.50,
357.24, 356.98, 356.73, 357.46, 357.20, 356.95, 356.69, 357.42
}, 
{
035.93, 294.70, 193.47, 118.59, 017.36, 276.13, 174.90, 100.02, 358.79, 257.56,
156.33, 081.45, 340.22, 238.99, 137.76, 062.88, 321.65, 220.42, 119.19, 044.32,
303.09, 201.86, 100.63, 025.75, 284.52, 183.29, 082.06, 007.18, 265.95, 164.72,
063.49, 348.61, 247.38, 146.15, 044.92, 330.04, 228.81, 127.58, 026.35, 311.47,
210.24, 109.01, 007.78, 292.90, 191.67, 090.44, 349.21, 274.34, 173.11, 071.88,
330.64, 255.77, 154.54, 053.31, 312.08, 237.20, 135.97, 034.74, 293.51, 218.63,
117.40, 016.17, 274.94, 200.06, 098.83, 357.60, 256.37, 181.49
}, 
{
024.29, 023.62, 023.10, 022.79, 022.71, 022.88, 023.28, 023.84, 024.53, 025.26,
025.97, 026.59, 027.05, 027.31, 027.33, 027.11, 026.66, 026.04, 025.32, 024.61,
023.99, 023.54, 023.31, 023.33, 023.59, 024.05, 024.67, 025.38, 026.11, 026.79,
027.35, 027.74, 027.91, 027.84, 027.53, 027.01, 026.35, 025.63, 024.94, 024.38,
024.01, 023.87, 023.98, 024.32, 024.84, 025.50, 026.22, 026.94, 027.58, 028.09,
028.40, 028.48, 028.31, 027.92, 027.34, 026.65, 025.93, 025.28, 024.79, 024.51,
024.46, 024.66, 025.07, 025.65, 026.34, 027.06, 027.76, 028.35
}, 
{
063.82, 324.38, 225.92, 165.87, 073.36, 321.72, 201.54, 116.84, 020.80, 265.20,
138.89, 047.46, 309.60, 221.23, 121.11, 046.38, 314.46, 231.40, 139.36, 067.47,
333.09, 248.40, 153.22, 070.04, 316.35, 216.12, 116.62, 020.31, 250.70, 132.51,
038.21, 331.22, 225.69, 122.94, 033.55, 336.62, 241.79, 143.30, 052.91, 356.06,
258.68, 150.43, 044.62, 339.91, 233.95, 106.91, 336.90, 249.79, 157.21, 053.84,
303.46, 228.15, 141.07, 053.99, 316.68, 246.81, 159.88, 074.50, 335.68, 257.86,
160.17, 070.47, 319.97, 220.30, 093.29, 346.39, 249.72, 163.79
}, 
{
182.30, 181.93, 181.61, 182.36, 182.20, 182.10, 182.04, 182.99, 182.95, 182.90,
182.79, 183.62, 183.38, 183.07, 182.69, 183.25, 182.78, 182.31, 181.86, 182.43,
182.08, 181.80, 181.60, 182.44, 182.36, 182.32, 182.29, 183.23, 183.16, 183.03,
182.84, 183.56, 183.22, 182.82, 182.37, 182.88, 182.42, 181.98, 181.59, 182.25,
182.00, 181.83, 181.71, 182.63, 182.60, 182.57, 182.51, 183.41, 183.25, 183.03,
182.73, 183.35, 182.93, 182.47, 182.00, 182.52, 182.10, 181.74, 181.45, 182.21,
182.07, 181.98, 181.93, 182.88, 182.84, 182.78, 182.66, 183.47
}, 
{
299.35, 292.74, 285.22, 315.65, 304.60, 290.80, 273.74, 292.89, 270.50, 248.00,
227.48, 249.53, 235.45, 224.17, 215.02, 246.81, 240.14, 233.99, 227.99, 261.15,
254.25, 246.22, 236.52, 263.89, 248.88, 230.53, 209.25, 225.95, 204.01, 184.64,
168.57, 195.07, 184.69, 176.19, 168.99, 202.00, 195.95, 189.89, 183.44, 215.58,
206.98, 196.45, 183.32, 206.44, 186.86, 164.80, 142.11, 160.41, 142.29, 127.50,
115.64, 145.50, 137.56, 130.72, 124.49, 157.91, 151.74, 145.02, 137.30, 167.45,
155.99, 141.70, 124.10, 142.80, 120.24, 097.93, 077.87, 100.46
}, 
{
344.30, 189.05, 033.02, 188.13, 029.68, 229.71, 068.23, 217.67, 054.13, 250.55,
087.67, 238.28, 078.17, 279.58, 122.35, 278.46, 123.15, 328.32, 173.62, 330.91,
175.40, 018.98, 221.38, 014.57, 214.01, 051.99, 248.83, 037.40, 234.01, 071.58,
270.53, 063.24, 265.20, 108.44, 312.67, 109.82, 315.08, 160.32, 005.21, 161.61,
004.76, 206.63, 047.01, 198.08, 035.57, 232.14, 068.49, 217.62, 055.69, 255.23,
096.31, 251.02, 094.67, 299.21, 144.31, 301.83, 146.98, 351.62, 195.44, 350.35,
191.66, 031.44, 229.73, 019.01, 215.40, 051.89, 249.19, 040.03
}, 
{
178.11, 025.10, 230.69, 027.52, 228.74, 067.36, 263.56, 051.14, 244.55, 077.93,
272.18, 061.38, 259.76, 100.75, 304.16, 102.81, 309.69, 157.41, 005.37, 166.13,
012.65, 217.53, 060.27, 213.70, 051.33, 246.74, 080.63, 227.12, 060.73, 255.56,
092.43, 245.02, 086.98, 291.24, 137.30, 297.80, 145.69, 353.56, 200.78, 359.95,
204.06, 045.85, 245.05, 034.96, 229.69, 063.24, 256.53, 043.71, 239.25, 077.06,
277.46, 073.57, 278.58, 125.19, 332.79, 133.96, 341.65, 188.45, 033.76, 190.23,
031.03, 229.24, 065.09, 212.46, 045.80, 239.26, 073.73, 223.29
}, 
{
060.76, 250.83, 080.73, 259.10, 088.54, 277.75, 106.75, 284.29, 113.07, 301.84,
130.69, 308.36, 137.55, 326.97, 156.63, 335.19, 165.25, 355.42, 185.62, 004.45,
194.46, 024.28, 213.88, 031.91, 221.03, 049.97, 238.79, 056.24, 245.03, 073.92,
262.98, 080.94, 270.46, 100.21, 290.17, 108.96, 299.15, 129.34, 319.44, 138.07,
327.81, 157.30, 346.56, 164.29, 353.18, 181.97, 010.73, 188.24, 017.19, 206.33,
035.69, 213.99, 043.82, 233.85, 064.00, 242.88, 073.04, 263.09, 092.96, 271.29,
100.69, 289.87, 118.84, 296.37, 125.14, 313.92, 142.78, 320.48
}, 
{
240.97, 096.30, 311.11, 079.06, 292.50, 145.24, 357.36, 122.83, 334.27, 185.70,
037.34, 163.21, 015.89, 229.26, 083.35, 211.90, 067.19, 282.81, 138.52, 267.86,
123.01, 337.58, 191.46, 318.41, 170.90, 022.83, 234.39, 359.58, 211.07, 062.86,
275.15, 041.88, 255.53, 109.90, 324.88, 094.12, 309.80, 165.47, 020.89, 149.63,
003.94, 217.55, 070.44, 196.48, 048.24, 259.72, 111.12, 236.49, 088.46, 300.98,
154.19, 281.92, 136.54, 351.72, 207.29, 336.79, 192.39, 047.65, 262.36, 030.20,
243.52, 096.15, 308.19, 073.61, 285.03, 136.48, 348.18, 114.13
}, 
{
330.86, 173.56, 015.92, 169.08, 010.52, 211.49, 052.06, 203.56, 043.67, 243.77,
084.01, 235.78, 076.72, 278.11, 119.99, 273.55, 116.22, 319.12, 162.07, 316.15,
158.73, 000.93, 202.67, 355.16, 195.97, 036.40, 236.59, 027.91, 228.05, 068.39,
269.07, 061.41, 263.00, 105.05, 307.52, 101.54, 304.48, 147.41, 350.17, 143.85,
345.87, 187.43, 028.50, 180.39, 020.71, 220.84, 060.93, 212.36, 052.82, 253.66,
094.94, 247.95, 090.18, 292.78, 135.64, 289.83, 132.72, 335.37, 177.66, 330.75,
172.11, 013.01, 213.52, 004.99, 205.08, 045.20, 245.48, 037.31
}, 
{
345.64, 112.25, 238.34, 264.51, 029.22, 153.24, 276.64, 300.32, 063.04, 185.74,
308.67, 332.75, 096.70, 221.35, 346.72, 013.48, 140.05, 266.95, 033.93, 061.48,
187.91, 313.76, 078.92, 104.08, 227.85, 351.06, 113.89, 137.30, 260.06, 023.13,
146.70, 171.64, 296.57, 062.21, 188.48, 215.93, 342.88, 109.84, 236.53, 263.48,
029.08, 153.96, 278.12, 302.38, 065.42, 188.17, 310.85, 334.43, 097.68, 221.48,
345.97, 011.91, 137.80, 264.27, 031.11, 058.82, 185.70, 312.24, 078.23, 104.28,
228.88, 352.79, 116.11, 139.74, 262.43, 025.16, 148.14, 172.31
}, 
{
013.44, 015.49, 017.10, 019.05, 019.16, 018.22, 016.17, 014.11, 010.46, 006.78,
003.66, 002.49, 001.46, 001.47, 002.36, 004.91, 006.93, 009.21, 011.55, 014.76,
016.66, 018.05, 018.71, 019.41, 018.04, 015.58, 012.24, 009.48, 005.96, 003.18,
001.46, 001.83, 002.21, 003.38, 005.15, 008.28, 010.60, 012.92, 015.04, 017.76,
018.89, 019.20, 018.51, 017.70, 014.86, 011.30, 007.56, 005.26, 002.87, 001.58,
001.37, 003.07, 004.49, 006.43, 008.66, 012.00, 014.26, 016.25, 017.78, 019.60,
019.55, 018.43, 016.21, 014.02, 010.32, 006.69, 003.71, 002.72
}, 
{
165.43, 266.78, 007.96, 084.54, 185.26, 285.75, 026.03, 101.78, 201.83, 301.88,
042.01, 117.89, 218.36, 319.06, 060.00, 136.77, 238.11, 339.56, 081.04, 158.08,
259.37, 000.47, 101.33, 177.58, 277.98, 018.20, 118.30, 193.96, 294.03, 034.20,
134.53, 210.71, 311.50, 052.53, 153.76, 230.77, 332.24, 073.70, 175.08, 251.92,
352.94, 093.71, 194.25, 270.19, 010.35, 110.42, 210.46, 286.18, 026.41, 126.83,
227.47, 303.98, 045.09, 146.39, 247.82, 324.92, 066.36, 167.68, 268.83, 345.37,
086.05, 186.50, 286.76, 002.49, 102.54, 202.60, 302.74, 018.65
}, 
{
149.73, 095.83, 040.98, 272.67, 214.93, 155.46, 094.26, 319.45, 255.96, 192.43,
129.68, 356.17, 296.53, 238.64, 182.35, 055.24, 001.26, 307.88, 254.66, 128.99,
074.77, 019.45, 322.71, 192.15, 131.99, 070.19, 007.13, 231.35, 168.03, 105.77,
045.06, 273.95, 216.70, 160.96, 106.44, 340.59, 287.31, 234.03, 180.29, 053.53,
357.70, 300.34, 241.26, 108.27, 045.92, 342.56, 278.95, 143.80, 082.10, 022.06,
323.78, 194.99, 139.76, 085.60, 032.13, 266.75, 213.34, 159.31, 104.27, 335.72,
277.71, 217.95, 156.49, 021.50, 317.94, 254.49, 191.93, 058.68
}, 
{
046.40, 003.08, 319.07, 163.60, 117.76, 070.98, 023.39, 224.61, 176.10, 127.58,
079.35, 281.10, 234.24, 188.31, 143.35, 348.68, 305.30, 262.37, 219.55, 065.93,
022.37, 338.05, 292.80, 135.99, 088.88, 041.03, 352.68, 193.54, 145.10, 097.06,
049.69, 252.59, 207.03, 162.42, 118.64, 324.89, 282.04, 239.17, 195.97, 041.55,
356.88, 311.26, 264.68, 106.67, 058.60, 010.14, 321.59, 162.67, 114.87, 067.81,
021.67, 225.89, 181.63, 138.11, 095.11, 301.70, 258.75, 215.33, 171.20, 015.57,
329.58, 282.66, 234.95, 076.10, 027.57, 339.07, 290.92, 132.79
}, 
{
136.29, 080.34, 023.88, 253.62, 195.78, 137.24, 078.09, 305.34, 245.50, 185.65,
126.02, 353.68, 295.07, 237.17, 179.99, 050.32, 354.33, 298.67, 243.11, 114.23,
058.10, 001.40, 304.00, 172.74, 113.95, 054.61, 354.89, 221.87, 162.08, 102.59,
043.60, 272.12, 214.49, 157.58, 101.29, 332.31, 276.71, 221.11, 165.25, 035.77,
338.81, 281.14, 222.75, 090.58, 031.06, 331.26, 271.39, 138.54, 079.23, 020.48,
322.42, 191.93, 135.27, 079.17, 023.46, 254.75, 199.08, 143.05, 086.50, 316.12,
258.16, 199.51, 140.28, 007.48, 307.62, 247.79, 188.22, 055.96
}, 
{
136.29, 080.34, 023.88, 253.62, 195.78, 137.24, 078.09, 305.34, 245.50, 185.65,
126.02, 353.68, 295.07, 237.17, 179.99, 050.32, 354.33, 298.67, 243.11, 114.23,
058.10, 001.40, 304.00, 172.74, 113.95, 054.61, 354.89, 221.87, 162.08, 102.59,
043.60, 272.12, 214.49, 157.58, 101.29, 332.31, 276.71, 221.11, 165.25, 035.77,
338.81, 281.14, 222.75, 090.58, 031.06, 331.26, 271.39, 138.54, 079.23, 020.48,
322.42, 191.93, 135.27, 079.17, 023.46, 254.75, 199.08, 143.05, 086.50, 316.12,
258.16, 199.51, 140.28, 007.48, 307.62, 247.79, 188.22, 055.96
}, 
{
136.29, 080.34, 023.88, 253.62, 195.78, 137.24, 078.09, 305.34, 245.50, 185.65,
126.02, 353.68, 295.07, 237.17, 179.99, 050.32, 354.33, 298.67, 243.11, 114.23,
058.10, 001.40, 304.00, 172.74, 113.95, 054.61, 354.89, 221.87, 162.08, 102.59,
043.60, 272.12, 214.49, 157.58, 101.29, 332.31, 276.71, 221.11, 165.25, 035.77,
338.81, 281.14, 222.75, 090.58, 031.06, 331.26, 271.39, 138.54, 079.23, 020.48,
322.42, 191.93, 135.27, 079.17, 023.46, 254.75, 199.08, 143.05, 086.50, 316.12,
258.16, 199.51, 140.28, 007.48, 307.62, 247.79, 188.22, 055.96
}, 
{
059.69, 169.94, 280.68, 329.33, 081.81, 195.56, 310.74, 004.46, 121.86, 239.30,
355.95, 048.45, 162.32, 274.91, 026.46, 074.44, 184.73, 294.74, 044.67, 091.92,
202.34, 313.33, 065.16, 115.28, 229.57, 345.31, 102.26, 156.98, 274.19, 030.36,
145.11, 195.65, 307.80, 059.03, 169.60, 216.93, 326.89, 076.86, 187.03, 234.82,
346.10, 098.33, 211.77, 263.81, 020.07, 137.33, 254.85, 308.92, 064.56, 178.75,
291.61, 340.55, 091.49, 201.88, 311.93, 359.05, 109.07, 219.39, 330.22, 019.02,
131.69, 245.66, 001.08, 054.98, 172.45, 289.81, 046.27, 098.54
}, 
{
270.01, 178.29, 087.09, 342.64, 253.36, 165.58, 079.57, 341.27, 258.21, 175.20,
091.10, 351.21, 263.58, 174.43, 084.11, 338.92, 247.25, 155.28, 063.23, 317.27,
225.72, 134.80, 044.79, 301.99, 214.87, 129.57, 045.89, 308.96, 225.64, 140.90,
054.35, 312.04, 222.40, 131.73, 040.34, 294.47, 202.45, 110.43, 018.64, 273.24,
182.63, 093.07, 004.92, 264.45, 179.83, 096.58, 013.68, 275.86, 190.43, 103.18,
014.34, 270.21, 179.23, 087.65, 355.73, 249.63, 157.67, 066.02, 334.93, 230.63,
141.57, 054.06, 328.35, 230.30, 147.33, 064.22, 339.86, 239.68
}, 
{
074.59, 267.08, 099.02, 279.79, 109.74, 298.20, 124.92, 299.64, 123.59, 307.48,
132.39, 308.62, 136.93, 326.75, 157.76, 339.31, 171.76, 004.52, 197.37, 019.74,
212.05, 043.70, 234.39, 053.47, 241.28, 067.33, 251.85, 065.29, 249.47, 074.99,
262.24, 080.83, 271.16, 102.54, 294.67, 116.94, 309.76, 142.58, 335.16, 156.92,
348.23, 178.47, 007.29, 184.09, 009.49, 193.61, 017.40, 191.67, 017.84, 205.77,
035.28, 215.72, 047.43, 239.77, 072.48, 255.01, 087.76, 280.17, 112.00, 292.61,
122.34, 310.53, 136.97, 311.45, 135.31, 319.30, 144.45, 320.97
}, 
{
345.53, 086.06, 187.73, 264.88, 007.57, 109.70, 210.69, 284.99, 023.82, 122.79,
222.79, 298.75, 041.06, 143.72, 245.99, 321.92, 062.11, 161.68, 261.57, 337.15,
079.24, 182.02, 284.75, 001.36, 102.05, 201.45, 300.24, 014.06, 114.40, 215.98,
318.36, 035.47, 137.36, 238.20, 338.03, 052.18, 152.34, 253.70, 356.16, 073.76,
176.47, 278.23, 018.63, 092.47, 191.31, 290.81, 031.50, 107.94, 210.32, 312.57,
054.04, 129.05, 228.59, 328.14, 068.60, 144.99, 247.73, 350.81, 093.44, 169.57,
269.69, 008.79, 107.80, 182.28, 283.34, 025.33, 127.67, 204.26
}, 
{
162.88, 263.72, 004.47, 081.68, 182.16, 282.49, 022.72, 099.46, 199.56, 299.65,
039.78, 116.60, 216.93, 317.39, 057.99, 135.32, 236.16, 337.07, 077.99, 155.48,
256.29, 356.99, 097.55, 174.57, 274.86, 015.05, 115.17, 191.86, 291.96, 032.12,
132.38, 209.36, 309.87, 050.53, 151.30, 228.78, 329.70, 070.61, 171.48, 248.85,
349.50, 090.00, 190.37, 267.22, 007.37, 107.47, 207.56, 284.29, 024.48, 124.78,
225.21, 302.38, 043.09, 143.90, 244.80, 322.33, 063.23, 164.06, 264.78, 341.98,
082.43, 182.75, 282.95, 359.69, 099.78, 199.88, 300.02, 016.85
}, 
{
104.78, 199.52, 293.18, 040.19, 129.85, 216.55, 299.77, 034.67, 112.33, 189.89,
269.48, 007.42, 093.81, 183.22, 275.02, 023.58, 118.25, 213.55, 309.02, 059.23,
153.61, 246.69, 337.85, 081.47, 166.86, 248.73, 327.54, 059.90, 138.03, 218.83,
303.10, 045.77, 136.19, 228.72, 322.76, 072.77, 168.19, 263.59, 358.52, 107.51,
199.91, 290.16, 017.57, 116.64, 197.21, 275.22, 352.57, 086.59, 168.71, 254.33,
343.12, 089.47, 182.65, 277.11, 012.32, 122.83, 218.10, 312.70, 046.13, 152.82,
242.04, 328.20, 050.86, 145.29, 222.78, 300.53, 020.61, 119.12
}, 
{
105.07, 199.55, 292.82, 039.94, 130.17, 216.98, 299.45, 034.15, 112.75, 190.40,
269.06, 006.97, 094.04, 183.63, 275.00, 023.27, 118.14, 213.79, 309.26, 059.10,
153.25, 246.61, 338.23, 081.70, 166.41, 248.39, 328.13, 060.28, 137.43, 218.49,
303.50, 046.10, 136.00, 228.42, 322.81, 073.09, 168.32, 263.34, 358.23, 107.60,
200.28, 290.17, 017.07, 116.50, 197.88, 275.41, 351.87, 086.43, 169.23, 254.51,
342.77, 089.25, 182.87, 277.42, 012.30, 122.52, 217.94, 312.93, 046.41, 152.64,
241.58, 328.27, 051.51, 145.28, 222.07, 300.59, 021.18, 119.08
}, 
{
314.07, 310.48, 305.42, 338.47, 327.88, 313.07, 293.27, 308.97, 281.05, 252.97,
227.88, 248.01, 232.76, 221.82, 214.22, 249.39, 245.69, 242.83, 240.20, 277.58,
273.50, 267.65, 259.17, 287.46, 270.78, 249.01, 222.77, 234.76, 207.52, 184.19,
165.90, 192.83, 183.30, 176.71, 172.17, 209.29, 206.59, 203.87, 200.52, 236.26,
229.50, 219.73, 205.95, 227.71, 204.05, 176.63, 148.26, 162.68, 141.26, 124.92,
113.09, 145.23, 139.52, 135.54, 132.56, 170.34, 167.45, 163.67, 158.30, 190.90,
179.69, 164.11, 143.48, 158.51, 130.33, 102.54, 078.15, 099.11
}, 
{
315.54, 309.06, 302.90, 339.93, 331.81, 312.90, 287.36, 304.59, 285.81, 260.07,
228.83, 243.36, 229.95, 224.03, 216.17, 248.24, 244.52, 244.39, 241.35, 275.69,
271.54, 269.54, 261.75, 285.81, 266.12, 248.94, 229.03, 239.41, 205.66, 178.67,
164.61, 195.79, 184.38, 174.89, 171.58, 211.39, 207.36, 201.76, 199.28, 238.25,
230.69, 217.21, 203.44, 231.16, 209.51, 177.23, 143.32, 157.88, 142.74, 128.31,
112.90, 142.74, 139.64, 137.99, 132.90, 168.25, 167.00, 165.54, 158.26, 188.04,
179.24, 169.05, 146.89, 155.11, 123.34, 100.62, 082.95, 102.35
}, 
{
107.15, 253.90, 039.80, 062.70, 206.30, 348.73, 130.14, 148.90, 289.17, 069.42,
210.04, 229.46, 011.79, 155.28, 299.98, 323.87, 110.56, 257.79, 045.18, 070.38,
216.84, 002.33, 146.67, 167.90, 309.92, 091.01, 231.48, 249.78, 030.13, 170.98,
312.67, 333.53, 117.49, 262.63, 048.81, 073.85, 221.19, 008.51, 155.42, 179.62,
324.69, 108.56, 251.25, 270.96, 051.77, 192.10, 332.32, 350.91, 132.05, 274.14,
057.36, 079.88, 225.45, 011.96, 159.10, 184.58, 331.79, 118.42, 264.16, 286.86,
070.27, 212.52, 353.80, 012.47, 152.71, 292.99, 073.70, 093.27
}, 
{
272.58, 160.68, 047.76, 147.24, 031.56, 274.48, 156.17, 250.68, 131.01, 011.31,
252.04, 347.35, 230.15, 114.34, 359.97, 100.65, 348.67, 237.35, 126.21, 228.46,
116.20, 002.80, 248.01, 345.48, 227.90, 109.21, 349.77, 083.73, 324.15, 205.18,
087.21, 184.24, 068.99, 315.16, 202.57, 304.62, 193.43, 082.22, 330.50, 071.55,
317.62, 202.28, 085.50, 181.16, 062.13, 302.52, 182.78, 277.09, 158.47, 040.97,
284.83, 023.85, 270.54, 158.35, 046.92, 149.50, 038.15, 286.11, 172.99, 272.24,
156.33, 039.03, 280.56, 014.96, 255.25, 135.59, 016.44, 111.92
}, 
{
012.68, 118.32, 222.73, 302.98, 043.48, 141.61, 237.53, 309.36, 042.72, 136.05,
230.17, 303.49, 041.41, 141.69, 244.17, 326.03, 071.57, 177.86, 284.34, 008.06,
113.28, 217.07, 318.94, 036.11, 133.35, 228.54, 322.34, 033.16, 126.70, 221.37,
317.89, 034.31, 135.48, 238.71, 343.54, 067.03, 173.45, 279.85, 025.70, 108.02,
211.12, 312.14, 050.80, 124.77, 219.33, 312.82, 046.07, 117.53, 212.84, 310.23,
049.99, 129.59, 233.50, 338.80, 084.97, 169.04, 275.29, 020.77, 124.93, 204.86,
304.98, 042.73, 138.33, 209.96, 303.26, 036.66, 130.99, 204.63
}, 
{
012.68, 118.32, 222.73, 302.98, 043.48, 141.61, 237.53, 309.36, 042.72, 136.05,
230.17, 303.49, 041.41, 141.69, 244.17, 326.03, 071.57, 177.86, 284.34, 008.06,
113.28, 217.07, 318.94, 036.11, 133.35, 228.54, 322.34, 033.16, 126.70, 221.37,
317.89, 034.31, 135.48, 238.71, 343.54, 067.03, 173.45, 279.85, 025.70, 108.02,
211.12, 312.14, 050.80, 124.77, 219.33, 312.82, 046.07, 117.53, 212.84, 310.23,
049.99, 129.59, 233.50, 338.80, 084.97, 169.04, 275.29, 020.77, 124.93, 204.86,
304.98, 042.73, 138.33, 209.96, 303.26, 036.66, 130.99, 204.63
}, 
{
075.54, 189.51, 303.15, 354.52, 107.24, 219.49, 331.33, 021.05, 132.44, 243.81,
355.34, 045.32, 157.53, 270.20, 023.36, 075.13, 189.08, 303.25, 057.48, 109.78,
223.64, 337.11, 090.13, 140.83, 252.92, 004.63, 116.09, 165.63, 277.04, 028.67,
140.62, 191.17, 304.04, 057.37, 171.12, 223.35, 337.56, 091.77, 205.81, 257.70,
011.01, 123.83, 236.19, 286.28, 037.89, 149.30, 260.66, 310.31, 062.04, 174.16,
286.72, 337.94, 091.45, 205.33, 319.46, 011.87, 126.03, 239.96, 353.53, 044.83,
157.47, 269.65, 021.43, 071.11, 182.49, 293.88, 045.44, 095.48
}, 
{
074.67, 188.06, 301.26, 352.41, 105.14, 217.64, 329.95, 020.30, 132.40, 244.50,
356.66, 047.13, 159.62, 272.33, 025.28, 076.63, 190.01, 303.50, 057.03, 108.67,
221.99, 335.11, 087.99, 138.80, 251.23, 003.48, 115.61, 165.88, 277.99, 030.20,
142.57, 193.31, 306.11, 059.15, 172.42, 224.02, 337.54, 091.05, 204.47, 255.89,
008.92, 121.71, 234.26, 284.78, 036.98, 149.10, 261.19, 311.50, 063.77, 176.20,
288.86, 339.93, 093.06, 206.40, 319.87, 011.57, 125.06, 238.42, 351.59, 042.70,
155.39, 267.86, 020.15, 070.48, 182.57, 294.68, 046.86, 097.35
}, 
{
316.14, 155.82, 355.72, 146.26, 347.23, 189.22, 032.53, 187.48, 033.12, 238.80,
083.61, 237.31, 079.41, 280.46, 120.80, 270.97, 110.67, 310.27, 149.85, 299.73,
139.48, 339.50, 180.02, 331.59, 174.06, 017.92, 223.07, 019.10, 224.54, 068.84,
271.74, 063.65, 264.38, 104.53, 304.35, 094.25, 293.84, 133.43, 333.09, 123.17,
323.35, 164.14, 005.87, 159.12, 003.52, 209.01, 054.77, 210.09, 053.86, 256.24,
097.50, 248.22, 088.22, 287.96, 127.57, 277.40, 117.01, 316.72, 156.66, 307.30,
148.41, 350.59, 194.13, 349.28, 194.99, 040.59, 245.20, 038.66
}, 
{
179.27, 283.03, 026.25, 105.24, 206.46, 306.20, 044.20, 117.13, 212.35, 307.52,
043.71, 118.16, 217.74, 318.84, 061.13, 140.89, 244.61, 348.66, 092.78, 173.37,
276.95, 019.88, 121.85, 199.14, 298.23, 035.55, 131.35, 203.01, 298.47, 035.26,
133.79, 210.60, 312.20, 054.85, 158.26, 238.75, 342.85, 086.94, 190.80, 270.77,
013.37, 114.88, 214.98, 289.99, 026.67, 122.06, 217.13, 289.62, 027.07, 126.27,
227.06, 305.71, 048.69, 152.31, 256.31, 337.04, 081.07, 184.76, 287.87, 006.69,
107.70, 207.17, 304.88, 017.58, 112.71, 207.98, 304.41, 019.14
}, 
{
171.42, 265.46, 001.79, 080.98, 186.01, 287.69, 027.77, 107.39, 213.26, 316.77,
057.15, 135.39, 240.65, 344.69, 083.29, 156.16, 254.93, 354.71, 089.48, 158.18,
254.44, 357.41, 101.04, 177.85, 278.08, 022.21, 127.95, 206.93, 307.25, 050.09,
155.94, 235.69, 334.38, 072.87, 174.40, 250.76, 343.89, 075.17, 171.85, 251.12,
352.61, 091.44, 192.16, 273.86, 018.95, 120.31, 220.96, 301.60, 047.39, 149.54,
248.64, 326.02, 069.46, 168.81, 261.41, 329.81, 067.36, 168.75, 267.58, 341.90,
083.35, 188.98, 293.02, 010.24, 111.57, 216.61, 321.80, 039.66
}, 
{
335.20, 076.78, 178.20, 254.03, 354.99, 095.72, 196.24, 271.25, 011.54, 111.83,
212.19, 287.33, 028.03, 128.97, 230.15, 306.18, 047.75, 149.44, 251.15, 327.45,
068.98, 170.32, 271.42, 346.92, 087.56, 188.02, 288.35, 003.27, 103.57, 203.98,
304.56, 019.99, 121.02, 222.28, 323.76, 040.02, 141.73, 243.43, 345.05, 061.14,
162.39, 263.41, 004.18, 079.38, 179.78, 280.09, 020.37, 095.34, 195.81, 296.46,
037.34, 113.10, 214.45, 315.99, 057.66, 134.01, 235.69, 337.26, 078.64, 154.44,
255.36, 356.05, 096.54, 171.53, 271.81, 012.11, 112.49, 187.66
}, 
{
012.68, 118.32, 222.73, 302.98, 043.48, 141.61, 237.53, 309.36, 042.72, 136.05,
230.17, 303.49, 041.41, 141.69, 244.17, 326.03, 071.57, 177.86, 284.34, 008.06,
113.28, 217.07, 318.94, 036.11, 133.35, 228.54, 322.34, 033.16, 126.70, 221.37,
317.89, 034.31, 135.48, 238.71, 343.54, 067.03, 173.45, 279.85, 025.70, 108.02,
211.12, 312.14, 050.80, 124.77, 219.33, 312.82, 046.07, 117.53, 212.84, 310.23,
049.99, 129.59, 233.50, 338.80, 084.97, 169.04, 275.29, 020.77, 124.93, 204.86,
304.98, 042.73, 138.33, 209.96, 303.26, 036.66, 130.99, 204.63
}, 
{
300.13, 110.66, 281.18, 103.03, 273.55, 084.07, 254.60, 076.44, 246.97, 057.49,
228.01, 049.86, 220.38, 030.91, 201.43, 023.27, 193.80, 004.32, 174.85, 356.69,
167.21, 337.74, 148.26, 330.10, 140.63, 311.15, 121.68, 303.52, 114.04, 284.57,
095.09, 276.93, 087.46, 257.98, 068.51, 250.35, 060.87, 231.40, 041.92, 223.76,
034.29, 204.81, 015.34, 197.18, 007.70, 178.23, 348.75, 170.59, 341.12, 151.64,
322.17, 144.01, 314.54, 125.06, 295.58, 117.43, 287.95, 098.48, 269.00, 090.84,
261.37, 071.89, 242.42, 064.26, 234.78, 045.31, 215.83, 037.67
}, 
{
255.32, 344.05, 072.77, 174.56, 263.28, 352.00, 080.72, 182.51, 271.23, 359.96,
088.68, 190.47, 279.19, 007.91, 096.63, 198.42, 287.14, 015.86, 104.59, 206.37,
295.10, 023.82, 112.54, 214.33, 303.05, 031.77, 120.50, 222.28, 311.01, 039.73,
128.45, 230.24, 318.96, 047.68, 136.40, 238.19, 326.91, 055.64, 144.36, 246.15,
334.87, 063.59, 152.31, 254.10, 342.82, 071.55, 160.27, 262.05, 350.78, 079.50,
168.22, 270.01, 358.73, 087.45, 176.18, 277.96, 006.69, 095.41, 184.13, 285.92,
014.64, 103.36, 192.09, 293.87, 022.59, 111.32, 200.04, 301.83
}, 
{
075.54, 189.51, 303.15, 354.52, 107.24, 219.49, 331.33, 021.05, 132.44, 243.81,
355.34, 045.32, 157.53, 270.20, 023.36, 075.13, 189.08, 303.25, 057.48, 109.78,
223.64, 337.11, 090.13, 140.83, 252.92, 004.63, 116.09, 165.63, 277.04, 028.67,
140.62, 191.17, 304.04, 057.37, 171.12, 223.35, 337.56, 091.77, 205.81, 257.70,
011.01, 123.83, 236.19, 286.28, 037.89, 149.30, 260.66, 310.31, 062.04, 174.16,
286.72, 337.94, 091.45, 205.33, 319.46, 011.87, 126.03, 239.96, 353.53, 044.83,
157.47, 269.65, 021.43, 071.11, 182.49, 293.88, 045.44, 095.48
}, 
{
325.87, 131.08, 325.45, 133.44, 346.42, 176.83, 010.17, 171.40, 027.60, 238.77,
075.37, 218.20, 069.52, 287.75, 129.57, 244.66, 091.95, 313.50, 159.40, 267.06,
112.54, 332.49, 180.27, 310.41, 149.93, 005.46, 220.49, 015.25, 209.53, 051.42,
266.43, 071.93, 263.81, 079.37, 292.59, 102.56, 297.15, 098.82, 311.99, 121.17,
320.75, 136.34, 343.20, 149.65, 001.29, 200.13, 036.68, 194.74, 051.37, 263.75,
088.08, 225.61, 082.30, 300.71, 120.55, 243.84, 101.69, 320.28, 148.06, 275.05,
127.99, 345.00, 190.83, 333.50, 175.59, 028.99, 245.35, 041.30
}, 
{
119.40, 033.69, 307.43, 208.26, 120.01, 030.27, 298.80, 193.57, 099.32, 005.01,
271.72, 168.01, 078.12, 349.75, 262.56, 164.16, 078.41, 352.98, 267.63, 170.05,
084.16, 357.61, 270.11, 169.24, 078.85, 346.71, 253.03, 146.53, 052.51, 319.82,
228.88, 127.53, 039.65, 312.84, 226.77, 129.10, 043.72, 318.34, 232.72, 134.53,
047.65, 319.69, 230.32, 127.17, 034.37, 300.29, 205.89, 100.21, 008.19, 277.92,
189.23, 089.72, 003.23, 277.37, 191.89, 094.47, 009.02, 283.24, 196.87, 097.53,
009.06, 279.06, 187.30, 081.84, 347.50, 253.29, 160.24, 056.82
}, 
{
140.47, 239.05, 338.00, 051.22, 151.71, 253.45, 356.72, 075.16, 180.99, 286.86,
031.79, 108.85, 210.72, 311.31, 050.95, 123.60, 222.20, 320.60, 058.94, 131.02,
229.72, 328.88, 068.77, 143.35, 245.66, 349.54, 094.83, 174.46, 280.06, 024.43,
127.23, 202.22, 302.40, 041.76, 140.58, 212.73, 311.09, 049.45, 147.97, 220.46,
319.87, 060.12, 161.55, 238.11, 342.59, 088.25, 194.21, 273.07, 016.84, 119.05,
219.90, 293.37, 032.49, 131.17, 229.59, 301.58, 039.99, 138.61, 237.64, 310.99,
051.66, 153.63, 257.16, 335.82, 081.72, 187.50, 292.21, 009.01
}, 
{
119.51, 314.73, 149.75, 280.95, 115.48, 309.78, 143.87, 274.25, 108.13, 302.01,
135.96, 266.46, 100.74, 295.25, 130.01, 261.43, 096.63, 291.95, 127.31, 259.02,
094.17, 289.10, 123.78, 254.64, 088.86, 282.89, 116.81, 247.11, 081.00, 274.99,
109.14, 239.93, 074.53, 269.39, 104.47, 236.15, 071.50, 266.84, 102.09, 233.58,
068.42, 263.00, 097.35, 227.91, 061.89, 255.79, 089.66, 220.00, 054.05, 248.28,
082.73, 213.86, 048.80, 243.96, 079.26, 211.05, 046.36, 241.55, 076.53, 207.70,
042.19, 236.45, 070.52, 200.88, 034.76, 228.64, 062.60, 193.14
}, 
{
210.71, 209.99, 209.27, 211.51, 210.80, 210.08, 209.37, 211.61, 210.89, 210.17,
209.46, 211.70, 210.98, 210.27, 209.55, 211.79, 211.07, 210.36, 209.64, 211.88,
211.17, 210.45, 209.73, 211.98, 211.26, 210.54, 209.83, 212.07, 211.35, 210.64,
209.92, 212.16, 211.44, 210.73, 210.01, 212.25, 211.54, 210.82, 210.10, 212.34,
211.63, 210.91, 210.20, 212.44, 211.72, 211.00, 210.29, 212.53, 211.81, 211.10,
210.38, 212.62, 211.91, 211.19, 210.47, 212.71, 212.00, 211.28, 210.56, 212.81,
212.09, 211.37, 210.66, 212.90, 212.18, 211.47, 210.75, 212.99
}, 
{
217.49, 221.53, 224.53, 228.95, 228.49, 225.90, 221.29, 218.11, 211.18, 204.22,
197.98, 196.16, 193.37, 192.72, 194.02, 199.85, 203.82, 208.42, 213.19, 220.61,
224.30, 226.75, 227.51, 229.19, 225.78, 220.52, 213.98, 209.90, 203.13, 197.38,
193.33, 194.33, 194.47, 196.43, 199.78, 207.01, 211.73, 216.43, 220.65, 226.88,
228.73, 228.73, 226.62, 225.39, 219.55, 212.74, 205.70, 202.19, 197.04, 193.77,
192.64, 196.49, 199.04, 202.80, 207.31, 215.03, 219.60, 223.51, 226.29, 230.42,
229.62, 226.69, 221.79, 218.43, 211.45, 204.55, 198.50, 196.98
}, 
{
351.95, 352.45, 352.94, 351.47, 351.96, 352.46, 352.95, 351.47, 351.97, 352.46,
352.96, 351.48, 351.98, 352.47, 352.97, 351.49, 351.98, 352.48, 352.97, 351.50,
351.99, 352.48, 352.98, 351.50, 352.00, 352.49, 352.99, 351.51, 352.00, 352.50,
352.99, 351.52, 352.01, 352.51, 353.00, 351.52, 352.02, 352.51, 353.01, 351.53,
352.03, 352.52, 353.02, 351.54, 352.03, 352.53, 353.02, 351.55, 352.04, 352.54,
353.03, 351.55, 352.05, 352.54, 353.04, 351.56, 352.06, 352.55, 353.04, 351.57,
352.06, 352.56, 353.05, 351.58, 352.07, 352.56, 353.06, 351.58
}, 
{
348.75, 346.96, 345.60, 342.92, 343.07, 344.26, 346.57, 347.90, 351.81, 355.74,
359.12, 359.55, 000.85, 001.09, 000.45, 357.17, 355.41, 353.39, 351.30, 347.36,
345.72, 344.59, 344.19, 342.75, 344.37, 347.09, 350.69, 352.71, 356.50, 359.53,
001.51, 000.41, 000.29, 359.37, 357.86, 354.00, 351.93, 349.87, 348.00, 344.55,
343.68, 343.62, 344.57, 344.65, 347.75, 351.57, 355.56, 357.13, 359.78, 001.32,
001.79, 359.36, 358.19, 356.51, 354.53, 350.47, 348.46, 346.72, 345.45, 342.90,
343.21, 344.58, 347.06, 348.52, 352.48, 356.36, 359.60, 359.86
}, 
{
008.05, 007.55, 007.06, 008.53, 008.04, 007.54, 007.05, 008.53, 008.03, 007.54,
007.04, 008.52, 008.02, 007.53, 007.03, 008.51, 008.02, 007.52, 007.03, 008.50,
008.01, 007.52, 007.02, 008.50, 008.00, 007.51, 007.01, 008.49, 008.00, 007.50,
007.01, 008.48, 007.99, 007.49, 007.00, 008.48, 007.98, 007.49, 006.99, 008.47,
007.97, 007.48, 006.98, 008.46, 007.97, 007.47, 006.98, 008.45, 007.96, 007.46,
006.97, 008.45, 007.95, 007.46, 006.96, 008.44, 007.94, 007.45, 006.96, 008.43,
007.94, 007.44, 006.95, 008.42, 007.93, 007.44, 006.94, 008.42
}, 
{
188.05, 187.55, 187.06, 188.53, 188.04, 187.54, 187.05, 188.53, 188.03, 187.54,
187.04, 188.52, 188.02, 187.53, 187.03, 188.51, 188.02, 187.52, 187.03, 188.50,
188.01, 187.52, 187.02, 188.50, 188.00, 187.51, 187.01, 188.49, 188.00, 187.50,
187.01, 188.48, 187.99, 187.49, 187.00, 188.48, 187.98, 187.49, 186.99, 188.47,
187.97, 187.48, 186.98, 188.46, 187.97, 187.47, 186.98, 188.45, 187.96, 187.46,
186.97, 188.45, 187.95, 187.46, 186.96, 188.44, 187.94, 187.45, 186.96, 188.43,
187.94, 187.44, 186.95, 188.42, 187.93, 187.44, 186.94, 188.42
}, 
{
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00,
180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00, 180.00
}, 
{
315.25, 154.34, 353.80, 144.14, 345.14, 187.40, 031.18, 186.75, 033.08, 239.47,
084.91, 239.09, 081.48, 282.58, 122.74, 272.50, 111.62, 310.53, 149.39, 298.59,
137.80, 337.48, 177.88, 329.58, 172.40, 016.80, 222.60, 019.34, 225.46, 070.35,
273.67, 065.77, 266.47, 106.34, 305.68, 094.94, 293.81, 132.69, 331.72, 121.33,
321.26, 162.02, 003.97, 157.64, 002.63, 208.81, 055.29, 211.26, 055.55, 258.27,
099.63, 250.23, 089.86, 289.05, 127.99, 277.09, 116.01, 315.15, 154.70, 305.16,
146.35, 348.83, 192.87, 348.65, 195.07, 041.37, 246.59, 040.51
}, 
{
013.44, 015.49, 017.10, 019.05, 019.16, 018.22, 016.17, 014.11, 010.46, 006.78,
003.66, 002.49, 001.46, 001.47, 002.36, 004.91, 006.93, 009.21, 011.55, 014.76,
016.66, 018.05, 018.71, 019.41, 018.04, 015.58, 012.24, 009.48, 005.96, 003.18,
001.46, 001.83, 002.21, 003.38, 005.15, 008.28, 010.60, 012.92, 015.04, 017.76,
018.89, 019.20, 018.51, 017.70, 014.86, 011.30, 007.56, 005.26, 002.87, 001.58,
001.37, 003.07, 004.49, 006.43, 008.66, 012.00, 014.26, 016.25, 017.78, 019.60,
019.55, 018.43, 016.21, 014.02, 010.32, 006.69, 003.71, 002.72
}, 
{
207.25, 211.54, 214.77, 218.44, 218.22, 215.87, 211.50, 207.58, 200.89, 194.16,
188.16, 185.60, 183.05, 182.63, 184.17, 189.26, 193.46, 198.30, 203.30, 209.98,
213.91, 216.60, 217.60, 218.53, 215.36, 210.34, 204.04, 199.21, 192.68, 187.17,
183.36, 183.61, 183.99, 186.18, 189.78, 196.26, 201.21, 206.15, 210.62, 216.10,
218.18, 218.42, 216.55, 214.58, 208.98, 202.40, 195.61, 191.35, 186.43, 183.41,
182.51, 185.62, 188.41, 192.41, 197.15, 204.13, 208.93, 213.08, 216.10, 219.49,
218.93, 216.23, 211.57, 207.47, 200.72, 194.06, 188.25, 185.98
}, 
{
270.11, 282.73, 295.19, 269.98, 281.98, 293.74, 305.31, 279.27, 290.60, 301.93,
313.33, 287.43, 299.17, 311.15, 323.36, 298.35, 310.97, 323.69, 336.45, 311.70,
324.27, 336.65, 348.79, 323.25, 334.93, 346.43, 357.80, 331.67, 343.02, 354.47,
006.08, 340.47, 352.54, 004.84, 017.36, 352.58, 005.32, 018.07, 030.72, 005.78,
018.07, 030.12, 041.94, 016.09, 027.53, 038.87, 050.20, 024.13, 035.63, 047.33,
059.25, 033.97, 046.36, 058.94, 071.64, 046.95, 059.67, 072.28, 084.70, 059.45,
071.41, 083.14, 094.67, 068.62, 079.95, 091.28, 102.70, 076.83
}, 
{
117.36, 134.27, 149.96, 128.43, 140.20, 149.61, 156.80, 126.85, 131.49, 136.09,
141.49, 113.02, 122.22, 133.78, 147.54, 127.61, 144.43, 161.99, 179.75, 161.68,
178.18, 193.25, 206.40, 181.79, 190.30, 196.76, 201.84, 170.88, 175.70, 181.64,
189.44, 164.08, 176.53, 191.03, 207.13, 188.84, 206.54, 224.22, 241.34, 221.88,
236.25, 248.55, 258.49, 230.67, 236.51, 241.28, 245.80, 215.47, 222.06, 230.73,
241.76, 219.58, 234.76, 251.34, 268.79, 251.08, 268.61, 285.36, 300.80, 278.94,
290.34, 299.37, 306.25, 276.09, 280.67, 285.34, 290.95, 262.81
}, 
{
210.18, 112.44, 014.16, 300.40, 200.12, 098.35, 354.85, 275.03, 168.75, 062.41,
317.10, 238.80, 136.88, 036.47, 297.26, 224.27, 126.49, 029.03, 291.65, 219.49,
121.57, 022.99, 283.46, 208.00, 105.58, 001.41, 255.70, 174.61, 068.56, 323.85,
220.87, 144.94, 045.03, 306.18, 208.09, 135.83, 038.43, 301.01, 203.36, 130.59,
031.68, 291.69, 190.28, 112.55, 007.72, 261.61, 155.17, 074.92, 330.86, 228.56,
127.84, 053.75, 315.23, 217.34, 119.83, 047.82, 310.34, 212.53, 114.13, 040.21,
299.71, 197.67, 093.89, 013.84, 267.47, 161.23, 056.15, 338.14
}, 
{
150.70, 249.04, 347.76, 061.72, 161.97, 263.47, 006.50, 085.70, 191.28, 296.92,
041.60, 119.41, 221.05, 321.40, 060.80, 134.19, 232.56, 330.72, 068.82, 141.65,
240.11, 339.03, 078.68, 154.01, 256.08, 359.72, 104.77, 185.15, 290.51, 034.64,
137.21, 212.94, 312.88, 052.01, 150.59, 223.48, 321.60, 059.73, 158.00, 231.24,
330.41, 070.43, 171.62, 248.92, 353.16, 098.58, 204.31, 283.91, 027.45, 129.41,
230.02, 304.24, 043.13, 141.57, 239.75, 312.48, 050.65, 149.04, 247.83, 321.92,
062.35, 164.09, 267.37, 346.78, 092.45, 197.99, 302.46, 020.01
}, 
{
314.86, 128.40, 301.39, 125.84, 296.84, 106.35, 274.12, 092.52, 257.52, 062.46,
228.42, 048.33, 217.69, 028.56, 200.62, 025.85, 199.35, 013.16, 187.06, 013.11,
186.47, 359.17, 170.92, 353.67, 162.53, 329.63, 135.20, 312.33, 117.56, 284.12,
092.42, 274.70, 086.07, 258.50, 071.68, 257.64, 071.51, 245.38, 059.00, 244.44,
056.81, 228.10, 037.97, 218.45, 024.90, 190.06, 354.91, 172.86, 340.08, 149.06,
319.62, 143.74, 316.50, 129.89, 303.65, 129.86, 303.66, 117.12, 290.00, 114.29,
285.07, 094.31, 261.80, 079.97, 244.87, 049.91, 216.11, 036.32
}, 
{
188.82, 090.96, 352.73, 277.27, 177.50, 076.47, 333.92, 253.23, 148.12, 042.97,
298.76, 219.45, 118.30, 018.42, 279.50, 204.61, 106.72, 009.04, 271.42, 197.10,
099.11, 000.67, 261.50, 184.67, 083.08, 339.92, 235.34, 153.48, 048.59, 304.93,
202.85, 125.62, 026.15, 287.51, 189.41, 115.02, 017.38, 279.73, 181.93, 107.19,
008.50, 268.96, 168.25, 089.45, 345.69, 240.75, 135.50, 054.40, 311.34, 209.86,
109.72, 034.01, 295.60, 197.64, 099.93, 025.71, 288.02, 190.11, 091.79, 016.21,
276.25, 175.00, 072.19, 351.28, 246.10, 141.03, 037.04, 318.00
}, 
{
180.21, 205.47, 230.38, 179.97, 203.96, 227.49, 250.61, 198.54, 221.20, 243.86,
266.66, 214.85, 238.34, 262.29, 286.73, 236.71, 261.94, 287.39, 312.90, 263.41,
288.54, 313.29, 337.59, 286.50, 309.86, 332.86, 355.60, 303.35, 326.04, 348.94,
012.17, 320.94, 345.08, 009.69, 034.72, 345.16, 010.65, 036.13, 061.45, 011.56,
036.14, 060.24, 083.87, 032.18, 055.06, 077.75, 100.39, 048.25, 071.27, 094.66,
118.50, 067.93, 092.72, 117.87, 143.29, 093.91, 119.34, 144.55, 169.40, 118.91,
142.83, 166.28, 189.35, 137.24, 159.89, 182.56, 205.40, 153.65
}, 
{
338.55, 249.40, 188.18, 076.42, 029.90, 318.45, 247.70, 120.76, 070.32, 014.82,
305.54, 161.69, 110.92, 069.44, 013.74, 210.69, 163.52, 131.36, 083.74, 275.12,
225.82, 189.56, 139.21, 346.53, 283.27, 234.00, 182.82, 048.42, 336.24, 272.79,
224.33, 106.25, 039.29, 318.08, 276.13, 169.59, 110.60, 018.68, 337.69, 229.20,
171.88, 088.48, 034.01, 274.42, 220.62, 152.95, 082.75, 312.27, 264.21, 213.99,
138.06, 355.20, 315.79, 279.50, 205.52, 052.89, 016.99, 341.05, 272.99, 119.91,
072.97, 027.73, 329.17, 183.46, 118.85, 065.65, 016.34, 245.93
}, 
{
233.87, 233.44, 260.95, 250.98, 293.18, 310.45, 328.43, 303.27, 341.56, 014.77,
034.21, 352.15, 030.11, 077.35, 110.37, 049.11, 090.66, 147.22, 188.33, 121.49,
160.92, 213.38, 251.75, 200.85, 226.33, 265.77, 303.32, 270.70, 287.24, 312.51,
352.78, 336.48, 358.25, 005.77, 052.53, 047.79, 077.52, 074.32, 122.05, 115.35,
146.74, 152.07, 186.32, 168.52, 203.44, 224.49, 243.02, 214.32, 254.99, 293.49,
306.29, 265.21, 314.52, 006.96, 021.70, 330.85, 023.67, 076.46, 097.12, 045.82,
087.61, 131.09, 161.25, 117.33, 141.45, 176.97, 216.38, 187.76
}, 
{
041.82, 304.76, 206.81, 133.91, 032.96, 290.12, 185.47, 105.79, 359.05, 252.28,
146.15, 067.70, 324.69, 223.58, 124.18, 052.48, 315.35, 218.74, 122.27, 051.90,
314.54, 216.14, 116.27, 040.95, 297.38, 192.13, 085.75, 005.25, 258.65, 152.97,
048.82, 332.90, 232.49, 133.66, 036.01, 325.49, 228.98, 132.45, 035.53, 324.17,
225.25, 124.71, 022.30, 304.38, 198.62, 091.98, 345.15, 265.17, 160.02, 056.58,
315.04, 241.64, 143.32, 046.01, 309.33, 239.21, 142.58, 045.40, 307.27, 234.11,
132.87, 029.73, 284.81, 204.97, 098.18, 351.46, 245.51, 167.33
}, 
{
276.36, 110.49, 306.38, 092.19, 294.08, 139.75, 349.06, 148.41, 001.90, 215.45,
067.69, 224.59, 070.62, 272.85, 111.64, 255.04, 089.30, 282.52, 115.46, 256.19,
090.91, 287.73, 127.47, 278.09, 125.24, 335.73, 188.51, 349.49, 202.70, 054.05,
262.35, 054.20, 255.02, 092.69, 287.97, 069.02, 262.05, 095.10, 288.93, 071.65,
269.51, 110.58, 315.39, 111.23, 322.76, 176.04, 029.71, 189.67, 039.96, 246.85,
089.92, 236.72, 073.37, 267.97, 101.35, 241.58, 074.85, 269.21, 105.47, 251.77,
094.26, 300.55, 150.37, 310.05, 163.64, 017.07, 228.97, 025.35
}, 
{
275.70, 178.20, 107.76, 024.88, 326.14, 240.57, 153.89, 049.07, 340.61, 267.05,
180.37, 059.86, 354.80, 300.93, 234.55, 101.59, 046.02, 005.96, 310.60, 173.40,
115.46, 069.51, 008.02, 241.81, 163.71, 097.90, 029.07, 275.95, 185.89, 105.49,
041.60, 309.39, 230.74, 139.42, 088.55, 013.28, 306.49, 206.77, 157.58, 079.52,
011.99, 276.78, 208.62, 112.91, 042.07, 316.47, 228.16, 119.49, 055.01, 350.06,
261.33, 146.85, 097.84, 052.97, 331.02, 210.06, 166.25, 121.85, 044.38, 279.94,
220.48, 160.82, 086.06, 322.31, 239.63, 168.43, 101.90, 355.08
}, 
{
219.94, 329.86, 077.50, 161.43, 261.70, 357.48, 089.03, 156.93, 243.61, 330.21,
058.33, 129.09, 224.45, 324.32, 068.34, 155.29, 265.04, 016.16, 127.64, 218.04,
327.19, 073.67, 176.54, 254.65, 348.71, 078.87, 166.38, 232.37, 319.38, 048.54,
141.25, 217.92, 319.47, 064.89, 173.32, 263.29, 014.67, 126.01, 236.32, 324.12,
069.30, 170.56, 267.36, 339.35, 068.31, 155.22, 241.68, 308.88, 039.27, 133.64,
232.50, 315.21, 061.90, 171.20, 282.12, 013.17, 124.23, 233.85, 341.03, 064.34,
163.91, 258.96, 349.90, 057.43, 143.98, 230.72, 319.24, 030.62
}, 
{
257.42, 164.42, 072.46, 327.00, 238.50, 152.13, 067.78, 329.91, 247.88, 165.88,
083.16, 343.94, 257.77, 169.46, 079.19, 332.32, 239.39, 145.84, 052.11, 303.64,
210.99, 119.58, 029.86, 287.14, 201.58, 117.89, 035.46, 298.51, 216.32, 133.10,
048.19, 306.16, 217.05, 126.13, 033.82, 285.55, 191.87, 098.21, 005.02, 257.75,
166.95, 077.99, 351.13, 251.32, 168.20, 086.05, 004.12, 266.60, 182.79, 097.09,
009.26, 264.38, 172.86, 080.14, 346.68, 237.91, 144.38, 051.51, 319.77, 214.60,
126.43, 040.41, 316.34, 218.66, 136.68, 054.62, 331.71, 232.19
}, 
{
309.83, 047.12, 142.31, 251.45, 339.72, 063.74, 143.72, 237.66, 313.01, 028.28,
105.00, 201.66, 285.28, 013.18, 104.98, 216.93, 314.07, 052.46, 151.20, 266.34,
002.92, 097.02, 187.75, 291.40, 013.78, 092.44, 168.58, 260.70, 336.36, 054.07,
135.16, 237.45, 326.93, 060.05, 155.96, 270.71, 009.34, 107.94, 205.59, 318.35,
051.24, 140.44, 225.42, 323.25, 040.77, 116.35, 191.48, 284.75, 003.64, 086.31,
173.25, 281.24, 015.54, 112.27, 210.47, 326.22, 064.56, 161.57, 256.33, 004.89,
092.49, 175.82, 255.23, 348.81, 064.04, 139.44, 216.54, 313.79
}, 
{
060.81, 171.78, 282.95, 331.70, 083.95, 197.22, 311.81, 004.97, 121.88, 238.85,
354.93, 046.84, 160.22, 272.55, 024.16, 072.55, 183.53, 294.41, 045.27, 093.35,
204.38, 315.68, 067.47, 117.26, 231.01, 346.15, 102.57, 156.82, 273.53, 029.11,
143.29, 193.41, 305.42, 056.85, 167.94, 216.06, 326.92, 077.79, 188.73, 237.02,
348.48, 100.55, 213.56, 265.02, 020.69, 137.46, 254.51, 308.04, 063.08, 176.74,
289.27, 338.21, 089.49, 200.50, 311.40, 359.44, 110.32, 221.31, 332.53, 021.38,
133.77, 247.23, 002.05, 055.41, 172.40, 289.27, 045.16, 096.84
}, 
{
233.87, 233.44, 260.95, 250.98, 293.18, 310.45, 328.43, 303.27, 341.56, 014.77,
034.21, 352.15, 030.11, 077.35, 110.37, 049.11, 090.66, 147.22, 188.33, 121.49,
160.92, 213.38, 251.75, 200.85, 226.33, 265.77, 303.32, 270.70, 287.24, 312.51,
352.78, 336.48, 358.25, 005.77, 052.53, 047.79, 077.52, 074.32, 122.05, 115.35,
146.74, 152.07, 186.32, 168.52, 203.44, 224.49, 243.02, 214.32, 254.99, 293.49,
306.29, 265.21, 314.52, 006.96, 021.70, 330.85, 023.67, 076.46, 097.12, 045.82,
087.61, 131.09, 161.25, 117.33, 141.45, 176.97, 216.38, 187.76
}, 
{
068.44, 326.66, 252.99, 166.44, 107.92, 024.70, 302.40, 201.49, 139.72, 072.89,
352.21, 234.26, 171.75, 118.30, 050.38, 272.33, 212.55, 167.66, 107.29, 323.42,
261.55, 212.91, 150.41, 023.27, 308.34, 247.57, 185.03, 076.74, 353.22, 278.32,
218.24, 125.78, 046.75, 313.24, 258.77, 177.02, 105.28, 000.61, 306.96, 223.42,
153.81, 058.36, 352.07, 258.33, 193.09, 114.07, 032.55, 288.14, 228.58, 166.66,
078.81, 321.23, 269.43, 220.57, 133.88, 005.93, 317.31, 268.77, 188.28, 060.45,
001.56, 304.59, 234.49, 114.84, 038.90, 334.37, 273.64, 169.10
}, 
{
180.21, 205.47, 230.38, 179.97, 203.96, 227.49, 250.61, 198.54, 221.20, 243.86,
266.66, 214.85, 238.34, 262.29, 286.73, 236.71, 261.94, 287.39, 312.90, 263.41,
288.54, 313.29, 337.59, 286.50, 309.86, 332.86, 355.60, 303.35, 326.04, 348.94,
012.17, 320.94, 345.08, 009.69, 034.72, 345.16, 010.65, 036.13, 061.45, 011.56,
036.14, 060.24, 083.87, 032.18, 055.06, 077.75, 100.39, 048.25, 071.27, 094.66,
118.50, 067.93, 092.72, 117.87, 143.29, 093.91, 119.34, 144.55, 169.40, 118.91,
142.83, 166.28, 189.35, 137.24, 159.89, 182.56, 205.40, 153.65
}, 
{
263.01, 059.88, 245.03, 081.90, 282.66, 098.96, 276.37, 099.71, 297.89, 131.01,
310.20, 116.37, 313.40, 159.24, 350.38, 135.56, 334.44, 188.11, 026.26, 165.34,
002.18, 212.44, 049.08, 205.69, 030.36, 229.37, 066.73, 242.79, 059.19, 244.12,
083.71, 275.07, 095.26, 260.71, 105.01, 306.25, 133.04, 286.91, 131.88, 331.50,
160.87, 324.65, 157.82, 348.14, 182.73, 003.65, 182.09, 001.96, 202.17, 039.83,
211.34, 017.26, 224.34, 074.18, 246.06, 041.02, 250.95, 101.09, 279.45, 075.08,
275.50, 118.08, 307.73, 112.34, 296.36, 131.77, 330.90, 150.45
}, 
{
226.24, 078.56, 290.91, 056.24, 269.21, 122.96, 337.84, 106.75, 323.72, 180.73,
036.94, 164.73, 018.58, 231.60, 084.16, 209.32, 061.64, 273.97, 126.30, 251.43,
103.75, 316.15, 168.81, 294.84, 148.99, 004.35, 220.87, 350.77, 207.56, 063.31,
277.83, 044.11, 256.92, 109.38, 321.71, 086.83, 299.16, 151.49, 003.81, 128.95,
341.42, 194.26, 047.81, 175.21, 031.05, 247.88, 104.97, 234.22, 089.49, 303.57,
156.75, 282.19, 134.58, 346.89, 199.22, 324.35, 176.68, 029.00, 241.36, 006.75,
219.82, 073.73, 288.81, 057.90, 274.94, 131.87, 347.90, 115.49
}, 
{
121.57, 062.61, 003.68, 230.80, 172.49, 114.97, 058.56, 289.26, 234.95, 180.69,
125.62, 355.20, 297.76, 239.51, 180.79, 047.74, 348.78, 289.83, 230.89, 097.80,
038.84, 339.97, 281.35, 149.17, 092.05, 036.13, 341.36, 213.06, 158.56, 103.04,
046.28, 274.35, 215.88, 157.06, 098.11, 325.02, 266.08, 207.13, 148.17, 015.09,
316.29, 257.85, 200.12, 069.31, 013.87, 319.43, 265.24, 136.28, 080.27, 023.07,
324.97, 192.20, 133.31, 074.35, 015.39, 242.32, 183.37, 124.41, 065.50, 292.67,
234.46, 177.10, 120.89, 351.77, 297.53, 243.19, 187.94, 057.32
}, 
{
178.87, 282.27, 025.06, 103.59, 204.42, 303.97, 042.20, 115.89, 212.29, 308.66,
045.66, 120.38, 219.81, 320.53, 062.36, 141.69, 245.04, 348.76, 092.59, 172.84,
276.03, 018.52, 120.04, 196.99, 296.03, 033.78, 130.54, 203.44, 299.98, 037.38,
135.99, 212.54, 313.71, 055.91, 158.91, 239.05, 342.84, 086.62, 190.13, 269.68,
011.83, 112.91, 212.76, 287.89, 025.21, 121.72, 218.02, 291.44, 029.28, 128.41,
228.84, 307.04, 049.58, 152.82, 256.49, 336.91, 080.62, 183.94, 286.61, 004.98,
105.60, 204.94, 302.97, 016.51, 112.86, 209.29, 306.45, 021.37
}, 
{
205.75, 313.25, 059.27, 141.70, 242.73, 340.41, 074.54, 144.12, 233.21, 322.22,
052.98, 125.37, 222.73, 323.46, 067.08, 151.51, 258.90, 007.17, 115.69, 202.35,
309.36, 054.62, 157.45, 235.81, 332.11, 064.95, 155.02, 222.41, 311.90, 043.75,
138.91, 216.20, 318.12, 062.68, 169.21, 255.61, 004.04, 112.46, 220.21, 305.21,
049.60, 151.32, 249.79, 323.28, 054.92, 144.31, 233.15, 301.95, 035.01, 131.56,
231.57, 313.17, 058.57, 165.67, 273.82, 000.91, 109.14, 216.45, 322.17, 044.18,
144.70, 241.81, 335.39, 044.55, 133.50, 222.67, 313.86, 026.81
}, 
{
320.63, 163.57, 006.16, 158.57, 000.25, 201.46, 042.27, 193.03, 033.37, 233.71,
074.19, 225.22, 066.39, 268.02, 110.14, 262.95, 105.86, 309.00, 152.19, 305.53,
148.35, 350.78, 192.76, 344.50, 185.55, 026.22, 226.65, 017.22, 217.60, 058.18,
259.10, 050.69, 252.51, 094.81, 297.52, 090.79, 293.96, 137.13, 340.13, 133.07,
335.33, 177.12, 018.43, 169.57, 010.14, 210.51, 050.83, 201.52, 042.22, 243.29,
084.82, 237.08, 079.54, 282.39, 125.48, 278.93, 122.05, 324.94, 167.48, 319.81,
161.41, 002.55, 203.30, 354.02, 194.36, 034.71, 235.23, 026.31
}, 
{
146.53, 090.34, 033.64, 264.12, 206.05, 147.26, 087.88, 315.88, 255.80, 195.71,
135.84, 004.24, 305.40, 247.26, 189.84, 060.92, 004.69, 308.79, 252.99, 124.86,
068.49, 011.55, 313.92, 183.40, 124.37, 064.79, 004.83, 232.56, 172.53, 112.80,
053.58, 282.84, 224.98, 167.82, 111.29, 343.06, 287.23, 231.38, 175.28, 046.56,
349.36, 291.44, 232.81, 101.39, 041.64, 341.60, 281.49, 149.39, 089.84, 030.85,
332.54, 202.80, 145.90, 089.57, 033.62, 265.66, 209.74, 153.48, 096.68, 327.05,
268.86, 209.97, 150.50, 018.45, 318.35, 258.28, 198.47, 066.96
}, 
{
088.98, 205.00, 320.26, 013.58, 126.40, 237.71, 347.50, 035.16, 142.89, 250.59,
358.99, 047.81, 158.98, 271.67, 025.72, 080.04, 196.01, 312.46, 069.03, 124.54,
240.30, 355.16, 108.83, 160.24, 270.96, 020.21, 128.34, 175.11, 283.00, 031.85,
142.08, 193.00, 306.24, 060.75, 176.27, 231.63, 348.16, 104.69, 220.85, 275.46,
029.89, 143.04, 254.70, 303.98, 052.74, 160.59, 268.22, 315.56, 064.91, 175.73,
288.09, 341.01, 095.94, 211.76, 328.13, 023.87, 140.29, 256.22, 011.31, 064.43,
177.02, 288.08, 037.64, 085.13, 192.81, 300.57, 049.15, 098.20
}, 
{
248.66, 172.13, 123.37, 346.40, 311.88, 252.19, 193.01, 040.03, 000.92, 316.75,
258.87, 089.11, 050.09, 020.59, 337.10, 149.04, 114.49, 095.05, 060.19, 226.82,
190.09, 166.20, 128.00, 309.78, 258.21, 220.43, 180.62, 020.09, 319.26, 267.25,
230.41, 086.72, 031.83, 322.93, 293.49, 162.17, 115.93, 036.75, 008.41, 234.98,
189.94, 118.60, 075.94, 290.52, 248.15, 191.82, 132.94, 336.39, 299.85, 261.31,
197.31, 029.16, 002.15, 338.44, 277.16, 099.84, 076.66, 053.32, 357.69, 179.36,
144.39, 110.87, 063.84, 252.08, 198.80, 156.93, 119.04, 322.76
}, 
{
068.44, 326.66, 252.99, 166.44, 107.92, 024.70, 302.40, 201.49, 139.72, 072.89,
352.21, 234.26, 171.75, 118.30, 050.38, 272.33, 212.55, 167.66, 107.29, 323.42,
261.55, 212.91, 150.41, 023.27, 308.34, 247.57, 185.03, 076.74, 353.22, 278.32,
218.24, 125.78, 046.75, 313.24, 258.77, 177.02, 105.28, 000.61, 306.96, 223.42,
153.81, 058.36, 352.07, 258.33, 193.09, 114.07, 032.55, 288.14, 228.58, 166.66,
078.81, 321.23, 269.43, 220.57, 133.88, 005.93, 317.31, 268.77, 188.28, 060.45,
001.56, 304.59, 234.49, 114.84, 038.90, 334.37, 273.64, 169.10
}, 
{
233.87, 233.44, 260.95, 250.98, 293.18, 310.45, 328.43, 303.27, 341.56, 014.77,
034.21, 352.15, 030.11, 077.35, 110.37, 049.11, 090.66, 147.22, 188.33, 121.49,
160.92, 213.38, 251.75, 200.85, 226.33, 265.77, 303.32, 270.70, 287.24, 312.51,
352.78, 336.48, 358.25, 005.77, 052.53, 047.79, 077.52, 074.32, 122.05, 115.35,
146.74, 152.07, 186.32, 168.52, 203.44, 224.49, 243.02, 214.32, 254.99, 293.49,
306.29, 265.21, 314.52, 006.96, 021.70, 330.85, 023.67, 076.46, 097.12, 045.82,
087.61, 131.09, 161.25, 117.33, 141.45, 176.97, 216.38, 187.76
}, 
{
143.98, 156.18, 196.14, 160.96, 215.16, 244.19, 273.73, 222.54, 272.16, 316.70,
347.54, 279.58, 329.28, 028.50, 073.74, 347.46, 041.63, 110.92, 164.78, 073.20,
125.19, 190.02, 240.54, 164.11, 201.26, 252.20, 301.12, 242.37, 270.26, 306.98,
358.86, 316.95, 350.79, 010.61, 069.89, 040.36, 082.84, 092.38, 152.77, 121.12,
164.81, 182.19, 228.25, 184.62, 230.98, 263.37, 293.21, 238.45, 290.62, 340.81,
005.54, 299.17, 000.88, 065.90, 093.34, 017.80, 083.34, 148.73, 181.82, 105.28,
159.03, 214.24, 255.93, 185.95, 221.39, 268.25, 319.08, 264.58
}, 
{
039.30, 140.22, 268.91, 335.52, 118.44, 236.20, 354.45, 045.05, 183.39, 316.66,
076.22, 110.04, 248.47, 036.41, 170.37, 185.88, 328.77, 126.78, 269.36, 279.57,
060.29, 213.84, 353.08, 018.44, 144.31, 283.97, 061.62, 104.66, 221.27, 346.71,
127.31, 187.19, 309.75, 058.29, 206.30, 278.55, 049.75, 148.02, 297.13, 007.27,
139.68, 245.78, 020.57, 078.72, 213.80, 334.91, 093.48, 140.50, 281.40, 060.31,
173.76, 209.18, 359.61, 153.35, 269.52, 295.77, 090.03, 244.14, 005.95, 031.20,
173.67, 317.60, 088.01, 119.83, 243.99, 019.57, 159.12, 206.41
}, 
{
031.67, 345.34, 298.87, 140.78, 094.47, 048.71, 003.87, 208.53, 165.55, 122.61,
078.95, 282.63, 236.93, 190.66, 144.16, 346.10, 299.75, 253.53, 207.34, 049.50,
003.12, 316.61, 270.14, 112.42, 066.98, 022.55, 339.16, 184.73, 141.58, 097.51,
052.36, 254.82, 208.42, 161.90, 115.47, 317.60, 271.40, 225.20, 178.89, 020.87,
334.36, 287.98, 242.05, 085.40, 041.40, 358.30, 315.43, 160.40, 115.90, 070.40,
024.22, 226.16, 179.66, 133.28, 087.04, 289.27, 243.04, 196.68, 150.20, 352.12,
305.87, 260.24, 215.57, 060.39, 017.48, 334.47, 290.64, 134.14
}, 
{
359.08, 127.74, 255.45, 283.56, 048.38, 171.46, 292.81, 314.43, 073.50, 192.52,
312.32, 335.24, 098.16, 222.82, 349.08, 018.40, 146.98, 276.15, 045.48, 076.24,
204.57, 331.81, 097.63, 123.49, 245.89, 006.64, 126.14, 146.79, 266.02, 026.32,
148.16, 173.47, 298.78, 065.60, 193.63, 224.20, 353.49, 122.75, 251.58, 281.24,
047.96, 173.16, 296.63, 320.07, 080.28, 199.47, 318.42, 339.69, 100.55, 223.06,
347.34, 014.97, 142.30, 270.69, 039.77, 070.82, 199.96, 328.49, 096.01, 123.88,
248.43, 011.22, 132.32, 153.75, 272.75, 031.85, 151.85, 175.03
}, 
{
121.57, 062.61, 003.68, 230.80, 172.49, 114.97, 058.56, 289.26, 234.95, 180.69,
125.62, 355.20, 297.76, 239.51, 180.79, 047.74, 348.78, 289.83, 230.89, 097.80,
038.84, 339.97, 281.35, 149.17, 092.05, 036.13, 341.36, 213.06, 158.56, 103.04,
046.28, 274.35, 215.88, 157.06, 098.11, 325.02, 266.08, 207.13, 148.17, 015.09,
316.29, 257.85, 200.12, 069.31, 013.87, 319.43, 265.24, 136.28, 080.27, 023.07,
324.97, 192.20, 133.31, 074.35, 015.39, 242.32, 183.37, 124.41, 065.50, 292.67,
234.46, 177.10, 120.89, 351.77, 297.53, 243.19, 187.94, 057.32
}, 
{
163.39, 007.36, 210.49, 004.71, 205.45, 045.09, 244.03, 035.06, 234.00, 072.96,
271.77, 062.90, 262.45, 103.09, 304.97, 100.23, 304.13, 148.57, 353.16, 149.71,
353.39, 196.10, 037.62, 190.12, 029.43, 228.26, 067.11, 218.31, 057.21, 256.01,
095.10, 247.25, 088.37, 290.72, 134.13, 290.51, 135.05, 339.58, 183.70, 339.27,
181.54, 022.56, 222.42, 013.69, 212.49, 051.41, 250.38, 041.44, 240.29, 079.65,
280.01, 073.84, 276.62, 120.36, 324.72, 121.53, 325.94, 169.80, 012.76, 166.78,
007.33, 206.82, 045.71, 196.75, 035.71, 234.65, 073.45, 224.64
}, 
{
240.97, 096.30, 311.11, 079.06, 292.50, 145.24, 357.36, 122.83, 334.27, 185.70,
037.34, 163.21, 015.89, 229.26, 083.35, 211.90, 067.19, 282.81, 138.52, 267.86,
123.01, 337.58, 191.46, 318.41, 170.90, 022.83, 234.39, 359.58, 211.07, 062.86,
275.15, 041.88, 255.53, 109.90, 324.88, 094.12, 309.80, 165.47, 020.89, 149.63,
003.94, 217.55, 070.44, 196.48, 048.24, 259.72, 111.12, 236.49, 088.46, 300.98,
154.19, 281.92, 136.54, 351.72, 207.29, 336.79, 192.39, 047.65, 262.36, 030.20,
243.52, 096.15, 308.19, 073.61, 285.03, 136.48, 348.18, 114.13
}, 
{
330.86, 173.56, 015.92, 169.08, 010.52, 211.49, 052.06, 203.56, 043.67, 243.77,
084.01, 235.78, 076.72, 278.11, 119.99, 273.55, 116.22, 319.12, 162.07, 316.15,
158.73, 000.93, 202.67, 355.16, 195.97, 036.40, 236.59, 027.91, 228.05, 068.39,
269.07, 061.41, 263.00, 105.05, 307.52, 101.54, 304.48, 147.41, 350.17, 143.85,
345.87, 187.43, 028.50, 180.39, 020.71, 220.84, 060.93, 212.36, 052.82, 253.66,
094.94, 247.95, 090.18, 292.78, 135.64, 289.83, 132.72, 335.37, 177.66, 330.75,
172.11, 013.01, 213.52, 004.99, 205.08, 045.20, 245.48, 037.31
}, 
{
151.07, 019.03, 246.30, 349.04, 214.48, 078.98, 302.67, 042.10, 264.87, 127.63,
350.67, 090.64, 315.06, 180.40, 046.72, 150.26, 018.16, 246.50, 114.97, 219.56,
087.28, 314.23, 180.26, 281.67, 145.83, 009.26, 232.19, 331.26, 194.09, 057.33,
281.24, 022.35, 248.07, 114.74, 342.24, 086.70, 315.12, 183.54, 051.62, 155.41,
022.01, 247.67, 112.37, 212.57, 075.77, 298.59, 161.32, 260.62, 124.09, 348.31,
213.44, 315.88, 182.89, 050.66, 278.93, 023.74, 252.06, 119.92, 347.07, 089.65,
314.94, 179.29, 042.87, 142.23, 004.98, 227.76, 090.88, 190.96
}, 
{
233.87, 233.44, 260.95, 250.98, 293.18, 310.45, 328.43, 303.27, 341.56, 014.77,
034.21, 352.15, 030.11, 077.35, 110.37, 049.11, 090.66, 147.22, 188.33, 121.49,
160.92, 213.38, 251.75, 200.85, 226.33, 265.77, 303.32, 270.70, 287.24, 312.51,
352.78, 336.48, 358.25, 005.77, 052.53, 047.79, 077.52, 074.32, 122.05, 115.35,
146.74, 152.07, 186.32, 168.52, 203.44, 224.49, 243.02, 214.32, 254.99, 293.49,
306.29, 265.21, 314.52, 006.96, 021.70, 330.85, 023.67, 076.46, 097.12, 045.82,
087.61, 131.09, 161.25, 117.33, 141.45, 176.97, 216.38, 187.76
}, 
{
204.74, 047.00, 276.87, 060.06, 303.70, 161.94, 020.48, 146.83, 025.23, 258.54,
118.23, 227.94, 106.83, 355.47, 230.36, 322.66, 206.89, 106.34, 350.40, 077.65,
319.65, 214.31, 094.42, 196.02, 062.29, 302.17, 179.91, 298.61, 155.29, 020.91,
261.85, 037.90, 261.25, 110.82, 000.06, 149.32, 021.99, 221.72, 112.21, 259.20,
132.62, 339.50, 214.82, 348.91, 224.15, 085.33, 303.94, 066.68, 307.81, 187.14,
041.23, 153.16, 044.70, 299.74, 157.34, 260.68, 156.39, 051.83, 274.78, 016.57,
259.72, 144.10, 014.77, 122.32, 346.53, 222.16, 101.86, 225.06
}, 
{
039.30, 140.22, 268.91, 335.52, 118.44, 236.20, 354.45, 045.05, 183.39, 316.66,
076.22, 110.04, 248.47, 036.41, 170.37, 185.88, 328.77, 126.78, 269.36, 279.57,
060.29, 213.84, 353.08, 018.44, 144.31, 283.97, 061.62, 104.66, 221.27, 346.71,
127.31, 187.19, 309.75, 058.29, 206.30, 278.55, 049.75, 148.02, 297.13, 007.27,
139.68, 245.78, 020.57, 078.72, 213.80, 334.91, 093.48, 140.50, 281.40, 060.31,
173.76, 209.18, 359.61, 153.35, 269.52, 295.77, 090.03, 244.14, 005.95, 031.20,
173.67, 317.60, 088.01, 119.83, 243.99, 019.57, 159.12, 206.41
}, 
{
343.55, 291.88, 238.65, 112.06, 054.00, 353.11, 289.59, 152.92, 086.39, 019.81,
314.18, 179.27, 118.12, 059.80, 004.16, 239.58, 187.80, 136.97, 086.41, 324.21,
272.01, 218.00, 161.61, 031.28, 329.31, 264.94, 198.93, 061.08, 354.75, 289.76,
226.96, 095.73, 038.48, 343.76, 291.06, 168.57, 117.93, 067.26, 015.87, 251.87,
197.00, 139.56, 079.30, 305.16, 240.04, 173.66, 107.00, 329.89, 265.66, 203.89,
144.93, 017.54, 323.67, 271.58, 220.61, 098.88, 048.01, 356.14, 302.59, 175.60,
117.09, 055.74, 351.85, 214.95, 148.34, 081.86, 016.47, 241.94
}, 
{
178.11, 025.10, 230.69, 027.52, 228.74, 067.36, 263.56, 051.14, 244.55, 077.93,
272.18, 061.38, 259.76, 100.75, 304.16, 102.81, 309.69, 157.41, 005.37, 166.13,
012.65, 217.53, 060.27, 213.70, 051.33, 246.74, 080.63, 227.12, 060.73, 255.56,
092.43, 245.02, 086.98, 291.24, 137.30, 297.80, 145.69, 353.56, 200.78, 359.95,
204.06, 045.85, 245.05, 034.96, 229.69, 063.24, 256.53, 043.71, 239.25, 077.06,
277.46, 073.57, 278.58, 125.19, 332.79, 133.96, 341.65, 188.45, 033.76, 190.23,
031.03, 229.24, 065.09, 212.46, 045.80, 239.26, 073.73, 223.29
}, 
{
164.51, 034.52, 263.41, 008.10, 233.64, 097.20, 318.84, 056.21, 275.33, 134.40,
354.33, 093.13, 316.51, 181.87, 049.08, 155.17, 025.09, 255.71, 126.52, 234.32,
103.94, 332.28, 198.96, 301.07, 163.87, 024.84, 244.43, 340.74, 200.05, 060.51,
282.70, 024.18, 250.28, 118.12, 347.39, 094.97, 325.72, 196.46, 066.66, 173.17,
040.90, 266.87, 130.88, 230.27, 090.63, 309.89, 168.88, 265.87, 126.96, 349.89,
214.81, 318.95, 187.39, 057.08, 287.59, 035.74, 266.32, 136.18, 004.84, 109.26,
334.48, 197.73, 059.08, 156.25, 015.29, 234.45, 094.59, 193.68
}, 
{
059.84, 018.57, 336.18, 182.65, 136.92, 089.20, 039.56, 238.72, 186.56, 134.36,
083.01, 283.60, 235.70, 189.78, 145.71, 353.59, 312.23, 271.57, 231.10, 080.69,
039.04, 356.10, 311.50, 155.40, 106.92, 056.62, 004.93, 203.02, 151.05, 100.24,
051.15, 254.42, 209.24, 165.81, 123.79, 333.17, 292.64, 252.09, 211.02, 059.31,
015.77, 330.46, 283.20, 124.37, 073.45, 021.43, 329.15, 167.93, 117.73, 069.39,
023.03, 228.96, 186.12, 144.54, 103.77, 313.70, 273.01, 231.59, 188.97, 035.18,
349.12, 301.09, 251.16, 090.12, 037.89, 345.77, 294.63, 135.51
}, 
{
315.16, 002.61, 048.95, 357.21, 040.19, 081.20, 120.29, 061.23, 097.80, 134.31,
171.69, 114.06, 154.89, 197.69, 242.34, 192.01, 239.38, 287.44, 335.69, 287.07,
334.13, 019.91, 064.04, 009.73, 049.98, 088.39, 125.42, 065.31, 102.06, 139.97,
179.60, 124.65, 168.20, 213.49, 260.20, 211.36, 259.55, 307.73, 355.38, 305.46,
350.64, 034.05, 075.51, 018.47, 056.28, 092.98, 129.41, 069.98, 108.51, 148.89,
191.25, 138.97, 184.85, 231.99, 279.95, 231.66, 279.69, 326.99, 013.11, 321.09,
003.76, 044.45, 083.25, 023.99, 060.48, 097.08, 134.67, 077.33
}, 
{
149.73, 095.83, 040.98, 272.67, 214.93, 155.46, 094.26, 319.45, 255.96, 192.43,
129.68, 356.17, 296.53, 238.64, 182.35, 055.24, 001.26, 307.88, 254.66, 128.99,
074.77, 019.45, 322.71, 192.15, 131.99, 070.19, 007.13, 231.35, 168.03, 105.77,
045.06, 273.95, 216.70, 160.96, 106.44, 340.59, 287.31, 234.03, 180.29, 053.53,
357.70, 300.34, 241.26, 108.27, 045.92, 342.56, 278.95, 143.80, 082.10, 022.06,
323.78, 194.99, 139.76, 085.60, 032.13, 266.75, 213.34, 159.31, 104.27, 335.72,
277.71, 217.95, 156.49, 021.50, 317.94, 254.49, 191.93, 058.68
}, 
{
211.83, 269.86, 327.03, 248.14, 303.02, 356.73, 049.42, 326.39, 017.94, 069.47,
121.36, 039.00, 092.60, 147.37, 203.34, 125.45, 183.42, 241.93, 300.59, 224.01,
281.74, 338.51, 034.13, 313.57, 006.87, 059.24, 110.98, 027.49, 079.12, 131.26,
184.22, 103.29, 158.53, 214.95, 272.41, 195.66, 254.27, 312.88, 011.06, 293.48,
349.82, 044.97, 098.93, 016.86, 068.95, 120.56, 172.05, 088.85, 141.28, 194.64,
249.14, 169.87, 226.71, 284.50, 342.93, 266.62, 325.11, 023.02, 080.03, 000.95,
055.63, 109.16, 161.71, 078.60, 130.11, 181.67, 233.66, 151.44
}, 
{
046.40, 003.08, 319.07, 163.60, 117.76, 070.98, 023.39, 224.61, 176.10, 127.58,
079.35, 281.10, 234.24, 188.31, 143.35, 348.68, 305.30, 262.37, 219.55, 065.93,
022.37, 338.05, 292.80, 135.99, 088.88, 041.03, 352.68, 193.54, 145.10, 097.06,
049.69, 252.59, 207.03, 162.42, 118.64, 324.89, 282.04, 239.17, 195.97, 041.55,
356.88, 311.26, 264.68, 106.67, 058.60, 010.14, 321.59, 162.67, 114.87, 067.81,
021.67, 225.89, 181.63, 138.11, 095.11, 301.70, 258.75, 215.33, 171.20, 015.57,
329.58, 282.66, 234.95, 076.10, 027.57, 339.07, 290.92, 132.79
}, 
{
301.72, 347.12, 031.84, 338.16, 021.04, 062.98, 104.12, 047.12, 087.34, 127.54,
168.03, 111.57, 153.43, 196.22, 239.98, 187.10, 232.45, 278.23, 324.14, 272.31,
317.47, 001.86, 045.34, 350.32, 031.93, 072.81, 113.18, 055.82, 096.10, 136.79,
178.14, 122.82, 165.99, 210.11, 255.05, 203.08, 248.95, 294.81, 340.33, 287.70,
331.75, 014.85, 057.00, 000.77, 041.42, 081.68, 121.85, 064.73, 105.64, 147.31,
189.89, 135.90, 180.36, 225.57, 271.28, 219.67, 265.43, 310.74, 355.33, 301.49,
344.22, 026.02, 067.04, 009.97, 050.16, 090.39, 130.96, 074.61
}, 
{
039.30, 140.22, 268.91, 335.52, 118.44, 236.20, 354.45, 045.05, 183.39, 316.66,
076.22, 110.04, 248.47, 036.41, 170.37, 185.88, 328.77, 126.78, 269.36, 279.57,
060.29, 213.84, 353.08, 018.44, 144.31, 283.97, 061.62, 104.66, 221.27, 346.71,
127.31, 187.19, 309.75, 058.29, 206.30, 278.55, 049.75, 148.02, 297.13, 007.27,
139.68, 245.78, 020.57, 078.72, 213.80, 334.91, 093.48, 140.50, 281.40, 060.31,
173.76, 209.18, 359.61, 153.35, 269.52, 295.77, 090.03, 244.14, 005.95, 031.20,
173.67, 317.60, 088.01, 119.83, 243.99, 019.57, 159.12, 206.41
}, 
{
136.29, 080.34, 023.88, 253.62, 195.78, 137.24, 078.09, 305.34, 245.50, 185.65,
126.02, 353.68, 295.07, 237.17, 179.99, 050.32, 354.33, 298.67, 243.11, 114.23,
058.10, 001.40, 304.00, 172.74, 113.95, 054.61, 354.89, 221.87, 162.08, 102.59,
043.60, 272.12, 214.49, 157.58, 101.29, 332.31, 276.71, 221.11, 165.25, 035.77,
338.81, 281.14, 222.75, 090.58, 031.06, 331.26, 271.39, 138.54, 079.23, 020.48,
322.42, 191.93, 135.27, 079.17, 023.46, 254.75, 199.08, 143.05, 086.50, 316.12,
258.16, 199.51, 140.28, 007.48, 307.62, 247.79, 188.22, 055.96
}, 
{
315.16, 002.61, 048.95, 357.21, 040.19, 081.20, 120.29, 061.23, 097.80, 134.31,
171.69, 114.06, 154.89, 197.69, 242.34, 192.01, 239.38, 287.44, 335.69, 287.07,
334.13, 019.91, 064.04, 009.73, 049.98, 088.39, 125.42, 065.31, 102.06, 139.97,
179.60, 124.65, 168.20, 213.49, 260.20, 211.36, 259.55, 307.73, 355.38, 305.46,
350.64, 034.05, 075.51, 018.47, 056.28, 092.98, 129.41, 069.98, 108.51, 148.89,
191.25, 138.97, 184.85, 231.99, 279.95, 231.66, 279.69, 326.99, 013.11, 321.09,
003.76, 044.45, 083.25, 023.99, 060.48, 097.08, 134.67, 077.33
}, 
{
211.83, 269.86, 327.03, 248.14, 303.02, 356.73, 049.42, 326.39, 017.94, 069.47,
121.36, 039.00, 092.60, 147.37, 203.34, 125.45, 183.42, 241.93, 300.59, 224.01,
281.74, 338.51, 034.13, 313.57, 006.87, 059.24, 110.98, 027.49, 079.12, 131.26,
184.22, 103.29, 158.53, 214.95, 272.41, 195.66, 254.27, 312.88, 011.06, 293.48,
349.82, 044.97, 098.93, 016.86, 068.95, 120.56, 172.05, 088.85, 141.28, 194.64,
249.14, 169.87, 226.71, 284.50, 342.93, 266.62, 325.11, 023.02, 080.03, 000.95,
055.63, 109.16, 161.71, 078.60, 130.11, 181.67, 233.66, 151.44
}, 
{
107.15, 253.90, 039.80, 062.70, 206.30, 348.73, 130.14, 148.90, 289.17, 069.42,
210.04, 229.46, 011.79, 155.28, 299.98, 323.87, 110.56, 257.79, 045.18, 070.38,
216.84, 002.33, 146.67, 167.90, 309.92, 091.01, 231.48, 249.78, 030.13, 170.98,
312.67, 333.53, 117.49, 262.63, 048.81, 073.85, 221.19, 008.51, 155.42, 179.62,
324.69, 108.56, 251.25, 270.96, 051.77, 192.10, 332.32, 350.91, 132.05, 274.14,
057.36, 079.88, 225.45, 011.96, 159.10, 184.58, 331.79, 118.42, 264.16, 286.86,
070.27, 212.52, 353.80, 012.47, 152.71, 292.99, 073.70, 093.27
}, 
{
204.74, 047.00, 276.87, 060.06, 303.70, 161.94, 020.48, 146.83, 025.23, 258.54,
118.23, 227.94, 106.83, 355.47, 230.36, 322.66, 206.89, 106.34, 350.40, 077.65,
319.65, 214.31, 094.42, 196.02, 062.29, 302.17, 179.91, 298.61, 155.29, 020.91,
261.85, 037.90, 261.25, 110.82, 000.06, 149.32, 021.99, 221.72, 112.21, 259.20,
132.62, 339.50, 214.82, 348.91, 224.15, 085.33, 303.94, 066.68, 307.81, 187.14,
041.23, 153.16, 044.70, 299.74, 157.34, 260.68, 156.39, 051.83, 274.78, 016.57,
259.72, 144.10, 014.77, 122.32, 346.53, 222.16, 101.86, 225.06
}, 
{
301.72, 347.12, 031.84, 338.16, 021.04, 062.98, 104.12, 047.12, 087.34, 127.54,
168.03, 111.57, 153.43, 196.22, 239.98, 187.10, 232.45, 278.23, 324.14, 272.31,
317.47, 001.86, 045.34, 350.32, 031.93, 072.81, 113.18, 055.82, 096.10, 136.79,
178.14, 122.82, 165.99, 210.11, 255.05, 203.08, 248.95, 294.81, 340.33, 287.70,
331.75, 014.85, 057.00, 000.77, 041.42, 081.68, 121.85, 064.73, 105.64, 147.31,
189.89, 135.90, 180.36, 225.57, 271.28, 219.67, 265.43, 310.74, 355.33, 301.49,
344.22, 026.02, 067.04, 009.97, 050.16, 090.39, 130.96, 074.61
}, 
{
262.72, 133.39, 003.98, 222.27, 092.63, 322.87, 193.01, 050.89, 280.92, 150.94,
021.00, 238.95, 109.18, 339.53, 210.00, 068.39, 299.06, 169.78, 040.52, 259.04,
129.68, 000.23, 230.67, 088.79, 318.99, 189.10, 059.15, 276.98, 147.01, 017.10,
247.27, 105.35, 335.75, 206.26, 076.88, 295.38, 166.12, 036.85, 267.54, 125.96,
356.47, 226.86, 097.12, 315.10, 185.18, 055.21, 285.23, 143.09, 013.21, 243.41,
113.74, 331.99, 202.54, 073.20, 303.91, 162.46, 033.18, 263.84, 134.42, 352.69,
223.03, 093.25, 323.38, 181.25, 051.27, 281.30, 151.37, 009.33
}, 
{
289.04, 228.80, 169.11, 035.17, 337.56, 281.37, 226.59, 097.77, 044.62, 351.49,
297.86, 168.08, 112.03, 054.54, 355.81, 221.07, 160.87, 100.38, 039.80, 264.25,
204.19, 144.80, 086.40, 314.21, 258.58, 204.27, 150.84, 022.66, 329.40, 275.42,
220.25, 088.51, 030.51, 331.40, 271.51, 136.05, 075.50, 014.96, 314.63, 179.68,
120.63, 062.71, 006.20, 236.00, 182.09, 128.86, 075.78, 307.20, 252.80, 197.08,
139.90, 006.31, 306.86, 246.77, 186.31, 050.62, 350.14, 289.97, 230.40, 096.63,
039.24, 343.28, 288.71, 160.01, 106.90, 053.73, 359.97, 229.98
}, 
{
046.09, 154.04, 262.74, 308.89, 060.66, 174.95, 292.29, 348.89, 111.33, 233.88,
354.53, 048.36, 162.91, 274.89, 024.97, 069.97, 177.98, 285.57, 033.05, 076.92,
185.12, 294.25, 044.82, 093.69, 209.11, 327.67, 089.05, 148.01, 270.02, 029.56,
145.97, 195.64, 306.81, 056.33, 164.77, 208.77, 316.29, 063.81, 171.64, 216.34,
325.96, 077.27, 190.93, 243.75, 003.50, 125.62, 248.35, 305.77, 064.12, 179.33,
291.83, 338.48, 087.53, 195.68, 303.33, 347.01, 094.62, 202.67, 311.53, 357.93,
110.06, 224.81, 342.66, 039.70, 162.31, 284.66, 044.87, 098.19
}, 
{
318.18, 055.24, 153.19, 226.09, 327.04, 069.88, 174.53, 254.21, 000.95, 107.72,
213.85, 292.30, 035.31, 136.42, 235.82, 307.52, 044.65, 141.26, 237.73, 308.10,
045.46, 143.86, 243.73, 319.05, 062.62, 167.87, 274.25, 354.75, 101.35, 207.03,
311.18, 027.10, 127.51, 226.34, 323.99, 034.51, 131.02, 227.55, 324.47, 035.83,
134.75, 235.29, 337.70, 055.62, 161.38, 268.02, 014.85, 094.83, 199.98, 303.42,
044.96, 118.36, 216.68, 313.99, 050.67, 120.79, 217.42, 314.60, 052.73, 125.89,
227.13, 330.27, 075.19, 155.03, 261.82, 008.54, 114.49, 192.67
}, 
{
355.67, 096.78, 197.72, 275.04, 015.53, 115.77, 215.82, 292.32, 032.13, 131.94,
231.83, 308.46, 048.69, 149.14, 249.85, 327.37, 068.47, 169.68, 270.92, 348.70,
089.76, 190.62, 291.25, 008.24, 108.40, 208.38, 308.24, 024.64, 124.48, 224.41,
324.51, 041.43, 141.98, 242.77, 343.77, 061.52, 162.75, 263.98, 005.12, 082.71,
183.48, 284.02, 024.31, 101.00, 200.93, 300.76, 040.56, 117.02, 217.02, 317.19,
057.60, 134.85, 235.72, 336.79, 077.98, 155.82, 257.02, 358.11, 099.02, 176.31,
276.75, 016.96, 116.98, 193.46, 293.27, 033.09, 132.99, 209.65
}, 
{
341.10, 183.56, 025.68, 179.58, 020.79, 221.52, 061.85, 214.10, 053.97, 253.83,
093.83, 246.35, 087.04, 288.20, 129.84, 284.15, 126.58, 329.24, 171.95, 326.78,
169.12, 011.08, 212.58, 005.82, 206.39, 046.58, 246.53, 038.60, 238.50, 078.61,
279.04, 072.13, 273.48, 115.30, 317.53, 112.29, 314.99, 157.68, 000.20, 154.63,
356.42, 197.73, 038.56, 191.20, 031.28, 231.18, 071.02, 223.21, 063.43, 264.02,
105.07, 258.83, 100.81, 303.18, 145.80, 300.74, 143.38, 345.80, 187.85, 341.68,
182.80, 023.47, 223.74, 015.95, 215.81, 055.68, 255.73, 048.30
}, 
{
301.72, 347.12, 031.84, 338.16, 021.04, 062.98, 104.12, 047.12, 087.34, 127.54,
168.03, 111.57, 153.43, 196.22, 239.98, 187.10, 232.45, 278.23, 324.14, 272.31,
317.47, 001.86, 045.34, 350.32, 031.93, 072.81, 113.18, 055.82, 096.10, 136.79,
178.14, 122.82, 165.99, 210.11, 255.05, 203.08, 248.95, 294.81, 340.33, 287.70,
331.75, 014.85, 057.00, 000.77, 041.42, 081.68, 121.85, 064.73, 105.64, 147.31,
189.89, 135.90, 180.36, 225.57, 271.28, 219.67, 265.43, 310.74, 355.33, 301.49,
344.22, 026.02, 067.04, 009.97, 050.16, 090.39, 130.96, 074.61
}, 
{
240.97, 096.30, 311.11, 079.06, 292.50, 145.24, 357.36, 122.83, 334.27, 185.70,
037.34, 163.21, 015.89, 229.26, 083.35, 211.90, 067.19, 282.81, 138.52, 267.86,
123.01, 337.58, 191.46, 318.41, 170.90, 022.83, 234.39, 359.58, 211.07, 062.86,
275.15, 041.88, 255.53, 109.90, 324.88, 094.12, 309.80, 165.47, 020.89, 149.63,
003.94, 217.55, 070.44, 196.48, 048.24, 259.72, 111.12, 236.49, 088.46, 300.98,
154.19, 281.92, 136.54, 351.72, 207.29, 336.79, 192.39, 047.65, 262.36, 030.20,
243.52, 096.15, 308.19, 073.61, 285.03, 136.48, 348.18, 114.13
}, 
{
123.61, 322.02, 161.15, 310.63, 152.30, 355.62, 200.56, 355.99, 202.78, 049.61,
255.85, 050.19, 253.67, 095.48, 295.82, 084.29, 282.76, 120.82, 318.77, 106.17,
304.82, 144.33, 345.07, 136.63, 340.60, 186.07, 032.55, 188.70, 035.37, 241.22,
085.71, 237.80, 079.01, 278.87, 117.75, 265.28, 103.26, 301.25, 139.55, 287.75,
127.69, 329.00, 171.95, 325.81, 171.73, 018.44, 225.32, 021.02, 226.39, 070.25,
272.43, 062.34, 261.77, 100.38, 298.49, 085.71, 283.78, 122.29, 321.57, 111.26,
313.18, 156.78, 001.95, 157.52, 004.36, 211.13, 057.23, 211.33
}, 
{
226.19, 157.61, 088.69, 343.64, 273.80, 203.49, 132.78, 026.07, 314.90, 243.72,
172.69, 066.25, 355.90, 286.02, 216.62, 111.97, 043.37, 334.98, 266.66, 162.53,
093.83, 024.75, 315.21, 209.49, 139.02, 068.18, 357.09, 250.19, 179.06, 108.12,
037.52, 291.65, 221.96, 152.73, 083.93, 339.73, 271.39, 203.04, 134.53, 030.00,
320.74, 251.02, 180.81, 074.49, 003.53, 292.39, 221.19, 114.42, 043.60, 333.16,
263.17, 157.96, 088.91, 020.24, 311.82, 207.80, 139.40, 070.78, 001.79, 256.66,
186.75, 116.37, 045.60, 298.86, 227.68, 156.51, 085.52, 339.13
}, 
{
060.76, 250.83, 080.73, 259.10, 088.54, 277.75, 106.75, 284.29, 113.07, 301.84,
130.69, 308.36, 137.55, 326.97, 156.63, 335.19, 165.25, 355.42, 185.62, 004.45,
194.46, 024.28, 213.88, 031.91, 221.03, 049.97, 238.79, 056.24, 245.03, 073.92,
262.98, 080.94, 270.46, 100.21, 290.17, 108.96, 299.15, 129.34, 319.44, 138.07,
327.81, 157.30, 346.56, 164.29, 353.18, 181.97, 010.73, 188.24, 017.19, 206.33,
035.69, 213.99, 043.82, 233.85, 064.00, 242.88, 073.04, 263.09, 092.96, 271.29,
100.69, 289.87, 118.84, 296.37, 125.14, 313.92, 142.78, 320.48
}, 
{
122.85, 064.85, 006.78, 234.56, 176.62, 119.02, 061.92, 291.23, 235.04, 178.87,
122.36, 351.18, 293.62, 235.70, 177.62, 045.41, 347.40, 289.47, 231.56, 099.47,
041.44, 343.35, 285.30, 153.33, 095.91, 039.02, 342.64, 212.38, 156.12, 099.41,
042.14, 270.29, 212.29, 154.20, 096.14, 324.03, 266.11, 208.19, 150.21, 018.01,
319.92, 261.94, 204.24, 072.88, 016.21, 319.96, 263.83, 133.29, 076.37, 018.91,
321.05, 188.86, 130.77, 072.75, 014.80, 242.75, 184.81, 126.80, 068.72, 296.52,
238.61, 181.08, 124.07, 353.46, 297.30, 241.10, 184.51, 053.24
}, 
{
345.59, 191.30, 036.12, 191.90, 033.81, 233.76, 071.58, 219.64, 054.22, 248.73,
084.42, 234.26, 074.03, 275.77, 119.18, 276.13, 121.78, 327.96, 174.29, 332.58,
177.99, 022.37, 225.32, 018.73, 217.87, 054.88, 250.11, 036.72, 231.56, 067.95,
266.40, 059.18, 261.61, 105.57, 310.70, 108.83, 315.11, 161.38, 007.25, 164.53,
008.40, 210.71, 051.13, 201.65, 037.90, 232.68, 067.08, 214.63, 051.79, 251.07,
092.39, 247.68, 092.14, 297.61, 143.71, 302.27, 148.42, 354.02, 198.66, 354.20,
195.81, 035.43, 232.90, 020.70, 215.17, 049.80, 245.76, 035.95
}, 
{
046.40, 003.08, 319.07, 163.60, 117.76, 070.98, 023.39, 224.61, 176.10, 127.58,
079.35, 281.10, 234.24, 188.31, 143.35, 348.68, 305.30, 262.37, 219.55, 065.93,
022.37, 338.05, 292.80, 135.99, 088.88, 041.03, 352.68, 193.54, 145.10, 097.06,
049.69, 252.59, 207.03, 162.42, 118.64, 324.89, 282.04, 239.17, 195.97, 041.55,
356.88, 311.26, 264.68, 106.67, 058.60, 010.14, 321.59, 162.67, 114.87, 067.81,
021.67, 225.89, 181.63, 138.11, 095.11, 301.70, 258.75, 215.33, 171.20, 015.57,
329.58, 282.66, 234.95, 076.10, 027.57, 339.07, 290.92, 132.79
}, 
{
301.72, 347.12, 031.84, 338.16, 021.04, 062.98, 104.12, 047.12, 087.34, 127.54,
168.03, 111.57, 153.43, 196.22, 239.98, 187.10, 232.45, 278.23, 324.14, 272.31,
317.47, 001.86, 045.34, 350.32, 031.93, 072.81, 113.18, 055.82, 096.10, 136.79,
178.14, 122.82, 165.99, 210.11, 255.05, 203.08, 248.95, 294.81, 340.33, 287.70,
331.75, 014.85, 057.00, 000.77, 041.42, 081.68, 121.85, 064.73, 105.64, 147.31,
189.89, 135.90, 180.36, 225.57, 271.28, 219.67, 265.43, 310.74, 355.33, 301.49,
344.22, 026.02, 067.04, 009.97, 050.16, 090.39, 130.96, 074.61
}, 
{
196.16, 329.68, 102.70, 150.59, 282.23, 053.16, 183.49, 228.90, 358.54, 128.16,
258.01, 303.82, 074.69, 206.26, 338.56, 027.05, 160.54, 294.35, 068.26, 117.54,
250.89, 023.66, 155.74, 202.64, 333.32, 103.45, 233.21, 278.35, 048.03, 178.02,
308.51, 355.19, 127.04, 259.60, 032.78, 081.96, 215.84, 349.71, 123.33, 172.01,
304.52, 076.32, 207.41, 253.40, 023.36, 153.03, 282.64, 327.95, 098.11, 228.84,
000.25, 047.92, 180.73, 314.11, 087.88, 137.32, 271.12, 044.58, 177.49, 225.28,
356.80, 127.62, 257.86, 303.22, 072.84, 202.49, 332.39, 018.29
}, 
{
289.04, 228.80, 169.11, 035.17, 337.56, 281.37, 226.59, 097.77, 044.62, 351.49,
297.86, 168.08, 112.03, 054.54, 355.81, 221.07, 160.87, 100.38, 039.80, 264.25,
204.19, 144.80, 086.40, 314.21, 258.58, 204.27, 150.84, 022.66, 329.40, 275.42,
220.25, 088.51, 030.51, 331.40, 271.51, 136.05, 075.50, 014.96, 314.63, 179.68,
120.63, 062.71, 006.20, 236.00, 182.09, 128.86, 075.78, 307.20, 252.80, 197.08,
139.90, 006.31, 306.86, 246.77, 186.31, 050.62, 350.14, 289.97, 230.40, 096.63,
039.24, 343.28, 288.71, 160.01, 106.90, 053.73, 359.97, 229.98
}, 
{
237.98, 274.44, 309.51, 284.50, 315.19, 343.29, 008.96, 334.70, 357.59, 020.44,
044.16, 011.53, 039.38, 069.84, 102.73, 079.53, 115.89, 153.09, 190.53, 169.45,
205.44, 239.80, 272.01, 243.59, 270.70, 295.59, 318.95, 283.60, 306.68, 331.00,
357.33, 328.09, 359.52, 033.25, 068.79, 047.45, 084.82, 122.16, 158.86, 136.19,
169.77, 201.04, 229.71, 197.78, 221.98, 245.01, 267.78, 233.12, 258.13, 285.42,
315.29, 289.56, 324.05, 000.13, 037.20, 016.54, 053.70, 089.98, 124.76, 099.39,
129.67, 157.35, 182.68, 148.20, 171.02, 193.95, 217.90, 185.62
}, 
{
226.19, 157.61, 088.69, 343.64, 273.80, 203.49, 132.78, 026.07, 314.90, 243.72,
172.69, 066.25, 355.90, 286.02, 216.62, 111.97, 043.37, 334.98, 266.66, 162.53,
093.83, 024.75, 315.21, 209.49, 139.02, 068.18, 357.09, 250.19, 179.06, 108.12,
037.52, 291.65, 221.96, 152.73, 083.93, 339.73, 271.39, 203.04, 134.53, 030.00,
320.74, 251.02, 180.81, 074.49, 003.53, 292.39, 221.19, 114.42, 043.60, 333.16,
263.17, 157.96, 088.91, 020.24, 311.82, 207.80, 139.40, 070.78, 001.79, 256.66,
186.75, 116.37, 045.60, 298.86, 227.68, 156.51, 085.52, 339.13
}, 
{
271.27, 108.58, 310.94, 108.48, 334.36, 168.68, 000.17, 123.59, 001.16, 207.19,
037.17, 143.93, 002.51, 247.07, 091.17, 201.70, 055.59, 310.16, 161.92, 273.63,
123.21, 014.77, 228.60, 336.46, 172.71, 039.11, 268.31, 018.48, 206.55, 042.07,
274.61, 059.35, 257.12, 093.45, 318.25, 121.80, 326.61, 164.31, 024.36, 190.23,
035.78, 229.34, 073.68, 229.82, 083.51, 273.92, 102.44, 220.62, 101.66, 314.77,
148.61, 261.85, 139.58, 015.87, 216.20, 330.63, 204.04, 086.40, 287.05, 037.27,
254.19, 137.89, 340.19, 083.72, 275.58, 133.17, 008.44, 123.82
}, 
{
088.22, 307.83, 165.88, 297.51, 150.72, 001.11, 208.86, 330.41, 175.16, 019.86,
225.50, 348.81, 198.93, 051.89, 267.53, 041.16, 260.66, 121.11, 341.82, 117.84,
336.92, 194.18, 049.07, 176.95, 026.26, 233.17, 078.43, 198.79, 043.75, 250.03,
098.51, 225.49, 079.52, 296.08, 154.66, 290.38, 151.01, 011.62, 231.51, 005.73,
222.13, 075.97, 286.99, 051.05, 257.22, 102.12, 306.73, 067.84, 274.89, 124.39,
336.71, 107.53, 324.94, 184.13, 044.43, 180.92, 041.32, 260.73, 118.46, 249.69,
102.45, 312.38, 159.77, 281.08, 125.75, 330.54, 176.43, 300.11
}, 
{
240.97, 096.30, 311.11, 079.06, 292.50, 145.24, 357.36, 122.83, 334.27, 185.70,
037.34, 163.21, 015.89, 229.26, 083.35, 211.90, 067.19, 282.81, 138.52, 267.86,
123.01, 337.58, 191.46, 318.41, 170.90, 022.83, 234.39, 359.58, 211.07, 062.86,
275.15, 041.88, 255.53, 109.90, 324.88, 094.12, 309.80, 165.47, 020.89, 149.63,
003.94, 217.55, 070.44, 196.48, 048.24, 259.72, 111.12, 236.49, 088.46, 300.98,
154.19, 281.92, 136.54, 351.72, 207.29, 336.79, 192.39, 047.65, 262.36, 030.20,
243.52, 096.15, 308.19, 073.61, 285.03, 136.48, 348.18, 114.13
}};



NV_FLOAT32 default_node_factor[DEFAULT_CONSTITUENTS][DEFAULT_NUM_YEARS] = {
{
1.1550, 1.1324, 1.0972, 1.0504, 0.9949, 0.9359, 0.8815, 0.8421, 0.8268, 0.8396,
0.8771, 0.9305, 0.9895, 1.0456, 1.0934, 1.1297, 1.1534, 1.1643, 1.1624, 1.1477,
1.1203, 1.0804, 1.0298, 0.9720, 0.9137, 0.8640, 0.8329, 0.8284, 0.8516, 0.8964,
0.9532, 1.0120, 1.0653, 1.1089, 1.1404, 1.1592, 1.1651, 1.1583, 1.1386, 1.1062,
1.0619, 1.0080, 0.9491, 0.8928, 0.8492, 0.8278, 0.8343, 0.8669, 0.9176, 0.9761,
1.0336, 1.0836, 1.1226, 1.1492, 1.1630, 1.1640, 1.1522, 1.1276, 1.0904, 1.0419,
0.9854, 0.9265, 0.8739, 0.8378, 0.8269, 0.8441, 0.8849, 0.9399
}, 
{
1.1052, 1.0884, 1.0627, 1.0294, 0.9910, 0.9514, 0.9161, 0.8912, 0.8817, 0.8897,
0.9133, 0.9479, 0.9873, 1.0260, 1.0600, 1.0864, 1.1040, 1.1122, 1.1108, 1.0998,
1.0795, 1.0507, 1.0150, 0.9755, 0.9369, 0.9050, 0.8855, 0.8827, 0.8972, 0.9257,
0.9629, 1.0027, 1.0399, 1.0712, 1.0943, 1.1083, 1.1128, 1.1077, 1.0930, 1.0693,
1.0375, 0.9999, 0.9602, 0.9234, 0.8957, 0.8824, 0.8864, 0.9068, 0.9394, 0.9782,
1.0176, 1.0529, 1.0812, 1.1008, 1.1112, 1.1119, 1.1031, 1.0849, 1.0578, 1.0235,
0.9845, 0.9453, 0.9113, 0.8886, 0.8818, 0.8925, 0.9183, 0.9541
}, 
{
1.2888, 1.2313, 1.1495, 1.0538, 0.9566, 0.8697, 0.8026, 0.7610, 0.7462, 0.7585,
0.7977, 0.8626, 0.9480, 1.0447, 1.1411, 1.2247, 1.2847, 1.3140, 1.3089, 1.2699,
1.2020, 1.1135, 1.0157, 0.9210, 0.8409, 0.7834, 0.7521, 0.7478, 0.7705, 0.8199,
0.8936, 0.9848, 1.0828, 1.1755, 1.2511, 1.3000, 1.3162, 1.2977, 1.2467, 1.1695,
1.0761, 0.9781, 0.8878, 0.8156, 0.7680, 0.7472, 0.7534, 0.7865, 0.8458, 0.9272,
1.0225, 1.1201, 1.2075, 1.2736, 1.3103, 1.3131, 1.2815, 1.2195, 1.1347, 1.0379,
0.9415, 0.8573, 0.7941, 0.7567, 0.7464, 0.7630, 0.8065, 0.8751
}, 
{
0.8831, 0.6623, 1.1220, 1.2746, 1.0150, 0.8055, 0.9886, 1.1790, 1.1703, 0.9946,
0.8452, 1.0012, 1.2407, 1.1589, 0.7443, 0.8102, 1.2664, 1.2492, 0.7484, 0.7453,
1.2196, 1.2498, 0.8975, 0.7985, 1.0789, 1.2102, 1.1077, 0.9196, 0.8915, 1.0966,
1.2402, 1.0587, 0.7049, 0.9429, 1.3097, 1.1554, 0.6393, 0.8671, 1.2911, 1.1868,
0.7787, 0.8482, 1.1647, 1.2047, 1.0215, 0.8780, 0.9704, 1.1656, 1.2040, 0.9582,
0.7337, 1.0650, 1.3148, 1.0392, 0.5914, 1.0009, 1.3288, 1.0909, 0.6859, 0.9409,
1.2309, 1.1616, 0.9271, 0.8837, 1.0590, 1.1994, 1.1385, 0.8768
}, 
{
1.9909, 2.1825, 1.5072, 0.9987, 1.5402, 1.7807, 1.4297, 0.8695, 0.8719, 1.3637,
1.6606, 1.4722, 0.9663, 1.3242, 2.0508, 2.0350, 1.2909, 1.3641, 2.1506, 2.1303,
1.3325, 1.1549, 1.7790, 1.8323, 1.2847, 0.7916, 1.0850, 1.4900, 1.5626, 1.2148,
0.8804, 1.4839, 2.0511, 1.8350, 1.1273, 1.5657, 2.2502, 2.0159, 1.1805, 1.3818,
1.9709, 1.8157, 1.1232, 0.8780, 1.3201, 1.5575, 1.4048, 0.9652, 0.9344, 1.6115,
1.9812, 1.5935, 1.0584, 1.7583, 2.2830, 1.8465, 1.0994, 1.6269, 2.1025, 1.7335,
0.9911, 1.0897, 1.5305, 1.5594, 1.2040, 0.7928, 1.0825, 1.6896
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
0.9502, 0.9604, 0.9751, 0.9929, 1.0117, 1.0295, 1.0440, 1.0537, 1.0573, 1.0543,
1.0452, 1.0310, 1.0134, 0.9946, 0.9767, 0.9616, 0.9509, 0.9457, 0.9466, 0.9535,
0.9656, 0.9818, 1.0002, 1.0188, 1.0356, 1.0485, 1.0559, 1.0569, 1.0515, 1.0402,
1.0245, 1.0062, 0.9875, 0.9704, 0.9568, 0.9482, 0.9454, 0.9486, 0.9576, 0.9715,
0.9887, 1.0075, 1.0257, 1.0411, 1.0520, 1.0571, 1.0556, 1.0477, 1.0345, 1.0176,
0.9989, 0.9805, 0.9646, 0.9529, 0.9464, 0.9459, 0.9515, 0.9625, 0.9779, 0.9959,
1.0147, 1.0321, 1.0460, 1.0547, 1.0573, 1.0532, 1.0432, 1.0283
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
1.1702, 1.1428, 1.1010, 1.0470, 0.9849, 0.9207, 0.8629, 0.8216, 0.8057, 0.8190,
0.8582, 0.9150, 0.9789, 1.0415, 1.0965, 1.1395, 1.1683, 1.1818, 1.1794, 1.1613,
1.1282, 1.0814, 1.0237, 0.9598, 0.8970, 0.8444, 0.8121, 0.8074, 0.8315, 0.8786,
0.9394, 1.0038, 1.0640, 1.1146, 1.1524, 1.1754, 1.1828, 1.1743, 1.1503, 1.1115,
1.0601, 0.9994, 0.9349, 0.8748, 0.8290, 0.8068, 0.8135, 0.8475, 0.9011, 0.9643,
1.0279, 1.0850, 1.1309, 1.1631, 1.1801, 1.1813, 1.1668, 1.1370, 1.0930, 1.0374,
0.9745, 0.9107, 0.8549, 0.8171, 0.8059, 0.8237, 0.8665, 0.9250
}, 
{
1.7125, 1.5723, 1.3776, 1.1566, 0.9389, 0.7495, 0.6055, 0.5163, 0.4848, 0.5110,
0.5950, 0.7342, 0.9200, 1.1360, 1.3579, 1.5563, 1.7025, 1.7748, 1.7621, 1.6661,
1.5019, 1.2937, 1.0705, 0.8609, 0.6876, 0.5643, 0.4973, 0.4881, 0.5367, 0.6425,
0.8012, 1.0014, 1.2229, 1.4389, 1.6203, 1.7402, 1.7802, 1.7343, 1.6095, 1.4247,
1.2074, 0.9866, 0.7887, 0.6334, 0.5315, 0.4868, 0.5000, 0.5711, 0.6981, 0.8745,
1.0859, 1.3090, 1.5150, 1.6752, 1.7657, 1.7725, 1.6945, 1.5439, 1.3430, 1.1205,
0.9059, 0.7229, 0.5873, 0.5073, 0.4851, 0.5207, 0.6138, 0.7613
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.1702, 1.1428, 1.1010, 1.0470, 0.9849, 0.9207, 0.8629, 0.8216, 0.8057, 0.8190,
0.8582, 0.9150, 0.9789, 1.0415, 1.0965, 1.1395, 1.1683, 1.1818, 1.1794, 1.1613,
1.1282, 1.0814, 1.0237, 0.9598, 0.8970, 0.8444, 0.8121, 0.8074, 0.8315, 0.8786,
0.9394, 1.0038, 1.0640, 1.1146, 1.1524, 1.1754, 1.1828, 1.1743, 1.1503, 1.1115,
1.0601, 0.9994, 0.9349, 0.8748, 0.8290, 0.8068, 0.8135, 0.8475, 0.9011, 0.9643,
1.0279, 1.0850, 1.1309, 1.1631, 1.1801, 1.1813, 1.1668, 1.1370, 1.0930, 1.0374,
0.9745, 0.9107, 0.8549, 0.8171, 0.8059, 0.8237, 0.8665, 0.9250
}, 
{
1.1702, 1.1428, 1.1010, 1.0470, 0.9849, 0.9207, 0.8629, 0.8216, 0.8057, 0.8190,
0.8582, 0.9150, 0.9789, 1.0415, 1.0965, 1.1395, 1.1683, 1.1818, 1.1794, 1.1613,
1.1282, 1.0814, 1.0237, 0.9598, 0.8970, 0.8444, 0.8121, 0.8074, 0.8315, 0.8786,
0.9394, 1.0038, 1.0640, 1.1146, 1.1524, 1.1754, 1.1828, 1.1743, 1.1503, 1.1115,
1.0601, 0.9994, 0.9349, 0.8748, 0.8290, 0.8068, 0.8135, 0.8475, 0.9011, 0.9643,
1.0279, 1.0850, 1.1309, 1.1631, 1.1801, 1.1813, 1.1668, 1.1370, 1.0930, 1.0374,
0.9745, 0.9107, 0.8549, 0.8171, 0.8059, 0.8237, 0.8665, 0.9250
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
1.1702, 1.1428, 1.1010, 1.0470, 0.9849, 0.9207, 0.8629, 0.8216, 0.8057, 0.8190,
0.8582, 0.9150, 0.9789, 1.0415, 1.0965, 1.1395, 1.1683, 1.1818, 1.1794, 1.1613,
1.1282, 1.0814, 1.0237, 0.9598, 0.8970, 0.8444, 0.8121, 0.8074, 0.8315, 0.8786,
0.9394, 1.0038, 1.0640, 1.1146, 1.1524, 1.1754, 1.1828, 1.1743, 1.1503, 1.1115,
1.0601, 0.9994, 0.9349, 0.8748, 0.8290, 0.8068, 0.8135, 0.8475, 0.9011, 0.9643,
1.0279, 1.0850, 1.1309, 1.1631, 1.1801, 1.1813, 1.1668, 1.1370, 1.0930, 1.0374,
0.9745, 0.9107, 0.8549, 0.8171, 0.8059, 0.8237, 0.8665, 0.9250
}, 
{
1.0681, 1.0595, 1.0450, 1.0245, 0.9987, 0.9700, 0.9428, 0.9229, 0.9151, 0.9216,
0.9406, 0.9673, 0.9961, 1.0223, 1.0434, 1.0584, 1.0676, 1.0716, 1.0709, 1.0654,
1.0546, 1.0378, 1.0151, 0.9877, 0.9590, 0.9339, 0.9182, 0.9159, 0.9277, 0.9503,
0.9785, 1.0068, 1.0312, 1.0499, 1.0626, 1.0697, 1.0719, 1.0694, 1.0619, 1.0488,
1.0297, 1.0049, 0.9765, 0.9485, 0.9265, 0.9156, 0.9189, 0.9354, 0.9609, 0.9897,
1.0168, 1.0392, 1.0555, 1.0660, 1.0711, 1.0715, 1.0671, 1.0575, 1.0421, 1.0207,
0.9941, 0.9654, 0.9390, 0.9207, 0.9152, 0.9239, 0.9445, 0.9720
}, 
{
1.0323, 1.0313, 1.0276, 1.0197, 1.0065, 0.9889, 0.9703, 0.9556, 0.9497, 0.9546,
0.9687, 0.9872, 1.0050, 1.0187, 1.0271, 1.0311, 1.0323, 1.0324, 1.0324, 1.0321,
1.0303, 1.0252, 1.0152, 1.0000, 0.9816, 0.9639, 0.9521, 0.9503, 0.9592, 0.9756,
0.9944, 1.0109, 1.0226, 1.0291, 1.0318, 1.0324, 1.0324, 1.0324, 1.0317, 1.0288,
1.0219, 1.0099, 0.9931, 0.9743, 0.9583, 0.9501, 0.9526, 0.9650, 0.9829, 1.0012,
1.0160, 1.0256, 1.0305, 1.0322, 1.0324, 1.0324, 1.0323, 1.0309, 1.0267, 1.0179,
1.0039, 0.9859, 0.9675, 0.9540, 0.9498, 0.9564, 0.9715, 0.9902
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
1.4164, 1.3412, 1.2322, 1.1010, 0.9622, 0.8312, 0.7232, 0.6517, 0.6253, 0.6473,
0.7150, 0.8200, 0.9495, 1.0883, 1.2209, 1.3324, 1.4111, 1.4490, 1.4424, 1.3918,
1.3024, 1.1834, 1.0474, 0.9095, 0.7858, 0.6907, 0.6358, 0.6281, 0.6684, 0.7517,
0.8680, 1.0032, 1.1413, 1.2671, 1.3672, 1.4310, 1.4518, 1.4279, 1.3614, 1.2591,
1.1320, 0.9935, 0.8592, 0.7448, 0.6642, 0.6271, 0.6382, 0.6961, 0.7936, 0.9188,
1.0571, 1.1924, 1.3097, 1.3966, 1.4443, 1.4478, 1.4069, 1.3256, 1.2122, 1.0787,
0.9401, 0.8118, 0.7090, 0.6442, 0.6256, 0.6552, 0.7297, 0.8397
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
0.8826, 0.9063, 0.9405, 0.9817, 1.0254, 1.0665, 1.1005, 1.1229, 1.1312, 1.1243,
1.1031, 1.0700, 1.0293, 0.9857, 0.9441, 0.9090, 0.8843, 0.8724, 0.8744, 0.8904,
0.9184, 0.9558, 0.9986, 1.0419, 1.0808, 1.1107, 1.1279, 1.1304, 1.1177, 1.0915,
1.0550, 1.0125, 0.9691, 0.9295, 0.8981, 0.8780, 0.8715, 0.8790, 0.8999, 0.9320,
0.9720, 1.0155, 1.0577, 1.0937, 1.1190, 1.1307, 1.1272, 1.1090, 1.0783, 1.0390,
0.9955, 0.9530, 0.9162, 0.8888, 0.8738, 0.8727, 0.8856, 0.9111, 0.9468, 0.9887,
1.0323, 1.0726, 1.1049, 1.1253, 1.1312, 1.1218, 1.0984, 1.0639
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
0.6696, 0.6731, 0.6793, 0.6872, 0.6961, 0.7050, 0.7128, 0.7187, 0.7222, 0.7228,
0.7207, 0.7159, 0.7090, 0.7007, 0.6919, 0.6838, 0.6771, 0.6728, 0.6714, 0.6730,
0.6776, 0.6845, 0.6929, 0.7019, 0.7105, 0.7177, 0.7227, 0.7252, 0.7248, 0.7216,
0.7159, 0.7084, 0.6999, 0.6912, 0.6835, 0.6776, 0.6743, 0.6741, 0.6769, 0.6824,
0.6900, 0.6987, 0.7077, 0.7158, 0.7223, 0.7265, 0.7279, 0.7264, 0.7222, 0.7158,
0.7078, 0.6991, 0.6907, 0.6835, 0.6786, 0.6764, 0.6773, 0.6812, 0.6876, 0.6957,
0.7047, 0.7134, 0.7210, 0.7267, 0.7299, 0.7302, 0.7277, 0.7226
}, 
{
1.7925, 1.7341, 1.3393, 1.0068, 0.9669, 0.8897, 0.6575, 0.4185, 0.3949, 0.5646,
0.7266, 0.7753, 0.7871, 1.0713, 1.4984, 1.6677, 1.5771, 1.6627, 1.8922, 1.7991,
1.4033, 1.1684, 1.1567, 0.9982, 0.6765, 0.4367, 0.4677, 0.5891, 0.6497, 0.6209,
0.6613, 1.0011, 1.3812, 1.4960, 1.4623, 1.6854, 1.9440, 1.8209, 1.4646, 1.3462,
1.3397, 1.0971, 0.7130, 0.5172, 0.5671, 0.6105, 0.5706, 0.4901, 0.5853, 0.9344,
1.2392, 1.3041, 1.3492, 1.6836, 1.9430, 1.7996, 1.5254, 1.5242, 1.5037, 1.1836,
0.7799, 0.6500, 0.6779, 0.6261, 0.4952, 0.4016, 0.5564, 0.8675
}, 
{
1.2246, 1.2284, 1.2329, 1.2376, 1.2419, 1.2454, 1.2476, 1.2483, 1.2475, 1.2452,
1.2416, 1.2372, 1.2324, 1.2278, 1.2239, 1.2211, 1.2197, 1.2200, 1.2219, 1.2250,
1.2292, 1.2338, 1.2384, 1.2425, 1.2455, 1.2471, 1.2472, 1.2457, 1.2429, 1.2389,
1.2342, 1.2295, 1.2251, 1.2216, 1.2193, 1.2187, 1.2196, 1.2220, 1.2257, 1.2301,
1.2348, 1.2392, 1.2429, 1.2453, 1.2463, 1.2458, 1.2437, 1.2403, 1.2360, 1.2312,
1.2265, 1.2225, 1.2195, 1.2178, 1.2178, 1.2194, 1.2224, 1.2264, 1.2310, 1.2356,
1.2398, 1.2430, 1.2449, 1.2453, 1.2441, 1.2414, 1.2376, 1.2330
}, 
{
1.4164, 1.3412, 1.2322, 1.1010, 0.9622, 0.8312, 0.7232, 0.6517, 0.6253, 0.6473,
0.7150, 0.8200, 0.9495, 1.0883, 1.2209, 1.3324, 1.4111, 1.4490, 1.4424, 1.3918,
1.3024, 1.1834, 1.0474, 0.9095, 0.7858, 0.6907, 0.6358, 0.6281, 0.6684, 0.7517,
0.8680, 1.0032, 1.1413, 1.2671, 1.3672, 1.4310, 1.4518, 1.4279, 1.3614, 1.2591,
1.1320, 0.9935, 0.8592, 0.7448, 0.6642, 0.6271, 0.6382, 0.6961, 0.7936, 0.9188,
1.0571, 1.1924, 1.3097, 1.3966, 1.4443, 1.4478, 1.4069, 1.3256, 1.2122, 1.0787,
0.9401, 0.8118, 0.7090, 0.6442, 0.6256, 0.6552, 0.7297, 0.8397
}, 
{
1.0323, 1.0313, 1.0276, 1.0197, 1.0065, 0.9889, 0.9703, 0.9556, 0.9497, 0.9546,
0.9687, 0.9872, 1.0050, 1.0187, 1.0271, 1.0311, 1.0323, 1.0324, 1.0324, 1.0321,
1.0303, 1.0252, 1.0152, 1.0000, 0.9816, 0.9639, 0.9521, 0.9503, 0.9592, 0.9756,
0.9944, 1.0109, 1.0226, 1.0291, 1.0318, 1.0324, 1.0324, 1.0324, 1.0317, 1.0288,
1.0219, 1.0099, 0.9931, 0.9743, 0.9583, 0.9501, 0.9526, 0.9650, 0.9829, 1.0012,
1.0160, 1.0256, 1.0305, 1.0322, 1.0324, 1.0324, 1.0323, 1.0309, 1.0267, 1.0179,
1.0039, 0.9859, 0.9675, 0.9540, 0.9498, 0.9564, 0.9715, 0.9902
}, 
{
1.2039, 1.1666, 1.1115, 1.0438, 0.9715, 0.9040, 0.8501, 0.8159, 0.8037, 0.8139,
0.8461, 0.8983, 0.9649, 1.0372, 1.1057, 1.1623, 1.2013, 1.2198, 1.2166, 1.1918,
1.1472, 1.0865, 1.0159, 0.9442, 0.8810, 0.8344, 0.8086, 0.8050, 0.8238, 0.8641,
0.9228, 0.9929, 1.0647, 1.1293, 1.1796, 1.2110, 1.2211, 1.2095, 1.1767, 1.1253,
1.0599, 0.9878, 0.9183, 0.8606, 0.8218, 0.8045, 0.8096, 0.8370, 0.8850, 0.9490,
1.0210, 1.0911, 1.1508, 1.1941, 1.2175, 1.2192, 1.1992, 1.1589, 1.1013, 1.0322,
0.9600, 0.8942, 0.8432, 0.8124, 0.8039, 0.8176, 0.8532, 0.9083
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
1.1052, 1.0884, 1.0627, 1.0294, 0.9910, 0.9514, 0.9161, 0.8912, 0.8817, 0.8897,
0.9133, 0.9479, 0.9873, 1.0260, 1.0600, 1.0864, 1.1040, 1.1122, 1.1108, 1.0998,
1.0795, 1.0507, 1.0150, 0.9755, 0.9369, 0.9050, 0.8855, 0.8827, 0.8972, 0.9257,
0.9629, 1.0027, 1.0399, 1.0712, 1.0943, 1.1083, 1.1128, 1.1077, 1.0930, 1.0693,
1.0375, 0.9999, 0.9602, 0.9234, 0.8957, 0.8824, 0.8864, 0.9068, 0.9394, 0.9782,
1.0176, 1.0529, 1.0812, 1.1008, 1.1112, 1.1119, 1.1031, 1.0849, 1.0578, 1.0235,
0.9845, 0.9453, 0.9113, 0.8886, 0.8818, 0.8925, 0.9183, 0.9541
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
0.9977, 1.0038, 1.0105, 1.0148, 1.0143, 1.0082, 0.9986, 0.9895, 0.9856, 0.9889,
0.9976, 1.0074, 1.0139, 1.0150, 1.0111, 1.0045, 0.9982, 0.9947, 0.9954, 0.9999,
1.0065, 1.0126, 1.0153, 1.0125, 1.0047, 0.9947, 0.9872, 0.9860, 0.9918, 1.0016,
1.0105, 1.0150, 1.0140, 1.0087, 1.0018, 0.9964, 0.9945, 0.9967, 1.0023, 1.0091,
1.0142, 1.0149, 1.0100, 1.0009, 0.9913, 0.9859, 0.9876, 0.9954, 1.0054, 1.0129,
1.0153, 1.0123, 1.0060, 0.9994, 0.9952, 0.9948, 0.9986, 1.0049, 1.0115, 1.0151,
1.0137, 1.0068, 0.9969, 0.9884, 0.9857, 0.9900, 0.9993, 1.0088
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
1.1762, 1.1454, 1.0996, 1.0424, 0.9792, 0.9163, 0.8617, 0.8238, 0.8094, 0.8214,
0.8574, 0.9108, 0.9732, 1.0368, 1.0947, 1.1417, 1.1741, 1.1895, 1.1868, 1.1662,
1.1292, 1.0786, 1.0184, 0.9543, 0.8937, 0.8446, 0.8152, 0.8110, 0.8328, 0.8764,
0.9343, 0.9982, 1.0602, 1.1144, 1.1561, 1.1822, 1.1906, 1.1809, 1.1537, 1.1110,
1.0561, 0.9937, 0.9300, 0.8728, 0.8305, 0.8104, 0.8164, 0.8475, 0.8976, 0.9587,
1.0227, 1.0825, 1.1323, 1.1682, 1.1876, 1.1890, 1.1724, 1.1389, 1.0910, 1.0325,
0.9688, 0.9067, 0.8542, 0.8197, 0.8096, 0.8257, 0.8650, 0.9205
}, 
{
1.2100, 1.1743, 1.1210, 1.0541, 0.9793, 0.9041, 0.8379, 0.7912, 0.7734, 0.7883,
0.8326, 0.8975, 0.9723, 1.0475, 1.1154, 1.1701, 1.2075, 1.2253, 1.2222, 1.1984,
1.1555, 1.0965, 1.0258, 0.9497, 0.8768, 0.8170, 0.7806, 0.7753, 0.8024, 0.8558,
0.9258, 1.0019, 1.0750, 1.1383, 1.1868, 1.2169, 1.2266, 1.2154, 1.1840, 1.1343,
1.0702, 0.9966, 0.9206, 0.8514, 0.7995, 0.7746, 0.7822, 0.8205, 0.8816, 0.9550,
1.0309, 1.1011, 1.1591, 1.2007, 1.2231, 1.2247, 1.2055, 1.1668, 1.1110, 1.0424,
0.9670, 0.8926, 0.8287, 0.7862, 0.7736, 0.7936, 0.8419, 0.9092
}, 
{
1.1550, 1.1324, 1.0972, 1.0504, 0.9949, 0.9359, 0.8815, 0.8421, 0.8268, 0.8396,
0.8771, 0.9305, 0.9895, 1.0456, 1.0934, 1.1297, 1.1534, 1.1643, 1.1624, 1.1477,
1.1203, 1.0804, 1.0298, 0.9720, 0.9137, 0.8640, 0.8329, 0.8284, 0.8516, 0.8964,
0.9532, 1.0120, 1.0653, 1.1089, 1.1404, 1.1592, 1.1651, 1.1583, 1.1386, 1.1062,
1.0619, 1.0080, 0.9491, 0.8928, 0.8492, 0.8278, 0.8343, 0.8669, 0.9176, 0.9761,
1.0336, 1.0836, 1.1226, 1.1492, 1.1630, 1.1640, 1.1522, 1.1276, 1.0904, 1.0419,
0.9854, 0.9265, 0.8739, 0.8378, 0.8269, 0.8441, 0.8849, 0.9399
}, 
{
0.9458, 0.9774, 1.0136, 1.0397, 1.0464, 1.0329, 1.0077, 0.9848, 0.9779, 0.9913,
1.0172, 1.0411, 1.0495, 1.0367, 1.0060, 0.9689, 0.9408, 0.9341, 0.9515, 0.9841,
1.0171, 1.0372, 1.0375, 1.0202, 0.9955, 0.9782, 0.9794, 0.9999, 1.0288, 1.0510,
1.0545, 1.0359, 1.0013, 0.9639, 0.9395, 0.9383, 0.9594, 0.9915, 1.0198, 1.0330,
1.0270, 1.0066, 0.9836, 0.9725, 0.9818, 1.0084, 1.0392, 1.0588, 1.0572, 1.0336,
0.9964, 0.9606, 0.9411, 0.9454, 0.9691, 0.9992, 1.0217, 1.0274, 1.0153, 0.9925,
0.9723, 0.9681, 0.9851, 1.0166, 1.0478, 1.0641, 1.0575, 1.0297
}, 
{
0.9803, 0.9844, 0.9904, 0.9974, 1.0046, 1.0114, 1.0168, 1.0204, 1.0217, 1.0206,
1.0172, 1.0119, 1.0053, 0.9980, 0.9910, 0.9849, 0.9806, 0.9785, 0.9788, 0.9816,
0.9865, 0.9930, 1.0002, 1.0074, 1.0137, 1.0184, 1.0212, 1.0216, 1.0196, 1.0154,
1.0095, 1.0025, 0.9952, 0.9885, 0.9830, 0.9795, 0.9783, 0.9796, 0.9833, 0.9889,
0.9957, 1.0030, 1.0099, 1.0157, 1.0198, 1.0216, 1.0211, 1.0182, 1.0133, 1.0069,
0.9997, 0.9925, 0.9862, 0.9814, 0.9787, 0.9785, 0.9808, 0.9853, 0.9914, 0.9985,
1.0058, 1.0124, 1.0175, 1.0208, 1.0217, 1.0202, 1.0165, 1.0109
}, 
{
1.4281, 1.3523, 1.2424, 1.1102, 0.9702, 0.8381, 0.7293, 0.6571, 0.6305, 0.6526,
0.7209, 0.8269, 0.9574, 1.0974, 1.2310, 1.3435, 1.4228, 1.4611, 1.4544, 1.4033,
1.3132, 1.1933, 1.0561, 0.9171, 0.7923, 0.6964, 0.6411, 0.6333, 0.6740, 0.7580,
0.8752, 1.0115, 1.1508, 1.2777, 1.3786, 1.4428, 1.4639, 1.4397, 1.3727, 1.2696,
1.1414, 1.0018, 0.8663, 0.7509, 0.6697, 0.6323, 0.6435, 0.7019, 0.8002, 0.9264,
1.0659, 1.2023, 1.3205, 1.4082, 1.4563, 1.4598, 1.4186, 1.3366, 1.2223, 1.0877,
0.9479, 0.8186, 0.7149, 0.6496, 0.6308, 0.6607, 0.7357, 0.8466
}, 
{
1.4270, 1.3446, 1.2399, 1.1172, 0.9763, 0.8337, 0.7230, 0.6612, 0.6362, 0.6475,
0.7149, 0.8319, 0.9649, 1.0955, 1.2236, 1.3426, 1.4298, 1.4655, 1.4494, 1.3959,
1.3142, 1.2015, 1.0594, 0.9108, 0.7884, 0.7027, 0.6452, 0.6263, 0.6697, 0.7648,
0.8805, 1.0067, 1.1449, 1.2807, 1.3863, 1.4437, 1.4564, 1.4344, 1.3771, 1.2772,
1.1410, 0.9947, 0.8654, 0.7587, 0.6717, 0.6242, 0.6414, 0.7095, 0.8026, 0.9198,
1.0627, 1.2086, 1.3271, 1.4054, 1.4482, 1.4580, 1.4253, 1.3419, 1.2183, 1.0811,
0.9503, 0.8268, 0.7145, 0.6414, 0.6310, 0.6681, 0.7350, 0.8394
}, 
{
1.7125, 1.5723, 1.3776, 1.1566, 0.9389, 0.7495, 0.6055, 0.5163, 0.4848, 0.5110,
0.5950, 0.7342, 0.9200, 1.1360, 1.3579, 1.5563, 1.7025, 1.7748, 1.7621, 1.6661,
1.5019, 1.2937, 1.0705, 0.8609, 0.6876, 0.5643, 0.4973, 0.4881, 0.5367, 0.6425,
0.8012, 1.0014, 1.2229, 1.4389, 1.6203, 1.7402, 1.7802, 1.7343, 1.6095, 1.4247,
1.2074, 0.9866, 0.7887, 0.6334, 0.5315, 0.4868, 0.5000, 0.5711, 0.6981, 0.8745,
1.0859, 1.3090, 1.5150, 1.6752, 1.7657, 1.7725, 1.6945, 1.5439, 1.3430, 1.1205,
0.9059, 0.7229, 0.5873, 0.5073, 0.4851, 0.5207, 0.6138, 0.7613
}, 
{
1.7385, 1.6305, 1.3609, 1.1127, 0.9651, 0.8062, 0.6116, 0.4655, 0.4452, 0.5319,
0.6505, 0.7564, 0.8744, 1.1073, 1.4133, 1.6055, 1.6569, 1.7247, 1.8002, 1.7067,
1.4643, 1.2643, 1.1222, 0.9127, 0.6614, 0.4999, 0.4861, 0.5417, 0.5915, 0.6335,
0.7393, 0.9910, 1.2910, 1.4758, 1.5675, 1.7096, 1.8276, 1.7538, 1.5556, 1.4122,
1.2747, 1.0252, 0.7406, 0.5784, 0.5501, 0.5542, 0.5385, 0.5328, 0.6351, 0.8849,
1.1566, 1.3273, 1.4611, 1.6684, 1.8191, 1.7697, 1.6310, 1.5479, 1.4153, 1.1400,
0.8498, 0.6941, 0.6288, 0.5659, 0.4932, 0.4649, 0.5696, 0.7928
}, 
{
0.8433, 0.8738, 0.9195, 0.9765, 1.0395, 1.1015, 1.1544, 1.1905, 1.2040, 1.1927,
1.1586, 1.1069, 1.0454, 0.9822, 0.9243, 0.8774, 0.8454, 0.8302, 0.8329, 0.8532,
0.8899, 0.9404, 1.0005, 1.0641, 1.1235, 1.1707, 1.1986, 1.2025, 1.1820, 1.1403,
1.0838, 1.0206, 0.9587, 0.9047, 0.8632, 0.8374, 0.8291, 0.8387, 0.8656, 0.9080,
0.9628, 1.0251, 1.0880, 1.1437, 1.1841, 1.2031, 1.1974, 1.1680, 1.1197, 1.0598,
0.9962, 0.9365, 0.8869, 0.8512, 0.8321, 0.8307, 0.8471, 0.8802, 0.9280, 0.9864,
1.0498, 1.1109, 1.1616, 1.1943, 1.2038, 1.1887, 1.1512, 1.0974
}, 
{
0.8150, 0.8506, 0.9041, 0.9719, 1.0476, 1.1230, 1.1881, 1.2327, 1.2495, 1.2355,
1.1932, 1.1296, 1.0547, 0.9786, 0.9099, 0.8548, 0.8175, 0.7999, 0.8030, 0.8265,
0.8694, 0.9289, 1.0006, 1.0774, 1.1500, 1.2082, 1.2428, 1.2477, 1.2222, 1.1706,
1.1014, 1.0248, 0.9507, 0.8867, 0.8381, 0.8083, 0.7986, 0.8097, 0.8409, 0.8907,
0.9556, 1.0301, 1.1065, 1.1749, 1.2249, 1.2484, 1.2413, 1.2049, 1.1453, 1.0721,
0.9954, 0.9243, 0.8658, 0.8243, 0.8021, 0.8005, 0.8194, 0.8581, 0.9142, 0.9837,
1.0601, 1.1345, 1.1969, 1.2375, 1.2493, 1.2305, 1.1841, 1.1180
}, 
{
1.2456, 1.1985, 1.1304, 1.0488, 0.9640, 0.8867, 0.8260, 0.7880, 0.7744, 0.7857,
0.8215, 0.8803, 0.9564, 1.0410, 1.1233, 1.1930, 1.2423, 1.2660, 1.2619, 1.2302,
1.1743, 1.0999, 1.0158, 0.9325, 0.8608, 0.8085, 0.7798, 0.7759, 0.7967, 0.8417,
0.9081, 0.9888, 1.0737, 1.1522, 1.2149, 1.2547, 1.2678, 1.2528, 1.2112, 1.1472,
1.0679, 0.9829, 0.9029, 0.8378, 0.7944, 0.7753, 0.7810, 0.8114, 0.8652, 0.9380,
1.0217, 1.1055, 1.1788, 1.2332, 1.2631, 1.2653, 1.2397, 1.1888, 1.1179, 1.0351,
0.9507, 0.8755, 0.8183, 0.7841, 0.7746, 0.7898, 0.8295, 0.8916
}, 
{
1.2456, 1.1985, 1.1304, 1.0488, 0.9640, 0.8867, 0.8260, 0.7880, 0.7744, 0.7857,
0.8215, 0.8803, 0.9564, 1.0410, 1.1233, 1.1930, 1.2423, 1.2660, 1.2619, 1.2302,
1.1743, 1.0999, 1.0158, 0.9325, 0.8608, 0.8085, 0.7798, 0.7759, 0.7967, 0.8417,
0.9081, 0.9888, 1.0737, 1.1522, 1.2149, 1.2547, 1.2678, 1.2528, 1.2112, 1.1472,
1.0679, 0.9829, 0.9029, 0.8378, 0.7944, 0.7753, 0.7810, 0.8114, 0.8652, 0.9380,
1.0217, 1.1055, 1.1788, 1.2332, 1.2631, 1.2653, 1.2397, 1.1888, 1.1179, 1.0351,
0.9507, 0.8755, 0.8183, 0.7841, 0.7746, 0.7898, 0.8295, 0.8916
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.9661, 0.9734, 0.9837, 0.9958, 1.0083, 1.0198, 1.0290, 1.0351, 1.0373, 1.0355,
1.0297, 1.0207, 1.0094, 0.9969, 0.9847, 0.9742, 0.9667, 0.9630, 0.9636, 0.9685,
0.9771, 0.9882, 1.0006, 1.0129, 1.0237, 1.0318, 1.0364, 1.0371, 1.0337, 1.0266,
1.0165, 1.0046, 0.9921, 0.9804, 0.9709, 0.9647, 0.9627, 0.9650, 0.9714, 0.9811,
0.9929, 1.0055, 1.0173, 1.0272, 1.0340, 1.0371, 1.0362, 1.0313, 1.0230, 1.0121,
0.9998, 0.9874, 0.9764, 0.9681, 0.9634, 0.9631, 0.9671, 0.9749, 0.9855, 0.9978,
1.0102, 1.0214, 1.0302, 1.0357, 1.0373, 1.0348, 1.0285, 1.0190
}, 
{
1.1310, 1.1124, 1.0826, 1.0420, 0.9925, 0.9387, 0.8880, 0.8508, 0.8362, 0.8484,
0.8839, 0.9337, 0.9877, 1.0378, 1.0793, 1.1101, 1.1297, 1.1386, 1.1371, 1.1251,
1.1022, 1.0682, 1.0238, 0.9718, 0.9181, 0.8715, 0.8421, 0.8378, 0.8598, 0.9020,
0.9546, 1.0079, 1.0551, 1.0925, 1.1190, 1.1344, 1.1393, 1.1337, 1.1175, 1.0903,
1.0521, 1.0044, 0.9508, 0.8986, 0.8575, 0.8372, 0.8433, 0.8743, 0.9217, 0.9755,
1.0271, 1.0709, 1.1041, 1.1262, 1.1375, 1.1383, 1.1287, 1.1083, 1.0768, 1.0346,
0.9840, 0.9300, 0.8808, 0.8467, 0.8363, 0.8527, 0.8912, 0.9424
}, 
{
1.1550, 1.1324, 1.0972, 1.0504, 0.9949, 0.9359, 0.8815, 0.8421, 0.8268, 0.8396,
0.8771, 0.9305, 0.9895, 1.0456, 1.0934, 1.1297, 1.1534, 1.1643, 1.1624, 1.1477,
1.1203, 1.0804, 1.0298, 0.9720, 0.9137, 0.8640, 0.8329, 0.8284, 0.8516, 0.8964,
0.9532, 1.0120, 1.0653, 1.1089, 1.1404, 1.1592, 1.1651, 1.1583, 1.1386, 1.1062,
1.0619, 1.0080, 0.9491, 0.8928, 0.8492, 0.8278, 0.8343, 0.8669, 0.9176, 0.9761,
1.0336, 1.0836, 1.1226, 1.1492, 1.1630, 1.1640, 1.1522, 1.1276, 1.0904, 1.0419,
0.9854, 0.9265, 0.8739, 0.8378, 0.8269, 0.8441, 0.8849, 0.9399
}, 
{
0.7807, 0.8791, 0.9258, 0.9581, 1.0577, 1.1800, 1.2209, 1.1908, 1.1958, 1.2459,
1.2354, 1.1349, 1.0410, 1.0119, 0.9673, 0.8527, 0.7366, 0.7160, 0.7768, 0.8342,
0.8556, 0.9033, 1.0288, 1.1488, 1.1781, 1.1642, 1.2055, 1.2665, 1.2443, 1.1497,
1.0895, 1.0781, 1.0166, 0.8817, 0.7691, 0.7525, 0.7812, 0.7907, 0.7911, 0.8572,
0.9969, 1.1047, 1.1260, 1.1374, 1.2115, 1.2740, 1.2412, 1.1623, 1.1380, 1.1361,
1.0573, 0.9153, 0.8199, 0.8034, 0.7918, 0.7535, 0.7399, 0.8215, 0.9605, 1.0491,
1.0682, 1.1111, 1.2109, 1.2676, 1.2283, 1.1747, 1.1834, 1.1824
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
1.2456, 1.1985, 1.1304, 1.0488, 0.9640, 0.8867, 0.8260, 0.7880, 0.7744, 0.7857,
0.8215, 0.8803, 0.9564, 1.0410, 1.1233, 1.1930, 1.2423, 1.2660, 1.2619, 1.2302,
1.1743, 1.0999, 1.0158, 0.9325, 0.8608, 0.8085, 0.7798, 0.7759, 0.7967, 0.8417,
0.9081, 0.9888, 1.0737, 1.1522, 1.2149, 1.2547, 1.2678, 1.2528, 1.2112, 1.1472,
1.0679, 0.9829, 0.9029, 0.8378, 0.7944, 0.7753, 0.7810, 0.8114, 0.8652, 0.9380,
1.0217, 1.1055, 1.1788, 1.2332, 1.2631, 1.2653, 1.2397, 1.1888, 1.1179, 1.0351,
0.9507, 0.8755, 0.8183, 0.7841, 0.7746, 0.7898, 0.8295, 0.8916
}, 
{
0.8826, 0.9063, 0.9405, 0.9817, 1.0254, 1.0665, 1.1005, 1.1229, 1.1312, 1.1243,
1.1031, 1.0700, 1.0293, 0.9857, 0.9441, 0.9090, 0.8843, 0.8724, 0.8744, 0.8904,
0.9184, 0.9558, 0.9986, 1.0419, 1.0808, 1.1107, 1.1279, 1.1304, 1.1177, 1.0915,
1.0550, 1.0125, 0.9691, 0.9295, 0.8981, 0.8780, 0.8715, 0.8790, 0.8999, 0.9320,
0.9720, 1.0155, 1.0577, 1.0937, 1.1190, 1.1307, 1.1272, 1.1090, 1.0783, 1.0390,
0.9955, 0.9530, 0.9162, 0.8888, 0.8738, 0.8727, 0.8856, 0.9111, 0.9468, 0.9887,
1.0323, 1.0726, 1.1049, 1.1253, 1.1312, 1.1218, 1.0984, 1.0639
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
1.1000, 0.7937, 1.2682, 1.3368, 0.9784, 0.7142, 0.8166, 0.9290, 0.9063, 0.7815,
0.6943, 0.8813, 1.1866, 1.2064, 0.8361, 0.9666, 1.5732, 1.5815, 0.9444, 0.9169,
1.4321, 1.3747, 0.9117, 0.7446, 0.9286, 0.9784, 0.8638, 0.7135, 0.7102, 0.9230,
1.1262, 1.0468, 0.7569, 1.0864, 1.5911, 1.4497, 0.8105, 1.0863, 1.5637, 1.3614,
0.8317, 0.8337, 1.0516, 1.0094, 0.8116, 0.6807, 0.7579, 0.9457, 1.0417, 0.8988,
0.7497, 1.1773, 1.5499, 1.2816, 0.7470, 1.2664, 1.6472, 1.2968, 0.7667, 0.9739,
1.1702, 1.0171, 0.7586, 0.6929, 0.8203, 0.9473, 0.9444, 0.7817
}, 
{
1.1310, 1.1124, 1.0826, 1.0420, 0.9925, 0.9387, 0.8880, 0.8508, 0.8362, 0.8484,
0.8839, 0.9337, 0.9877, 1.0378, 1.0793, 1.1101, 1.1297, 1.1386, 1.1371, 1.1251,
1.1022, 1.0682, 1.0238, 0.9718, 0.9181, 0.8715, 0.8421, 0.8378, 0.8598, 0.9020,
0.9546, 1.0079, 1.0551, 1.0925, 1.1190, 1.1344, 1.1393, 1.1337, 1.1175, 1.0903,
1.0521, 1.0044, 0.9508, 0.8986, 0.8575, 0.8372, 0.8433, 0.8743, 0.9217, 0.9755,
1.0271, 1.0709, 1.1041, 1.1262, 1.1375, 1.1383, 1.1287, 1.1083, 1.0768, 1.0346,
0.9840, 0.9300, 0.8808, 0.8467, 0.8363, 0.8527, 0.8912, 0.9424
}, 
{
1.1702, 1.1428, 1.1010, 1.0470, 0.9849, 0.9207, 0.8629, 0.8216, 0.8057, 0.8190,
0.8582, 0.9150, 0.9789, 1.0415, 1.0965, 1.1395, 1.1683, 1.1818, 1.1794, 1.1613,
1.1282, 1.0814, 1.0237, 0.9598, 0.8970, 0.8444, 0.8121, 0.8074, 0.8315, 0.8786,
0.9394, 1.0038, 1.0640, 1.1146, 1.1524, 1.1754, 1.1828, 1.1743, 1.1503, 1.1115,
1.0601, 0.9994, 0.9349, 0.8748, 0.8290, 0.8068, 0.8135, 0.8475, 0.9011, 0.9643,
1.0279, 1.0850, 1.1309, 1.1631, 1.1801, 1.1813, 1.1668, 1.1370, 1.0930, 1.0374,
0.9745, 0.9107, 0.8549, 0.8171, 0.8059, 0.8237, 0.8665, 0.9250
}, 
{
0.9650, 0.9725, 0.9831, 0.9956, 1.0086, 1.0205, 1.0300, 1.0363, 1.0386, 1.0367,
1.0308, 1.0215, 1.0097, 0.9968, 0.9842, 0.9733, 0.9655, 0.9617, 0.9624, 0.9674,
0.9763, 0.9878, 1.0007, 1.0134, 1.0245, 1.0329, 1.0377, 1.0384, 1.0348, 1.0275,
1.0171, 1.0048, 0.9918, 0.9797, 0.9699, 0.9635, 0.9614, 0.9638, 0.9705, 0.9805,
0.9927, 1.0057, 1.0179, 1.0281, 1.0352, 1.0384, 1.0375, 1.0324, 1.0238, 1.0125,
0.9998, 0.9869, 0.9756, 0.9670, 0.9622, 0.9618, 0.9659, 0.9740, 0.9850, 0.9977,
1.0106, 1.0222, 1.0313, 1.0370, 1.0386, 1.0360, 1.0295, 1.0197
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.2888, 1.2313, 1.1495, 1.0538, 0.9566, 0.8697, 0.8026, 0.7610, 0.7462, 0.7585,
0.7977, 0.8626, 0.9480, 1.0447, 1.1411, 1.2247, 1.2847, 1.3140, 1.3089, 1.2699,
1.2020, 1.1135, 1.0157, 0.9210, 0.8409, 0.7834, 0.7521, 0.7478, 0.7705, 0.8199,
0.8936, 0.9848, 1.0828, 1.1755, 1.2511, 1.3000, 1.3162, 1.2977, 1.2467, 1.1695,
1.0761, 0.9781, 0.8878, 0.8156, 0.7680, 0.7472, 0.7534, 0.7865, 0.8458, 0.9272,
1.0225, 1.1201, 1.2075, 1.2736, 1.3103, 1.3131, 1.2815, 1.2195, 1.1347, 1.0379,
0.9415, 0.8573, 0.7941, 0.7567, 0.7464, 0.7630, 0.8065, 0.8751
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.1052, 1.0884, 1.0627, 1.0294, 0.9910, 0.9514, 0.9161, 0.8912, 0.8817, 0.8897,
0.9133, 0.9479, 0.9873, 1.0260, 1.0600, 1.0864, 1.1040, 1.1122, 1.1108, 1.0998,
1.0795, 1.0507, 1.0150, 0.9755, 0.9369, 0.9050, 0.8855, 0.8827, 0.8972, 0.9257,
0.9629, 1.0027, 1.0399, 1.0712, 1.0943, 1.1083, 1.1128, 1.1077, 1.0930, 1.0693,
1.0375, 0.9999, 0.9602, 0.9234, 0.8957, 0.8824, 0.8864, 0.9068, 0.9394, 0.9782,
1.0176, 1.0529, 1.0812, 1.1008, 1.1112, 1.1119, 1.1031, 1.0849, 1.0578, 1.0235,
0.9845, 0.9453, 0.9113, 0.8886, 0.8818, 0.8925, 0.9183, 0.9541
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000
}, 
{
1.1702, 1.1428, 1.1010, 1.0470, 0.9849, 0.9207, 0.8629, 0.8216, 0.8057, 0.8190,
0.8582, 0.9150, 0.9789, 1.0415, 1.0965, 1.1395, 1.1683, 1.1818, 1.1794, 1.1613,
1.1282, 1.0814, 1.0237, 0.9598, 0.8970, 0.8444, 0.8121, 0.8074, 0.8315, 0.8786,
0.9394, 1.0038, 1.0640, 1.1146, 1.1524, 1.1754, 1.1828, 1.1743, 1.1503, 1.1115,
1.0601, 0.9994, 0.9349, 0.8748, 0.8290, 0.8068, 0.8135, 0.8475, 0.9011, 0.9643,
1.0279, 1.0850, 1.1309, 1.1631, 1.1801, 1.1813, 1.1668, 1.1370, 1.0930, 1.0374,
0.9745, 0.9107, 0.8549, 0.8171, 0.8059, 0.8237, 0.8665, 0.9250
}, 
{
1.1052, 1.0884, 1.0627, 1.0294, 0.9910, 0.9514, 0.9161, 0.8912, 0.8817, 0.8897,
0.9133, 0.9479, 0.9873, 1.0260, 1.0600, 1.0864, 1.1040, 1.1122, 1.1108, 1.0998,
1.0795, 1.0507, 1.0150, 0.9755, 0.9369, 0.9050, 0.8855, 0.8827, 0.8972, 0.9257,
0.9629, 1.0027, 1.0399, 1.0712, 1.0943, 1.1083, 1.1128, 1.1077, 1.0930, 1.0693,
1.0375, 0.9999, 0.9602, 0.9234, 0.8957, 0.8824, 0.8864, 0.9068, 0.9394, 0.9782,
1.0176, 1.0529, 1.0812, 1.1008, 1.1112, 1.1119, 1.1031, 1.0849, 1.0578, 1.0235,
0.9845, 0.9453, 0.9113, 0.8886, 0.8818, 0.8925, 0.9183, 0.9541
}, 
{
1.2888, 1.2313, 1.1495, 1.0538, 0.9566, 0.8697, 0.8026, 0.7610, 0.7462, 0.7585,
0.7977, 0.8626, 0.9480, 1.0447, 1.1411, 1.2247, 1.2847, 1.3140, 1.3089, 1.2699,
1.2020, 1.1135, 1.0157, 0.9210, 0.8409, 0.7834, 0.7521, 0.7478, 0.7705, 0.8199,
0.8936, 0.9848, 1.0828, 1.1755, 1.2511, 1.3000, 1.3162, 1.2977, 1.2467, 1.1695,
1.0761, 0.9781, 0.8878, 0.8156, 0.7680, 0.7472, 0.7534, 0.7865, 0.8458, 0.9272,
1.0225, 1.1201, 1.2075, 1.2736, 1.3103, 1.3131, 1.2815, 1.2195, 1.1347, 1.0379,
0.9415, 0.8573, 0.7941, 0.7567, 0.7464, 0.7630, 0.8065, 0.8751
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
1.2456, 1.1985, 1.1304, 1.0488, 0.9640, 0.8867, 0.8260, 0.7880, 0.7744, 0.7857,
0.8215, 0.8803, 0.9564, 1.0410, 1.1233, 1.1930, 1.2423, 1.2660, 1.2619, 1.2302,
1.1743, 1.0999, 1.0158, 0.9325, 0.8608, 0.8085, 0.7798, 0.7759, 0.7967, 0.8417,
0.9081, 0.9888, 1.0737, 1.1522, 1.2149, 1.2547, 1.2678, 1.2528, 1.2112, 1.1472,
1.0679, 0.9829, 0.9029, 0.8378, 0.7944, 0.7753, 0.7810, 0.8114, 0.8652, 0.9380,
1.0217, 1.1055, 1.1788, 1.2332, 1.2631, 1.2653, 1.2397, 1.1888, 1.1179, 1.0351,
0.9507, 0.8755, 0.8183, 0.7841, 0.7746, 0.7898, 0.8295, 0.8916
}, 
{
1.1550, 1.1324, 1.0972, 1.0504, 0.9949, 0.9359, 0.8815, 0.8421, 0.8268, 0.8396,
0.8771, 0.9305, 0.9895, 1.0456, 1.0934, 1.1297, 1.1534, 1.1643, 1.1624, 1.1477,
1.1203, 1.0804, 1.0298, 0.9720, 0.9137, 0.8640, 0.8329, 0.8284, 0.8516, 0.8964,
0.9532, 1.0120, 1.0653, 1.1089, 1.1404, 1.1592, 1.1651, 1.1583, 1.1386, 1.1062,
1.0619, 1.0080, 0.9491, 0.8928, 0.8492, 0.8278, 0.8343, 0.8669, 0.9176, 0.9761,
1.0336, 1.0836, 1.1226, 1.1492, 1.1630, 1.1640, 1.1522, 1.1276, 1.0904, 1.0419,
0.9854, 0.9265, 0.8739, 0.8378, 0.8269, 0.8441, 0.8849, 0.9399
}, 
{
1.1702, 1.1428, 1.1010, 1.0470, 0.9849, 0.9207, 0.8629, 0.8216, 0.8057, 0.8190,
0.8582, 0.9150, 0.9789, 1.0415, 1.0965, 1.1395, 1.1683, 1.1818, 1.1794, 1.1613,
1.1282, 1.0814, 1.0237, 0.9598, 0.8970, 0.8444, 0.8121, 0.8074, 0.8315, 0.8786,
0.9394, 1.0038, 1.0640, 1.1146, 1.1524, 1.1754, 1.1828, 1.1743, 1.1503, 1.1115,
1.0601, 0.9994, 0.9349, 0.8748, 0.8290, 0.8068, 0.8135, 0.8475, 0.9011, 0.9643,
1.0279, 1.0850, 1.1309, 1.1631, 1.1801, 1.1813, 1.1668, 1.1370, 1.0930, 1.0374,
0.9745, 0.9107, 0.8549, 0.8171, 0.8059, 0.8237, 0.8665, 0.9250
}, 
{
1.1550, 1.1324, 1.0972, 1.0504, 0.9949, 0.9359, 0.8815, 0.8421, 0.8268, 0.8396,
0.8771, 0.9305, 0.9895, 1.0456, 1.0934, 1.1297, 1.1534, 1.1643, 1.1624, 1.1477,
1.1203, 1.0804, 1.0298, 0.9720, 0.9137, 0.8640, 0.8329, 0.8284, 0.8516, 0.8964,
0.9532, 1.0120, 1.0653, 1.1089, 1.1404, 1.1592, 1.1651, 1.1583, 1.1386, 1.1062,
1.0619, 1.0080, 0.9491, 0.8928, 0.8492, 0.8278, 0.8343, 0.8669, 0.9176, 0.9761,
1.0336, 1.0836, 1.1226, 1.1492, 1.1630, 1.1640, 1.1522, 1.1276, 1.0904, 1.0419,
0.9854, 0.9265, 0.8739, 0.8378, 0.8269, 0.8441, 0.8849, 0.9399
}, 
{
1.1702, 1.1428, 1.1010, 1.0470, 0.9849, 0.9207, 0.8629, 0.8216, 0.8057, 0.8190,
0.8582, 0.9150, 0.9789, 1.0415, 1.0965, 1.1395, 1.1683, 1.1818, 1.1794, 1.1613,
1.1282, 1.0814, 1.0237, 0.9598, 0.8970, 0.8444, 0.8121, 0.8074, 0.8315, 0.8786,
0.9394, 1.0038, 1.0640, 1.1146, 1.1524, 1.1754, 1.1828, 1.1743, 1.1503, 1.1115,
1.0601, 0.9994, 0.9349, 0.8748, 0.8290, 0.8068, 0.8135, 0.8475, 0.9011, 0.9643,
1.0279, 1.0850, 1.1309, 1.1631, 1.1801, 1.1813, 1.1668, 1.1370, 1.0930, 1.0374,
0.9745, 0.9107, 0.8549, 0.8171, 0.8059, 0.8237, 0.8665, 0.9250
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.8249, 0.6275, 1.0849, 1.2625, 1.0308, 0.8372, 1.0471, 1.2642, 1.2605, 1.0673,
0.8964, 1.0427, 1.2629, 1.1506, 0.7212, 0.7689, 1.1841, 1.1596, 0.6956, 0.6995,
1.1640, 1.2194, 0.8976, 0.8186, 1.1303, 1.2890, 1.1909, 0.9900, 0.9532, 1.1557,
1.2808, 1.0673, 0.6931, 0.9058, 1.2348, 1.0763, 0.5931, 0.8082, 1.2186, 1.1419,
0.7670, 0.8566, 1.2047, 1.2712, 1.0930, 0.9454, 1.0429, 1.2403, 1.2597, 0.9807,
0.7326, 1.0374, 1.2531, 0.9744, 0.5495, 0.9293, 1.2434, 1.0366, 0.6657, 0.9358,
1.2550, 1.2115, 0.9844, 0.9488, 1.1405, 1.2852, 1.2045, 0.9100
}, 
{
0.8249, 0.6275, 1.0849, 1.2625, 1.0308, 0.8372, 1.0471, 1.2642, 1.2605, 1.0673,
0.8964, 1.0427, 1.2629, 1.1506, 0.7212, 0.7689, 1.1841, 1.1596, 0.6956, 0.6995,
1.1640, 1.2194, 0.8976, 0.8186, 1.1303, 1.2890, 1.1909, 0.9900, 0.9532, 1.1557,
1.2808, 1.0673, 0.6931, 0.9058, 1.2348, 1.0763, 0.5931, 0.8082, 1.2186, 1.1419,
0.7670, 0.8566, 1.2047, 1.2712, 1.0930, 0.9454, 1.0429, 1.2403, 1.2597, 0.9807,
0.7326, 1.0374, 1.2531, 0.9744, 0.5495, 0.9293, 1.2434, 1.0366, 0.6657, 0.9358,
1.2550, 1.2115, 0.9844, 0.9488, 1.1405, 1.2852, 1.2045, 0.9100
}, 
{
1.2456, 1.1985, 1.1304, 1.0488, 0.9640, 0.8867, 0.8260, 0.7880, 0.7744, 0.7857,
0.8215, 0.8803, 0.9564, 1.0410, 1.1233, 1.1930, 1.2423, 1.2660, 1.2619, 1.2302,
1.1743, 1.0999, 1.0158, 0.9325, 0.8608, 0.8085, 0.7798, 0.7759, 0.7967, 0.8417,
0.9081, 0.9888, 1.0737, 1.1522, 1.2149, 1.2547, 1.2678, 1.2528, 1.2112, 1.1472,
1.0679, 0.9829, 0.9029, 0.8378, 0.7944, 0.7753, 0.7810, 0.8114, 0.8652, 0.9380,
1.0217, 1.1055, 1.1788, 1.2332, 1.2631, 1.2653, 1.2397, 1.1888, 1.1179, 1.0351,
0.9507, 0.8755, 0.8183, 0.7841, 0.7746, 0.7898, 0.8295, 0.8916
}, 
{
1.5515, 1.4365, 1.2777, 1.1000, 0.9293, 0.7862, 0.6823, 0.6209, 0.5998, 0.6173,
0.6749, 0.7749, 0.9147, 1.0836, 1.2618, 1.4234, 1.5433, 1.6028, 1.5923, 1.5134,
1.3789, 1.2099, 1.0319, 0.8696, 0.7409, 0.6536, 0.6081, 0.6020, 0.6347, 0.7085,
0.8246, 0.9777, 1.1529, 1.3276, 1.4759, 1.5743, 1.6072, 1.5695, 1.4670, 1.3160,
1.1405, 0.9662, 0.8152, 0.7020, 0.6311, 0.6012, 0.6099, 0.6583, 0.7485, 0.8799,
1.0439, 1.2222, 1.3896, 1.5209, 1.5953, 1.6009, 1.5368, 1.4132, 1.2496, 1.0713,
0.9039, 0.7666, 0.6696, 0.6148, 0.6000, 0.6238, 0.6881, 0.7949
}, 
{
1.1000, 0.7937, 1.2682, 1.3368, 0.9784, 0.7142, 0.8166, 0.9290, 0.9063, 0.7815,
0.6943, 0.8813, 1.1866, 1.2064, 0.8361, 0.9666, 1.5732, 1.5815, 0.9444, 0.9169,
1.4321, 1.3747, 0.9117, 0.7446, 0.9286, 0.9784, 0.8638, 0.7135, 0.7102, 0.9230,
1.1262, 1.0468, 0.7569, 1.0864, 1.5911, 1.4497, 0.8105, 1.0863, 1.5637, 1.3614,
0.8317, 0.8337, 1.0516, 1.0094, 0.8116, 0.6807, 0.7579, 0.9457, 1.0417, 0.8988,
0.7497, 1.1773, 1.5499, 1.2816, 0.7470, 1.2664, 1.6472, 1.2968, 0.7667, 0.9739,
1.1702, 1.0171, 0.7586, 0.6929, 0.8203, 0.9473, 0.9444, 0.7817
}, 
{
1.6053, 1.4758, 1.2993, 1.1052, 0.9221, 0.7711, 0.6630, 0.5996, 0.5779, 0.5959,
0.6553, 0.7593, 0.9066, 1.0875, 1.2818, 1.4611, 1.5960, 1.6636, 1.6516, 1.5622,
1.4114, 1.2248, 1.0318, 0.8589, 0.7238, 0.6333, 0.5865, 0.5802, 0.6138, 0.6901,
0.8114, 0.9737, 1.1627, 1.3544, 1.5200, 1.6312, 1.6686, 1.6257, 1.5100, 1.3417,
1.1492, 0.9614, 0.8016, 0.6834, 0.6102, 0.5793, 0.5884, 0.6382, 0.7318, 0.8698,
1.0448, 1.2383, 1.4234, 1.5707, 1.6551, 1.6614, 1.5886, 1.4498, 1.2685, 1.0743,
0.8952, 0.7506, 0.6498, 0.5934, 0.5781, 0.6026, 0.6690, 0.7803
}, 
{
1.2039, 1.1666, 1.1115, 1.0438, 0.9715, 0.9040, 0.8501, 0.8159, 0.8037, 0.8139,
0.8461, 0.8983, 0.9649, 1.0372, 1.1057, 1.1623, 1.2013, 1.2198, 1.2166, 1.1918,
1.1472, 1.0865, 1.0159, 0.9442, 0.8810, 0.8344, 0.8086, 0.8050, 0.8238, 0.8641,
0.9228, 0.9929, 1.0647, 1.1293, 1.1796, 1.2110, 1.2211, 1.2095, 1.1767, 1.1253,
1.0599, 0.9878, 0.9183, 0.8606, 0.8218, 0.8045, 0.8096, 0.8370, 0.8850, 0.9490,
1.0210, 1.0911, 1.1508, 1.1941, 1.2175, 1.2192, 1.1992, 1.1589, 1.1013, 1.0322,
0.9600, 0.8942, 0.8432, 0.8124, 0.8039, 0.8176, 0.8532, 0.9083
}, 
{
1.5515, 1.4365, 1.2777, 1.1000, 0.9293, 0.7862, 0.6823, 0.6209, 0.5998, 0.6173,
0.6749, 0.7749, 0.9147, 1.0836, 1.2618, 1.4234, 1.5433, 1.6028, 1.5923, 1.5134,
1.3789, 1.2099, 1.0319, 0.8696, 0.7409, 0.6536, 0.6081, 0.6020, 0.6347, 0.7085,
0.8246, 0.9777, 1.1529, 1.3276, 1.4759, 1.5743, 1.6072, 1.5695, 1.4670, 1.3160,
1.1405, 0.9662, 0.8152, 0.7020, 0.6311, 0.6012, 0.6099, 0.6583, 0.7485, 0.8799,
1.0439, 1.2222, 1.3896, 1.5209, 1.5953, 1.6009, 1.5368, 1.4132, 1.2496, 1.0713,
0.9039, 0.7666, 0.6696, 0.6148, 0.6000, 0.6238, 0.6881, 0.7949
}, 
{
1.1310, 1.1124, 1.0826, 1.0420, 0.9925, 0.9387, 0.8880, 0.8508, 0.8362, 0.8484,
0.8839, 0.9337, 0.9877, 1.0378, 1.0793, 1.1101, 1.1297, 1.1386, 1.1371, 1.1251,
1.1022, 1.0682, 1.0238, 0.9718, 0.9181, 0.8715, 0.8421, 0.8378, 0.8598, 0.9020,
0.9546, 1.0079, 1.0551, 1.0925, 1.1190, 1.1344, 1.1393, 1.1337, 1.1175, 1.0903,
1.0521, 1.0044, 0.9508, 0.8986, 0.8575, 0.8372, 0.8433, 0.8743, 0.9217, 0.9755,
1.0271, 1.0709, 1.1041, 1.1262, 1.1375, 1.1383, 1.1287, 1.1083, 1.0768, 1.0346,
0.9840, 0.9300, 0.8808, 0.8467, 0.8363, 0.8527, 0.8912, 0.9424
}, 
{
0.8249, 0.6275, 1.0849, 1.2625, 1.0308, 0.8372, 1.0471, 1.2642, 1.2605, 1.0673,
0.8964, 1.0427, 1.2629, 1.1506, 0.7212, 0.7689, 1.1841, 1.1596, 0.6956, 0.6995,
1.1640, 1.2194, 0.8976, 0.8186, 1.1303, 1.2890, 1.1909, 0.9900, 0.9532, 1.1557,
1.2808, 1.0673, 0.6931, 0.9058, 1.2348, 1.0763, 0.5931, 0.8082, 1.2186, 1.1419,
0.7670, 0.8566, 1.2047, 1.2712, 1.0930, 0.9454, 1.0429, 1.2403, 1.2597, 0.9807,
0.7326, 1.0374, 1.2531, 0.9744, 0.5495, 0.9293, 1.2434, 1.0366, 0.6657, 0.9358,
1.2550, 1.2115, 0.9844, 0.9488, 1.1405, 1.2852, 1.2045, 0.9100
}, 
{
0.8535, 0.6446, 1.1033, 1.2685, 1.0229, 0.8212, 1.0174, 1.2208, 1.2146, 1.0303,
0.8704, 1.0217, 1.2518, 1.1547, 0.7327, 0.7893, 1.2245, 1.2036, 0.7215, 0.7220,
1.1915, 1.2345, 0.8976, 0.8085, 1.1043, 1.2490, 1.1485, 0.9542, 0.9218, 1.1257,
1.2603, 1.0630, 0.6990, 0.9242, 1.2717, 1.1151, 0.6158, 0.8371, 1.2543, 1.1641,
0.7729, 0.8524, 1.1846, 1.2375, 1.0567, 0.9111, 1.0060, 1.2024, 1.2315, 0.9694,
0.7332, 1.0511, 1.2836, 1.0063, 0.5701, 0.9645, 1.2854, 1.0634, 0.6757, 0.9383,
1.2429, 1.1863, 0.9553, 0.9157, 1.0990, 1.2416, 1.1710, 0.8932
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.8831, 0.6623, 1.1220, 1.2746, 1.0150, 0.8055, 0.9886, 1.1790, 1.1703, 0.9946,
0.8452, 1.0012, 1.2407, 1.1589, 0.7443, 0.8102, 1.2664, 1.2492, 0.7484, 0.7453,
1.2196, 1.2498, 0.8975, 0.7985, 1.0789, 1.2102, 1.1077, 0.9196, 0.8915, 1.0966,
1.2402, 1.0587, 0.7049, 0.9429, 1.3097, 1.1554, 0.6393, 0.8671, 1.2911, 1.1868,
0.7787, 0.8482, 1.1647, 1.2047, 1.0215, 0.8780, 0.9704, 1.1656, 1.2040, 0.9582,
0.7337, 1.0650, 1.3148, 1.0392, 0.5914, 1.0009, 1.3288, 1.0909, 0.6859, 0.9409,
1.2309, 1.1616, 0.9271, 0.8837, 1.0590, 1.1994, 1.1385, 0.8768
}, 
{
1.0931, 1.0828, 1.0646, 1.0371, 1.0003, 0.9570, 0.9139, 0.8810, 0.8678, 0.8788,
0.9103, 0.9529, 0.9965, 1.0341, 1.0625, 1.0814, 1.0924, 1.0970, 1.0962, 1.0899,
1.0767, 1.0551, 1.0239, 0.9840, 0.9398, 0.8994, 0.8731, 0.8692, 0.8890, 0.9260,
0.9701, 1.0120, 1.0462, 1.0709, 1.0865, 1.0949, 1.0973, 1.0945, 1.0857, 1.0694,
1.0442, 1.0093, 0.9670, 0.9231, 0.8870, 0.8687, 0.8743, 0.9019, 0.9428, 0.9869,
1.0263, 1.0569, 1.0779, 1.0905, 1.0965, 1.0969, 1.0919, 1.0804, 1.0608, 1.0317,
0.9936, 0.9498, 0.9076, 0.8773, 0.8680, 0.8827, 0.9167, 0.9601
}, 
{
1.0931, 1.0828, 1.0646, 1.0371, 1.0003, 0.9570, 0.9139, 0.8810, 0.8678, 0.8788,
0.9103, 0.9529, 0.9965, 1.0341, 1.0625, 1.0814, 1.0924, 1.0970, 1.0962, 1.0899,
1.0767, 1.0551, 1.0239, 0.9840, 0.9398, 0.8994, 0.8731, 0.8692, 0.8890, 0.9260,
0.9701, 1.0120, 1.0462, 1.0709, 1.0865, 1.0949, 1.0973, 1.0945, 1.0857, 1.0694,
1.0442, 1.0093, 0.9670, 0.9231, 0.8870, 0.8687, 0.8743, 0.9019, 0.9428, 0.9869,
1.0263, 1.0569, 1.0779, 1.0905, 1.0965, 1.0969, 1.0919, 1.0804, 1.0608, 1.0317,
0.9936, 0.9498, 0.9076, 0.8773, 0.8680, 0.8827, 0.9167, 0.9601
}, 
{
1.0681, 1.0595, 1.0450, 1.0245, 0.9987, 0.9700, 0.9428, 0.9229, 0.9151, 0.9216,
0.9406, 0.9673, 0.9961, 1.0223, 1.0434, 1.0584, 1.0676, 1.0716, 1.0709, 1.0654,
1.0546, 1.0378, 1.0151, 0.9877, 0.9590, 0.9339, 0.9182, 0.9159, 0.9277, 0.9503,
0.9785, 1.0068, 1.0312, 1.0499, 1.0626, 1.0697, 1.0719, 1.0694, 1.0619, 1.0488,
1.0297, 1.0049, 0.9765, 0.9485, 0.9265, 0.9156, 0.9189, 0.9354, 0.9609, 0.9897,
1.0168, 1.0392, 1.0555, 1.0660, 1.0711, 1.0715, 1.0671, 1.0575, 1.0421, 1.0207,
0.9941, 0.9654, 0.9390, 0.9207, 0.9152, 0.9239, 0.9445, 0.9720
}, 
{
1.3046, 1.2551, 1.1803, 1.0857, 0.9807, 0.8780, 0.7913, 0.7330, 0.7114, 0.7294,
0.7846, 0.8691, 0.9710, 1.0763, 1.1723, 1.2493, 1.3012, 1.3255, 1.3213, 1.2886,
1.2289, 1.1457, 1.0457, 0.9398, 0.8417, 0.7649, 0.7200, 0.7137, 0.7467, 0.8143,
0.9072, 1.0122, 1.1152, 1.2047, 1.2725, 1.3140, 1.3273, 1.3120, 1.2686, 1.1991,
1.1084, 1.0048, 0.9002, 0.8087, 0.7432, 0.7129, 0.7219, 0.7693, 0.8480, 0.9471,
1.0529, 1.1521, 1.2339, 1.2918, 1.3225, 1.3248, 1.2985, 1.2447, 1.1662, 1.0691,
0.9636, 0.8626, 0.7797, 0.7269, 0.7116, 0.7359, 0.7965, 0.8848
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
1.0323, 1.0313, 1.0276, 1.0197, 1.0065, 0.9889, 0.9703, 0.9556, 0.9497, 0.9546,
0.9687, 0.9872, 1.0050, 1.0187, 1.0271, 1.0311, 1.0323, 1.0324, 1.0324, 1.0321,
1.0303, 1.0252, 1.0152, 1.0000, 0.9816, 0.9639, 0.9521, 0.9503, 0.9592, 0.9756,
0.9944, 1.0109, 1.0226, 1.0291, 1.0318, 1.0324, 1.0324, 1.0324, 1.0317, 1.0288,
1.0219, 1.0099, 0.9931, 0.9743, 0.9583, 0.9501, 0.9526, 0.9650, 0.9829, 1.0012,
1.0160, 1.0256, 1.0305, 1.0322, 1.0324, 1.0324, 1.0323, 1.0309, 1.0267, 1.0179,
1.0039, 0.9859, 0.9675, 0.9540, 0.9498, 0.9564, 0.9715, 0.9902
}, 
{
0.7973, 0.6108, 1.0668, 1.2565, 1.0388, 0.8536, 1.0776, 1.3090, 1.3082, 1.1056,
0.9232, 1.0640, 1.2742, 1.1464, 0.7100, 0.7491, 1.1450, 1.1173, 0.6706, 0.6776,
1.1371, 1.2045, 0.8977, 0.8288, 1.1570, 1.3303, 1.2348, 1.0272, 0.9856, 1.1864,
1.3016, 1.0717, 0.6873, 0.8878, 1.1990, 1.0387, 0.5713, 0.7802, 1.1839, 1.1200,
0.7613, 0.8609, 1.2252, 1.3058, 1.1306, 0.9810, 1.0812, 1.2794, 1.2885, 0.9922,
0.7321, 1.0239, 1.2234, 0.9435, 0.5297, 0.8955, 1.2029, 1.0105, 0.6558, 0.9332,
1.2673, 1.2373, 1.0143, 0.9830, 1.1837, 1.3304, 1.2389, 0.9270
}, 
{
0.8535, 0.6446, 1.1033, 1.2685, 1.0229, 0.8212, 1.0174, 1.2208, 1.2146, 1.0303,
0.8704, 1.0217, 1.2518, 1.1547, 0.7327, 0.7893, 1.2245, 1.2036, 0.7215, 0.7220,
1.1915, 1.2345, 0.8976, 0.8085, 1.1043, 1.2490, 1.1485, 0.9542, 0.9218, 1.1257,
1.2603, 1.0630, 0.6990, 0.9242, 1.2717, 1.1151, 0.6158, 0.8371, 1.2543, 1.1641,
0.7729, 0.8524, 1.1846, 1.2375, 1.0567, 0.9111, 1.0060, 1.2024, 1.2315, 0.9694,
0.7332, 1.0511, 1.2836, 1.0063, 0.5701, 0.9645, 1.2854, 1.0634, 0.6757, 0.9383,
1.2429, 1.1863, 0.9553, 0.9157, 1.0990, 1.2416, 1.1710, 0.8932
}, 
{
0.8249, 0.6275, 1.0849, 1.2625, 1.0308, 0.8372, 1.0471, 1.2642, 1.2605, 1.0673,
0.8964, 1.0427, 1.2629, 1.1506, 0.7212, 0.7689, 1.1841, 1.1596, 0.6956, 0.6995,
1.1640, 1.2194, 0.8976, 0.8186, 1.1303, 1.2890, 1.1909, 0.9900, 0.9532, 1.1557,
1.2808, 1.0673, 0.6931, 0.9058, 1.2348, 1.0763, 0.5931, 0.8082, 1.2186, 1.1419,
0.7670, 0.8566, 1.2047, 1.2712, 1.0930, 0.9454, 1.0429, 1.2403, 1.2597, 0.9807,
0.7326, 1.0374, 1.2531, 0.9744, 0.5495, 0.9293, 1.2434, 1.0366, 0.6657, 0.9358,
1.2550, 1.2115, 0.9844, 0.9488, 1.1405, 1.2852, 1.2045, 0.9100
}, 
{
0.7973, 0.6108, 1.0668, 1.2565, 1.0388, 0.8536, 1.0776, 1.3090, 1.3082, 1.1056,
0.9232, 1.0640, 1.2742, 1.1464, 0.7100, 0.7491, 1.1450, 1.1173, 0.6706, 0.6776,
1.1371, 1.2045, 0.8977, 0.8288, 1.1570, 1.3303, 1.2348, 1.0272, 0.9856, 1.1864,
1.3016, 1.0717, 0.6873, 0.8878, 1.1990, 1.0387, 0.5713, 0.7802, 1.1839, 1.1200,
0.7613, 0.8609, 1.2252, 1.3058, 1.1306, 0.9810, 1.0812, 1.2794, 1.2885, 0.9922,
0.7321, 1.0239, 1.2234, 0.9435, 0.5297, 0.8955, 1.2029, 1.0105, 0.6558, 0.9332,
1.2673, 1.2373, 1.0143, 0.9830, 1.1837, 1.3304, 1.2389, 0.9270
}, 
{
0.7973, 0.6108, 1.0668, 1.2565, 1.0388, 0.8536, 1.0776, 1.3090, 1.3082, 1.1056,
0.9232, 1.0640, 1.2742, 1.1464, 0.7100, 0.7491, 1.1450, 1.1173, 0.6706, 0.6776,
1.1371, 1.2045, 0.8977, 0.8288, 1.1570, 1.3303, 1.2348, 1.0272, 0.9856, 1.1864,
1.3016, 1.0717, 0.6873, 0.8878, 1.1990, 1.0387, 0.5713, 0.7802, 1.1839, 1.1200,
0.7613, 0.8609, 1.2252, 1.3058, 1.1306, 0.9810, 1.0812, 1.2794, 1.2885, 0.9922,
0.7321, 1.0239, 1.2234, 0.9435, 0.5297, 0.8955, 1.2029, 1.0105, 0.6558, 0.9332,
1.2673, 1.2373, 1.0143, 0.9830, 1.1837, 1.3304, 1.2389, 0.9270
}, 
{
1.0564, 1.0539, 1.0469, 1.0322, 1.0081, 0.9757, 0.9405, 0.9122, 0.9006, 0.9103,
0.9375, 0.9724, 1.0054, 1.0303, 1.0459, 1.0535, 1.0563, 1.0570, 1.0569, 1.0558,
1.0519, 1.0422, 1.0240, 0.9963, 0.9619, 0.9282, 0.9053, 0.9019, 0.9192, 0.9506,
0.9858, 1.0162, 1.0374, 1.0496, 1.0550, 1.0567, 1.0570, 1.0567, 1.0548, 1.0490,
1.0363, 1.0143, 0.9835, 0.9482, 0.9175, 0.9014, 0.9064, 0.9303, 0.9644, 0.9985,
1.0256, 1.0432, 1.0523, 1.0560, 1.0569, 1.0569, 1.0562, 1.0532, 1.0451, 1.0289,
1.0033, 0.9700, 0.9352, 0.9090, 0.9008, 0.9137, 0.9429, 0.9781
}, 
{
0.9977, 1.0038, 1.0105, 1.0148, 1.0143, 1.0082, 0.9986, 0.9895, 0.9856, 0.9889,
0.9976, 1.0074, 1.0139, 1.0150, 1.0111, 1.0045, 0.9982, 0.9947, 0.9954, 0.9999,
1.0065, 1.0126, 1.0153, 1.0125, 1.0047, 0.9947, 0.9872, 0.9860, 0.9918, 1.0016,
1.0105, 1.0150, 1.0140, 1.0087, 1.0018, 0.9964, 0.9945, 0.9967, 1.0023, 1.0091,
1.0142, 1.0149, 1.0100, 1.0009, 0.9913, 0.9859, 0.9876, 0.9954, 1.0054, 1.0129,
1.0153, 1.0123, 1.0060, 0.9994, 0.9952, 0.9948, 0.9986, 1.0049, 1.0115, 1.0151,
1.0137, 1.0068, 0.9969, 0.9884, 0.9857, 0.9900, 0.9993, 1.0088
}, 
{
1.0931, 1.0828, 1.0646, 1.0371, 1.0003, 0.9570, 0.9139, 0.8810, 0.8678, 0.8788,
0.9103, 0.9529, 0.9965, 1.0341, 1.0625, 1.0814, 1.0924, 1.0970, 1.0962, 1.0899,
1.0767, 1.0551, 1.0239, 0.9840, 0.9398, 0.8994, 0.8731, 0.8692, 0.8890, 0.9260,
0.9701, 1.0120, 1.0462, 1.0709, 1.0865, 1.0949, 1.0973, 1.0945, 1.0857, 1.0694,
1.0442, 1.0093, 0.9670, 0.9231, 0.8870, 0.8687, 0.8743, 0.9019, 0.9428, 0.9869,
1.0263, 1.0569, 1.0779, 1.0905, 1.0965, 1.0969, 1.0919, 1.0804, 1.0608, 1.0317,
0.9936, 0.9498, 0.9076, 0.8773, 0.8680, 0.8827, 0.9167, 0.9601
}, 
{
1.4576, 1.3697, 1.2445, 1.0981, 0.9494, 0.8163, 0.7128, 0.6474, 0.6240, 0.6435,
0.7051, 0.8054, 0.9363, 1.0842, 1.2316, 1.3595, 1.4514, 1.4961, 1.4883, 1.4287,
1.3248, 1.1895, 1.0398, 0.8950, 0.7721, 0.6827, 0.6333, 0.6265, 0.6624, 0.7395,
0.8530, 0.9926, 1.1425, 1.2843, 1.4000, 1.4748, 1.4994, 1.4712, 1.3932, 1.2751,
1.1321, 0.9824, 0.8441, 0.7330, 0.6586, 0.6255, 0.6353, 0.6877, 0.7796, 0.9045,
1.0503, 1.1995, 1.3332, 1.4344, 1.4906, 1.4947, 1.4464, 1.3516, 1.2218, 1.0738,
0.9265, 0.7973, 0.6995, 0.6407, 0.6242, 0.6506, 0.7188, 0.8247
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.8249, 0.6275, 1.0849, 1.2625, 1.0308, 0.8372, 1.0471, 1.2642, 1.2605, 1.0673,
0.8964, 1.0427, 1.2629, 1.1506, 0.7212, 0.7689, 1.1841, 1.1596, 0.6956, 0.6995,
1.1640, 1.2194, 0.8976, 0.8186, 1.1303, 1.2890, 1.1909, 0.9900, 0.9532, 1.1557,
1.2808, 1.0673, 0.6931, 0.9058, 1.2348, 1.0763, 0.5931, 0.8082, 1.2186, 1.1419,
0.7670, 0.8566, 1.2047, 1.2712, 1.0930, 0.9454, 1.0429, 1.2403, 1.2597, 0.9807,
0.7326, 1.0374, 1.2531, 0.9744, 0.5495, 0.9293, 1.2434, 1.0366, 0.6657, 0.9358,
1.2550, 1.2115, 0.9844, 0.9488, 1.1405, 1.2852, 1.2045, 0.9100
}, 
{
0.7705, 0.5945, 1.0491, 1.2506, 1.0469, 0.8702, 1.1090, 1.3555, 1.3577, 1.1453,
0.9508, 1.0859, 1.2855, 1.1423, 0.6989, 0.7297, 1.1072, 1.0765, 0.6465, 0.6564,
1.1109, 1.1898, 0.8978, 0.8392, 1.1842, 1.3729, 1.2804, 1.0658, 1.0191, 1.2180,
1.3227, 1.0761, 0.6816, 0.8702, 1.1642, 1.0025, 0.5503, 0.7533, 1.1502, 1.0986,
0.7555, 0.8652, 1.2461, 1.3414, 1.1694, 1.0179, 1.1209, 1.3198, 1.3180, 1.0038,
0.7315, 1.0105, 1.1944, 0.9136, 0.5106, 0.8629, 1.1636, 0.9851, 0.6461, 0.9307,
1.2797, 1.2636, 1.0451, 1.0186, 1.2284, 1.3772, 1.2743, 0.9444
}, 
{
0.7973, 0.6108, 1.0668, 1.2565, 1.0388, 0.8536, 1.0776, 1.3090, 1.3082, 1.1056,
0.9232, 1.0640, 1.2742, 1.1464, 0.7100, 0.7491, 1.1450, 1.1173, 0.6706, 0.6776,
1.1371, 1.2045, 0.8977, 0.8288, 1.1570, 1.3303, 1.2348, 1.0272, 0.9856, 1.1864,
1.3016, 1.0717, 0.6873, 0.8878, 1.1990, 1.0387, 0.5713, 0.7802, 1.1839, 1.1200,
0.7613, 0.8609, 1.2252, 1.3058, 1.1306, 0.9810, 1.0812, 1.2794, 1.2885, 0.9922,
0.7321, 1.0239, 1.2234, 0.9435, 0.5297, 0.8955, 1.2029, 1.0105, 0.6558, 0.9332,
1.2673, 1.2373, 1.0143, 0.9830, 1.1837, 1.3304, 1.2389, 0.9270
}, 
{
1.1635, 1.1356, 1.0930, 1.0389, 0.9791, 0.9216, 0.8749, 0.8449, 0.8341, 0.8431,
0.8713, 0.9167, 0.9735, 1.0335, 1.0885, 1.1323, 1.1616, 1.1752, 1.1729, 1.1545,
1.1207, 1.0732, 1.0160, 0.9560, 0.9018, 0.8611, 0.8384, 0.8353, 0.8518, 0.8871,
0.9378, 0.9969, 1.0558, 1.1069, 1.1454, 1.1688, 1.1762, 1.1677, 1.1432, 1.1038,
1.0519, 0.9927, 0.9339, 0.8841, 0.8500, 0.8349, 0.8393, 0.8634, 0.9052, 0.9601,
1.0202, 1.0769, 1.1235, 1.1563, 1.1735, 1.1748, 1.1601, 1.1297, 1.0850, 1.0294,
0.9694, 0.9132, 0.8688, 0.8418, 0.8343, 0.8463, 0.8776, 0.9253
}, 
{
1.2039, 1.1666, 1.1115, 1.0438, 0.9715, 0.9040, 0.8501, 0.8159, 0.8037, 0.8139,
0.8461, 0.8983, 0.9649, 1.0372, 1.1057, 1.1623, 1.2013, 1.2198, 1.2166, 1.1918,
1.1472, 1.0865, 1.0159, 0.9442, 0.8810, 0.8344, 0.8086, 0.8050, 0.8238, 0.8641,
0.9228, 0.9929, 1.0647, 1.1293, 1.1796, 1.2110, 1.2211, 1.2095, 1.1767, 1.1253,
1.0599, 0.9878, 0.9183, 0.8606, 0.8218, 0.8045, 0.8096, 0.8370, 0.8850, 0.9490,
1.0210, 1.0911, 1.1508, 1.1941, 1.2175, 1.2192, 1.1992, 1.1589, 1.1013, 1.0322,
0.9600, 0.8942, 0.8432, 0.8124, 0.8039, 0.8176, 0.8532, 0.9083
}, 
{
0.9643, 0.9771, 0.9937, 1.0100, 1.0222, 1.0279, 1.0277, 1.0246, 1.0229, 1.0244,
1.0274, 1.0281, 1.0230, 1.0114, 0.9953, 0.9785, 0.9652, 0.9584, 0.9596, 0.9686,
0.9833, 1.0003, 1.0154, 1.0252, 1.0284, 1.0266, 1.0236, 1.0231, 1.0256, 1.0282,
1.0269, 1.0192, 1.0055, 0.9887, 0.9728, 0.9617, 0.9579, 0.9622, 0.9738, 0.9898,
1.0066, 1.0199, 1.0272, 1.0281, 1.0253, 1.0230, 1.0238, 1.0268, 1.0284, 1.0247,
1.0145, 0.9991, 0.9822, 0.9678, 0.9593, 0.9586, 0.9660, 0.9796, 0.9964, 1.0123,
1.0236, 1.0282, 1.0272, 1.0242, 1.0229, 1.0248, 1.0278, 1.0277
}, 
{
0.9643, 0.9771, 0.9937, 1.0100, 1.0222, 1.0279, 1.0277, 1.0246, 1.0229, 1.0244,
1.0274, 1.0281, 1.0230, 1.0114, 0.9953, 0.9785, 0.9652, 0.9584, 0.9596, 0.9686,
0.9833, 1.0003, 1.0154, 1.0252, 1.0284, 1.0266, 1.0236, 1.0231, 1.0256, 1.0282,
1.0269, 1.0192, 1.0055, 0.9887, 0.9728, 0.9617, 0.9579, 0.9622, 0.9738, 0.9898,
1.0066, 1.0199, 1.0272, 1.0281, 1.0253, 1.0230, 1.0238, 1.0268, 1.0284, 1.0247,
1.0145, 0.9991, 0.9822, 0.9678, 0.9593, 0.9586, 0.9660, 0.9796, 0.9964, 1.0123,
1.0236, 1.0282, 1.0272, 1.0242, 1.0229, 1.0248, 1.0278, 1.0277
}, 
{
0.9643, 0.9771, 0.9937, 1.0100, 1.0222, 1.0279, 1.0277, 1.0246, 1.0229, 1.0244,
1.0274, 1.0281, 1.0230, 1.0114, 0.9953, 0.9785, 0.9652, 0.9584, 0.9596, 0.9686,
0.9833, 1.0003, 1.0154, 1.0252, 1.0284, 1.0266, 1.0236, 1.0231, 1.0256, 1.0282,
1.0269, 1.0192, 1.0055, 0.9887, 0.9728, 0.9617, 0.9579, 0.9622, 0.9738, 0.9898,
1.0066, 1.0199, 1.0272, 1.0281, 1.0253, 1.0230, 1.0238, 1.0268, 1.0284, 1.0247,
1.0145, 0.9991, 0.9822, 0.9678, 0.9593, 0.9586, 0.9660, 0.9796, 0.9964, 1.0123,
1.0236, 1.0282, 1.0272, 1.0242, 1.0229, 1.0248, 1.0278, 1.0277
}, 
{
0.9977, 1.0038, 1.0105, 1.0148, 1.0143, 1.0082, 0.9986, 0.9895, 0.9856, 0.9889,
0.9976, 1.0074, 1.0139, 1.0150, 1.0111, 1.0045, 0.9982, 0.9947, 0.9954, 0.9999,
1.0065, 1.0126, 1.0153, 1.0125, 1.0047, 0.9947, 0.9872, 0.9860, 0.9918, 1.0016,
1.0105, 1.0150, 1.0140, 1.0087, 1.0018, 0.9964, 0.9945, 0.9967, 1.0023, 1.0091,
1.0142, 1.0149, 1.0100, 1.0009, 0.9913, 0.9859, 0.9876, 0.9954, 1.0054, 1.0129,
1.0153, 1.0123, 1.0060, 0.9994, 0.9952, 0.9948, 0.9986, 1.0049, 1.0115, 1.0151,
1.0137, 1.0068, 0.9969, 0.9884, 0.9857, 0.9900, 0.9993, 1.0088
}, 
{
0.8433, 0.8738, 0.9195, 0.9765, 1.0395, 1.1015, 1.1544, 1.1905, 1.2040, 1.1927,
1.1586, 1.1069, 1.0454, 0.9822, 0.9243, 0.8774, 0.8454, 0.8302, 0.8329, 0.8532,
0.8899, 0.9404, 1.0005, 1.0641, 1.1235, 1.1707, 1.1986, 1.2025, 1.1820, 1.1403,
1.0838, 1.0206, 0.9587, 0.9047, 0.8632, 0.8374, 0.8291, 0.8387, 0.8656, 0.9080,
0.9628, 1.0251, 1.0880, 1.1437, 1.1841, 1.2031, 1.1974, 1.1680, 1.1197, 1.0598,
0.9962, 0.9365, 0.8869, 0.8512, 0.8321, 0.8307, 0.8471, 0.8802, 0.9280, 0.9864,
1.0498, 1.1109, 1.1616, 1.1943, 1.2038, 1.1887, 1.1512, 1.0974
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.7973, 0.6108, 1.0668, 1.2565, 1.0388, 0.8536, 1.0776, 1.3090, 1.3082, 1.1056,
0.9232, 1.0640, 1.2742, 1.1464, 0.7100, 0.7491, 1.1450, 1.1173, 0.6706, 0.6776,
1.1371, 1.2045, 0.8977, 0.8288, 1.1570, 1.3303, 1.2348, 1.0272, 0.9856, 1.1864,
1.3016, 1.0717, 0.6873, 0.8878, 1.1990, 1.0387, 0.5713, 0.7802, 1.1839, 1.1200,
0.7613, 0.8609, 1.2252, 1.3058, 1.1306, 0.9810, 1.0812, 1.2794, 1.2885, 0.9922,
0.7321, 1.0239, 1.2234, 0.9435, 0.5297, 0.8955, 1.2029, 1.0105, 0.6558, 0.9332,
1.2673, 1.2373, 1.0143, 0.9830, 1.1837, 1.3304, 1.2389, 0.9270
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
0.9643, 0.9771, 0.9937, 1.0100, 1.0222, 1.0279, 1.0277, 1.0246, 1.0229, 1.0244,
1.0274, 1.0281, 1.0230, 1.0114, 0.9953, 0.9785, 0.9652, 0.9584, 0.9596, 0.9686,
0.9833, 1.0003, 1.0154, 1.0252, 1.0284, 1.0266, 1.0236, 1.0231, 1.0256, 1.0282,
1.0269, 1.0192, 1.0055, 0.9887, 0.9728, 0.9617, 0.9579, 0.9622, 0.9738, 0.9898,
1.0066, 1.0199, 1.0272, 1.0281, 1.0253, 1.0230, 1.0238, 1.0268, 1.0284, 1.0247,
1.0145, 0.9991, 0.9822, 0.9678, 0.9593, 0.9586, 0.9660, 0.9796, 0.9964, 1.0123,
1.0236, 1.0282, 1.0272, 1.0242, 1.0229, 1.0248, 1.0278, 1.0277
}, 
{
0.8433, 0.8738, 0.9195, 0.9765, 1.0395, 1.1015, 1.1544, 1.1905, 1.2040, 1.1927,
1.1586, 1.1069, 1.0454, 0.9822, 0.9243, 0.8774, 0.8454, 0.8302, 0.8329, 0.8532,
0.8899, 0.9404, 1.0005, 1.0641, 1.1235, 1.1707, 1.1986, 1.2025, 1.1820, 1.1403,
1.0838, 1.0206, 0.9587, 0.9047, 0.8632, 0.8374, 0.8291, 0.8387, 0.8656, 0.9080,
0.9628, 1.0251, 1.0880, 1.1437, 1.1841, 1.2031, 1.1974, 1.1680, 1.1197, 1.0598,
0.9962, 0.9365, 0.8869, 0.8512, 0.8321, 0.8307, 0.8471, 0.8802, 0.9280, 0.9864,
1.0498, 1.1109, 1.1616, 1.1943, 1.2038, 1.1887, 1.1512, 1.0974
}, 
{
0.8433, 0.8738, 0.9195, 0.9765, 1.0395, 1.1015, 1.1544, 1.1905, 1.2040, 1.1927,
1.1586, 1.1069, 1.0454, 0.9822, 0.9243, 0.8774, 0.8454, 0.8302, 0.8329, 0.8532,
0.8899, 0.9404, 1.0005, 1.0641, 1.1235, 1.1707, 1.1986, 1.2025, 1.1820, 1.1403,
1.0838, 1.0206, 0.9587, 0.9047, 0.8632, 0.8374, 0.8291, 0.8387, 0.8656, 0.9080,
0.9628, 1.0251, 1.0880, 1.1437, 1.1841, 1.2031, 1.1974, 1.1680, 1.1197, 1.0598,
0.9962, 0.9365, 0.8869, 0.8512, 0.8321, 0.8307, 0.8471, 0.8802, 0.9280, 0.9864,
1.0498, 1.1109, 1.1616, 1.1943, 1.2038, 1.1887, 1.1512, 1.0974
}, 
{
0.7705, 0.5945, 1.0491, 1.2506, 1.0469, 0.8702, 1.1090, 1.3555, 1.3577, 1.1453,
0.9508, 1.0859, 1.2855, 1.1423, 0.6989, 0.7297, 1.1072, 1.0765, 0.6465, 0.6564,
1.1109, 1.1898, 0.8978, 0.8392, 1.1842, 1.3729, 1.2804, 1.0658, 1.0191, 1.2180,
1.3227, 1.0761, 0.6816, 0.8702, 1.1642, 1.0025, 0.5503, 0.7533, 1.1502, 1.0986,
0.7555, 0.8652, 1.2461, 1.3414, 1.1694, 1.0179, 1.1209, 1.3198, 1.3180, 1.0038,
0.7315, 1.0105, 1.1944, 0.9136, 0.5106, 0.8629, 1.1636, 0.9851, 0.6461, 0.9307,
1.2797, 1.2636, 1.0451, 1.0186, 1.2284, 1.3772, 1.2743, 0.9444
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.7349, 0.7821, 0.8514, 0.9361, 1.0274, 1.1150, 1.1883, 1.2373, 1.2555, 1.2404,
1.1939, 1.1225, 1.0358, 0.9444, 0.8587, 0.7877, 0.7382, 0.7146, 0.7187, 0.7503,
0.8067, 0.8827, 0.9712, 1.0625, 1.1457, 1.2105, 1.2483, 1.2536, 1.2258, 1.1688,
1.0903, 1.0003, 0.9100, 0.8291, 0.7657, 0.7258, 0.7129, 0.7278, 0.7694, 0.8342,
0.9160, 1.0067, 1.0962, 1.1736, 1.2288, 1.2543, 1.2467, 1.2068, 1.1404, 1.0563,
0.9648, 0.8769, 0.8020, 0.7473, 0.7175, 0.7153, 0.7409, 0.7919, 0.8642, 0.9507,
1.0421, 1.1281, 1.1980, 1.2425, 1.2553, 1.2349, 1.1839, 1.1093
}, 
{
1.1635, 1.1356, 1.0930, 1.0389, 0.9791, 0.9216, 0.8749, 0.8449, 0.8341, 0.8431,
0.8713, 0.9167, 0.9735, 1.0335, 1.0885, 1.1323, 1.1616, 1.1752, 1.1729, 1.1545,
1.1207, 1.0732, 1.0160, 0.9560, 0.9018, 0.8611, 0.8384, 0.8353, 0.8518, 0.8871,
0.9378, 0.9969, 1.0558, 1.1069, 1.1454, 1.1688, 1.1762, 1.1677, 1.1432, 1.1038,
1.0519, 0.9927, 0.9339, 0.8841, 0.8500, 0.8349, 0.8393, 0.8634, 0.9052, 0.9601,
1.0202, 1.0769, 1.1235, 1.1563, 1.1735, 1.1748, 1.1601, 1.1297, 1.0850, 1.0294,
0.9694, 0.9132, 0.8688, 0.8418, 0.8343, 0.8463, 0.8776, 0.9253
}, 
{
1.3694, 1.3059, 1.2121, 1.0962, 0.9700, 0.8477, 0.7446, 0.6750, 0.6492, 0.6707,
0.7366, 0.8372, 0.9583, 1.0848, 1.2022, 1.2985, 1.3650, 1.3966, 1.3911, 1.3487,
1.2728, 1.1694, 1.0479, 0.9212, 0.8046, 0.7131, 0.6595, 0.6519, 0.6914, 0.7720,
0.8824, 1.0076, 1.1321, 1.2424, 1.3280, 1.3816, 1.3989, 1.3790, 1.3231, 1.2355,
1.1238, 0.9988, 0.8741, 0.7653, 0.6872, 0.6509, 0.6618, 0.7183, 0.8120, 0.9298,
1.0566, 1.1773, 1.2790, 1.3528, 1.3927, 1.3956, 1.3614, 1.2927, 1.1946, 1.0762,
0.9496, 0.8293, 0.7308, 0.6677, 0.6494, 0.6785, 0.7508, 0.8557
}, 
{
1.2456, 1.1985, 1.1304, 1.0488, 0.9640, 0.8867, 0.8260, 0.7880, 0.7744, 0.7857,
0.8215, 0.8803, 0.9564, 1.0410, 1.1233, 1.1930, 1.2423, 1.2660, 1.2619, 1.2302,
1.1743, 1.0999, 1.0158, 0.9325, 0.8608, 0.8085, 0.7798, 0.7759, 0.7967, 0.8417,
0.9081, 0.9888, 1.0737, 1.1522, 1.2149, 1.2547, 1.2678, 1.2528, 1.2112, 1.1472,
1.0679, 0.9829, 0.9029, 0.8378, 0.7944, 0.7753, 0.7810, 0.8114, 0.8652, 0.9380,
1.0217, 1.1055, 1.1788, 1.2332, 1.2631, 1.2653, 1.2397, 1.1888, 1.1179, 1.0351,
0.9507, 0.8755, 0.8183, 0.7841, 0.7746, 0.7898, 0.8295, 0.8916
}, 
{
0.9665, 0.9734, 0.9833, 0.9953, 1.0078, 1.0195, 1.0291, 1.0355, 1.0378, 1.0359,
1.0299, 1.0205, 1.0089, 0.9964, 0.9844, 0.9742, 0.9670, 0.9635, 0.9641, 0.9687,
0.9769, 0.9878, 1.0001, 1.0125, 1.0236, 1.0320, 1.0369, 1.0376, 1.0340, 1.0266,
1.0162, 1.0041, 0.9916, 0.9802, 0.9710, 0.9651, 0.9632, 0.9654, 0.9715, 0.9809,
0.9925, 1.0050, 1.0170, 1.0272, 1.0344, 1.0377, 1.0367, 1.0315, 1.0229, 1.0117,
0.9992, 0.9870, 0.9763, 0.9683, 0.9639, 0.9636, 0.9674, 0.9748, 0.9852, 0.9973,
1.0098, 1.0212, 1.0304, 1.0361, 1.0378, 1.0352, 1.0286, 1.0188
}, 
{
0.9341, 0.9475, 0.9670, 0.9905, 1.0156, 1.0394, 1.0591, 1.0722, 1.0771, 1.0730,
1.0606, 1.0414, 1.0179, 0.9928, 0.9690, 0.9490, 0.9350, 0.9283, 0.9295, 0.9385,
0.9544, 0.9757, 1.0002, 1.0252, 1.0477, 1.0651, 1.0751, 1.0766, 1.0692, 1.0539,
1.0327, 1.0082, 0.9833, 0.9607, 0.9428, 0.9315, 0.9278, 0.9320, 0.9439, 0.9621,
0.9850, 1.0099, 1.0343, 1.0552, 1.0699, 1.0768, 1.0747, 1.0641, 1.0463, 1.0235,
0.9985, 0.9741, 0.9531, 0.9376, 0.9291, 0.9285, 0.9358, 0.9503, 0.9706, 0.9946,
1.0196, 1.0429, 1.0617, 1.0736, 1.0770, 1.0716, 1.0579, 1.0379
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
1.2039, 1.1666, 1.1115, 1.0438, 0.9715, 0.9040, 0.8501, 0.8159, 0.8037, 0.8139,
0.8461, 0.8983, 0.9649, 1.0372, 1.1057, 1.1623, 1.2013, 1.2198, 1.2166, 1.1918,
1.1472, 1.0865, 1.0159, 0.9442, 0.8810, 0.8344, 0.8086, 0.8050, 0.8238, 0.8641,
0.9228, 0.9929, 1.0647, 1.1293, 1.1796, 1.2110, 1.2211, 1.2095, 1.1767, 1.1253,
1.0599, 0.9878, 0.9183, 0.8606, 0.8218, 0.8045, 0.8096, 0.8370, 0.8850, 0.9490,
1.0210, 1.0911, 1.1508, 1.1941, 1.2175, 1.2192, 1.1992, 1.1589, 1.1013, 1.0322,
0.9600, 0.8942, 0.8432, 0.8124, 0.8039, 0.8176, 0.8532, 0.9083
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
0.9977, 1.0038, 1.0105, 1.0148, 1.0143, 1.0082, 0.9986, 0.9895, 0.9856, 0.9889,
0.9976, 1.0074, 1.0139, 1.0150, 1.0111, 1.0045, 0.9982, 0.9947, 0.9954, 0.9999,
1.0065, 1.0126, 1.0153, 1.0125, 1.0047, 0.9947, 0.9872, 0.9860, 0.9918, 1.0016,
1.0105, 1.0150, 1.0140, 1.0087, 1.0018, 0.9964, 0.9945, 0.9967, 1.0023, 1.0091,
1.0142, 1.0149, 1.0100, 1.0009, 0.9913, 0.9859, 0.9876, 0.9954, 1.0054, 1.0129,
1.0153, 1.0123, 1.0060, 0.9994, 0.9952, 0.9948, 0.9986, 1.0049, 1.0115, 1.0151,
1.0137, 1.0068, 0.9969, 0.9884, 0.9857, 0.9900, 0.9993, 1.0088
}, 
{
1.0564, 1.0539, 1.0469, 1.0322, 1.0081, 0.9757, 0.9405, 0.9122, 0.9006, 0.9103,
0.9375, 0.9724, 1.0054, 1.0303, 1.0459, 1.0535, 1.0563, 1.0570, 1.0569, 1.0558,
1.0519, 1.0422, 1.0240, 0.9963, 0.9619, 0.9282, 0.9053, 0.9019, 0.9192, 0.9506,
0.9858, 1.0162, 1.0374, 1.0496, 1.0550, 1.0567, 1.0570, 1.0567, 1.0548, 1.0490,
1.0363, 1.0143, 0.9835, 0.9482, 0.9175, 0.9014, 0.9064, 0.9303, 0.9644, 0.9985,
1.0256, 1.0432, 1.0523, 1.0560, 1.0569, 1.0569, 1.0562, 1.0532, 1.0451, 1.0289,
1.0033, 0.9700, 0.9352, 0.9090, 0.9008, 0.9137, 0.9429, 0.9781
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}, 
{
1.1635, 1.1356, 1.0930, 1.0389, 0.9791, 0.9216, 0.8749, 0.8449, 0.8341, 0.8431,
0.8713, 0.9167, 0.9735, 1.0335, 1.0885, 1.1323, 1.1616, 1.1752, 1.1729, 1.1545,
1.1207, 1.0732, 1.0160, 0.9560, 0.9018, 0.8611, 0.8384, 0.8353, 0.8518, 0.8871,
0.9378, 0.9969, 1.0558, 1.1069, 1.1454, 1.1688, 1.1762, 1.1677, 1.1432, 1.1038,
1.0519, 0.9927, 0.9339, 0.8841, 0.8500, 0.8349, 0.8393, 0.8634, 0.9052, 0.9601,
1.0202, 1.0769, 1.1235, 1.1563, 1.1735, 1.1748, 1.1601, 1.1297, 1.0850, 1.0294,
0.9694, 0.9132, 0.8688, 0.8418, 0.8343, 0.8463, 0.8776, 0.9253
}, 
{
1.2039, 1.1666, 1.1115, 1.0438, 0.9715, 0.9040, 0.8501, 0.8159, 0.8037, 0.8139,
0.8461, 0.8983, 0.9649, 1.0372, 1.1057, 1.1623, 1.2013, 1.2198, 1.2166, 1.1918,
1.1472, 1.0865, 1.0159, 0.9442, 0.8810, 0.8344, 0.8086, 0.8050, 0.8238, 0.8641,
0.9228, 0.9929, 1.0647, 1.1293, 1.1796, 1.2110, 1.2211, 1.2095, 1.1767, 1.1253,
1.0599, 0.9878, 0.9183, 0.8606, 0.8218, 0.8045, 0.8096, 0.8370, 0.8850, 0.9490,
1.0210, 1.0911, 1.1508, 1.1941, 1.2175, 1.2192, 1.1992, 1.1589, 1.1013, 1.0322,
0.9600, 0.8942, 0.8432, 0.8124, 0.8039, 0.8176, 0.8532, 0.9083
}, 
{
0.8725, 0.8977, 0.9350, 0.9812, 1.0315, 1.0804, 1.1217, 1.1497, 1.1601, 1.1514,
1.1249, 1.0846, 1.0361, 0.9857, 0.9390, 0.9007, 0.8743, 0.8617, 0.8639, 0.8807,
0.9109, 0.9520, 1.0004, 1.0510, 1.0977, 1.1344, 1.1559, 1.1590, 1.1431, 1.1107,
1.0665, 1.0165, 0.9669, 0.9230, 0.8889, 0.8677, 0.8608, 0.8687, 0.8909, 0.9257,
0.9702, 1.0200, 1.0698, 1.1134, 1.1448, 1.1594, 1.1550, 1.1323, 1.0947, 1.0475,
0.9969, 0.9489, 0.9084, 0.8791, 0.8633, 0.8621, 0.8757, 0.9030, 0.9420, 0.9891,
1.0396, 1.0877, 1.1273, 1.1526, 1.1600, 1.1483, 1.1193, 1.0772
}, 
{
1.7973, 2.0128, 1.4331, 0.9845, 1.5764, 1.8870, 1.5583, 0.9654, 0.9746, 1.5158,
1.8140, 1.5646, 0.9924, 1.3100, 1.9561, 1.8815, 1.1672, 1.2200, 1.9271, 1.9367,
1.2424, 1.1131, 1.7796, 1.9019, 1.3777, 0.8701, 1.2095, 1.6643, 1.7275, 1.3144,
0.9240, 1.5022, 1.9999, 1.7279, 1.0320, 1.4076, 2.0110, 1.8140, 1.0825, 1.3041,
1.9266, 1.8429, 1.1815, 0.9517, 1.4610, 1.7402, 1.5651, 1.0595, 1.0000, 1.6686,
1.9767, 1.5320, 0.9849, 1.5963, 2.0447, 1.6520, 0.9952, 1.5070, 2.0104, 1.7194,
1.0204, 1.1607, 1.6744, 1.7347, 1.3457, 0.8794, 1.1779, 1.7865
}, 
{
1.1635, 1.1356, 1.0930, 1.0389, 0.9791, 0.9216, 0.8749, 0.8449, 0.8341, 0.8431,
0.8713, 0.9167, 0.9735, 1.0335, 1.0885, 1.1323, 1.1616, 1.1752, 1.1729, 1.1545,
1.1207, 1.0732, 1.0160, 0.9560, 0.9018, 0.8611, 0.8384, 0.8353, 0.8518, 0.8871,
0.9378, 0.9969, 1.0558, 1.1069, 1.1454, 1.1688, 1.1762, 1.1677, 1.1432, 1.1038,
1.0519, 0.9927, 0.9339, 0.8841, 0.8500, 0.8349, 0.8393, 0.8634, 0.9052, 0.9601,
1.0202, 1.0769, 1.1235, 1.1563, 1.1735, 1.1748, 1.1601, 1.1297, 1.0850, 1.0294,
0.9694, 0.9132, 0.8688, 0.8418, 0.8343, 0.8463, 0.8776, 0.9253
}, 
{
0.9028, 0.9223, 0.9509, 0.9858, 1.0235, 1.0597, 1.0900, 1.1103, 1.1178, 1.1115,
1.0923, 1.0628, 1.0270, 0.9893, 0.9539, 0.9246, 0.9041, 0.8944, 0.8961, 0.9091,
0.9324, 0.9638, 1.0003, 1.0380, 1.0724, 1.0992, 1.1148, 1.1170, 1.1055, 1.0819,
1.0495, 1.0123, 0.9750, 0.9416, 0.9155, 0.8990, 0.8937, 0.8998, 0.9170, 0.9438,
0.9775, 1.0150, 1.0519, 1.0839, 1.1067, 1.1173, 1.1141, 1.0977, 1.0702, 1.0354,
0.9977, 0.9614, 0.9305, 0.9079, 0.8956, 0.8947, 0.9052, 0.9263, 0.9562, 0.9918,
1.0296, 1.0651, 1.0940, 1.1124, 1.1177, 1.1093, 1.0882, 1.0573
}};
