[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::chan::zero n 1]
[keywords /dev/zero]
[keywords {reflected channel}]
[keywords {tip 219}]
[keywords {virtual channel}]
[keywords zero]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {Zero channel}]
[require Tcl 8.5]
[require TclOO]
[require tcl::chan::events [opt 1]]
[require tcl::chan::zero [opt 1]]
[description]
[para]

The [package tcl::chan::zero] package provides a command creating zero
channels, i.e. read-only channels which return an infinite stream of null
characters upon reading. This is equivalent to the zero channels
provided by the package [package Memchan], except that this is written
in pure Tcl, not C. On the other hand, [package Memchan] is usable with
Tcl 8.4 and before, whereas this package requires Tcl 8.5 or higher,
and TclOO.

[para] Packages related to this are [package tcl::chan::null] and
[package tcl::chan::nullzero].

[para] The internal [package TclOO] class implementing the channel
handler is a sub-class of the [package tcl::chan::events] framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::chan::zero]]

This command creates a new zero channel and returns its handle.

[list_end]

[vset CATEGORY virtchannel]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
