[comment {-*- tcl -*- doctools manpage}]
[vset VERSION 1.1]
[manpage_begin debug::caller n [vset VERSION]]
[keywords debug]
[keywords log]
[keywords narrative]
[keywords trace]
[copyright {2012-2015, Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc {debug narrative}]
[titledesc {debug narrative - caller}]
[category  {debugging, tracing, and logging}]
[require Tcl 8.5]
[require debug::caller [opt [vset VERSION]]]
[description]
[para]

[section API]

[list_begin definitions]
[call [cmd debug] [method caller] [opt [arg args]...]]

This method is useful in a tag-specific prefix to automatically
provide caller information for all uses of the tag. Or in a message,
when only specific places need such detail.

[para] Beyond that it recognizing the various internal forms of method
calls generated by the [package snit] OO system and rewrites these to
their original form, for better readability.

Similarly for [package TclOO].

[para] If [arg args] are specified then they are treated as the
integer indices of command arguments to [emph not] show in the
output. The referenced arguments are replaced by [const *] instead.

The main anticipiated use case for this is the exclusion of arguments
expected to contain large Tcl values, i.e. long lists, large
dictionaries, etc. to prevent them from overwhelming the narrative.

[list_end]

[vset CATEGORY debug]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
