[comment {-*- tcl -*- doctools manpage}]
[manpage_begin dicttool n 1.0]
[keywords dict]
[copyright {2017 Sean Woods <yoda@etoyoc.com>}]
[moddesc   {Extensions to the standard "dict" command}]
[category Utilites]
[titledesc {Dictionary Tools}]
[require Tcl 8.5]
[description]
[para]
The [package dicttool] package enhances the standard [emph dict] command with several new
commands. In addition, the package also defines several "creature comfort" list commands as well.
Each command checks to see if a command already exists of the same name before adding itself,
just in case any of these slip into the core.

[list_begin definitions]
[call [cmd ladd] [arg varname] [arg args]]

This command will add a new instance of each element in [arg args] to [arg varname], but only if that element
is not already present.

[call [cmd ldelete] [arg varname] [arg args]]

This command will add a delete all instances of each element in [arg args] from [arg varname].

[call [cmd {dict getnull}] [arg args]]

Operates like [cmd {dict get}], however if the key [arg args] does not exist, it returns an empty
list instead of throwing an error.

[call [cmd {dict print}] [arg dict]]

This command will produce a string representation of [arg dict], with each nested branch on
a newline, and indented with two spaces for every level.

[call [cmd {dict is_dict}] [arg value]]

This command will return true if [arg value] can be interpreted as a dict. The command operates in
such a way as to not force an existing dict representation to shimmer into another internal rep.

[call [cmd rmerge] [arg args]]

Return a dict which is the product of a recursive merge of all of the arguments. Unlike [cmd {dict merge}],
this command descends into all of the levels of a dict. Dict keys which end in a : indicate a leaf, which
will be interpreted as a literal value, and not descended into further.

[example {

set items [dict merge {
  option {color {default: green}}
} {
  option {fruit {default: mango}}
} {
  option {color {default: blue} fruit {widget: select values: {mango apple cherry grape}}}
}]
puts [dict print $items]
}]

Prints the following result:
[example {
option {
  color {
    default: blue
  }
  fruit {
    widget: select
    values: {mango apple cherry grape}
  }
}
}]

[list_end]

[vset CATEGORY dict]
[include ../doctools2base/include/feedback.inc]
[manpage_end]