[vset TU_STRING_VERSION 0.8]
[manpage_begin textutil::string n [vset TU_STRING_VERSION]]
[see_also regexp(n)]
[see_also split(n)]
[see_also string(n)]
[keywords capitalize]
[keywords chop]
[keywords {common prefix}]
[keywords formatting]
[keywords prefix]
[keywords string]
[keywords uncapitalize]
[moddesc   {Text and string utilities, macro processing}]
[titledesc {Procedures to manipulate texts and strings.}]
[category  {Text processing}]
[require Tcl 8.2]
[require textutil::string [opt [vset TU_STRING_VERSION]]]
[description]

The package [package textutil::string] provides miscellaneous string
manipulation commands.

[para]

The complete set of procedures is described below.

[list_begin definitions]

[call [cmd ::textutil::string::chop] [arg string]]

A convenience command. Removes the last character of [arg string] and
returns the shortened string.

[call [cmd ::textutil::string::tail] [arg string]]

A convenience command. Removes the first character of [arg string] and
returns the shortened string.

[call [cmd ::textutil::string::cap] [arg string]]

Capitalizes the first character of [arg string] and returns the
modified string.

[call [cmd ::textutil::string::capEachWord] [arg string]]

Capitalizes the first character of word of the [arg string] and
returns the modified string. Words quoted with either backslash or
dollar-sign are left untouched.

[call [cmd ::textutil::string::uncap] [arg string]]

The complementary operation to [cmd ::textutil::string::cap]. Forces
the first character of [arg string] to lower case and returns the
modified string.

[call [cmd ::textutil::string::longestCommonPrefixList] [arg list]]
[call [cmd ::textutil::string::longestCommonPrefix] [opt [arg string]...]]

Computes the longest common prefix for either the [arg string]s given
to the command, or the strings specified in the single [arg list], and
returns it as the result of the command.

[para]

If no strings were specified the result is the empty string.  If only
one string was specified, the string itself is returned, as it is its
own longest common prefix.

[list_end]

[vset CATEGORY textutil]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
