テーマの作り方
=======

テーマ作成に先だって
----------

テーマはtDiary 1.1.0以降で使えるようになった、日記の見栄えを簡単に変更する仕組みです。テーマはCSS(カスケーディングスタイルシート)で実現されているので、CSSの書き方がわかれば作ることができます。CSSの書き方についてはここでは述べません。このドキュメントでは、tDiaryのテーマを作るときの約束事だけを説明します。

tDiaryのテーマは、インストールディレクトリにあるthemeディレクトリに入っています。tDiary標準セットではDefaultだけ、フルセットではテーマ集にあるすべてのテーマが入っています。

テーマ作成の基本ルール
-----------

tDiaryテーマには、以下のような基本的な約束事があります。もちろん、CSSであればなんでもかまわないのですが、themeディレクトリに配置してtDiaryの設定画面から選択したり、テーマ・ギャラリーに入るようなテーマにするなら、これらの約束事を守った方が良いでしょう。

  - テーマの配置
    - themeディレクトリの下にテーマ名のディレクトリを作成し、その下に関連するファイルをすべて納める
    - テーマ名は英小文字または数字で始まる英小文字・数字・「\_」「-」からつける。なお「\_」で単語を区切ると、tDiaryの設定画面の一覧で「\_」が空白に置き換えられることを覚えておいて損はない
    - テーマ名の文字数に制限はないが、あまり長くしすぎないように
    - (少なくとも公開する気があるのなら)テーマ集にまだ含まれていない名称をつけるべきである
    - そのテーマが表現するものを端的に表した名称が望ましい
  - CSSファイル名
    - 個々のテーマのディレクトリ直下に「テーマ名.css」というファイル名で作成する
    - 最低限default.cssに含まれているエレメントは含むようにする(ただしプラグインに関する記述は任意)。後述する「テストベンチ」で確認すると良い
  - 関連ファイル(README、イメージファイルなど)
    - テーマに関連するファイルは、個々のテーマディレクトリにすべて納める
    - そのテーマの説明はREADMEというファイル名にする。このファイルの先頭に後述するフォーマットで簡単な説明を書いておくと、テーマ・ギャラリー掲載時にその内容が使われる
    - その他のファイル名に特に制限はないが、テーマの命名と同程度の規則を適用するのが望ましい。慣例として、イメージアンカーにはsanchor.png(セクション)、canchor.png(ツッコミ)の名称がよく使われる。
  - エレメント
    - div.section(日記本文)で使われる文字サイズ(font-size)は、「100%」を強く推奨する。もちろん、親要素で文字サイズを指定していない場合には無指定でよい。また、ツッコミ等の読者によく読まれる可能性のあるエレメントでも、90%に満たない文字サイズの指定は推奨しない。
    - div.mainとdiv.sidebarは、サイドバー(タイトルリスト等を入れる縦長のボックス)を実現するために用意されている。div.mainは本文用、div.sidebarはサイドバー用のエレメント。これらを定義しておくと、他のテーマと共通のやり方でサイドバーが設置できるようになる。
    - もし、サイドバーの位置としてdiv.sidebarで指定したのと反対側にも出せるようにしたい場合には、div.main2、div.sidebar2を定義する。

なお、実際のエレメントやクラスがtDiary上で持つ意味は、付属のdefault/default.cssにコメントとして書かれていますので、参考にしてください。

テーマ・ギャラリー用の説明
-------------

tDiary.Netには、[テーマ・ギャラリー](http://www.tdiary.org/20021001.html)というページがあります。テーマ集に登録されたテーマはここでスクリーンショットともども一覧することができます。ここに表示されている作者名やコメントは、テーマ付属のREADME(1.4の時の名残でcssファイルも利用されている)に一定のフォーマットで書かれているものを自動的に抜き出しているものです。

最初からこのフォーマットで書いておくと、テーマ集に入った時に見栄えがします。以下にそのフォーマットについて解説します。

```
Title: クローバー
Author: ただただし
Access: t@tdtds.jp
License: GPL2 or any later version
Comment: 四つ葉のクローバーの葉をあしらった、シンプルでかわいらしいテーマ 春向きのテーマです。 サイドバー対応。 calendar2、recent_list、footnote、amazonプラグイン対応。
```

この説明は、READMEの最初の行から記述します。「キー」と「値」を「: 」で挟んだ形式で、1項目1行で書きます。日本語を書くときは、文字コードをUTF-8にして下さい。英語の説明があれば、README.enというファイルにしてください。

各項目の意味は以下のとおりです。なお、現在ギャラリーで利用されている項目はTitle、Author、License、Commentだけです。

  - Title: テーマのタイトルです。ファイル名だけでは味気ないと思ったら、この項目を書いてください。なくてもかまいません。
  - Author: 作者名
  - Access: 作者の連絡先。メールアドレスか、URLを
  - License: ライセンス。記述しない場合はtDiaryと同じGPL2になります
  - Comment: このテーマに関する簡単な説明

これらのあとに空改行をあければ、それ以下には何を書いてもかまいません。レイアウト上のアドバイスや、作者の思い入れを語る等、好きなように使ってください。

テーマ・テストベンチ
----------

テーマの見え方を確認するための、[テストベンチ](http://www.tdiary.org/theme.sample.html)というページがあります。ギャラリーのスクリーンショットと異なり、こちらでは様々なエレメントの見え方や、代表的なプラグインの表示を確認することができます。テーマ作成時に利用してください。

