package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecoverPhysicalConnection invokes the vpc.RecoverPhysicalConnection API synchronously
func (client *Client) RecoverPhysicalConnection(request *RecoverPhysicalConnectionRequest) (response *RecoverPhysicalConnectionResponse, err error) {
	response = CreateRecoverPhysicalConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// RecoverPhysicalConnectionWithChan invokes the vpc.RecoverPhysicalConnection API asynchronously
func (client *Client) RecoverPhysicalConnectionWithChan(request *RecoverPhysicalConnectionRequest) (<-chan *RecoverPhysicalConnectionResponse, <-chan error) {
	responseChan := make(chan *RecoverPhysicalConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecoverPhysicalConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecoverPhysicalConnectionWithCallback invokes the vpc.RecoverPhysicalConnection API asynchronously
func (client *Client) RecoverPhysicalConnectionWithCallback(request *RecoverPhysicalConnectionRequest, callback func(response *RecoverPhysicalConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecoverPhysicalConnectionResponse
		var err error
		defer close(result)
		response, err = client.RecoverPhysicalConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecoverPhysicalConnectionRequest is the request struct for api RecoverPhysicalConnection
type RecoverPhysicalConnectionRequest struct {
	*requests.RpcRequest
	DryRun     requests.Boolean `position:"Query" name:"DryRun"`
	Token      string           `position:"Query" name:"Token"`
	InstanceId string           `position:"Query" name:"InstanceId"`
}

// RecoverPhysicalConnectionResponse is the response struct for api RecoverPhysicalConnection
type RecoverPhysicalConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRecoverPhysicalConnectionRequest creates a request to invoke RecoverPhysicalConnection API
func CreateRecoverPhysicalConnectionRequest() (request *RecoverPhysicalConnectionRequest) {
	request = &RecoverPhysicalConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "RecoverPhysicalConnection", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecoverPhysicalConnectionResponse creates a response to parse from RecoverPhysicalConnection response
func CreateRecoverPhysicalConnectionResponse() (response *RecoverPhysicalConnectionResponse) {
	response = &RecoverPhysicalConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
