## TFSA-2021-085: Division by zero in TFLite's implementation of `SpaceToBatchNd`

### CVE Number
CVE-2021-29597

### Impact
The implementation of the `SpaceToBatchNd` TFLite operator is [vulnerable to a
division by zero
error](https://github.com/tensorflow/tensorflow/blob/412c7d9bb8f8a762c5b266c9e73bfa165f29aac8/tensorflow/lite/kernels/space_to_batch_nd.cc#L82-L83):

```cc
TF_LITE_ENSURE_EQ(context, final_dim_size % block_shape[dim], 0);
output_size->data[dim + 1] = final_dim_size / block_shape[dim];
```

An attacker can craft a model such that one dimension of the `block` input is 0.
Hence, the corresponding value in `block_shape` is 0.

### Patches
We have patched the issue in GitHub commit
[6d36ba65577006affb272335b7c1abd829010708](https://github.com/tensorflow/tensorflow/commit/6d36ba65577006affb272335b7c1abd829010708).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
