/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.handles;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.piccolo2d.PCamera;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PDragSequenceEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventFilter;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.extras.util.PLocator;
import org.piccolo2d.extras.util.PNodeLocator;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PDimension;

public class PHandle
extends PPath.Float {
    private static final long serialVersionUID = 1L;
    public static final float DEFAULT_HANDLE_SIZE = 8.0f;
    public static final Shape DEFAULT_HANDLE_SHAPE = new Ellipse2D.Float(0.0f, 0.0f, 8.0f, 8.0f);
    public static final Color DEFAULT_COLOR = Color.white;
    private PLocator locator;
    private transient PDragSequenceEventHandler handleDragger;

    public PHandle(PLocator aLocator) {
        super(DEFAULT_HANDLE_SHAPE);
        this.locator = aLocator;
        this.setPaint(DEFAULT_COLOR);
        this.installHandleEventHandlers();
    }

    protected void installHandleEventHandlers() {
        this.handleDragger = new HandleDragHandler();
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PHandle.this.relocateHandle();
            }
        });
        this.handleDragger.setEventFilter(new PInputEventFilter(16));
        this.handleDragger.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.handleDragger.getEventFilter().setAcceptsMouseEntered(false);
        this.handleDragger.getEventFilter().setAcceptsMouseExited(false);
        this.handleDragger.getEventFilter().setAcceptsMouseMoved(false);
        this.addInputEventListener((PInputEventListener)this.handleDragger);
    }

    public PDragSequenceEventHandler getHandleDraggerHandler() {
        return this.handleDragger;
    }

    public PLocator getLocator() {
        return this.locator;
    }

    public void setLocator(PLocator locator) {
        this.locator = locator;
        this.invalidatePaint();
        this.relocateHandle();
    }

    public void startHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
    }

    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
    }

    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
    }

    public void setParent(PNode newParent) {
        super.setParent(newParent);
        this.relocateHandle();
    }

    public void parentBoundsChanged() {
        this.relocateHandle();
    }

    public void relocateHandle() {
        if (this.locator == null) {
            return;
        }
        PBounds b = this.getBoundsReference();
        Point2D aPoint = this.locator.locatePoint(null);
        if (this.locator instanceof PNodeLocator) {
            PNode located = ((PNodeLocator)this.locator).getNode();
            PNode parent = this.getParent();
            located.localToGlobal(aPoint);
            this.globalToLocal(aPoint);
            if (parent != located && parent instanceof PCamera) {
                ((PCamera)parent).viewToLocal(aPoint);
            }
        }
        double newCenterX = aPoint.getX();
        double newCenterY = aPoint.getY();
        if (newCenterX != b.getCenterX() || newCenterY != b.getCenterY()) {
            this.centerBoundsOnPoint(newCenterX, newCenterY);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.installHandleEventHandlers();
    }

    private final class HandleDragHandler
    extends PDragSequenceEventHandler {
        private HandleDragHandler() {
        }

        protected void startDrag(PInputEvent event) {
            super.startDrag(event);
            PHandle.this.startHandleDrag(event.getPositionRelativeTo((PNode)PHandle.this), event);
        }

        protected void drag(PInputEvent event) {
            super.drag(event);
            PDimension aDelta = event.getDeltaRelativeTo((PNode)PHandle.this);
            if (aDelta.getWidth() != 0.0 || aDelta.getHeight() != 0.0) {
                PHandle.this.dragHandle(aDelta, event);
            }
        }

        protected void endDrag(PInputEvent event) {
            super.endDrag(event);
            PHandle.this.endHandleDrag(event.getPositionRelativeTo((PNode)PHandle.this), event);
        }
    }
}

