---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations
---

# Comment limiter la largeur d'une illustration ?

Supposons que vous ayez des images dont la largeur peut grandement varier :

- s'ils sont moins grands que la largeur de la page, vous souhaitez 
  les afficher à leur taille naturelle ;
- sinon, vous souhaitez réduire l'échelle de l'image afin qu'elle tienne 
  dans la largeur de la page.

Pour obtenir ce résultat, le code de l'extension <ctanpkg:graphics> donne 
une solution :

```{noedit}
\makeatletter
\def\maxwidth{%
  \ifdim\Gin@nat@width>\linewidth % Comparaison de la largeur de l'image
                                  % et de la largeur de la ligne de texte
    \linewidth
  \else
    \Gin@nat@width
  \fi
}
\makeatother
```

Ce code définit une largeur qui a les propriétés souhaitées. Cette largeur 
s'utilise ensuite dans la commande `\includegraphics`. En voici un exemple
(où l'image est plus large par défaut que le texte).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Quelques images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[body={9cm,15cm}]{geometry}

  \makeatletter
  \def\maxwidth{%
    \ifdim\Gin@nat@width>\linewidth % Comparaison de la largeur de l'image
                                    % et de la largeur de la ligne de texte
      \linewidth
    \else
      \Gin@nat@width
    \fi
  }
  \makeatother

\begin{document}
Comme promis, vous trouverez ci-dessous mon projet de nouveau caractère, 
agrandi, afin que vous puissez en admirer les magnifiques détails. Notez
son admirable symétrie.

\begin{figure}[h!]
  \centering
  \includegraphics[width=\maxwidth]{example-image-a}
  \caption{Mon projet}
\end{figure}
\end{document}
```

Bien évidemment, ce code peut être librement adapté pour modifier 
la contrainte. Il suffit alors en général de remplacer `\linewidth` 
par une autre expression.


:::{sources}
- [Limit the width of imported graphics](faquk:FAQ-grmaxwidth)
:::