////////////////////////////////////////////////////////////////////////////////
//
// Copyright 2016 - 2019, 2023, Thomas Lauf, Paul Beckingham, Federico Hernandez.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// https://www.opensource.org/licenses/mit-license.php
//
////////////////////////////////////////////////////////////////////////////////

#ifndef INCLUDED_RANGE
#define INCLUDED_RANGE

#include <Datetime.h>
#include <vector>

class Range
{
public:
  Range () = default;
  virtual ~Range() = default;
  Range (const Datetime&, const Datetime&);
  bool operator== (const Range&) const;
  bool operator!= (const Range&) const;

  void open ();
  void open (const Datetime&);
  void close ();

  bool is_open () const;
  bool is_started () const;
  bool is_ended () const;
  bool is_empty () const;

  bool contains (const Datetime&) const;

  bool overlaps (const Range&) const;
  bool encloses (const Range&) const;
  bool startsWithin (const Range&) const;
  bool endsWithin (const Range&) const;
  Range intersect (const Range&) const;
  bool intersects (const Range&) const;
  Range combine (const Range&) const;
  std::vector <Range> subtract (const Range&) const;
  time_t total () const;

  virtual std::string dump () const;

public:
  Datetime start {0};
  Datetime end   {0};

};

#endif
