#!/bin/sh
### BEGIN INIT INFO
# Provides:          tpconfig
# Required-Start:    $remote_fs $syslog
# Required-Stop:
# Default-Start:     2 3 4 5
# Default-Stop:
# Short-Description: Start tpconfig at boot time
# Description:       Enable tpconfig daemon
### END INIT INFO
# $Id: init.d,v 1.10 2001/03/05 17:35:08 cph Exp $
#
# Copyright (c) 2001 Massachusetts Institute of Technology
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this package; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

set -e

case "$1" in
    "start")
	[ -f /etc/default/tpconfig ] || exit 0
	. /etc/default/tpconfig
	if [ "${RESET_P:-false}" != "false" ]; then
	    tpconfig --reset > /dev/null 2>&1 || true
	fi
	if [ "${OPTIONS:-none}" != "none" ]; then
	     tpconfig ${OPTIONS} > /dev/null 2>&1 || true
	fi
	;;
    "stop")
	;;
    "restart"|"force-reload")
	$0 stop
	$0 start
	;;
    *)
	echo "Usage: $0 {start|stop|restart|force-reload}"
	exit 1
	;;
esac

exit 0
