# Copyright (C) 2006,2007 Daiki Ueno <ueno@unixuser.org>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

module Treil
  class Color
    def self.rgb2hsv(r, g, b)
      max = [r, g, b].max
      min = [r, g, b].min
      if max == r
        [60 * (g - b) / (max - min), (max - min) / max, max]
      elsif max == g
        [60 * (b - r) / (max - min) + 120, (max - min) / max, max]
      else
        [60 * (r - g) / (max - min) + 240, (max - min) / max, max]
      end
    end

    def self.hsv2rgb(h, s, v)
      if s == 0.0
        return [v, v, v]
      end
      hi = (h / 60).floor % 6
      f = h / 60 - hi
      p = v * (1 - s)
      q = v * (1 - f * s)
      t = v * (1 - (1 - f) * s)
      case hi
      when 0
        [v, t, p]
      when 1
        [q, v, p]
      when 2
        [p, v, t]
      when 3
        [p, q, v]
      when 4
        [t, p, v]
      when 5
        [v, p, q]
      end
    end
  end
end
