from _typeshed import Incomplete, Unused
from enum import IntEnum
from typing import ClassVar
from typing_extensions import Literal

from ._binary import o8 as o8
from .ImageFile import ImageFile

is_cid: Incomplete
MAX_TEXT_CHUNK: Incomplete
MAX_TEXT_MEMORY: Incomplete

class Disposal(IntEnum):
    OP_NONE: int
    OP_BACKGROUND: int
    OP_PREVIOUS: int

class Blend(IntEnum):
    OP_SOURCE: int
    OP_OVER: int

class ChunkStream:
    fp: Incomplete
    queue: Incomplete
    def __init__(self, fp) -> None: ...
    def read(self): ...
    def __enter__(self): ...
    def __exit__(self, *args: Unused) -> None: ...
    def close(self) -> None: ...
    def push(self, cid, pos, length) -> None: ...
    def call(self, cid, pos, length): ...
    def crc(self, cid, data) -> None: ...
    def crc_skip(self, cid, data) -> None: ...
    def verify(self, endchunk: bytes = b"IEND"): ...

class iTXt(str):
    lang: Incomplete
    tkey: Incomplete
    @staticmethod
    def __new__(cls, text, lang: Incomplete | None = None, tkey: Incomplete | None = None): ...

class PngInfo:
    chunks: Incomplete
    def __init__(self) -> None: ...
    def add(self, cid, data, after_idat: bool = False) -> None: ...
    def add_itxt(self, key, value, lang: str = "", tkey: str = "", zip: bool = False) -> None: ...
    def add_text(self, key, value, zip: bool = False): ...

class PngStream(ChunkStream):
    im_info: Incomplete
    im_text: Incomplete
    im_size: Incomplete
    im_mode: Incomplete
    im_tile: Incomplete
    im_palette: Incomplete
    im_custom_mimetype: Incomplete
    im_n_frames: Incomplete
    rewind_state: Incomplete
    text_memory: int
    def __init__(self, fp) -> None: ...
    def check_text_memory(self, chunklen) -> None: ...
    def save_rewind(self) -> None: ...
    def rewind(self) -> None: ...
    def chunk_iCCP(self, pos, length): ...
    def chunk_IHDR(self, pos, length): ...
    im_idat: Incomplete
    def chunk_IDAT(self, pos, length) -> None: ...
    def chunk_IEND(self, pos, length) -> None: ...
    def chunk_PLTE(self, pos, length): ...
    def chunk_tRNS(self, pos, length): ...
    def chunk_gAMA(self, pos, length): ...
    def chunk_cHRM(self, pos, length): ...
    def chunk_sRGB(self, pos, length): ...
    def chunk_pHYs(self, pos, length): ...
    def chunk_tEXt(self, pos, length): ...
    def chunk_zTXt(self, pos, length): ...
    def chunk_iTXt(self, pos, length): ...
    def chunk_eXIf(self, pos, length): ...
    def chunk_acTL(self, pos, length): ...
    def chunk_fcTL(self, pos, length): ...
    def chunk_fdAT(self, pos, length): ...

class PngImageFile(ImageFile):
    format: ClassVar[Literal["PNG"]]
    format_description: ClassVar[str]
    @property
    def text(self): ...
    fp: Incomplete
    def verify(self) -> None: ...
    def seek(self, frame) -> None: ...
    def tell(self): ...
    decoderconfig: Incomplete
    def load_prepare(self) -> None: ...
    def load_read(self, read_bytes): ...
    png: Incomplete
    im: Incomplete
    def load_end(self) -> None: ...
    def getexif(self): ...
    def getxmp(self): ...

def putchunk(fp, cid, *data) -> None: ...

class _idat:
    fp: Incomplete
    chunk: Incomplete
    def __init__(self, fp, chunk) -> None: ...
    def write(self, data) -> None: ...

class _fdat:
    fp: Incomplete
    chunk: Incomplete
    seq_num: Incomplete
    def __init__(self, fp, chunk, seq_num) -> None: ...
    def write(self, data) -> None: ...

def getchunks(im, **params): ...
