//
// Copyright 2021 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: switch_setup_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // TX0_PATH_CONTROL : 0x0 (switch_control.v)
  // TX1_PATH_CONTROL : 0x400 (switch_control.v)
  // RX0_PATH_CONTROL : 0x800 (switch_control.v)
  // RX1_PATH_CONTROL : 0xC00 (switch_control.v)

//===============================================================================
// RegTypes
//===============================================================================

  // RX_PATH_CONTROL Type (from switch_control.v)
  localparam RX_PATH_CONTROL_SIZE = 32;
  localparam RX_PATH_CONTROL_MASK = 32'h757D77;
  localparam RX_SWITCH_1_SIZE = 2;  //RX_PATH_CONTROL:RX_SWITCH_1
  localparam RX_SWITCH_1_MSB  = 1;  //RX_PATH_CONTROL:RX_SWITCH_1
  localparam RX_SWITCH_1      = 0;  //RX_PATH_CONTROL:RX_SWITCH_1
  localparam RX_SWITCH_2_SIZE = 1;  //RX_PATH_CONTROL:RX_SWITCH_2
  localparam RX_SWITCH_2_MSB  = 2;  //RX_PATH_CONTROL:RX_SWITCH_2
  localparam RX_SWITCH_2      = 2;  //RX_PATH_CONTROL:RX_SWITCH_2
  localparam RX_SWITCH_3_SIZE = 3;  //RX_PATH_CONTROL:RX_SWITCH_3
  localparam RX_SWITCH_3_MSB  = 6;  //RX_PATH_CONTROL:RX_SWITCH_3
  localparam RX_SWITCH_3      = 4;  //RX_PATH_CONTROL:RX_SWITCH_3
  localparam RX_SWITCH_4_SIZE = 1;  //RX_PATH_CONTROL:RX_SWITCH_4
  localparam RX_SWITCH_4_MSB  = 8;  //RX_PATH_CONTROL:RX_SWITCH_4
  localparam RX_SWITCH_4      = 8;  //RX_PATH_CONTROL:RX_SWITCH_4
  localparam RX_SWITCH_5_SIZE =  2;  //RX_PATH_CONTROL:RX_SWITCH_5
  localparam RX_SWITCH_5_MSB  = 11;  //RX_PATH_CONTROL:RX_SWITCH_5
  localparam RX_SWITCH_5      = 10;  //RX_PATH_CONTROL:RX_SWITCH_5
  localparam RX_SWITCH_6_SIZE =  2;  //RX_PATH_CONTROL:RX_SWITCH_6
  localparam RX_SWITCH_6_MSB  = 13;  //RX_PATH_CONTROL:RX_SWITCH_6
  localparam RX_SWITCH_6      = 12;  //RX_PATH_CONTROL:RX_SWITCH_6
  localparam RX_SWITCH_7_8_SIZE =  1;  //RX_PATH_CONTROL:RX_SWITCH_7_8
  localparam RX_SWITCH_7_8_MSB  = 14;  //RX_PATH_CONTROL:RX_SWITCH_7_8
  localparam RX_SWITCH_7_8      = 14;  //RX_PATH_CONTROL:RX_SWITCH_7_8
  localparam RX_SWITCH_9_SIZE =  1;  //RX_PATH_CONTROL:RX_SWITCH_9
  localparam RX_SWITCH_9_MSB  = 16;  //RX_PATH_CONTROL:RX_SWITCH_9
  localparam RX_SWITCH_9      = 16;  //RX_PATH_CONTROL:RX_SWITCH_9
  localparam RX_SWITCH_10_SIZE =  1;  //RX_PATH_CONTROL:RX_SWITCH_10
  localparam RX_SWITCH_10_MSB  = 18;  //RX_PATH_CONTROL:RX_SWITCH_10
  localparam RX_SWITCH_10      = 18;  //RX_PATH_CONTROL:RX_SWITCH_10
  localparam RX_SWITCH_11_SIZE =  3;  //RX_PATH_CONTROL:RX_SWITCH_11
  localparam RX_SWITCH_11_MSB  = 22;  //RX_PATH_CONTROL:RX_SWITCH_11
  localparam RX_SWITCH_11      = 20;  //RX_PATH_CONTROL:RX_SWITCH_11

  // TX_PATH_CONTROL Type (from switch_control.v)
  localparam TX_PATH_CONTROL_SIZE = 32;
  localparam TX_PATH_CONTROL_MASK = 32'h53F7FFD;
  localparam TX_SWITCH_1_2_SIZE = 1;  //TX_PATH_CONTROL:TX_SWITCH_1_2
  localparam TX_SWITCH_1_2_MSB  = 0;  //TX_PATH_CONTROL:TX_SWITCH_1_2
  localparam TX_SWITCH_1_2      = 0;  //TX_PATH_CONTROL:TX_SWITCH_1_2
  localparam TX_SWITCH_3_SIZE = 2;  //TX_PATH_CONTROL:TX_SWITCH_3
  localparam TX_SWITCH_3_MSB  = 3;  //TX_PATH_CONTROL:TX_SWITCH_3
  localparam TX_SWITCH_3      = 2;  //TX_PATH_CONTROL:TX_SWITCH_3
  localparam TX_SWITCH_4_SIZE = 2;  //TX_PATH_CONTROL:TX_SWITCH_4
  localparam TX_SWITCH_4_MSB  = 5;  //TX_PATH_CONTROL:TX_SWITCH_4
  localparam TX_SWITCH_4      = 4;  //TX_PATH_CONTROL:TX_SWITCH_4
  localparam TX_SWITCH_5_SIZE = 2;  //TX_PATH_CONTROL:TX_SWITCH_5
  localparam TX_SWITCH_5_MSB  = 7;  //TX_PATH_CONTROL:TX_SWITCH_5
  localparam TX_SWITCH_5      = 6;  //TX_PATH_CONTROL:TX_SWITCH_5
  localparam TX_SWITCH_6_SIZE = 2;  //TX_PATH_CONTROL:TX_SWITCH_6
  localparam TX_SWITCH_6_MSB  = 9;  //TX_PATH_CONTROL:TX_SWITCH_6
  localparam TX_SWITCH_6      = 8;  //TX_PATH_CONTROL:TX_SWITCH_6
  localparam TX_SWITCH_7_SIZE =  2;  //TX_PATH_CONTROL:TX_SWITCH_7
  localparam TX_SWITCH_7_MSB  = 11;  //TX_PATH_CONTROL:TX_SWITCH_7
  localparam TX_SWITCH_7      = 10;  //TX_PATH_CONTROL:TX_SWITCH_7
  localparam TX_SWITCH_8_SIZE =  3;  //TX_PATH_CONTROL:TX_SWITCH_8
  localparam TX_SWITCH_8_MSB  = 14;  //TX_PATH_CONTROL:TX_SWITCH_8
  localparam TX_SWITCH_8      = 12;  //TX_PATH_CONTROL:TX_SWITCH_8
  localparam TX_SWITCH_9_SIZE =  2;  //TX_PATH_CONTROL:TX_SWITCH_9
  localparam TX_SWITCH_9_MSB  = 17;  //TX_PATH_CONTROL:TX_SWITCH_9
  localparam TX_SWITCH_9      = 16;  //TX_PATH_CONTROL:TX_SWITCH_9
  localparam TX_SWITCH_10_SIZE =  2;  //TX_PATH_CONTROL:TX_SWITCH_10
  localparam TX_SWITCH_10_MSB  = 19;  //TX_PATH_CONTROL:TX_SWITCH_10
  localparam TX_SWITCH_10      = 18;  //TX_PATH_CONTROL:TX_SWITCH_10
  localparam TX_SWITCH_11_SIZE =  2;  //TX_PATH_CONTROL:TX_SWITCH_11
  localparam TX_SWITCH_11_MSB  = 21;  //TX_PATH_CONTROL:TX_SWITCH_11
  localparam TX_SWITCH_11      = 20;  //TX_PATH_CONTROL:TX_SWITCH_11
  localparam TX_SWITCH_13_SIZE =  1;  //TX_PATH_CONTROL:TX_SWITCH_13
  localparam TX_SWITCH_13_MSB  = 24;  //TX_PATH_CONTROL:TX_SWITCH_13
  localparam TX_SWITCH_13      = 24;  //TX_PATH_CONTROL:TX_SWITCH_13
  localparam TX_SWITCH_14_SIZE =  1;  //TX_PATH_CONTROL:TX_SWITCH_14
  localparam TX_SWITCH_14_MSB  = 26;  //TX_PATH_CONTROL:TX_SWITCH_14
  localparam TX_SWITCH_14      = 26;  //TX_PATH_CONTROL:TX_SWITCH_14

//===============================================================================
// Register Group SWITCH_SETUP_REGISTERS
//===============================================================================

  // TX0_PATH_CONTROL Register (from switch_control.v)
  localparam TX0_PATH_CONTROL_COUNT = 256; // Number of elements in array

  // TX1_PATH_CONTROL Register (from switch_control.v)
  localparam TX1_PATH_CONTROL_COUNT = 256; // Number of elements in array

  // RX0_PATH_CONTROL Register (from switch_control.v)
  localparam RX0_PATH_CONTROL_COUNT = 256; // Number of elements in array

  // RX1_PATH_CONTROL Register (from switch_control.v)
  localparam RX1_PATH_CONTROL_COUNT = 256; // Number of elements in array

  // Return the offset of an element of register array TX0_PATH_CONTROL
  function integer TX0_PATH_CONTROL (input integer i);
    TX0_PATH_CONTROL = (i * 'h4) + 'h0;
  endfunction

  // Return the offset of an element of register array TX1_PATH_CONTROL
  function integer TX1_PATH_CONTROL (input integer i);
    TX1_PATH_CONTROL = (i * 'h4) + 'h400;
  endfunction

  // Return the offset of an element of register array RX0_PATH_CONTROL
  function integer RX0_PATH_CONTROL (input integer i);
    RX0_PATH_CONTROL = (i * 'h4) + 'h800;
  endfunction

  // Return the offset of an element of register array RX1_PATH_CONTROL
  function integer RX1_PATH_CONTROL (input integer i);
    RX1_PATH_CONTROL = (i * 'h4) + 'hC00;
  endfunction
