/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef UNS_CONFIG
#define UNS_CONFIG

#include <string>
#include <fstream>

class UNSConfig
{
public:
//ctor
	UNSConfig();

//init(): Load the configuration from configuration files.
//Returns true on success, false if either of the files could not be opened (in which
//case the defaults will be used).
	bool Init();

//Properties
	unsigned long CheckAMTStatusTimeout() const;
	unsigned long NumPollsForDisabled() const;
	unsigned long GetPostureInterval() const;
	bool TraceLogEnabled() const;
#ifdef _DEBUG
	bool debugMode() const;
	bool debugModeAMTEnabled() const;
#endif

private:
	void LoadDefaults();
	bool LoadMachineConfig();

	//Configuration file names
	std::string m_MachineConfigFileName;
#ifdef _DEBUG
	std::string m_DebugModeConfigFileName;
#endif

	//Constants for configuration parameters names
	static const std::string CHECK_AMT_STATUS_TIMEOUT;
	static const std::string NUM_POLLS_FOR_DISABLED;
	static const std::string GET_POSTURE_INTERVAL;
	static const std::string TRACE_LOG_ENABLED;
#ifdef _DEBUG
	static const std::string DEBUG_MODE;
	static const std::string DEBUG_MODE_AMT_ENABLED;
#endif

	//Default values for configuration parameters
	static const unsigned long	DEFAULT_CHECK_AMT_STATUS_TIMEOUT;
	static const unsigned long	DEFAULT_NUM_POLLS_FOR_DISABLED;
	static const unsigned long	DEFAULT_GET_POSTURE_INTERVAL;
	static const bool			DEFAULT_TRACE_LOG_ENABLED;
#ifdef _DEBUG
	static const bool			DEFAULT_DEBUG_MODE;
	static const bool			DEFAULT_DEBUG_MODE_AMT_ENABLED;
#endif

	//Constants for configuration file names
	static const std::string MACHINE_CFG_FILENAME;
#ifdef _DEBUG
	static const std::string DEBUG_MODE_FILENAME;
#endif

	// Configuration state members
	unsigned long m_nCheckAMTStatusTimeout;
	unsigned long m_nNumPollsForDisabled;
	unsigned long m_nGetPostureInterval;
	bool m_bTraceLogEnabled;
};

#endif //UNS_CONFIG
