/*
 * ===========================
 * VDK Builder
 * Version 2.0
 * March 2001
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_Env_main_form_h_
#define _vdkb_Env_main_form_h_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define OBJECTS 50
#define CHANGED_COLOR "red"
// vdk support
#include <vdk/vdk.h>
// Vdkb_Env FORM  CLASS
class Vdkb_EnvForm: public VDKForm
{
// gui object declarations
private:
// gui object declarations
  void GUISetup(void);
  VDKObject* objects[OBJECTS];
  bool Changed;
  bool LockChanged;
  bool forceToClose;
  void WriteSyntaxSampleText();
  void SaveEnvironment();
protected:
  void OnOptionChanged ();
public:
	Vdkb_EnvForm(VDKForm* owner, char* title);
	~Vdkb_EnvForm();
	void Setup(void);

protected: VDKBox* vbox2;
protected: VDKBox* vbox3;
protected: VDKNotebook* nbook;
protected: VDKBox* Nbook0_Page0;
protected: VDKFixed* fixed0;
protected: VDKLabel* label0;
protected: VDKEntry* workdir;
protected: VDKCheckButton* hide_on_run;
protected: VDKCheckButton* wi_resizeable;
protected: VDKCheckButton* autosave;
protected: VDKLabel* label2;
protected: VDKSpinButton* savingtime;
protected: VDKCheckButton* backup;
protected: VDKLabel* label3;
protected: VDKEntry* vdk_ref_path;
protected: VDKCheckButton* run_modal;
protected: VDKCheckButton* emacs;
protected: VDKCheckButton* save_session;
protected: VDKCheckButton* theme;
protected: VDKCheckButton* enable_class_browser;
protected: VDKBox* nbook_page2;
protected: VDKFixed* fixed1;
protected: VDKLabel* label4;
protected: VDKLabel* label1;
protected: VDKLabel* label5;
protected: VDKEntry* cc_ext;
protected: VDKEntry* h_ext;
protected: VDKEntry* o_ext;
protected: VDKEntry* editor_font;
protected: VDKCustomButton* fontbutton;
protected: VDKCustomButton* bgbutton;
protected: VDKEntry* editor_bg;
protected: VDKCustomButton* fgbutton;
protected: VDKEntry* editor_fg;
protected: VDKLabel* label6;
protected: VDKSpinButton* editor_size_x;
protected: VDKLabel* label7;
protected: VDKSpinButton* editor_size_y;
protected: VDKCheckButton* code_autoindent;
protected: VDKCheckButton* showln;
protected: VDKSpinButton* editortab;
protected: VDKLabel* label8;
protected: VDKBox* nbook_page3;
protected: VDKFixed* fixed2;
protected: VDKCustomButton* syntfontbutton;
protected: VDKCustomButton* syntcolorbutton;
 protected: VDKEntry* syntfont;
protected: VDKFrame* frame0;
protected: VDKEditor* code_example;
protected: VDKCustomList* tokenlistbox;
protected: VDKSeparator* separator0;
protected: VDKBox* hbox4;
protected: VDKCustomButton* done;
protected: VDKCustomButton* cancel;
protected: VDKLabel* label9;
protected: VDKEntry* vdk_ref_browser;
	VDKRadioButtonGroup* rgroup;
bool CanClose();

public:
DECLARE_SIGNAL_MAP(Vdkb_EnvForm);
bool OndoneClick(VDKObject* sender);
bool OncancelClick(VDKObject* sender);
bool OnfontbuttonClick(VDKObject* sender);
bool OnbgbuttonClick(VDKObject* sender);
bool OnfgbuttonClick(VDKObject* sender);
 bool Oneditor_fontActivate (VDKObject* sender);
bool OnsyntfontbuttonClick(VDKObject* sender);
 bool OnsyntfontActivate (VDKObject* sender);
bool OnsyntcolorbuttonClick(VDKObject* sender);
bool Oncode_exampleRealize(VDKObject* sender);
bool Onhide_on_runToggled(VDKObject* sender);
bool Onwi_resizeableToggled(VDKObject* sender);
bool OnautosaveToggled(VDKObject* sender);
bool OnbackupToggled(VDKObject* sender);
bool Onrun_modalToggled(VDKObject* sender);
bool OnemacsToggled(VDKObject* sender);
bool Onsave_sessionToggled(VDKObject* sender);
bool OnworkdirChanged(VDKObject* sender);
bool OnsavingtimeValueChanged(VDKObject* sender);
bool Onvdk_ref_pathChanged(VDKObject* sender);
bool Onvdk_ref_browserChanged(VDKObject* sender);
bool Oncc_extChanged(VDKObject* sender);
bool Onh_extChanged(VDKObject* sender);
bool Oneditor_size_xValueChanged(VDKObject* sender);
bool Oneditor_size_yValueChanged(VDKObject* sender);
bool OneditortabValueChanged(VDKObject* sender);
bool Oncode_autoindentToggled(VDKObject* sender);
bool OnshowlnToggled(VDKObject* sender);
bool OntokenlistboxSelectRow (VDKObject* sender);
bool OnthemeToggled(VDKObject* sender);
bool Onenable_class_browserToggled(VDKObject* sender);
bool OnRgroupToggled(VDKObject* sender);
/*
declaring signal and events
dynamics tables
*/
DECLARE_SIGNAL_LIST(Vdkb_EnvForm);
DECLARE_EVENT_LIST(Vdkb_EnvForm);

};

#endif

