/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#include <vdkb2/vdkb_separator.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBSeparator
// put here vdk class name string
#define VDK_CLASS "VDKSeparator"
// put here vdk class name 
#define VDK_ANCESTOR  VDKSeparator
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "separator"

static char buff[128];

int CLASS::Counter = 0;
//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDKBEvSeparator);
DEFINE_EVENT_LIST(CLASS,VDKBEvSeparator);
///////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner,int mode):
  VDKBEvSeparator(owner,mode),VDKBObject(name),mode(mode)
{
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  SetPropValue(JUSTIFY_INTERNAL,"0");
  SetPropValue( EXPAND_INTERNAL,"0");
  SetPropValue(FILL_INTERNAL,"0");
  // assign this to VDKBObject <object> member.
  object = this;
  // connects events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  SetSize(100,2);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;", PROP_SEPARATOR_MODE,mode == h_separator ? 
	  "h_separator" : "v_separator");
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
 */
int
CLASS::MakeWidgetH(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* separator = NULL;
// autogenerate first suitable button counter
  // to ensure unicity
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    // actually makes widget
    separator = new CLASS(buff,owner,h_separator);
  // add widget to form
  return owner->AddToSelf(separator,ev);
}
int
CLASS::MakeWidgetV(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* separator = NULL;
// autogenerate first suitable button counter
  // to ensure unicity
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    // actually makes widget
    separator = new CLASS(buff,owner,v_separator);
  // add widget to form
  return owner->AddToSelf(separator,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char obj_mode[16];
  // get name, and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return NULL;
  // get mode
  else if ( !parser.GetParam(obj_mode,buffer,PROP_SEPARATOR_MODE))
    return NULL;
  source = new char[4096];
  sprintf(tmp,"\n%s = new %s(this,%s);", obj_name,VDK_CLASS,obj_mode);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char obj_mode[16];
  CLASS* separator = NULL;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return false;
  // get mode
  else if ( !parser.GetParam(obj_mode,buffer,PROP_SEPARATOR_MODE) )
    return false;
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      separator = new CLASS(obj_name,owner,atoi(obj_mode));
      // pack widget to container
      return owner->PackToSelf(separator, container, buffer, parser);
    }
  else
    return false;
}








