/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             I S O T O P E S . H                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, October 2003                    *
*                                                                              *
********************************************************************************
*
* $Id: isotopes.h,v 1.6 2003/11/07 12:49:18 jrh Exp $
* $Log: isotopes.h,v $
* Revision 1.6  2003/11/07 12:49:18  jrh
* Release 2.4
*
* Revision 1.5  2000/12/10 15:09:45  jrh
* Release 2.3
*
* Revision 1.4  1999/05/24 01:26:06  jrh
* Release 2.2.1
*
* Revision 1.3  1999/02/07 21:51:49  jrh
* Release 2.2
*
* Revision 1.2  1998/01/26 00:48:14  jrh
* Release 2.1
*
* Revision 1.1  1996/12/10  18:45:37  jrh
* Initial revision
*
     Atomic masses of isotopes

     isotopes[atomic number][abundancy]:
     isotopic abundancy or lifetime, respectively,
     0 average, 1 most common, 2 second most common ...

     Average atomic masses from Pure & Appl. Chem., 1996, 68, 2339-2359.
     Atomic masses and selection of isotopes from:
                         J. Emsley
                        "The Elements"
                         Oxford, 1991
*/

#define LASTELEMENT 109

double isotope[LASTELEMENT][9] = {
/*  1H        2H       3H */
  {1.00794, 1.007825, 2.01410, 3.01605, 0.0, 0.0, 0.0, 0.0, 0.0},
/*  4He      3He */
  {4.002602, 4.00260, 3.01603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*  7Li       6Li */
  {6.941, 7.016003, 6.015121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*  9Be        10Be      7Be */
  {9.012182, 9.012182, 10.013534, 7.016928, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   11B        10B */
  {10.811, 11.009305, 10.012937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   12C  13C        14C        11C */
  {12.0107, 12., 13.003355, 14.003241, 11.011430, 0.0, 0.0, 0.0, 0.0},
/*   14N        15N */
  {14.00674, 14.003074, 15.000108, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   16O        18O        17O */
  {15.9994, 15.994915, 17.999160, 16.999131, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   19F         18F */
  {18.9984032, 18.9984033, 18.000937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   20Ne       22Ne       21Ne */
  {20.1797, 19.992435, 21.991383, 20.993843, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   23Na        22Na       24Na */
  {22.989770, 22.9897697, 21.994434, 23.990961, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   24Mg       26Mg       25Mg       28Mg */
  {24.3050, 23.985042, 25.982593, 24.985837, 27.983876, 0.0, 0.0, 0.0, 0.0},
/*   27Al       26Al */
  {26.981538, 26.981540, 25.986892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   28Si       29Si       30Si       32Si */
  {28.0855, 27.976927, 28.976495, 29.973770, 31.974148, 0.0, 0.0, 0.0, 0.0},
/*   31P        32P        33P */
  {30.973761, 30.973762, 31.973907, 32.971725, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   32S        34S        33S        36S        35S */
  {32.066, 31.972070, 33.967866, 32.971456, 35.967080, 34.969031, 0.0, 0.0, 0.0},
/*   35Cl       37Cl       36Cl */
  {35.4527, 34.968852, 36.965903, 35.968306, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   40Ar       36Ar       38Ar       39Ar       37Ar */
  {39.948, 39.962384, 35.967545, 37.962732, 38.962314, 36.966776, 0.0, 0.0, 0.0},
/*   39K        41K        40K        43K        42K */
  {39.0983, 38.963707, 40.961825, 39.963999, 42.960717, 41.962402, 0.0, 0.0, 0.0},
/*   40Ca       44Ca       42Ca       48Ca       43Ca       46Ca       45Ca       47Ca  */
  {40.078, 39.962591, 43.955480, 41.958618, 47.952533, 42.958766, 45.953689, 44.955480, 46.954543},
/*   45Sc       46Sc       47Sc       44Sc */
  {44.955910, 44.955910, 45.955170, 46.952408, 43.959404, 0.0, 0.0, 0.0, 0.0},
/*   48Ti       46Ti       47Ti       49Ti       50Ti       44Ti         */
  {47.867, 47.947947, 45.952629, 46.951764, 48.947871, 49.944792, 43.959689,  0.0, 0.0},
/*   51V        50V        49V        48V */
  {50.9415, 50.943962, 49.947161, 48.948517, 47.952257, 0.0, 0.0, 0.0, 0.0},
/*   52Cr       53Cr       50Cr       54Cr       51Cr */
  {51.9961, 51.940509, 52.940651, 49.946046, 53.938882, 50.944768, 0.0, 0.0, 0.0},
/*   55Mn       53Mn       54Mn       56Mn */
  {54.938049, 54.938047, 52.941291, 53.940361, 55.938906, 0.0, 0.0, 0.0, 0.0},
/*   56Fe       54Fe       57Fe       58Fe       60Fe       55Fe       59Fe       52Fe */
  {55.845, 55.934939, 53.939612, 56.935396, 57.933277, 59.934080, 54.938296, 58.934877, 51.948114},
/*   59Co       60Co       57Co       56Co       58Co */
  {58.933200, 58.933198, 59.933819, 56.936294, 55.939841, 57.935755, 0.0, 0.0, 0.0},
/*   58Ni       60Ni       62Ni       61Ni       64Ni       59Ni       63Ni */
  {58.6934, 57.935346, 59.930788, 61.928346, 60.931058, 63.927968, 58.934349, 62.929669,  0.0},
/*   63Cu       65Cu       67Cu       64Cu */
  {63.546, 62.939598, 64.927793, 66.927747, 63.929765, 0.0, 0.0, 0.0, 0.0},
/*   64Zn       66Zn       68Zn       67Zn       70Zn       65Zn       69Zn */
  {65.39, 63.929145, 65.926034, 67.924846, 66.927129, 69.925325, 64.929243, 69.926552, 0.0},
/*   69Ga       71Ga       67Ga       72Ga */
  {69.723, 68.925580, 70.924700, 66.928420, 71.926365, 0.0, 0.0, 0.0, 0.0},
/*   74Ge       72Ge       70Ge       73Ge       76Ge       68Ge       71Ge        77Ge  */
  {72.61, 73.921177, 71.922079, 69.924250, 72.923463, 75.921401, 67.928096, 70.924250,  76.923548},
/*   75As       73As       76As       74As */
  {74.92160, 74.921594, 72.923827, 75.922393, 73.923827, 0.0, 0.0, 0.0, 0.0},
/*   80Se       78Se       82Se       76Se       77Se       74Se       75Se */
  {78.96, 79.916520, 77.917308, 81.916698, 75.919212, 76.919912, 73.922475, 74.922521, 0.0},
/*   79Br       81Br       77Br       82Br */
  {79.904, 78.918336, 80.916289, 76.921378, 81.914802, 0.0, 0.0, 0.0, 0.0},
/*   84Kr       86Kr       82Kr       83Kr       80Kr       78Kr       85Kr   */
  {83.80, 83.911507, 85.910616, 81.913482, 82.914135, 79.916380, 77.920400, 84.912531, 0.0},
/*   85Rb */
  {85.4678, 84.9117, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   88Sr     84Sr     86Sr     87Sr */
  {87.62, 87.9056, 83.9134, 85.9094, 86.9089, 0.0, 0.0, 0.0, 0.0},
/*   89Y */
  {88.90585, 88.9054, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   90Zr     91Zr     92Zr     94Zr */
  {91.224, 89.9043, 90.9053, 91.9046, 93.9061, 0.0, 0.0, 0.0, 0.0},
/*     93Nb */
  {92.90638, 92.9060, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*   98Mo     92Mo     95Mo      96Mo */
  {95.94, 97.9055, 91.9063, 94.90584, 95.9046, 0.0, 0.0, 0.0, 0.0},
/*   Tc */
  {98.9063, 98.9062, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    102Ru    99Ru     100Ru     104Ru */
  {101.07, 101.9037, 98.9061, 99.9030, 103.9055, 0.0, 0.0, 0.0, 0.0},
/*    103Rh */
  {102.90550, 102.9048, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    106Pd     104Pd     105Pd     108Pd */
  {106.42, 105.9032, 103.9036, 104.9046, 107.90389, 0.0, 0.0, 0.0, 0.0},
/*    107Ag      109Ag */
  {107.8682, 106.90509, 108.9047, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    114Cd     110Cd     111Cd     112Cd */
  {112.411, 113.9036, 109.9030, 110.9042, 111.9028, 0.0, 0.0, 0.0, 0.0},
/*    115In     113In */
  {14.818, 114.9041, 112.9043, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    118Sn     116Sn     117Sn     119Sn */
  {118.710, 117.9018, 115.9021, 116.9031, 118.9034, 0.0, 0.0, 0.0, 0.0},
/*    121Sb     123Sb */
  {121.760, 120.9038, 122.9041, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    130Te     125Te     126Te     128Te */
  {127.60, 129.9067, 124.9044, 125.9032, 127.9047, 0.0, 0.0, 0.0, 0.0},
/*    127I */
  {126.90447, 126.9004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    132Xe     129Xe     131Xe     134Xe */
  {131.29, 131.9042, 128.9048, 130.9051, 133.9054, 0.0, 0.0, 0.0, 0.0},
/*    134Cs */
  {132.90545, 133.9051, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    138Ba     134Ba     135Ba     136Ba */
  {137.327, 137.9050, 133.9043, 134.9056, 135.9044, 0.0, 0.0, 0.0, 0.0},
/*    139La     138La */
  {138.9055, 138.9061, 137.9068, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    140Ce     138Ce     142Ce */
  {140.116, 139.9053, 137.9057, 141.9090, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    141Pr */
  {140.90765, 140.9074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    142Nd     143Nd     144Nd     146Nd */
  {144.24, 141.9075, 142.9096, 143.9099, 145.9127, 0.0, 0.0, 0.0, 0.0},
/*    Pm */
  {144.9127, 145.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    152Sm     147Sm     149Sm     154Sm */
  {150.36, 151.9195, 146.9146, 148.9169, 153.9220, 0.0, 0.0, 0.0, 0.0},
/*    153Eu     151Eu */
  {151.964, 152.9209, 150.9196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    158Gd     156Gd     157Gd     160Gd */
  {157.25, 157.9241, 155.9221, 156.9339, 159.9271, 0.0, 0.0, 0.0, 0.0},
/*    159Tb     151Tb */
  {158.92534, 158.9250, 150.9230, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    164Dy     161Dy     162Dy     163Dy */
  {162.50, 163.9288, 160.9266, 161.9265, 162.9284, 0.0, 0.0, 0.0, 0.0},
/*    165Ho */
  {164.93032, 164.9303, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    166Er     167Er     168Er     170Er */
  {167.26, 165.9304, 166.9320, 167.9324, 169.9355, 0.0, 0.0, 0.0, 0.0},
/*    169Tm */
  {168.93421, 168.9344, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    174Yb     171Yb     172Yb     173Yb */
  {173.04, 173.9390, 170.9365, 171.9366, 172.9383, 0.0, 0.0, 0.0, 0.0},
/*    175Lu */
  {174.967, 174.9409, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    180Hf     177Hf     178Hf     179Hf */
  {178.49, 179.9468, 176.9435, 177.9439, 178.9460, 0.0, 0.0, 0.0, 0.0},
/*    181Ta     180Ta */
  {180.9479, 180.9480, 179.9415, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    184W      182W      183W      186W */
  {183.84, 183.9510, 181.9483, 182.9503, 185.9543, 0.0, 0.0, 0.0, 0.0},
/*    187Re     185Re */
  {186.207, 186.9560, 184.9530, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    190Os     188Os     189Os */
  {190.23, 189.9586, 187.9560, 188.9586, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    193Ir     191Ir */
  {192.217, 192.9633, 190.9609, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    195Pt     194Pt     196Pt     198Pt */
  {195.078, 194.9648, 193.9628, 195.9650, 197.9675, 0.0, 0.0, 0.0, 0.0},
/*    197Au */
  {196.96655, 196.9666, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    202Hg     199Hg     200Hg     201Hg */
  {200.59, 201.9706, 198.9683, 199.9683, 200.9703, 0.0, 0.0, 0.0, 0.0},
/*    205Tl     203Tl */
  {204.3833, 204.9745, 202.9723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    208Pb     204Pb     206Pb     207Pb */
  {207.2, 207.9766, 203.9730, 205.9745, 206.9759, 0.0, 0.0, 0.0, 0.0},
/*    209Bi     211Bi */
  {208.98038, 208.9804, 210.9873, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    209Po     206Po     207Po     208Po */
  {208.9824, 208.9825, 205.9805, 206.9816, 207.9813, 0.0, 0.0, 0.0, 0.0},
/*    211At */
  {209.9871, 210.9875, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    222Rn     210Rn     211Rn     212Rn */
  {222.0176, 222.0175, 209.9897, 210.9906, 211.9907, 0.0, 0.0, 0.0, 0.0},
/*    223Fr     212Fr     221Fr */
  {223.0197, 223.0198, 211.9960, 221.0142, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    226Ra */
  {226.0254, 226.0254, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    227Ac */
  {227.0277, 227.0278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    232Th     228Th     229Th     230Th */
  {232.0381, 232.0382, 228.0287, 229.0316, 230.0331, 0.0, 0.0, 0.0, 0.0},
/*    231Pa     234Pa */
  {231.03588, 231.0359, 234.0430, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    238U      234U      235U      236U */
  {238.0289, 238.0508, 234.0409, 235.0439, 236.0457, 0.0, 0.0, 0.0, 0.0},
/*    237Np     236Np */
  {237.0482, 237.0480, 236.0466, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    242Pu     239Pu     240Pu */
  {244.0642, 242.0587, 239.0522, 240.0540, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    243Am     241Am */
  {243.0614, 243.0614, 241.0567, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    246Cm     245Cm */
  {247.0703, 246.0674, 245.0653, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    247Bk */
  {247.0703, 247.0702, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    249Cf     250Cf */
  {251.0796, 249.0748, 250.0766, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    252Es     253Es     254Es */
  {252.0830, 252.0829, 253.0847, 254.0881, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    252Fm     250Fm     254Fm */
  {257.0951, 252.0827, 250.0795, 254.0870, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    255Md */
  {258.0984, 255.0906, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    259No */
  {259.1011, 259.100931, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    260Lr */
  {262.110, 260.105320, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    261Rf       257Rf       259Rf */
  {261.1089, 261.108690, 257.102950, 259.105530, 0.0, 0.0, 0.0, 0.0, 0.0},
/*    262Db       258Db */
  {262.1144, 262.113760, 258.109020, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*       Sg             */
  {263.1186, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*       Bh             */
  {264.12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*       Hs             */
  {265.1306, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
/*       Mt             */
  {268.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
char pse[LASTELEMENT][2] = {
  "H",  "He", "Li", "Be", "B",  "C",  "N",  "O",
  "F",  "Ne", "Na", "Mg", "Al", "Si", "P",  "S",
  "Cl", "Ar", "K",  "Ca", "Sc", "Ti", "V",  "Cr",
  "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge",
  "As", "Se", "Br", "Kr", "Rb", "Sr", "Y",  "Zr",
  "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd",
  "In", "Sn", "Sb", "Te", "I",  "Xe", "Cs", "Ba",
  "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd",
  "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf",
  "Ta", "W",  "Re", "Os", "Ir", "Pt", "Au", "Hg",
  "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra",
  "Ac", "Th", "Pa", "U",  "Np", "Pu", "Am", "Cm",
  "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf",
  "Db", "Sg", "Bh", "Hs", "Mt"};
int electrons[LASTELEMENT] = {
  1, 0,-1,-1,-1, 4, 5, 6,
  7, 0,-1,-1,-1, 4, 5, 6,
  7, 0,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1, 4,
 -1,-1, 7, 0,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1, 7, 0,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1, 0,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1};
