/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CompoundUndoManager
extends UndoManager {
    public static final int IDLE_DELAY_MS = 500;
    long startMillis = 0L;
    CompoundEdit comp = null;

    public synchronized boolean addEdit(UndoableEdit anEdit) {
        long now = System.currentTimeMillis();
        if (this.comp == null) {
            this.comp = new CompoundEdit();
        }
        this.comp.addEdit(anEdit);
        if (now - this.startMillis > 500L) {
            this.comp.end();
            super.addEdit(this.comp);
            this.comp = null;
        }
        this.startMillis = now;
        return true;
    }

    public synchronized boolean canRedo() {
        this.commitCompound();
        return super.canRedo();
    }

    public synchronized boolean canUndo() {
        this.commitCompound();
        return super.canUndo();
    }

    public synchronized void discardAllEdits() {
        this.comp = null;
        super.discardAllEdits();
    }

    public synchronized void redo() throws CannotRedoException {
        this.commitCompound();
        super.redo();
    }

    public synchronized void undo() throws CannotUndoException {
        this.commitCompound();
        super.undo();
    }

    private void commitCompound() {
        if (this.comp != null) {
            this.comp.end();
            super.addEdit(this.comp);
            this.comp = null;
        }
    }
}

