##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
##
# Version 0.2 # 
# Fixed regex to return multiple scripts
##
Plugin.define "Script-URLs" do
author "Brendan Coles <bcoles@gmail.com>" # 2010-10-14
version "0.2"
description "This plugin detects instances of script HTML elements and retrieves the URL."

# Google results as at 2010-10-14 #
# 384 for "your browser does not support javascript"

# Examples #
examples %w|
github.com
morningstarsecurity.com
twitter.com
wordpress.com
www.microsoft.com
|

# Matches #
matches [

# Extract source URL
{ :string=>/<script[^>]+src\s*=\s*["']?([^>^"^']+)/i },

]

end

