/* msm-render.h
 *
 * Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MSM_RENDER_H_
#define MSM_RENDER_H_

#include "msm.h"

#define MSM_BLIT_GEM 0x01
#define MSM_BLIT_FB  0x02
#define MSM_BLIT_PMEM  0x04

typedef struct {
  int width;
  int height;
  int format;
  int pitch;
  unsigned long priv[2];
  int flags;
} MSMBlitSurface;

typedef struct {
  int x, y, w, h;
} MSMBlitRect;

typedef struct {
  MSMBlitSurface *src;
  MSMBlitSurface *dst;
  MSMBlitRect *srcRect;
  MSMBlitRect *dstRect;
} MSMBlitRec;

BOOL isCopyMDPCompatible(MSMBlitRec *blit, int bpp);
void swBlit(MSMPtr,MSMBlitRec *blit, int bpp, BOOL blockSignalsForVFP);

void swBlit_NoOverlap(unsigned char * __restrict__ dst, unsigned char * __restrict__ src, int w, int h, int dpitch, int spitch, int bpp, BOOL blockSignalsForVFP);

void swFill(MSMPtr pMsm, int byteOffset, int destSurfaceWidthPixels,
            int x, int y, int w, int h, uint32_t src,
            int bitsPerPixel, BOOL blockSignalsForVFP);

void hwBlit(MSMPtr, MSMBlitRec *blit, int flags);
void hwBlitFlush(MSMPtr);
void hwBlitReset(void);

#endif
