% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{xgb.cb.early.stop}
\alias{xgb.cb.early.stop}
\title{Callback to activate early stopping}
\usage{
xgb.cb.early.stop(
  stopping_rounds,
  maximize = FALSE,
  metric_name = NULL,
  verbose = TRUE,
  keep_all_iter = TRUE
)
}
\arguments{
\item{stopping_rounds}{The number of rounds with no improvement in
the evaluation metric in order to stop the training.}

\item{maximize}{Whether to maximize the evaluation metric.}

\item{metric_name}{The name of an evaluation column to use as a criteria for early
stopping. If not set, the last column would be used.
Let's say the test data in \code{evals} was labelled as \code{dtest},
and one wants to use the AUC in test data for early stopping regardless of where
it is in the \code{evals}, then one of the following would need to be set:
\code{metric_name='dtest-auc'} or \code{metric_name='dtest_auc'}.
All dash '-' characters in metric names are considered equivalent to '_'.}

\item{verbose}{Whether to print the early stopping information.}

\item{keep_all_iter}{Whether to keep all of the boosting rounds that were produced
in the resulting object. If passing \code{FALSE}, will only keep the boosting rounds
up to the detected best iteration, discarding the ones that come after.}
}
\value{
An \code{xgb.Callback} object, which can be passed to \link{xgb.train} or \link{xgb.cv}.
}
\description{
This callback function determines the condition for early stopping.

The following attributes are assigned to the booster's object:
\itemize{
\item \code{best_score} the evaluation score at the best iteration
\item \code{best_iteration} at which boosting iteration the best score has occurred
(0-based index for interoperability of binary models)
}

The same values are also stored as R attributes as a result of the callback, plus an additional
attribute \code{stopped_by_max_rounds} which indicates whether an early stopping by the \code{stopping_rounds}
condition occurred. Note that the \code{best_iteration} that is stored under R attributes will follow
base-1 indexing, so it will be larger by '1' than the C-level 'best_iteration' that is accessed
through \link{xgb.attr} or \link{xgb.attributes}.

At least one dataset is required in \code{evals} for early stopping to work.
}
