.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
romanboy \- Draws a 3d immersion of the real projective plane that
smoothly deforms between the Roman surface and the Boy surface.
.SH SYNOPSIS
.B romanboy
[\-display \fIhost:display.screen\fP]
[\-install]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fIusecs\fP]
[\-fps]
[\-mode \fIdisplay-mode\fP]
[\-wireframe]
[\-surface]
[\-transparent]
[\-appearance \fIappearance\fP]
[\-solid]
[\-distance-bands]
[\-direction-bands]
[\-colors \fIcolor-scheme\fP]
[\-onesided-colors]
[\-twosided-colors]
[\-distance-colors]
[\-direction-colors]
[\-change-colors]
[\-view-mode \fIview-mode\fP]
[\-walk]
[\-turn]
[\-no-deform]
[\-deformation-speed \fIfloat\fP]
[\-initial-deformation \fIfloat\fP]
[\-roman]
[\-boy]
[\-surface-order \fInumber\fP]
[\-orientation-marks]
[\-projection \fImode\fP]
[\-perspective]
[\-orthographic]
[\-speed-x \fIfloat\fP]
[\-speed-y \fIfloat\fP]
[\-speed-z \fIfloat\fP]
[\-walk-direction \fIfloat\fP]
[\-walk-speed \fIfloat\fP]
.SH DESCRIPTION
The \fIromanboy\fP program shows a 3d immersion of the real projective
plane that smoothly deforms between the Roman surface and the Boy
surface.  You can walk on the projective plane or turn in 3d.  The
smooth deformation (homotopy) between these two famous immersions of
the real projective plane was constructed by Franois Apry.
.PP
The real projective plane is a non-orientable surface.  To make this
apparent, the two-sided color mode can be used.  Alternatively,
orientation markers (curling arrows) can be drawn as a texture map on
the surface of the projective plane.  While walking on the projective
plane, you will notice that the orientation of the curling arrows
changes (which it must because the projective plane is
non-orientable).
.PP
The real projective plane is a model for the projective geometry in 2d
space.  One point can be singled out as the origin.  A line can be
singled out as the line at infinity, i.e., a line that lies at an
infinite distance to the origin.  The line at infinity, like all lines
in the projective plane, is topologically a circle.  Points on the
line at infinity are also used to model directions in projective
geometry.  The origin can be visualized in different manners.  When
using distance colors (and using static colors), the origin is the
point that is displayed as fully saturated red, which is easier to see
as the center of the reddish area on the projective plane.
Alternatively, when using distance bands, the origin is the center of
the only band that projects to a disk.  When using direction bands,
the origin is the point where all direction bands collapse to a point.
Finally, when orientation markers are being displayed, the origin the
the point where all orientation markers are compressed to a point.
The line at infinity can also be visualized in different ways.  When
using distance colors (and using static colors), the line at infinity
is the line that is displayed as fully saturated magenta.  When
two-sided (and static) colors are used, the line at infinity lies at
the points where the red and green "sides" of the projective plane
meet (of course, the real projective plane only has one side, so this
is a design choice of the visualization).  Alternatively, when
orientation markers are being displayed, the line at infinity is the
place where the orientation markers change their orientation.
.PP
Note that when the projective plane is displayed with bands, the
orientation markers are placed in the middle of the bands.  For
distance bands, the bands are chosen in such a way that the band at
the origin is only half as wide as the remaining bands, which results
in a disk being displayed at the origin that has the same diameter as
the remaining bands.  This choice, however, also implies that the band
at infinity is half as wide as the other bands.  Since the projective
plane is attached to itself (in a complicated fashion) at the line at
infinity, effectively the band at infinity is again as wide as the
remaining bands.  However, since the orientation markers are displayed
in the middle of the bands, this means that only one half of the
orientation markers will be displayed twice at the line at infinity if
distance bands are used.  If direction bands are used or if the
projective plane is displayed as a solid surface, the orientation
markers are displayed fully at the respective sides of the line at
infinity.
.PP
The immersed projective plane can be projected to the screen either
perspectively or orthographically.  When using the walking modes,
perspective projection to the screen will be used.
.PP
There are three display modes for the projective plane: mesh
(wireframe), solid, or transparent.  Furthermore, the appearance of
the projective plane can be as a solid object or as a set of
see-through bands.  The bands can be distance bands, i.e., bands that
lie at increasing distances from the origin, or direction bands, i.e.,
bands that lie at increasing angles with respect to the origin.
.PP
When the projective plane is displayed with direction bands, you will
be able to see that each direction band (modulo the "pinching" at the
origin) is a Moebius strip, which also shows that the projective plane
is non-orientable.
.PP
Finally, the colors with with the projective plane is drawn can be set
to one-sided, two-sided, distance, or direction.  In one-sided mode,
the projective plane is drawn with the same color on both "sides."  In
two-sided mode (using static colors), the projective plane is drawn
with red on one "side" and green on the "other side."  As described
above, the projective plane only has one side, so the color jumps from
red to green along the line at infinity.  This mode enables you to see
that the projective plane is non-orientable.  If changing colors are
used in two-sided mode, changing complementary colors are used on the
respective "sides."  In distance mode, the projective plane is
displayed with fully saturated colors that depend on the distance of
the points on the projective plane to the origin.  If static colors
are used, the origin is displayed in red, while the line at infinity
is displayed in magenta.  If the projective plane is displayed as
distance bands, each band will be displayed with a different color.
In direction mode, the projective plane is displayed with fully
saturated colors that depend on the angle of the points on the
projective plane with respect to the origin.  Angles in opposite
directions to the origin (e.g., 15 and 205 degrees) are displayed in
the same color since they are projectively equivalent.  If the
projective plane is displayed as direction bands, each band will be
displayed with a different color.
.PP
The rotation speed for each of the three coordinate axes around which
the projective plane rotates can be chosen.
.PP
Furthermore, in the walking mode the walking direction in the 2d base
square of the projective plane and the walking speed can be chosen.
The walking direction is measured as an angle in degrees in the 2d
square that forms the coordinate system of the surface of the
projective plane.  A value of 0 or 180 means that the walk is along a
circle at a randomly chosen distance from the origin (parallel to a
distance band).  A value of 90 or 270 means that the walk is directly
from the origin to the line at infinity and back (analogous to a
direction band).  Any other value results in a curved path from the
origin to the line at infinity and back.
.PP
By default, the immersion of the real projective plane smoothly
deforms between the Roman and Boy surfaces.  It is possible to choose
the speed of the deformation.  Furthermore, it is possible to switch
the deformation off.  It is also possible to determine the initial
deformation of the immersion.  This is mostly useful if the
deformation is switched off, in which case it will determine the
appearance of the surface.
.PP
As a final option, it is possible to display generalized versions of
the immersion discussed above by specifying the order of the surface.
The default surface order of 3 results in the immersion of the real
projective described above.  The surface order can be chosen between 2
and 9.  Odd surface orders result in generalized immersions of the
real projective plane, while even numbers result in a immersion of a
topological sphere (which is orientable).  The most interesting even
case is a surface order of 2, which results in an immersion of the
halfway model of Morin's sphere eversion (if the deformation is
switched off).
.PP
This program is inspired by Franois Apry's book "Models of the Real
Projective Plane", Vieweg, 1987.
.SH OPTIONS
.I romanboy
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 10000, or 1/100th second.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.PP
The following four options are mutually exclusive.  They determine how
the projective plane is displayed.
.TP 8
.B \-mode random
Display the projective plane in a random display mode (default).
.TP 8
.B \-mode wireframe \fP(Shortcut: \fB\-wireframe\fP)
Display the projective plane as a wireframe mesh.
.TP 8
.B \-mode surface \fP(Shortcut: \fB\-surface\fP)
Display the projective plane as a solid surface.
.TP 8
.B \-mode transparent \fP(Shortcut: \fB\-transparent\fP)
Display the projective plane as a transparent surface.
.PP
The following four options are mutually exclusive.  They determine the
appearance of the projective plane.
.TP 8
.B \-appearance random
Display the projective plane with a random appearance (default).
.TP 8
.B \-appearance solid \fP(Shortcut: \fB\-solid\fP)
Display the projective plane as a solid object.
.TP 8
.B \-appearance distance-bands \fP(Shortcut: \fB\-distance-bands\fP)
Display the projective plane as see-through bands that lie at
increasing distances from the origin.
.PP
.TP 8
.B \-appearance direction-bands \fP(Shortcut: \fB\-direction-bands\fP)
Display the projective plane as see-through bands that lie at
increasing angles with respect to the origin.
.PP
The following four options are mutually exclusive.  They determine how
to color the projective plane.
.TP 8
.B \-colors random
Display the projective plane with a random color scheme (default).
.TP 8
.B \-colors onesided \fP(Shortcut: \fB\-onesided-colors\fP)
Display the projective plane with a single color.
.TP 8
.B \-colors twosided \fP(Shortcut: \fB\-twosided-colors\fP)
Display the projective plane with two colors: one color one "side" and
the complementary color on the "other side."  For static colors, the
colors are red and green.  Note that the line at infinity lies at the
points where the red and green "sides" of the projective plane meet,
i.e., where the orientation of the projective plane reverses.
.TP 8
.B \-colors distance \fP(Shortcut: \fB\-distance-colors\fP)
Display the projective plane with fully saturated colors that depend
on the distance of the points on the projective plane to the origin.
For static colors, the origin is displayed in red, while the line at
infinity is displayed in magenta.  If the projective plane is
displayed as distance bands, each band will be displayed with a
different color.
.TP 8
.B \-colors direction \fP(Shortcut: \fB\-direction-colors\fP)
Display the projective plane with fully saturated colors that depend
on the angle of the points on the projective plane with respect to the
origin.  Angles in opposite directions to the origin (e.g., 15 and 205
degrees) are displayed in the same color since they are projectively
equivalent.  If the projective plane is displayed as direction bands,
each band will be displayed with a different color.
.PP
The following options determine whether the colors with which the
projective plane is displayed are static or are changing dynamically.
.TP 8
.B \-change-colors
Change the colors with which the projective plane is displayed
dynamically.
.TP 8
.B \-no-change-colors
Use static colors to display the projective plane (default).
.PP
The following three options are mutually exclusive.  They determine
how to view the projective plane.
.TP 8
.B \-view-mode random
View the projective plane in a random view mode (default).
.TP 8
.B \-view-mode turn \fP(Shortcut: \fB\-turn\fP)
View the projective plane while it turns in 3d.
.TP 8
.B \-view-mode walk \fP(Shortcut: \fB\-walk\fP)
View the projective plane as if walking on its surface.
.PP
The following options determine whether the surface is being deformed.
.TP 8
.B \-deform
Deform the surface smoothly between the Roman and Boy surfaces
(default).
.TP 8
.B \-no-deform
Don't deform the surface.
.PP
The following option determines the deformation speed.
.TP 8
.B \-deformation-speed \fIfloat\fP
The deformation speed is measured in percent of some sensible maximum
speed (default: 10.0).
.PP
The following options determine the initial deformation of the
surface.  As described above, this is mostly useful if
\fB\-no-deform\fP is specified.
.TP 8
.B \-initial-deformation \fIfloat\fP
The initial deformation is specified as a number between 0 and 1000.
A value of 0 corresponds to the Roman surface, while a value of 1000
corresponds to the Boy surface.  The default value is 1000.
.TP 8
.B \-roman
This is a shortcut for \fB\-initial-deformation 0\fP.
.TP 8
.B \-boy
This is a shortcut for \fB\-initial-deformation 1000\fP.
.PP
The following option determines the order of the surface to be
displayed.
.TP 8
.B \-surface-order \fInumber\fP
The surface order can be set to values between 2 and 9 (default: 3).
As described above, odd surface orders result in generalized
immersions of the real projective plane, while even numbers result in
a immersion of a topological sphere.
.PP
The following options determine whether orientation marks are shown on
the projective plane.
.TP 8
.B \-orientation-marks
Display orientation marks on the projective plane.
.TP 8
.B \-no-orientation-marks
Don't display orientation marks on the projective plane (default).
.PP
The following three options are mutually exclusive.  They determine
how the projective plane is projected from 3d to 2d (i.e., to the
screen).
.TP 8
.B \-projection random
Project the projective plane from 3d to 2d using a random projection
mode (default).
.TP 8
.B \-projection perspective \fP(Shortcut: \fB\-perspective\fP)
Project the projective plane from 3d to 2d using a perspective
projection.
.TP 8
.B \-projection orthographic \fP(Shortcut: \fB\-orthographic\fP)
Project the projective plane from 3d to 2d using an orthographic
projection.
.PP
The following three options determine the rotation speed of the
projective plane around the three possible axes.  The rotation speed
is measured in degrees per frame.  The speeds should be set to
relatively small values, e.g., less than 4 in magnitude.  In walk
mode, all speeds are ignored.
.TP 8
.B \-speed-x \fIfloat\fP
Rotation speed around the x axis (default: 1.1).
.TP 8
.B \-speed-y \fIfloat\fP
Rotation speed around the y axis (default: 1.3).
.TP 8
.B \-speed-z \fIfloat\fP
Rotation speed around the z axis (default: 1.5).
.PP
The following two options determine the walking speed and direction.
.TP 8
.B \-walk-direction \fIfloat\fP
The walking direction is measured as an angle in degrees in the 2d
square that forms the coordinate system of the surface of the
projective plane (default: 83.0).  A value of 0 or 180 means that the
walk is along a circle at a randomly chosen distance from the origin
(parallel to a distance band).  A value of 90 or 270 means that the
walk is directly from the origin to the line at infinity and back
(analogous to a direction band).  Any other value results in a curved
path from the origin to the line at infinity and back.
.TP 8
.B \-walk-speed \fIfloat\fP
The walking speed is measured in percent of some sensible maximum
speed (default: 20.0).
.SH INTERACTION
If you run this program in standalone mode in its turn mode, you can
rotate the projective plane by dragging the mouse while pressing the
left mouse button.  This rotates the projective plane in 3d.  To
examine the projective plane at your leisure, it is best to set all
speeds to 0.  Otherwise, the projective plane will rotate while the
left mouse button is not pressed.  This kind of interaction is not
available in the walk mode.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2013-2020 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 06-jan-2020.
