/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import IceInternal.RouterInfo;
import java.util.Enumeration;
import java.util.Hashtable;

public final class RouterManager {
    private Hashtable _table = new Hashtable();

    RouterManager() {
    }

    synchronized void destroy() {
        Enumeration enumeration = this._table.elements();
        while (enumeration.hasMoreElements()) {
            RouterInfo routerInfo = (RouterInfo)enumeration.nextElement();
            routerInfo.destroy();
        }
        this._table.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterInfo get(RouterPrx routerPrx) {
        if (routerPrx == null) {
            return null;
        }
        RouterPrx routerPrx2 = RouterPrxHelper.uncheckedCast(routerPrx.ice_router(null));
        RouterManager routerManager = this;
        synchronized (routerManager) {
            RouterInfo routerInfo = (RouterInfo)this._table.get(routerPrx2);
            if (routerInfo == null) {
                routerInfo = new RouterInfo(routerPrx2);
                this._table.put(routerPrx2, routerInfo);
            }
            return routerInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterInfo erase(RouterPrx routerPrx) {
        RouterInfo routerInfo = null;
        if (routerPrx != null) {
            RouterPrx routerPrx2 = RouterPrxHelper.uncheckedCast(routerPrx.ice_router(null));
            RouterManager routerManager = this;
            synchronized (routerManager) {
                routerInfo = (RouterInfo)this._table.remove(routerPrx2);
            }
        }
        return routerInfo;
    }
}

