/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;

public final class Network {
    public static boolean connectionLost(IOException iOException) {
        String string = iOException.getMessage();
        if (string != null) {
            string = string.toLowerCase();
            String[] stringArray = new String[]{"connection reset by peer", "cannot send after socket shutdown", "cannot send after transport endpoint shutdown", "software caused connection abort", "an existing connection was forcibly closed"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean connectionRefused(IOException iOException) {
        String string = iOException.getMessage();
        if (string != null) {
            string = string.toLowerCase();
            String[] stringArray = new String[]{"connection refused"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean notConnected(IOException iOException) {
        String string = iOException.getMessage().toLowerCase();
        return string.indexOf("transport endpoint is not connected") != -1;
    }

    public static String getLocalHost(boolean bl) {
        String string = System.getProperty("microedition.hostname");
        if (string == null) {
            string = "127.0.0.1";
        }
        return string;
    }

    public static byte[] getLocalAddress() {
        byte[] byArray = new byte[]{127, 0, 0, 1};
        return byArray;
    }

    public static String toString(SocketConnection socketConnection) {
        if (socketConnection == null) {
            return "<closed>";
        }
        try {
            String string = socketConnection.getLocalAddress();
            int n = socketConnection.getLocalPort();
            String string2 = socketConnection.getAddress();
            int n2 = socketConnection.getPort();
            return Network.addressesToString(string, n, string2, n2);
        }
        catch (IOException iOException) {
            return "<closed>";
        }
    }

    public static String toString(ServerSocketConnection serverSocketConnection) {
        if (serverSocketConnection == null) {
            return "<closed>";
        }
        try {
            return serverSocketConnection.getLocalAddress() + ":" + serverSocketConnection.getLocalPort();
        }
        catch (IOException iOException) {
            return "<closed>";
        }
    }

    public static String addressesToString(String string, int n, String string2, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("local address = ");
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(n);
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append("\nremote address = <not connected>");
        } else {
            stringBuffer.append("\nremote address = ");
            stringBuffer.append(string2);
            stringBuffer.append(':');
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public static byte[] addrStringToIP(String string) {
        if (string.length() < "1.1.1.1".length()) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer[] stringBufferArray = new StringBuffer[4];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '.') {
                if (++n <= 3) continue;
                return null;
            }
            if (!Character.isDigit(cArray[i])) {
                return null;
            }
            if (stringBufferArray[n] == null) {
                stringBufferArray[n] = new StringBuffer(3);
            }
            stringBufferArray[n].append(cArray[i]);
            if (stringBufferArray[n].length() <= 3) continue;
            return null;
        }
        if (n != 3) {
            return null;
        }
        byte[] byArray = new byte[stringBufferArray.length];
        for (int i = 0; i < stringBufferArray.length; ++i) {
            try {
                Integer n2 = Integer.valueOf(stringBufferArray[i].toString());
                if (n2 < 0 || n2 > 255) {
                    return null;
                }
                byArray[i] = n2.byteValue();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return byArray;
    }

    public static boolean interrupted(IOException iOException) {
        return iOException instanceof InterruptedIOException || iOException.getMessage().indexOf("Interrupted system call") >= 0;
    }
}

