/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Copyright 2006 Ricardo Correia.
 * Use is subject to license terms.
 */

#ifndef _SOL_KERN_SYS_IDMAP_H
#define _SOL_KERN_SYS_IDMAP_H

#include <stdlib.h>
#include <sys/idmap.h>

typedef int idmap_get_handle_t;
typedef int idmap_stat;

#define kidmap_get_create(zone) (abort(), NULL)
#define kidmap_get_destroy(gh)  (abort())

#define kidmap_get_mappings(gh) (abort(), 0)

#define kidmap_getuidbysid(zone,sp,rid,uid) (abort(), 0)
#define kidmap_getgidbysid(zone,sp,rid,gid) (abort(), 0)

#define kidmap_getsidbyuid(zone,uid,sp,rid) (abort(), 0)
#define kidmap_getsidbygid(zone,uid,sp,rid) (abort(), 0)

#define kidmap_batch_getuidbysid(gh,sp,rid,uid,s) (abort(), 0)
#define kidmap_batch_getgidbysid(gh,sp,rid,gid,s) (abort(), 0)

#endif
