
package ONVIF::Device::Elements::MetadataConfiguration;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/schema' }

__PACKAGE__->__set_name('MetadataConfiguration');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    ONVIF::Device::Types::MetadataConfiguration
);

}

1;


=pod

=head1 NAME

ONVIF::Device::Elements::MetadataConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
MetadataConfiguration from the namespace http://www.onvif.org/ver10/schema.







=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::MetadataConfiguration->new($data);

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::MetadataConfiguration
   PTZStatus =>  { # ONVIF::Device::Types::PTZFilter
     Status =>  $some_value, # boolean
     Position =>  $some_value, # boolean
   },
   Analytics =>  $some_value, # boolean
   Multicast =>  { # ONVIF::Device::Types::MulticastConfiguration
     Address =>  { # ONVIF::Device::Types::IPAddress
       Type => $some_value, # IPType
       IPv4Address => $some_value, # IPv4Address
       IPv6Address => $some_value, # IPv6Address
     },
     Port =>  $some_value, # int
     TTL =>  $some_value, # int
     AutoStart =>  $some_value, # boolean
   },
   SessionTimeout =>  $some_value, # duration
   AnalyticsEngineConfiguration =>  { # ONVIF::Device::Types::AnalyticsEngineConfiguration
     AnalyticsModule =>  { # ONVIF::Device::Types::Config
       Parameters =>  { # ONVIF::Device::Types::ItemList
         SimpleItem => ,
         ElementItem =>  {
         },
         Extension =>  { # ONVIF::Device::Types::ItemListExtension
         },
       },
     },
     Extension =>  { # ONVIF::Device::Types::AnalyticsEngineConfigurationExtension
     },
   },
   Extension =>  { # ONVIF::Device::Types::MetadataConfigurationExtension
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

