package ONVIF::Device::Types::H264Options;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ResolutionsAvailable_of :ATTR(:get<ResolutionsAvailable>);
my %GovLengthRange_of :ATTR(:get<GovLengthRange>);
my %FrameRateRange_of :ATTR(:get<FrameRateRange>);
my %EncodingIntervalRange_of :ATTR(:get<EncodingIntervalRange>);
my %H264ProfilesSupported_of :ATTR(:get<H264ProfilesSupported>);

__PACKAGE__->_factory(
    [ qw(        ResolutionsAvailable
        GovLengthRange
        FrameRateRange
        EncodingIntervalRange
        H264ProfilesSupported

    ) ],
    {
        'ResolutionsAvailable' => \%ResolutionsAvailable_of,
        'GovLengthRange' => \%GovLengthRange_of,
        'FrameRateRange' => \%FrameRateRange_of,
        'EncodingIntervalRange' => \%EncodingIntervalRange_of,
        'H264ProfilesSupported' => \%H264ProfilesSupported_of,
    },
    {
        'ResolutionsAvailable' => 'ONVIF::Device::Types::VideoResolution',
        'GovLengthRange' => 'ONVIF::Device::Types::IntRange',
        'FrameRateRange' => 'ONVIF::Device::Types::IntRange',
        'EncodingIntervalRange' => 'ONVIF::Device::Types::IntRange',
        'H264ProfilesSupported' => 'ONVIF::Device::Types::H264Profile',
    },
    {

        'ResolutionsAvailable' => 'ResolutionsAvailable',
        'GovLengthRange' => 'GovLengthRange',
        'FrameRateRange' => 'FrameRateRange',
        'EncodingIntervalRange' => 'EncodingIntervalRange',
        'H264ProfilesSupported' => 'H264ProfilesSupported',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::H264Options

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
H264Options from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ResolutionsAvailable


=item * GovLengthRange


=item * FrameRateRange


=item * EncodingIntervalRange


=item * H264ProfilesSupported




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::H264Options
   ResolutionsAvailable =>  { # ONVIF::Device::Types::VideoResolution
     Width =>  $some_value, # int
     Height =>  $some_value, # int
   },
   GovLengthRange =>  { # ONVIF::Device::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
   FrameRateRange =>  { # ONVIF::Device::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
   EncodingIntervalRange =>  { # ONVIF::Device::Types::IntRange
     Min =>  $some_value, # int
     Max =>  $some_value, # int
   },
   H264ProfilesSupported => $some_value, # H264Profile
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

