; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f -target-abi ilp32f -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32IF %s
; RUN: llc -mtriple=riscv64 -mattr=+f -target-abi lp64f -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64IF %s

; These test that we can use both the architectural names (x*) and the ABI names
; (a*, s*, t* etc) to refer to registers in inline asm constraint lists. In each
; case, the named register should be used for the source register of the `addi`.
; It is very likely that `a0` will be chosen as the designation register, but
; this is left to the compiler to choose.
;
; The inline assembly will, by default, contain the ABI names for the registers.
;
; Parenthesised registers in comments are the other aliases for this register.


define i32 @explicit_register_f0(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f0:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft0, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft0
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f0:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft0, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft0
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f0}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft0(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft0:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft0, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft0
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft0:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft0, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft0
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft0}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f1(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f1:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft1, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft1
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f1:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft1, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft1
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f1}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft1(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft1:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft1, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft1
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft1:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft1, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft1
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft1}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f2(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f2:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft2, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft2
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f2:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft2, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft2
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f2}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft2(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft2:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft2, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft2
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft2:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft2, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft2
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft2}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f3(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f3:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft3, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft3
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f3:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft3, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft3
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f3}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft3(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft3:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft3, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft3
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft3:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft3, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft3
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft3}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f4(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f4:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft4, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft4
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f4:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft4, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft4
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f4}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft4(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft4:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft4, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft4
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft4:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft4, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft4
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft4}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f5(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f5:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft5, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft5
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f5:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft5, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft5
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f5}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft5(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft5:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft5, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft5
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft5:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft5, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft5
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft5}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f6(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f6:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft6, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft6
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f6:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft6, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft6
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f6}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft6(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft6:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft6, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft6
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft6:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft6, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft6
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft6}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f7(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f7:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft7, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft7
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f7:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft7, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft7
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f7}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft7(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft7:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft7, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft7
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft7:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft7, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft7
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft7}"(float %a)
  ret i32 %1
}


; NOTE: This test uses `f8` (`fs0`) as an input, so it should be saved.
define i32 @explicit_register_f8(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f8:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs0, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs0
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs0, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f8:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs0, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs0, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs0
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs0, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f8}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs0` (`f8`) as an input, so it should be saved.
define i32 @explicit_register_fs0(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs0:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs0, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs0, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs0
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs0, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs0:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs0, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs0, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs0
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs0, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs0}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f9` (`fs1`) as an input, so it should be saved.
define i32 @explicit_register_f9(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f9:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs1, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs1, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs1
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs1, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f9:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs1, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs1, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs1
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs1, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f9}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs1` (`f9`) as an input, so it should be saved.
define i32 @explicit_register_fs1(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs1:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs1, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs1, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs1
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs1, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs1:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs1, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs1, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs1
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs1, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs1}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f10(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f10:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa0
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f10:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa0
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f10}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_fa0(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fa0:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa0
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fa0:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa0
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fa0}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f11(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f11:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa1, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa1
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f11:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa1, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa1
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f11}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_fa1(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fa1:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa1, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa1
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fa1:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa1, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa1
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fa1}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f12(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f12:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa2, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa2
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f12:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa2, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa2
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f12}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_fa2(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fa2:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa2, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa2
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fa2:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa2, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa2
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fa2}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f13(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f13:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa3, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa3
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f13:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa3, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa3
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f13}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_fa3(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fa3:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa3, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa3
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fa3:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa3, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa3
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fa3}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f14(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f14:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa4, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa4
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f14:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa4, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa4
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f14}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_fa4(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fa4:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa4, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa4
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fa4:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa4, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa4
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fa4}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f15(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f15:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa5, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa5
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f15:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa5, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa5
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f15}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_fa5(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fa5:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa5, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa5
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fa5:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa5, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa5
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fa5}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f16(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f16:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa6, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa6
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f16:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa6, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa6
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f16}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_fa6(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fa6:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa6, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa6
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fa6:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa6, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa6
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fa6}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f17(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f17:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa7, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa7
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f17:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa7, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa7
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f17}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_fa7(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fa7:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s fa7, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fa7
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fa7:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s fa7, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fa7
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fa7}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f18` (`fs2`) as an input, so it should be saved.
define i32 @explicit_register_f18(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f18:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs2, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs2, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs2
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs2, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f18:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs2, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs2, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs2
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs2, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f18}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs2` (`f18`) as an input, so it should be saved.
define i32 @explicit_register_fs2(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs2:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs2, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs2, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs2
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs2, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs2:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs2, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs2, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs2
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs2, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs2}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f19` (`fs3`) as an input, so it should be saved.
define i32 @explicit_register_f19(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f19:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs3, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs3, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs3
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs3, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f19:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs3, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs3, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs3
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs3, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f19}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs3` (`f19`) as an input, so it should be saved.
define i32 @explicit_register_fs3(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs3:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs3, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs3, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs3
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs3, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs3:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs3, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs3, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs3
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs3, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs3}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f20` (`fs4`) as an input, so it should be saved.
define i32 @explicit_register_f20(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f20:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs4, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs4, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs4
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs4, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f20:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs4, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs4, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs4
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs4, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f20}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs4` (`f20`) as an input, so it should be saved.
define i32 @explicit_register_fs4(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs4:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs4, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs4, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs4
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs4, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs4:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs4, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs4, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs4
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs4, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs4}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f21` (`fs5`) as an input, so it should be saved.
define i32 @explicit_register_f21(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f21:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs5, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs5, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs5
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs5, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f21:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs5, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs5, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs5
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs5, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f21}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs5` (`f21`) as an input, so it should be saved.
define i32 @explicit_register_fs5(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs5:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs5, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs5, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs5
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs5, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs5:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs5, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs5, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs5
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs5, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs5}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f22` (`fs6`) as an input, so it should be saved.
define i32 @explicit_register_f22(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f22:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs6, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs6, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs6
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs6, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f22:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs6, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs6, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs6
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs6, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f22}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs6` (`f22`) as an input, so it should be saved.
define i32 @explicit_register_fs6(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs6:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs6, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs6, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs6
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs6, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs6:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs6, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs6, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs6
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs6, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs6}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f23` (`fs7`) as an input, so it should be saved.
define i32 @explicit_register_f23(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f23:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs7, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs7, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs7
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs7, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f23:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs7, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs7, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs7
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs7, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f23}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs7` (`f23`) as an input, so it should be saved.
define i32 @explicit_register_fs7(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs7:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs7, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs7, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs7
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs7, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs7:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs7, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs7, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs7
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs7, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs7}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f24` (`fs8`) as an input, so it should be saved.
define i32 @explicit_register_f24(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f24:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs8, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs8, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs8
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs8, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f24:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs8, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs8, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs8
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs8, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f24}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs8` (`f24`) as an input, so it should be saved.
define i32 @explicit_register_fs8(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs8:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs8, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs8, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs8
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs8, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs8:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs8, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs8, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs8
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs8, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs8}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f25` (`fs9`) as an input, so it should be saved.
define i32 @explicit_register_f25(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f25:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs9, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs9, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs9
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs9, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f25:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs9, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs9, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs9
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs9, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f25}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs9` (`f25`) as an input, so it should be saved.
define i32 @explicit_register_fs9(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs9:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs9, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs9, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs9
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs9, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs9:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs9, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs9, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs9
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs9, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs9}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f26` (`fs10`) as an input, so it should be saved.
define i32 @explicit_register_f26(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f26:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs10, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs10, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs10
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs10, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f26:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs10, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs10, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs10
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs10, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f26}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs10` (`f26`) as an input, so it should be saved.
define i32 @explicit_register_fs10(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs10:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs10, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs10, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs10
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs10, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs10:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs10, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs10, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs10
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs10, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs10}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `f27` (`fs11`) as an input, so it should be saved.
define i32 @explicit_register_f27(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f27:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs11, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs11, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs11
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs11, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f27:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs11, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs11, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs11
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs11, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f27}"(float %a)
  ret i32 %1
}

; NOTE: This test uses `fs11` (`f27`) as an input, so it should be saved.
define i32 @explicit_register_fs11(float %a) nounwind {
; RV32IF-LABEL: explicit_register_fs11:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    addi sp, sp, -16
; RV32IF-NEXT:    fsw fs11, 12(sp) # 4-byte Folded Spill
; RV32IF-NEXT:    fmv.s fs11, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, fs11
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    flw fs11, 12(sp) # 4-byte Folded Reload
; RV32IF-NEXT:    addi sp, sp, 16
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_fs11:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    addi sp, sp, -16
; RV64IF-NEXT:    fsw fs11, 12(sp) # 4-byte Folded Spill
; RV64IF-NEXT:    fmv.s fs11, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, fs11
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    flw fs11, 12(sp) # 4-byte Folded Reload
; RV64IF-NEXT:    addi sp, sp, 16
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{fs11}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f28(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f28:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft8, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft8
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f28:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft8, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft8
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f28}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft8(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft8:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft8, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft8
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft8:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft8, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft8
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft8}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f29(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f29:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft9, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft9
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f29:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft9, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft9
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f29}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft9(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft9:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft9, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft9
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft9:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft9, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft9
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft9}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f30(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f30:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft10, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft10
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f30:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft10, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft10
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f30}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft10(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft10:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft10, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft10
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft10:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft10, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft10
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft10}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_f31(float %a) nounwind {
; RV32IF-LABEL: explicit_register_f31:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft11, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft11
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_f31:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft11, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft11
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{f31}"(float %a)
  ret i32 %1
}

define i32 @explicit_register_ft11(float %a) nounwind {
; RV32IF-LABEL: explicit_register_ft11:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fmv.s ft11, fa0
; RV32IF-NEXT:    #APP
; RV32IF-NEXT:    fcvt.w.s a0, ft11
; RV32IF-NEXT:    #NO_APP
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: explicit_register_ft11:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fmv.s ft11, fa0
; RV64IF-NEXT:    #APP
; RV64IF-NEXT:    fcvt.w.s a0, ft11
; RV64IF-NEXT:    #NO_APP
; RV64IF-NEXT:    ret
  %1 = tail call i32 asm "fcvt.w.s $0, $1", "=r,{ft11}"(float %a)
  ret i32 %1
}
