/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.adapter;

import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.SortedMap;
import com.github.andrewoma.dexx.collection.internal.adapter.MapAdapter;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class SortedMapAdapter<K, V>
extends MapAdapter<K, V>
implements java.util.SortedMap<K, V> {
    private SortedMap<K, V> map;

    public SortedMapAdapter(SortedMap<K, V> map) {
        super(map);
        this.map = map;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.map.comparator();
    }

    @Override
    @NotNull
    public java.util.SortedMap<K, V> subMap(@NotNull K fromKey, @NotNull K toKey) {
        return new SortedMapAdapter<K, V>(this.map.range(fromKey, true, toKey, false));
    }

    @Override
    @NotNull
    public java.util.SortedMap<K, V> headMap(@NotNull K toKey) {
        return new SortedMapAdapter<K, V>(this.map.to(toKey, false));
    }

    @Override
    @NotNull
    public java.util.SortedMap<K, V> tailMap(@NotNull K fromKey) {
        return new SortedMapAdapter<K, V>(this.map.from(fromKey, true));
    }

    @Override
    public K firstKey() {
        Pair<K, V> first = this.map.first();
        if (first == null) {
            throw new NoSuchElementException("Empty map");
        }
        return first.component1();
    }

    @Override
    public K lastKey() {
        Pair<K, V> last = this.map.last();
        if (last == null) {
            throw new NoSuchElementException("Empty map");
        }
        return last.component1();
    }
}

