#ifndef _ES2FBUFFEROBJECTQUERYTESTS_HPP
#define _ES2FBUFFEROBJECTQUERYTESTS_HPP
/*-------------------------------------------------------------------------
 * drawElements Quality Program OpenGL ES 2.0 Module
 * -------------------------------------------------
 *
 * Copyright 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *//*!
 * \file
 * \brief Buffer Object Query tests.
 *//*--------------------------------------------------------------------*/

#include "tcuDefs.hpp"
#include "tes2TestCase.hpp"

namespace deqp
{
namespace gles2
{
namespace Functional
{
namespace BufferParamVerifiers
{

class GetBufferParameterIVerifier;

} // BufferParamVerifiers

class BufferObjectQueryTests : public TestCaseGroup
{
public:
																		BufferObjectQueryTests	(Context& context);
																		~BufferObjectQueryTests	(void);

	void																init					(void);
	void																deinit					(void);

private:
																		BufferObjectQueryTests	(const BufferObjectQueryTests& other);
	BufferObjectQueryTests&												operator=				(const BufferObjectQueryTests& other);

	BufferParamVerifiers::GetBufferParameterIVerifier*					m_verifierInt;
};

} // Functional
} // gles2
} // deqp

#endif // _ES2FBUFFEROBJECTQUERYTESTS_HPP
