// vim:expandtab:shiftwidth=2:tabstop=2:
// Copyright (C) 2016 Canonical Ltd.

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _OXIDE_QT_CORE_BROWSER_SCREEN_H_
#define _OXIDE_QT_CORE_BROWSER_SCREEN_H_

#include <map>

#include <QObject>
#include <QtGlobal>
#if defined(USE_QINPUTDEVICE)
#include <QInputDevice>
#endif

#include "base/macros.h"

#include "qt/core/common/oxide_qt_export.h"
#include "shared/browser/screen.h"

QT_BEGIN_NAMESPACE
class QPlatformScreen;
class QScreen;
QT_END_NAMESPACE

namespace oxide {
namespace qt {

class OXIDE_QT_EXPORT Screen : public QObject,
                               public oxide::Screen {
  Q_OBJECT

 public:
  Screen();
  ~Screen() override;

  static Screen* GetInstance();

  display::Display DisplayFromQScreen(QScreen* screen) const;

  // oxide::Screen implementation
  display::Display GetPrimaryDisplay() override;
  std::vector<display::Display> GetAllDisplays() override;
  gfx::Point GetCursorScreenPoint() override;
  oxide::DisplayFormFactor GetDisplayFormFactor(
      const display::Display& display) override;

  static void SetEnableQtUbuntuIntegrationForTesting(bool enable);

 protected :
  ShellMode GetShellMode() override;

 private Q_SLOTS:
  void OnScreenAdded(QScreen* screen);
  void OnScreenRemoved(QScreen* screen);
  void OnPrimaryScreenChanged(QScreen* screen);
#if defined(USE_QINPUTDEVICE)
  void OnInputDeviceAdded(QInputDevice* device);
  void OnInputDeviceRemoved(const QString& deviceId);
  void OnInputDevicesReady();
#endif
  void OnPlatformScreenPropertyChanged(QPlatformScreen* screen,
                                       const QString& property_name);

 private:
  QScreen* QScreenFromDisplay(const display::Display& display) const;
  void UpdateDisplayForScreen(QScreen* screen);
#if defined(USE_QINPUTDEVICE)
  bool GetShellModeFromInputDevices(ShellMode* mode);
#endif

#if QT_VERSION >= QT_VERSION_CHECK(5, 4, 0)
  std::map<QScreen*, display::Display> displays_;
#endif
#if defined(USE_QINPUTDEVICE)
  QInputInfoManager input_device_manager_;
#endif
  oxide::ShellMode current_shell_mode_;
};

} // namespace qt
} // namespace oxide

#endif // _OXIDE_QT_CORE_BROWSER_SCREEN_H_
