// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_TEST_TEST_SCREEN_H_
#define UI_DISPLAY_TEST_TEST_SCREEN_H_

#include <vector>

#include "base/macros.h"
#include "ui/display/display.h"
#include "ui/display/screen_base.h"

namespace display {
namespace test {

// A dummy implementation of Screen that contains a single
// Display only. The contained Display can be accessed and modified via
// TestScreen::display().
//
// NOTE: Adding and removing DisplayOberver's are no-ops and observers
// will NOT be notified ever.
class TestScreen : public ScreenBase {
 public:
  TestScreen();
  ~TestScreen() override;

  // Screen:
  gfx::Point GetCursorScreenPoint() override;
  bool IsWindowUnderCursor(gfx::NativeWindow window) override;
  gfx::NativeWindow GetWindowAtScreenPoint(const gfx::Point& point) override;
  Display GetDisplayNearestWindow(gfx::NativeView view) const override;

 private:
  DISALLOW_COPY_AND_ASSIGN(TestScreen);
};

}  // namespace test
}  // namespace display

#endif  // UI_DISPLAY_TEST_TEST_SCREEN_H_
