# Scour

Scour is a Python module that takes an input SVG and outputs a cleaner,
more concise SVG file.  The goal is that authors will use this script after
editing the file in a GUI editor such as Inkscape or Adobe Illustrator.

Scour was started as a vehicle for me to learn Python.  In addition, the goal
is to reduce the amount of time I spend in cleaning up files I find on sites
such as openclipart.org

Ideas are pulled from three places:

  * my head
  * Sam Ruby's SVG Tidy script: http://intertwingly.net/code/svgtidy/svgtidy.rb
  * Inkscape's proposal for a 'cleaned SVG': http://wiki.inkscape.org/wiki/index.php/Save_Cleaned_SVG

Regards,

Jeff Schiller, 2009-04-06

codedread@gmail.com

http://blog.codedread.com/

http://www.codedread.com/scour/

## Usage

Standard:

	scour -i mysvg.svg -o mysvg_opt.svg

Better (this works in IE which needs Viewbox):

	scour -i mysvg.svg -o mysvg_opt.svg --enable-viewboxing

Maximum:

	scour -i mysvg.svg -o mysvg_opt.svg --enable-viewboxing --enable-id-stripping \
          --enable-comment-stripping --shorten-ids --indent=none

Maximum + Compress:

	scour -i mysvg.svg -o mysvg_opt.svgz --enable-viewboxing --enable-id-stripping \
          --enable-comment-stripping --shorten-ids --indent=none

## Notes

Packaging from [sources](http://www.codedread.com/scour/) retrieved on 2013/20/22:

  * done by Tavendo GmbH, Tobias Oberstein
  * license same as upstream (Apache 2.0)
  * now official repo, please see [here](https://github.com/codedread/scour/issues/11)
