// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (C) 2017, Bin Meng <bmeng.cn@gmail.com>
 */

#include <asm/arch/gpio.h>
#include <asm/fsp1/fsp_support.h>

static const struct gpio_family gpio_family[] = {
	GPIO_FAMILY_CONF("SOUTHEAST_2_hshvfamily_2x3_rcomp_7_0", NA, 0,
			 VOLT_1_8, NA, NA, NA, 0, ENABLE, 2, SOUTHEAST),

	/* end of the table */
	GPIO_FAMILY_CONF("GPIO FAMILY TABLE END", NA, 0,
			 VOLT_1_8, NA, NA, NA, 0, DISABLE, 0, TERMINATOR),
};

static const struct gpio_pad gpio_pad[] = {
	GPIO_PAD_CONF("N37: CX_PRDY_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 29, NA, 0x4c38, NORTH),
	GPIO_PAD_CONF("N35: CX_PRDY_B_2", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 27, NA, 0x4c28, NORTH),
	GPIO_PAD_CONF("N39: CX_PREQ_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 20, NA, 0x4858, NORTH),
	GPIO_PAD_CONF("N48: GP_CAMERASB00", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 37, NA, 0x5018, NORTH),
	GPIO_PAD_CONF("N53: GP_CAMERASB01", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 42, NA, 0x5040, NORTH),
	GPIO_PAD_CONF("N46: GP_CAMERASB02", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 35, NA, 0x5008, NORTH),
	GPIO_PAD_CONF("N51: GP_CAMERASB03", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 40, NA, 0x5030, NORTH),
	GPIO_PAD_CONF("N56: GP_CAMERASB04", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 45, NA, 0x5058, NORTH),
	GPIO_PAD_CONF("N45: GP_CAMERASB05", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 34, NA, 0x5000, NORTH),
	GPIO_PAD_CONF("N49: GP_CAMERASB06", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 38, NA, 0x5020, NORTH),
	GPIO_PAD_CONF("N54: GP_CAMERASB07", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 43, NA, 0x5048, NORTH),
	GPIO_PAD_CONF("N47: GP_CAMERASB08", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 36, NA, 0x5010, NORTH),
	GPIO_PAD_CONF("N52: GP_CAMERASB09", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 41, NA, 0x5038, NORTH),
	GPIO_PAD_CONF("N50: GP_CAMERASB10", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 39, NA, 0x5028, NORTH),
	GPIO_PAD_CONF("N55: GP_CAMERASB11", GPIO, M1, GPO, LOW,
		      NA, NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 44, NA, 0x5050, NORTH),
	GPIO_PAD_CONF("N00: GPIO_DFX0", NATIVE, M5, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 0, NA, 0x4400, NORTH),
	GPIO_PAD_CONF("N03: GPIO_DFX1", NATIVE, M5, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 3, NA, 0x4418, NORTH),
	GPIO_PAD_CONF("N07: GPIO_DFX2", NATIVE, M5, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 2, NA, 0x4438, NORTH),
	GPIO_PAD_CONF("N01: GPIO_DFX3", NATIVE, M5, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, INV_TX_ENABLE,
		      NA, 1, NA, 0x4408, NORTH),
	GPIO_PAD_CONF("N05: GPIO_DFX4", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 5, NA, 0x4428, NORTH),
	GPIO_PAD_CONF("N04: GPIO_DFX5", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 4, NA, 0x4420, NORTH),
	GPIO_PAD_CONF("N08: GPIO_DFX6", NATIVE, M8, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 8, NA, 0x4440, NORTH),
	GPIO_PAD_CONF("N02: GPIO_DFX7", GPIO, M1, GPO, LOW, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 2, NA, 0x4410, NORTH),
	GPIO_PAD_CONF("N15: GPIO_SUS0", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 9 , NA, 0x4800, NORTH),
	GPIO_PAD_CONF("N19: GPIO_SUS1", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 13, NA, 0x4820, NORTH),
	GPIO_PAD_CONF("N24: GPIO_SUS2", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 18, NA, 0x4848, NORTH),
	GPIO_PAD_CONF("N17: GPIO_SUS3", NATIVE, M6, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 11, NA, 0x4810, NORTH),
	GPIO_PAD_CONF("N22: GPIO_SUS4", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 16, NA, 0x4838, NORTH),
	GPIO_PAD_CONF("N20: GPIO_SUS5", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 14, NA, 0x4828, NORTH),
	GPIO_PAD_CONF("N25: GPIO_SUS6", GPIO, M1, GPI, NA, NA,
		      TRIG_EDGE_LOW, L9, NA, NA, NA, NON_MASKABLE,
		      EN_EDGE_RX_DATA, NO_INVERSION,
		      NA, 19, SCI, 0x4850, NORTH),
	GPIO_PAD_CONF("N18: GPIO_SUS7", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 12, SMI, 0x4818, NORTH),
	GPIO_PAD_CONF("N71: HV_DDI0_DDC_SCL", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 57, NA, 0x5458, NORTH),
	GPIO_PAD_CONF("N66: HV_DDI0_DDC_SDA", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 52, NA, 0x5430, NORTH),
	GPIO_PAD_CONF("N61: HV_DDI0_HPD", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, INV_TX_ENABLE,
		      NA, 47, NA, 0x5408, NORTH),
	GPIO_PAD_CONF("N64: HV_DDI1_HPD", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, INV_TX_ENABLE,
		      NA, 50, NA, 0x5420, NORTH),
	GPIO_PAD_CONF("N67: HV_DDI2_DDC_SCL", NATIVE, M3, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 53, NA, 0x5438, NORTH),
	GPIO_PAD_CONF("N62: HV_DDI2_DDC_SDA", NATIVE, M3, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 48, NA, 0x5410, NORTH),
	GPIO_PAD_CONF("N68: HV_DDI2_HPD", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, INV_TX_ENABLE,
		      NA, 54, NA, 0x5440, NORTH),
	GPIO_PAD_CONF("N65: PANEL0_BKLTCTL", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 51, NA, 0x5428, NORTH),
	GPIO_PAD_CONF("N60: PANEL0_BKLTEN", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 46, NA, 0x5400, NORTH),
	GPIO_PAD_CONF("N72: PANEL0_VDDEN", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 58, NA, 0x5460, NORTH),
	GPIO_PAD_CONF("N63: PANEL1_BKLTCTL", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 49, NA, 0x5418, NORTH),
	GPIO_PAD_CONF("N70: PANEL1_BKLTEN", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 56, NA, 0x5450, NORTH),
	GPIO_PAD_CONF("N69: PANEL1_VDDEN", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 55, NA, 0x5448, NORTH),
	GPIO_PAD_CONF("N32: PROCHOT_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 24, NA, 0x4c10, NORTH),
	GPIO_PAD_CONF("N16: SEC_GPIO_SUS10", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 10, NA, 0x4808, NORTH),
	GPIO_PAD_CONF("N21: SEC_GPIO_SUS11", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 15, NA, 0x4830, NORTH),
	GPIO_PAD_CONF("N23: SEC_GPIO_SUS8", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 17, NA, 0x4840, NORTH),
	GPIO_PAD_CONF("N27: SEC_GPIO_SUS9", GPIO, M1, GPI, LOW, NA,
		      TRIG_LEVEL, L15, NA, NA, NA, NON_MASKABLE,
		      EN_RX_DATA, INV_RX_DATA,
		      NA, 21, SCI, 0x4860, NORTH),
	GPIO_PAD_CONF("N31: TCK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 23, NA, 0x4c08, NORTH),
	GPIO_PAD_CONF("N41: TDI", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 33, NA, 0x4c58, NORTH),
	GPIO_PAD_CONF("N39: TDO", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 31, NA, 0x4c48, NORTH),
	GPIO_PAD_CONF("N36: TDO_2", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 28, NA, 0x4c30, NORTH),
	GPIO_PAD_CONF("N34: TMS", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 26, NA, 0x4c20, NORTH),
	GPIO_PAD_CONF("N30: TRST_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 22, NA, 0x4c00, NORTH),

	GPIO_PAD_CONF("E21: MF_ISH_GPIO_0", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 18, NA, 0x4830, EAST),
	GPIO_PAD_CONF("E18: MF_ISH_GPIO_1", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 15, NA, 0x4818, EAST),
	GPIO_PAD_CONF("E24: MF_ISH_GPIO_2", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 21, NA, 0x4848, EAST),
	GPIO_PAD_CONF("E15: MF_ISH_GPIO_3", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 12, NA, 0x4800, EAST),
	GPIO_PAD_CONF("E22: MF_ISH_GPIO_4", GPIO, M1, GPI, NA, NA,
		      NA, L0, NA, NA, NA, NON_MASKABLE, NA, NO_INVERSION,
		      NA, 19, NA, 0x4838, EAST),
	GPIO_PAD_CONF("E19: MF_ISH_GPIO_5", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 16, NA, 0x4820, EAST),
	GPIO_PAD_CONF("E25: MF_ISH_GPIO_6", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 22, NA, 0x4850, EAST),
	GPIO_PAD_CONF("E16: MF_ISH_GPIO_7", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 13, NA, 0x4808, EAST),
	GPIO_PAD_CONF("E23: MF_ISH_GPIO_8", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 20, NA, 0x4840, EAST),
	GPIO_PAD_CONF("E20: MF_ISH_GPIO_9", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 17, NA, 0x4828, EAST),
	GPIO_PAD_CONF("E26: MF_ISH_I2C1_SDA", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 23, NA, 0x4858, EAST),
	GPIO_PAD_CONF("E17: MF_ISH_I2C1_SCL", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 14, NA, 0x4810, EAST),
	GPIO_PAD_CONF("E04: PMU_AC_PRESENT", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 4, NA, 0x4420, EAST),
	GPIO_PAD_CONF("E01: PMU_BATLOW_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 1, NA, 0x4408, EAST),
	GPIO_PAD_CONF("E05: PMU_PLTRST_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 5, NA, 0x4428, EAST),
	GPIO_PAD_CONF("E07: PMU_SLP_LAN_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 7, NA, 0x4438, EAST),
	GPIO_PAD_CONF("E03: PMU_SLP_S0IX_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 3, NA, 0x4418, EAST),
	GPIO_PAD_CONF("E00: PMU_SLP_S3_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 0, NA, 0x4400, EAST),
	GPIO_PAD_CONF("E09: PMU_SLP_S4_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 9, NA, 0x4448, EAST),
	GPIO_PAD_CONF("E06: PMU_SUSCLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 6, NA, 0x4430, EAST),
	GPIO_PAD_CONF("E10: PMU_WAKE_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_1K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 10, NA, 0x4450, EAST),
	GPIO_PAD_CONF("E11: PMU_WAKE_LAN_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 11, NA, 0x4458, EAST),
	GPIO_PAD_CONF("E02: SUS_STAT_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 2, NA, 0x4410, EAST),

	GPIO_PAD_CONF("SE16: SDMMC1_CLK", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_L, NA, NA, NA, NA, NO_INVERSION,
		      NA, 9, NA, 0x4808, SOUTHEAST),
	GPIO_PAD_CONF("SE23: SDMMC1_CMD", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 16, NA, 0x4840, SOUTHEAST),
	GPIO_PAD_CONF("SE17: SDMMC1_D0", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 10, NA, 0x4810, SOUTHEAST),
	GPIO_PAD_CONF("SE24: SDMMC1_D1", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 17, NA, 0x4848, SOUTHEAST),
	GPIO_PAD_CONF("SE20: SDMMC1_D2", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 13, NA, 0x4828, SOUTHEAST),
	GPIO_PAD_CONF("SE26: SDMMC1_D3_CD_B", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 19, NA, 0x4858, SOUTHEAST),
	GPIO_PAD_CONF("SE67: MMC1_D4_SD_WE", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 41, NA, 0x5438, SOUTHEAST),
	GPIO_PAD_CONF("SE65: MMC1_D5", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 39, NA, 0x5428, SOUTHEAST),
	GPIO_PAD_CONF("SE63: MMC1_D6", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 37, NA, 0x5418, SOUTHEAST),
	GPIO_PAD_CONF("SE68: MMC1_D7", NATIVE, M1, NA, NA, HIGH,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 42, NA, 0x5440, SOUTHEAST),
	GPIO_PAD_CONF("SE69: MMC1_RCLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 43, NA, 0x5448, SOUTHEAST),
	GPIO_PAD_CONF("SE77: GPIO_ALERT", GPIO, M1, GPI, NA, NA,
		      TRIG_LEVEL, L2, NA, NA, NA, NON_MASKABLE,
		      EN_RX_DATA, INV_RX_DATA,
		      NA, 46, NA, 0x5810, SOUTHEAST),
	GPIO_PAD_CONF("SE79: ILB_SERIRQ", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 48, NA, 0x5820, SOUTHEAST),
	GPIO_PAD_CONF("SE51: MF_LPC_CLKOUT0", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_NONE, NA, NA, NA, NA, NO_INVERSION,
		      NA, 32, NA, 0x5030, SOUTHEAST),
	GPIO_PAD_CONF("SE49: MF_LPC_CLKOUT1", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 30, NA, 0x5020, SOUTHEAST),
	GPIO_PAD_CONF("SE47: MF_LPC_AD0", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 28, NA, 0x5010, SOUTHEAST),
	GPIO_PAD_CONF("SE52: MF_LPC_AD1", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 33, NA, 0x5038, SOUTHEAST),
	GPIO_PAD_CONF("SE45: MF_LPC_AD2", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 26, NA, 0x5000, SOUTHEAST),
	GPIO_PAD_CONF("SE50: MF_LPC_AD3", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 31, NA, 0x5028, SOUTHEAST),
	GPIO_PAD_CONF("SE46: LPC_CLKRUNB", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 27, NA, 0x5008, SOUTHEAST),
	GPIO_PAD_CONF("SE48: LPC_FRAMEB", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 29, NA, 0x5018, SOUTHEAST),
	GPIO_PAD_CONF("SE00: MF_PLT_CLK0", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 0, NA, 0x4400, SOUTHEAST),
	GPIO_PAD_CONF("SE02: MF_PLT_CLK1", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 1, NA, 0x4410, SOUTHEAST),
	GPIO_PAD_CONF("SE07: MF_PLT_CLK2", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 7, NA, 0x4438, SOUTHEAST),
	GPIO_PAD_CONF("SE04: MF_PLT_CLK3", GPIO, M1, GPI, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 4, NA, 0x4420, SOUTHEAST),
	GPIO_PAD_CONF("SE03: MF_PLT_CLK4", GPIO, M1, GPO, LOW, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 3, NA, 0x4418, SOUTHEAST),
	GPIO_PAD_CONF("SE06: MF_PLT_CLK5", GPIO, M3, GPO, LOW, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 6, NA, 0x4430, SOUTHEAST),
	GPIO_PAD_CONF("SE83: SUSPWRDNACK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 52, NA, 0x5840, SOUTHEAST),
	GPIO_PAD_CONF("SE05: PWM0", GPIO, M1, GPO, LOW, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 5, NA, 0x4428, SOUTHEAST),
	GPIO_PAD_CONF("SE01: PWM1", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 1, NA, 0x4408, SOUTHEAST),
	GPIO_PAD_CONF("SE85: SDMMC3_1P8_EN", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 54, NA, 0x5850, SOUTHEAST),
	GPIO_PAD_CONF("SE81: SDMMC3_CD_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 50, NA, 0x5830, SOUTHEAST),
	GPIO_PAD_CONF("SE31: SDMMC3_CLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 21, NA, 0x4c08, SOUTHEAST),
	GPIO_PAD_CONF("SE34: SDMMC3_CMD", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 24, NA, 0x4c20, SOUTHEAST),
	GPIO_PAD_CONF("SE35: SDMMC3_D0", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 25, NA, 0x4c28, SOUTHEAST),
	GPIO_PAD_CONF("SE30: SDMMC3_D1", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 20, NA, 0x4c00, SOUTHEAST),
	GPIO_PAD_CONF("SE33: SDMMC3_D2", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 23, NA, 0x4c18, SOUTHEAST),
	GPIO_PAD_CONF("SE32: SDMMC3_D3", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 22, NA, 0x4c10, SOUTHEAST),
	GPIO_PAD_CONF("SE78: SDMMC3_PWR_EN_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_L, NA, NA, NA, NA, NO_INVERSION,
		      NA, 47, NA, 0x5818, SOUTHEAST),
	GPIO_PAD_CONF("SE19: SDMMC2_CLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 12, NA, 0x4820, SOUTHEAST),
	GPIO_PAD_CONF("SE22: SDMMC2_CMD", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 15, NA, 0x4838, SOUTHEAST),
	GPIO_PAD_CONF("SE25: SDMMC2_D0", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 18, NA, 0x4850, SOUTHEAST),
	GPIO_PAD_CONF("SE18: SDMMC2_D1", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 11, NA, 0x4818, SOUTHEAST),
	GPIO_PAD_CONF("SE21: SDMMC2_D2", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 14, NA, 0x4830, SOUTHEAST),
	GPIO_PAD_CONF("SE15: SDMMC2_D3_CD_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 8, NA, 0x4800, SOUTHEAST),
	GPIO_PAD_CONF("SE62: SPI1_CLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 36, NA, 0x5410, SOUTHEAST),
	GPIO_PAD_CONF("SE61: SPI1_CS0_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 35, NA, 0x5408, SOUTHEAST),
	GPIO_PAD_CONF("SE66: SPI1_CS1_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 40, NA, 0x5430, SOUTHEAST),
	GPIO_PAD_CONF("SE60: SPI1_MISO", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 34, NA, 0x5400, SOUTHEAST),
	GPIO_PAD_CONF("SE64: SPI1_MOSI", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 38, NA, 0x5420, SOUTHEAST),
	GPIO_PAD_CONF("SE80: USB_OC0_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 49, NA, 0x5828, SOUTHEAST),
	GPIO_PAD_CONF("SE75: USB_OC1_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 44, NA, 0x5800, SOUTHEAST),
	GPIO_PAD_CONF("SW02: FST_SPI_CLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 2, NA, 0x4410, SOUTHWEST),
	GPIO_PAD_CONF("SW06: FST_SPI_CS0_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 6, NA, 0x4430, SOUTHWEST),
	GPIO_PAD_CONF("SW04: FST_SPI_CS1_B", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 4, NA, 0x4420, SOUTHWEST),
	GPIO_PAD_CONF("SW07: FST_SPI_CS2_B", GPIO, M1, GPO, LOW, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 7, NA, 0x4438, SOUTHWEST),
	GPIO_PAD_CONF("SW01: FST_SPI_D0", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 1, NA, 0x4408, SOUTHWEST),
	GPIO_PAD_CONF("SW05: FST_SPI_D1", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 5, NA, 0x4428, SOUTHWEST),
	GPIO_PAD_CONF("SW00: FST_SPI_D2", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 0, NA, 0x4400, SOUTHWEST),
	GPIO_PAD_CONF("SW03: FST_SPI_D3", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 3, NA, 0x4418, SOUTHWEST),
	GPIO_PAD_CONF("SW30: MF_HDA_CLK", NATIVE, M2, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 16, NA, 0x4c00, SOUTHWEST),
	GPIO_PAD_CONF("SW37: MF_HDA_DOCKENB", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 23, NA, 0x4c38, SOUTHWEST),
	GPIO_PAD_CONF("SW34: MF_HDA_DOCKRSTB", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 20, NA, 0x4c20, SOUTHWEST),
	GPIO_PAD_CONF("SW31: MF_HDA_RSTB", NATIVE, M2, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 17, NA, 0x4c08, SOUTHWEST),
	GPIO_PAD_CONF("SW32: MF_HDA_SDI0", NATIVE, M2, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 18, NA, 0x4c10, SOUTHWEST),
	GPIO_PAD_CONF("SW36: MF_HDA_SDI1", NATIVE, M2, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 22, NA, 0x4c30, SOUTHWEST),
	GPIO_PAD_CONF("SW33: MF_HDA_SDO", NATIVE, M2, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 19, NA, 0x4c18, SOUTHWEST),
	GPIO_PAD_CONF("SW35: MF_HDA_SYNC", NATIVE, M2, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 21, NA, 0x4c28, SOUTHWEST),
	GPIO_PAD_CONF("SW18: UART1_CTS_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 11, NA, 0x4818, SOUTHWEST),
	GPIO_PAD_CONF("SW15: UART1_RTS_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 8, NA, 0x4800, SOUTHWEST),
	GPIO_PAD_CONF("SW16: UART1_RXD", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 9, NA, 0x4808, SOUTHWEST),
	GPIO_PAD_CONF("SW20: UART1_TXD", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 13, NA, 0x4828, SOUTHWEST),
	GPIO_PAD_CONF("SW22: UART2_CTS_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_NONE, NA, NA, NA, NA, NO_INVERSION,
		      NA, 15, NA, 0x4838, SOUTHWEST),
	GPIO_PAD_CONF("SW19: UART2_RTS_B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 12, NA, 0x4820, SOUTHWEST),
	GPIO_PAD_CONF("SW17: UART2_RXD", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_NONE, NA, NA, NA, NA, NO_INVERSION,
		      NA, 10, NA, 0x4810, SOUTHWEST),
	GPIO_PAD_CONF("SW21: UART2_TXD", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 14, NA, 0x4830, SOUTHWEST),
	GPIO_PAD_CONF("SW50: I2C4_SCL", NATIVE, M3, NA, NA, NA,
		      NA, NA, P_1K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 29, NA, 0x5028, SOUTHWEST),
	GPIO_PAD_CONF("SW46: I2C4_SDA", NATIVE, M3, NA, NA, NA,
		      NA, NA, P_1K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 25, NA, 0x5008, SOUTHWEST),
	GPIO_PAD_CONF("SW49: I2C_NFC_SDA", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, INV_TX_ENABLE,
		      NA, 28, NA, 0x5020, SOUTHWEST),
	GPIO_PAD_CONF("SW52: I2C_NFC_SCL", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, INV_TX_ENABLE,
		      NA, 31, NA, 0x5038, SOUTHWEST),
	GPIO_PAD_CONF("SW77: GP_SSP_2_CLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 50, NA, 0x5c10, SOUTHWEST),
	GPIO_PAD_CONF("SW81: GP_SSP_2_FS", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 54, NA, 0x5c30, SOUTHWEST),
	GPIO_PAD_CONF("SW79: GP_SSP_2_RXD", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 52, NA, 0x5c20, SOUTHWEST),
	GPIO_PAD_CONF("SW82: GP_SSP_2_TXD", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, INV_TX_ENABLE,
		      NA, 55, NA, 0x5C38, SOUTHWEST),
	GPIO_PAD_CONF("SW90: PCIE_CLKREQ0B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 48, NA, 0x5c00, SOUTHWEST),
	GPIO_PAD_CONF("SW91: PCIE_CLKREQ1B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 49, NA, 0x5c08, SOUTHWEST),
	GPIO_PAD_CONF("SW93: PCIE_CLKREQ2B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 51, NA, 0x5c18, SOUTHWEST),
	GPIO_PAD_CONF("SW95: PCIE_CLKREQ3B", NATIVE, M2, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 53, NA, 0x5c28, SOUTHWEST),
	GPIO_PAD_CONF("SW75: SATA_GP0", GPIO, M1, GPO, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 40, NA, 0x5800, SOUTHWEST),
	GPIO_PAD_CONF("SW76: SATA_GP1", GPIO, M1, GPI, HIGH, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 41, NA, 0x5808, SOUTHWEST),
	GPIO_PAD_CONF("SW78: SATA_GP2", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, ENABLE, NA, NA, NA, NO_INVERSION,
		      NA, 43, NA, 0x5818, SOUTHWEST),
	GPIO_PAD_CONF("SW80: SATA_GP3", GPIO, M2, GPI, LOW, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 45, NA, 0x5828, SOUTHWEST),
	GPIO_PAD_CONF("SW77: SATA_LEDN", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, ENABLE, NA, NA, NA, NO_INVERSION,
		      NA, 42, NA, 0x5810, SOUTHWEST),
	GPIO_PAD_CONF("SW79: MF_SMB_ALERTB", NATIVE, M1, NA, NA,
		      NA, NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 44, NA, 0x5820, SOUTHWEST),
	GPIO_PAD_CONF("SW81: MF_SMB_CLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 46, NA, 0x5830, SOUTHWEST),
	GPIO_PAD_CONF("SW82: MF_SMB_DATA", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NO_INVERSION,
		      NA, 47, NA, 0x5838, SOUTHWEST),
	GPIO_PAD_CONF("SW90: PCIE_CLKREQ0B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NA,
		      NA, 48, NA, 0x5c00, SOUTHWEST),
	GPIO_PAD_CONF("SW91: PCIE_CLKREQ1B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NA,
		      NA, 49, NA, 0x5c08, SOUTHWEST),
	GPIO_PAD_CONF("SW93: PCIE_CLKREQ2B", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NA,
		      NA, 51, NA, 0x5c18, SOUTHWEST),
	GPIO_PAD_CONF("SW95: PCIE_CLKREQ3B", NATIVE, M2, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NA,
		      NA, 53, NA, 0x5c28, SOUTHWEST),
	GPIO_PAD_CONF("SW75: SATA_GP0", GPIO, M1, GPO, HIGH, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA,
		      NA, 40, NA, 0x5800, SOUTHWEST),
	GPIO_PAD_CONF("SW76: SATA_GP1", GPIO, M1, GPI, HIGH, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA,
		      NA, 41, NA, 0x5808, SOUTHWEST),
	GPIO_PAD_CONF("SW78: SATA_GP2", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, ENABLE, NA, NA, NA, NA,
		      NA, 43, NA, 0x5818, SOUTHWEST),
	GPIO_PAD_CONF("SW80: SATA_GP3", GPIO, M2, GPI, LOW, NA,
		      NA, NA, NA, NA, NA, NA, NA, NA,
		      NA, 45, NA, 0x5828, SOUTHWEST),
	GPIO_PAD_CONF("SW77: SATA_LEDN", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, ENABLE, NA, NA, NA, NA,
		      NA, 42, NA, 0x5810, SOUTHWEST),
	GPIO_PAD_CONF("SW79: MF_SMB_ALERTB", NATIVE, M1, NA, NA,
		      NA, NA, NA, P_20K_H, NA, NA, NA, NA, NA,
		      NA, 44, NA, 0x5820, SOUTHWEST),
	GPIO_PAD_CONF("SW81: MF_SMB_CLK", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NA,
		      NA, 46, NA, 0x5830, SOUTHWEST),
	GPIO_PAD_CONF("SW82: MF_SMB_DATA", NATIVE, M1, NA, NA, NA,
		      NA, NA, P_20K_H, NA, NA, NA, NA, NA,
		      NA, 47, NA, 0x5838, SOUTHWEST),

	/* end of the table */
	GPIO_PAD_CONF("GPIO PAD TABLE END", NATIVE, M1, NA, NA, NA,
		      NA, NA, NA, NA, NA, NA, NA, NO_INVERSION,
		      NA, 0, NA, 0, TERMINATOR),
};

void update_fsp_gpio_configs(const struct gpio_family **family,
			     const struct gpio_pad **pad)
{
	*family = gpio_family;
	*pad = gpio_pad;
}
