#!/usr/bin/make -f

# This is a blob of url-escaped JSON data that serves as a translation
# table between english strings and localised strings (a mapping from
# msgid -> msgstr fields). It needs to be generated from .po files in
# the po/ directory at build time, and can't be hard-coded into the
# .js file for maintenance reasons.
gettext=$(shell /usr/share/unity-webapps/tools/po2json.py)

override_dh_auto_test:
	/usr/share/unity-webapps/tools/applinter.sh
	ls *.js|xargs -L1 /usr/share/unity-webapps/tools/style_checker.js

override_dh_install:
	dh_install
#	Replace the gettext placeholder with real compiled .po data.
	sed -i -e "s/%7B%22GETTEXT%22%3A%22PLACEHOLDER%22%7D/$(gettext)/"  \
		debian/*/usr/share/unity-webapps/userscripts/*/*.user.js

%:
	dh $@ --with migrations
