#!/bin/sh
#               blalign.sh <file of blocks>
#
blocks=""
if [ $# -gt 0 -a -f "$1" ]
then
      blocks=`cat $1`
fi
#  From the <HTML> to </HTML> is ~blocks/www/blalign.html
#       with the blocks TEXTAREA modified to insert $blocks

cat << EOM
Content-type: text/html

<HTML>
<TITLE>Do-It-Yourself Block Search</TITLE>
<H1><IMG ALIGN=MIDDLE SRC="/blocks/icons/blocks.xbm">Do-It-YourSelf Block Search</H1>

<FORM METHOD="POST" ACTION="/blocks-bin/diy.pl">

<P>

<A HREF="help/about_diy.html">Do-It-Yourself Block Search </A>
aligns a set of Blocks with a protein or DNA sequence.
<BR>
You can make blocks from unaligned protein sequences with
<A HREF="blocks/make_blocks.html">Block Maker</A>.<BR>
If you need to convert another multiple alignment to
<A HREF="help/blocks_format.html">BLOCKS format</A>, use the
<A HREF="process_blocks.html">Multiple Alignment Processor</A> or the
<A HREF="block_formatter.html">Block Formatter</A>.<BR>
<P>

Enter your Blocks in 
<A HREF="help/blocks_format.html">BLOCKS format</A>:<BR>
<TEXTAREA NAME="blocks" ROWS=10 COLS=70>$blocks</TEXTAREA>
<P>
Enter your protein or DNA sequence in 
<A HREF="http://www.ncbi.nlm.nih.gov/BLAST/fasta.html">FASTA format</A>:<BR>
<TEXTAREA NAME="sequence" ROWS=10 COLS=70></TEXTAREA>

<HR>
<INPUT TYPE=submit VALUE="Search">
<INPUT TYPE=reset>
<BR>

<HR>
<A HREF="/blocks">Blocks home</A>
<HR>
<A HREF="/blocks/contact.html">Contact us</A><P>
Page last modified on <MODIFICATION_DATE>August 2003</MODIFICATION_DATE>
</HTML>

EOM

exit
